package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.ReclamacionArb;
import com.ejie.y41b.model.TipoReclamacion;
import com.ejie.y41b.service.TipoReclamacionService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.service.ArbsolteleService;

/**
 * * DecisionController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/reclamacion")
public class ReclamacionController {

	private static final Logger logger = LoggerFactory.getLogger(ReclamacionController.class);

	@Autowired
	private TipoReclamacionService reclamacionService;

	@Autowired
	private Properties appConfiguration;

	@Autowired
	private Y41bUDAErrorManager errorManager;

	@Autowired
	private ArbsolteleService arbsolteleService;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormMantenimiento'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "reclamaciones", method = RequestMethod.GET)
	public ModelAndView getCreateFormMantenimiento(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null || censoMonitor.getPerfilMaestros().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("reclamaciones", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormAltaReclamacion'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "altaReclamacion", method = RequestMethod.GET)
	public ModelAndView getCreateFormAltaReclamacion(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("codReclamacion", Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

		model.addAttribute("modoReclamacion", Y41bConstantes.MODO_POPUP_ALTA);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null || censoMonitor.getPerfilMaestros().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleReclamacion", "model", model);
		}
	}

	/**
	 * Method 'getAllReclamacion'. de tipo like
	 * 
	 * @param tsrcodigo_
	 *            String
	 * @param tsrnombre_
	 *            String
	 * @param tsrnombree_
	 *            String
	 * @param tsrnombrei_
	 *            String
	 * @param tsrnombref_
	 *            String
	 * @param tsrnombrea_
	 *            String
	 * @param tsrimporte_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */

	@RequestMapping(value = "/like", method = RequestMethod.GET)
	public @ResponseBody Object getAllReclamacion(
			@RequestParam(value = "tsrcodigo", required = false) String tsrcodigo_,
			@RequestParam(value = "tsrnombre", required = false) String tsrnombre_,
			@RequestParam(value = "tsrnombree", required = false) String tsrnombree_,
			@RequestParam(value = "tsrnombrei", required = false) String tsrnombrei_,
			@RequestParam(value = "tsrnombref", required = false) String tsrnombref_,
			@RequestParam(value = "tsrnombrea", required = false) String tsrnombrea_,
			@RequestParam(value = "tsrimporte", required = false) String tsrimporte_, HttpServletRequest request) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String tsrcodigo = ("".equals(tsrcodigo_)) ? null : tsrcodigo_;
			String tsrnombre = null;
			String tsrnombree = null;
			String tsrnombrei = null;
			String tsrnombref = null;
			String tsrnombrea = null;
			String tsrimporte = null;

			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
				tsrnombre = ("".equals(tsrnombre_)) ? null : tsrnombre_;
			} else {
				tsrnombree = ("".equals(tsrnombre_)) ? null : tsrnombre_;
			}

			tsrimporte = ("".equals(tsrimporte_)) ? null : tsrimporte_;

			TipoReclamacion filterReclamacion = new TipoReclamacion(tsrcodigo, tsrnombre, tsrnombree, tsrnombrei,
					tsrnombref, tsrnombrea, tsrimporte);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<TipoReclamacion> reclamaciones = this.reclamacionService.findAllLike(filterReclamacion, pagination,
						false);

				if (reclamaciones == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.reclamacionService.findAllLikeCount(filterReclamacion, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(reclamaciones);
				return data;
			} else {
				List<TipoReclamacion> reclamaciones = this.reclamacionService.findAllLike(filterReclamacion, pagination,
						false);
				if (reclamaciones == null) {
					throw new Exception("No data Found.");
				}
				return reclamaciones;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param reclamacion
	 *            TipoReclamacion
	 * @return TipoReclamacion
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody TipoReclamacion add(@RequestBody TipoReclamacion reclamacion) {
		try {
			TipoReclamacion reclamacionAux = this.reclamacionService.add(reclamacion);
			logger.info("Entity correctly inserted!");
			return reclamacionAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'getCreateFormModReclamacion'.
	 * 
	 * @param codReclamacion
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "modReclamacion/{codReclamacion}", method = RequestMethod.GET)
	public ModelAndView getCreateFormModReclamacion(@PathVariable String codReclamacion, Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("codReclamacion", codReclamacion);

		model.addAttribute("modoReclamacion", Y41bConstantes.MODO_POPUP_MODIFICACION);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		TipoReclamacion reclamacion = new TipoReclamacion();
		reclamacion.setTsrcodigo(codReclamacion);

		if (censoMonitor.getPerfilMaestros() == null || censoMonitor.getPerfilMaestros().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleReclamacion", "model", model);
		}
	}

	/**
	 * Method 'editReclamacion'.
	 * 
	 * @param reclamacion
	 *            Tiporeclamacion
	 * @param response
	 *            HttpServletResponse
	 * @return Tiporeclamacion
	 */
	@RequestMapping(value = "/updateReclamacion", method = RequestMethod.PUT)
	public @ResponseBody TipoReclamacion editReclamacion(@RequestBody TipoReclamacion reclamacion,
			HttpServletResponse response) {
		try {
			TipoReclamacion reclamacionAux = this.reclamacionService.update(reclamacion);
			logger.info("Entity correctly inserted!");
			return reclamacionAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'editReclamacion'.
	 * 
	 * @param reclamacion
	 *            Tiporeclamacion
	 * @param response
	 *            HttpServletResponse
	 * @return Tiporeclamacion
	 */
	@RequestMapping(value = "/cogerexpedientesreclamacionprevia", method = RequestMethod.GET)
	public @ResponseBody List<ReclamacionArb> cogerExpedientesReclamacionPrevia(
			@RequestParam(value = "nif-reclamante", required = false) String nifReclamante,
			@RequestParam(value = "nif-reclamado", required = false) String nifReclamado,
			@RequestParam(value = "campo", required = false) String campo, HttpServletResponse response) {
		try {

			logger.info("Reclamacion controller - cogerExpedientesReclamacionPrevia");

			List<ReclamacionArb> listaReclamaciones = arbsolteleService.cogerExpedientesReclamacionPrevia(nifReclamante,
					nifReclamado);

			return listaReclamaciones;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}

	}

	/**
	 * Method 'remove'.
	 * 
	 * @param tsrcodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "remove/{tsrcodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String tsrcodigo, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			TipoReclamacion reclamacion = new TipoReclamacion();
			reclamacion.setTsrcodigo(tsrcodigo);
			this.reclamacionService.updateFechaBaja(reclamacion);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			this.logger.error("Unable to delete " + tsrcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param tsrcodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "findReclamacion/{tsrcodigo}", method = RequestMethod.GET)
	public @ResponseBody TipoReclamacion getById(@PathVariable String tsrcodigo) {
		try {
			TipoReclamacion reclamacion = new TipoReclamacion();
			reclamacion.setTsrcodigo(tsrcodigo);
			reclamacion = this.reclamacionService.find(reclamacion);
			if (reclamacion == null) {
				throw new Exception(tsrcodigo.toString());
			}
			return reclamacion;
		} catch (Exception e) {
			throw new ResourceNotFoundException(tsrcodigo.toString());
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		this.logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getReclamacionService'.
	 * 
	 * @return ReclamacionService
	 */
	protected TipoReclamacionService getReclamacionService() {
		return this.reclamacionService;
	}

	/**
	 * Method 'setReclamacionService'.
	 * 
	 * @param reclamacionService
	 *            ReclamacionService
	 * @return
	 */
	public void setReclamacionService(TipoReclamacionService reclamacionService) {
		this.reclamacionService = reclamacionService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

}
