package com.ejie.y41b.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.RangoEdadService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41b.model.RangoEdad;

/**
 * * RangoEdadController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/rangoedad")
public class RangoEdadController {

	private static final Logger logger = LoggerFactory
			.getLogger(RangoEdadController.class);

	@Autowired
	private RangoEdadService rangoEdadService;

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));
		return new ModelAndView("rangoedad", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param rancod
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{rancod}", method = RequestMethod.GET)
	public @ResponseBody
	RangoEdad getById(@PathVariable String rancod) {
		try {
			RangoEdad rangoEdad = new RangoEdad();
			rangoEdad.setRancod(rancod);
			rangoEdad = this.rangoEdadService.find(rangoEdad);
			if (rangoEdad == null) {
				throw new Exception(rancod.toString());
			}
			return rangoEdad;
		} catch (Exception e) {
			throw new ResourceNotFoundException(rancod.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param rancod
	 *            String
	 * @param randesc
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "rancod", required = false) String rancod,
			@RequestParam(value = "randesc", required = false) String randesc,
			HttpServletRequest request) {
		try {
			RangoEdad filterRangoEdad = new RangoEdad(rancod, randesc);
			Pagination pagination = null;
			pagination = new Pagination();
			pagination.setSort(request.getParameter("sidx"));
			pagination.setAscDsc(request.getParameter("sord"));
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				List<RangoEdad> rangoEdads = this.rangoEdadService.findAll(
						filterRangoEdad, pagination);

				if (rangoEdads == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterRangoEdad, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(rangoEdads);
				return data;
			} else {
				List<RangoEdad> rangoEdads = this.rangoEdadService.findAll(
						filterRangoEdad, pagination);
				if (rangoEdads == null) {
					throw new Exception("No data Found.");
				}
				return rangoEdads;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterRangoEdad
	 *            RangoEdad
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "rangoEdad", required = false) RangoEdad filterRangoEdad,
			HttpServletRequest request) {
		try {
			return rangoEdadService
					.findAllCount(filterRangoEdad != null ? filterRangoEdad
							: new RangoEdad());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param rangoEdad
	 *            RangoEdad
	 * @param response
	 *            HttpServletResponse
	 * @return RangoEdad
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	RangoEdad edit(@RequestBody RangoEdad rangoEdad,
			HttpServletResponse response) {
		try {
			RangoEdad rangoEdadAux = this.rangoEdadService.update(rangoEdad);
			logger.info("Entity correctly inserted!");
			return rangoEdadAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param rangoEdad
	 *            RangoEdad
	 * @return RangoEdad
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	RangoEdad add(@RequestBody RangoEdad rangoEdad) {
		try {
			RangoEdad rangoEdadAux = this.rangoEdadService.add(rangoEdad);
			logger.info("Entity correctly inserted!");
			return rangoEdadAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param rancod
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{rancod}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String rancod, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			RangoEdad rangoEdad = new RangoEdad();
			rangoEdad.setRancod(rancod);
			this.rangoEdadService.remove(rangoEdad);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + rancod);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param rangoEdadIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> rangoEdadIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<RangoEdad> rangoEdadList = new ArrayList<RangoEdad>();
		try {
			for (ArrayList<String> rangoEdadId : rangoEdadIds) {
				Iterator<String> iterator = rangoEdadId.iterator();
				RangoEdad rangoEdad = new RangoEdad();
				rangoEdad.setRancod(ObjectConversionManager.convert(
						iterator.next(), String.class));
				rangoEdadList.add(rangoEdad);
			}
			this.rangoEdadService.removeMultiple(rangoEdadList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getRangoEdadService'.
	 * 
	 * @return RangoEdadService
	 */
	protected RangoEdadService getRangoEdadService() {
		return this.rangoEdadService;
	}

	/**
	 * Method 'setRangoEdadService'.
	 * 
	 * @param rangoEdadService
	 *            RangoEdadService
	 * @return
	 */
	public void setRangoEdadService(RangoEdadService rangoEdadService) {
		this.rangoEdadService = rangoEdadService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
