package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.ProvincService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.Provinc;

/**
 * ProvincController  
 *  
 */
 
@Controller
@RequestMapping (value = "/provinc")

public class ProvincController  {

	private static final Logger logger = LoggerFactory.getLogger(ProvincController.class);

	@Autowired
	private ProvincService provincService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ProvincController.logger.info("[GET - View] : provinc");
		return "provinc";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param pvcodigo String
	 * @return provinc Provinc
	 */
	@RequestMapping(value = "/{pvcodigo}", method = RequestMethod.GET)
	public @ResponseBody Provinc getById(@PathVariable String pvcodigo) {
        Provinc provinc = new Provinc();
		provinc.setPvcodigo(pvcodigo);
        provinc = this.provincService.find(provinc);
        ProvincController.logger.info("[GET - findBy_PK] : Obtener Provinc por PK");
        return provinc;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterProvinc Provinc
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Provinc> getAll(@ModelAttribute Provinc filterProvinc) {
		ProvincController.logger.info("[GET - find_ALL] : Obtener Provinc por filtro");
	    return this.provincService.findAll(filterProvinc, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param provinc Provinc 
	 * @return Provinc
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Provinc edit(@RequestBody Provinc provinc) {		
        Provinc provincAux = this.provincService.update(provinc);
		ProvincController.logger.info("[PUT] : Provinc actualizado correctamente");
        return provincAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param provinc Provinc 
	 * @return Provinc
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Provinc add(@RequestBody Provinc provinc) {		
        Provinc provincAux = this.provincService.add(provinc);
        ProvincController.logger.info("[POST] : Provinc insertado correctamente");
    	return provincAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param pvcodigo String
	 * @return provinc
	 */
	@RequestMapping(value = "/{pvcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody Provinc remove(@PathVariable String pvcodigo) {
        Provinc provinc = new Provinc();
        provinc.setPvcodigo(pvcodigo);
        this.provincService.remove(provinc);
       	ProvincController.logger.info("[DELETE] : Provinc borrado correctamente");
       	return provinc;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param provincIds List
	 * @return provincList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> provincIds) {
        List<Provinc> provincList = new ArrayList<Provinc>();
        for (List<String> provincId:provincIds) {
		    Iterator<String> iterator = provincId.iterator();
		    Provinc provinc = new Provinc(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        provinc.setPvcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
		    provincList.add(provinc);
	    }
        this.provincService.removeMultiple(provincList);
		ProvincController.logger.info("[POST - DELETE_ALL] : Provinc borrados correctamente");
		return provincIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterProvinc Provinc
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute Provinc filterProvinc, @ModelAttribute Pagination pagination) {
        List<Provinc> provincs = this.provincService.findAll(filterProvinc, pagination);
        Long recordNum = this.provincService.findAllCount(filterProvinc);
        ProvincController.logger.info("[GET - jqGrid] : Obtener Provinc");
		return new JQGridJSONModel(pagination, recordNum, provincs);
	}
	
}	
