package com.ejie.y41b.control;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.CampanhaProd;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Descriptor;
import com.ejie.y41b.model.ProdAgrupado;
import com.ejie.y41b.model.Producto;
import com.ejie.y41b.model.Y41bArbolProductos;
import com.ejie.y41b.service.ArbolProductosService;
import com.ejie.y41b.service.ProductoService;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.tree.Y41bProductosTree;

/**
 * * ProductoController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/producto")
@SessionAttributes({ "codProducto", "modoBusquedaProducto", "modoProducto" })
public class ProductoController {

	private static final Logger logger = LoggerFactory
			.getLogger(ProductoController.class);

	@Autowired
	private ProductoService productoService;

	@Autowired
	private ArbolProductosService arbolProductosService;

	@Autowired
	private Properties appConfiguration;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormMantenimiento'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "productos", method = RequestMethod.GET)
	public ModelAndView getCreateFormMantenimiento(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusquedaProducto", "");

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("productos", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "seleccionProducto", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusquedaProducto",
				Y41bConstantes.MODO_POPUP_SELECCION);

		return new ModelAndView("seleccionProductos", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "arbolproducto", method = RequestMethod.GET)
	public ModelAndView getCreateFormArbolProducto(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("arbolProductos", "model", model);
	}

	/**
	 * Method 'getCreateFormAltaProducto'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "altaProducto", method = RequestMethod.GET)
	public ModelAndView getCreateFormAltaProducto(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("codProducto", "");

		model.addAttribute("modoProducto", Y41bConstantes.MODO_POPUP_ALTA);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleProducto", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormModProducto'.
	 * 
	 * @param codProducto
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "modProducto/{codProducto}", method = RequestMethod.GET)
	public ModelAndView getCreateFormModProducto(
			@PathVariable String codProducto, Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("codProducto", codProducto);

		model.addAttribute("modoProducto",
				Y41bConstantes.MODO_POPUP_MODIFICACION);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleProducto", "model", model);
		}
	}

	/**
	 * Method 'getProductoById'.
	 * 
	 * @param pscodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/findProducto/{pscodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Producto getProductoById(@PathVariable String pscodigo) {
		try {
			Producto producto = new Producto();
			producto.setPscodigo(pscodigo);
			producto = this.productoService.findProducto(producto);
			if (producto == null) {
				throw new Exception(pscodigo.toString());
			}
			return producto;
		} catch (Exception e) {
			throw new ResourceNotFoundException(pscodigo.toString());
		}
	}

	/**
	 * Method 'getByIdSeleccionable'.
	 * 
	 * @param pscodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/seleccionable/{pscodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Producto getByIdSeleccionable(@PathVariable String pscodigo) {
		try {
			Producto producto = new Producto();
			producto.setPscodigo(pscodigo);
			producto = this.productoService.findProductoSeleccionable(producto);
			if (producto == null) {
				throw new Exception(pscodigo.toString());
			}
			return producto;
		} catch (Exception e) {
			throw new ResourceNotFoundException(pscodigo.toString());
		}
	}

	/**
	 * Method 'getByIdSeleccionableCampanha'.
	 * 
	 * @param pscodigo
	 *            String
	 * @param codCampanha_
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/seleccionableCampanha/{pscodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Producto getByIdSeleccionableCampanha(
			@PathVariable String pscodigo,
			@RequestParam(value = "codCampanha", required = false) String codCampanha_) {
		try {
			CampanhaProd campanhaProd = new CampanhaProd();
			campanhaProd.setCpcops(pscodigo);

			String codCampanha = ("".equals(codCampanha_)) ? null
					: codCampanha_;
			Campanha campanha = new Campanha();
			campanha.setCmcodigo(codCampanha);

			campanhaProd.setCampanha(campanha);

			Producto producto = this.productoService
					.findProductoSeleccionableCampanha(campanhaProd);
			if (producto == null) {
				throw new Exception(pscodigo.toString());
			}
			return producto;
		} catch (Exception e) {
			throw new ResourceNotFoundException(pscodigo.toString());
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param pscodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{pscodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Producto getById(@PathVariable String pscodigo) {
		try {
			Producto producto = new Producto();
			producto.setPscodigo(pscodigo);
			producto = this.productoService.find(producto);
			if (producto == null) {
				throw new Exception(pscodigo.toString());
			}
			return producto;
		} catch (Exception e) {
			throw new ResourceNotFoundException(pscodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param pscodigo
	 *            String
	 * @param prodAgrupadoE8codigo
	 *            String
	 * @param psnombre
	 *            String
	 * @param psnoco
	 *            String
	 * @param psdescri
	 *            String
	 * @param pscose
	 *            String
	 * @param psnombree
	 *            String
	 * @param psnombrei
	 *            String
	 * @param psnombref
	 *            String
	 * @param psnombrea
	 *            String
	 * @param psnocoe
	 *            String
	 * @param psnocoi
	 *            String
	 * @param psnocof
	 *            String
	 * @param psnocoa
	 *            String
	 * @param psdescrie
	 *            String
	 * @param psdescrii
	 *            String
	 * @param psdescrif
	 *            String
	 * @param psdescria
	 *            String
	 * @param pssel1
	 *            String
	 * @param pscoinc
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "pscodigo", required = false) String pscodigo,
			@RequestParam(value = "prodAgrupadoE8codigo", required = false) String prodAgrupadoE8codigo,
			@RequestParam(value = "psnombre", required = false) String psnombre,
			@RequestParam(value = "psnoco", required = false) String psnoco,
			@RequestParam(value = "psdescri", required = false) String psdescri,
			@RequestParam(value = "pscose", required = false) String pscose,
			@RequestParam(value = "psnombree", required = false) String psnombree,
			@RequestParam(value = "psnombrei", required = false) String psnombrei,
			@RequestParam(value = "psnombref", required = false) String psnombref,
			@RequestParam(value = "psnombrea", required = false) String psnombrea,
			@RequestParam(value = "psnocoe", required = false) String psnocoe,
			@RequestParam(value = "psnocoi", required = false) String psnocoi,
			@RequestParam(value = "psnocof", required = false) String psnocof,
			@RequestParam(value = "psnocoa", required = false) String psnocoa,
			@RequestParam(value = "psdescrie", required = false) String psdescrie,
			@RequestParam(value = "psdescrii", required = false) String psdescrii,
			@RequestParam(value = "psdescrif", required = false) String psdescrif,
			@RequestParam(value = "psdescria", required = false) String psdescria,
			@RequestParam(value = "pssel1", required = false) String pssel1,
			@RequestParam(value = "pscoinc", required = false) String pscoinc,
			HttpServletRequest request) {
		try {
			Producto filterProducto = new Producto(pscodigo, psnombre, psnoco,
					psdescri, pscose, psnombree, psnombrei, psnombref,
					psnombrea, psnocoe, psnocoi, psnocof, psnocoa, psdescrie,
					psdescrii, psdescrif, psdescria, pssel1, pscoinc,
					new ProdAgrupado(prodAgrupadoE8codigo, null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Producto> productos = this.productoService.findAll(
						filterProducto, pagination);

				if (productos == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterProducto, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(productos);
				return data;
			} else {
				List<Producto> productos = this.productoService.findAll(
						filterProducto, pagination);
				if (productos == null) {
					throw new Exception("No data Found.");
				}
				return productos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllProducto'.
	 * 
	 * @param pscodigo_
	 *            String
	 * @param prodAgrupadoE8codigo_
	 *            String
	 * @param psnombre_
	 *            String
	 * @param psnoco
	 *            String
	 * @param psdescri
	 *            String
	 * @param pscose
	 *            String
	 * @param psnombree_
	 *            String
	 * @param psnombrei
	 *            String
	 * @param psnombref
	 *            String
	 * @param psnombrea
	 *            String
	 * @param psnocoe
	 *            String
	 * @param psnocoi
	 *            String
	 * @param psnocof
	 *            String
	 * @param psnocoa
	 *            String
	 * @param psdescrie
	 *            String
	 * @param psdescrii
	 *            String
	 * @param psdescrif
	 *            String
	 * @param psdescria
	 *            String
	 * @param pssel1_
	 *            String
	 * @param pscoinc
	 *            String
	 * @param idsDescriptores
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/like", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllProducto(
			@RequestParam(value = "pscodigo", required = false) String pscodigo_,
			@RequestParam(value = "prodAgrupadoE8codigo", required = false) String prodAgrupadoE8codigo_,
			@RequestParam(value = "psnombre", required = false) String psnombre_,
			@RequestParam(value = "psnoco", required = false) String psnoco,
			@RequestParam(value = "psdescri", required = false) String psdescri,
			@RequestParam(value = "pscose", required = false) String pscose,
			@RequestParam(value = "psnombree", required = false) String psnombree_,
			@RequestParam(value = "psnombrei", required = false) String psnombrei,
			@RequestParam(value = "psnombref", required = false) String psnombref,
			@RequestParam(value = "psnombrea", required = false) String psnombrea,
			@RequestParam(value = "psnocoe", required = false) String psnocoe,
			@RequestParam(value = "psnocoi", required = false) String psnocoi,
			@RequestParam(value = "psnocof", required = false) String psnocof,
			@RequestParam(value = "psnocoa", required = false) String psnocoa,
			@RequestParam(value = "psdescrie", required = false) String psdescrie,
			@RequestParam(value = "psdescrii", required = false) String psdescrii,
			@RequestParam(value = "psdescrif", required = false) String psdescrif,
			@RequestParam(value = "psdescria", required = false) String psdescria,
			@RequestParam(value = "pssel1", required = false) String pssel1_,
			@RequestParam(value = "pscoinc", required = false) String pscoinc,
			@RequestParam(value = "idsDescriptores", required = false) String idsDescriptores,
			HttpServletRequest request) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String pssel1 = ("".equals(pssel1_)) ? null : pssel1_;
			String pscodigo = ("".equals(pscodigo_)) ? null : pscodigo_;

			String psnombre = null;
			String psnombree = null;
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
				psnombre = ("".equals(psnombre_)) ? null : psnombre_;
			} else {
				psnombree = ("".equals(psnombre_)) ? null : psnombre_;
			}

			String prodAgrupadoE8codigo = ("".equals(prodAgrupadoE8codigo_)) ? null
					: prodAgrupadoE8codigo_;

			Producto filterProducto = new Producto(pscodigo, psnombre, psnoco,
					psdescri, pscose, psnombree, psnombrei, psnombref,
					psnombrea, psnocoe, psnocoi, psnocof, psnocoa, psdescrie,
					psdescrii, psdescrif, psdescria, pssel1, pscoinc,
					new ProdAgrupado(prodAgrupadoE8codigo, null, null));

			List<Descriptor> descriptores = new ArrayList<Descriptor>();
			// Generar el listado listado de etiquetas (comun)
			if (null != idsDescriptores && !"".equals(idsDescriptores)) {
				Descriptor descriptor = null;
				for (String id : idsDescriptores.split(",")) {
					descriptor = new Descriptor();// NOPMD 2012/02/29 (IDA)
					descriptor.setIdDescriptor(id);
					descriptores.add(descriptor);
				}
			}
			filterProducto.setDescriptores(descriptores);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Producto> productos = this.productoService
						.findAllLikeProducto(filterProducto, pagination, false);

				if (productos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.productoService.findAllLikeProductoCount(
						filterProducto, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(productos);
				return data;
			} else {
				List<Producto> productos = this.productoService
						.findAllLikeProducto(filterProducto, pagination, false);
				if (productos == null) {
					throw new Exception("No data Found.");
				}
				return productos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllProductoSeleccion'.
	 * 
	 * @param pscodigo_
	 *            String
	 * @param prodAgrupadoE8codigo_
	 *            String
	 * @param psnombre_
	 *            String
	 * @param psnoco
	 *            String
	 * @param psdescri
	 *            String
	 * @param pscose
	 *            String
	 * @param psnombree_
	 *            String
	 * @param psnombrei
	 *            String
	 * @param psnombref
	 *            String
	 * @param psnombrea
	 *            String
	 * @param psnocoe
	 *            String
	 * @param psnocoi
	 *            String
	 * @param psnocof
	 *            String
	 * @param psnocoa
	 *            String
	 * @param psdescrie
	 *            String
	 * @param psdescrii
	 *            String
	 * @param psdescrif
	 *            String
	 * @param psdescria
	 *            String
	 * @param pssel1_
	 *            String
	 * @param pscoinc
	 *            String
	 * @param idsDescriptores
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/likeSeleccion", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllProductoSeleccion(
			@RequestParam(value = "pscodigo", required = false) String pscodigo_,
			@RequestParam(value = "prodAgrupadoE8codigo", required = false) String prodAgrupadoE8codigo_,
			@RequestParam(value = "psnombre", required = false) String psnombre_,
			@RequestParam(value = "psnoco", required = false) String psnoco,
			@RequestParam(value = "psdescri", required = false) String psdescri,
			@RequestParam(value = "pscose", required = false) String pscose,
			@RequestParam(value = "psnombree", required = false) String psnombree_,
			@RequestParam(value = "psnombrei", required = false) String psnombrei,
			@RequestParam(value = "psnombref", required = false) String psnombref,
			@RequestParam(value = "psnombrea", required = false) String psnombrea,
			@RequestParam(value = "psnocoe", required = false) String psnocoe,
			@RequestParam(value = "psnocoi", required = false) String psnocoi,
			@RequestParam(value = "psnocof", required = false) String psnocof,
			@RequestParam(value = "psnocoa", required = false) String psnocoa,
			@RequestParam(value = "psdescrie", required = false) String psdescrie,
			@RequestParam(value = "psdescrii", required = false) String psdescrii,
			@RequestParam(value = "psdescrif", required = false) String psdescrif,
			@RequestParam(value = "psdescria", required = false) String psdescria,
			@RequestParam(value = "pssel1", required = false) String pssel1_,
			@RequestParam(value = "pscoinc", required = false) String pscoinc,
			@RequestParam(value = "idsDescriptores", required = false) String idsDescriptores,
			HttpServletRequest request) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String pssel1 = ("".equals(pssel1_)) ? null : pssel1_;
			String pscodigo = ("".equals(pscodigo_)) ? null : pscodigo_;

			String psnombre = null;
			String psnombree = null;
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
				psnombre = ("".equals(psnombre_)) ? null : psnombre_;
			} else {
				psnombree = ("".equals(psnombre_)) ? null : psnombre_;
			}

			String prodAgrupadoE8codigo = ("".equals(prodAgrupadoE8codigo_)) ? null
					: prodAgrupadoE8codigo_;

			Producto filterProducto = new Producto(pscodigo, psnombre, psnoco,
					psdescri, pscose, psnombree, psnombrei, psnombref,
					psnombrea, psnocoe, psnocoi, psnocof, psnocoa, psdescrie,
					psdescrii, psdescrif, psdescria, pssel1, pscoinc,
					new ProdAgrupado(prodAgrupadoE8codigo, null, null));

			List<Descriptor> descriptores = new ArrayList<Descriptor>();
			// Generar el listado listado de etiquetas (comun)
			if (null != idsDescriptores && !"".equals(idsDescriptores)) {
				Descriptor descriptor = null;
				for (String id : idsDescriptores.split(",")) {
					descriptor = new Descriptor();// NOPMD 2012/02/29 (IDA)
					descriptor.setIdDescriptor(id);
					descriptores.add(descriptor);
				}
			}
			filterProducto.setDescriptores(descriptores);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Producto> productos = this.productoService
						.findAllLikeProductoSeleccion(filterProducto,
								pagination, false);

				if (productos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.productoService
						.findAllLikeProductoSeleccionCount(filterProducto,
								false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(productos);
				return data;
			} else {
				List<Producto> productos = this.productoService
						.findAllLikeProductoSeleccion(filterProducto,
								pagination, false);
				if (productos == null) {
					throw new Exception("No data Found.");
				}
				return productos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllProductoSeleccionCampanha'.
	 * 
	 * @param pscodigo_
	 *            String
	 * @param prodAgrupadoE8codigo_
	 *            String
	 * @param psnombre_
	 *            String
	 * @param psnoco
	 *            String
	 * @param psdescri
	 *            String
	 * @param pscose
	 *            String
	 * @param psnombree_
	 *            String
	 * @param psnombrei
	 *            String
	 * @param psnombref
	 *            String
	 * @param psnombrea
	 *            String
	 * @param psnocoe
	 *            String
	 * @param psnocoi
	 *            String
	 * @param psnocof
	 *            String
	 * @param psnocoa
	 *            String
	 * @param psdescrie
	 *            String
	 * @param psdescrii
	 *            String
	 * @param psdescrif
	 *            String
	 * @param psdescria
	 *            String
	 * @param pssel1_
	 *            String
	 * @param pscoinc
	 *            String
	 * @param idsDescriptores
	 *            String
	 * @param codCampanha_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/likeSeleccionCampanha", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllProductoSeleccionCampanha(
			@RequestParam(value = "pscodigo", required = false) String pscodigo_,
			@RequestParam(value = "prodAgrupadoE8codigo", required = false) String prodAgrupadoE8codigo_,
			@RequestParam(value = "psnombre", required = false) String psnombre_,
			@RequestParam(value = "psnoco", required = false) String psnoco,
			@RequestParam(value = "psdescri", required = false) String psdescri,
			@RequestParam(value = "pscose", required = false) String pscose,
			@RequestParam(value = "psnombree", required = false) String psnombree_,
			@RequestParam(value = "psnombrei", required = false) String psnombrei,
			@RequestParam(value = "psnombref", required = false) String psnombref,
			@RequestParam(value = "psnombrea", required = false) String psnombrea,
			@RequestParam(value = "psnocoe", required = false) String psnocoe,
			@RequestParam(value = "psnocoi", required = false) String psnocoi,
			@RequestParam(value = "psnocof", required = false) String psnocof,
			@RequestParam(value = "psnocoa", required = false) String psnocoa,
			@RequestParam(value = "psdescrie", required = false) String psdescrie,
			@RequestParam(value = "psdescrii", required = false) String psdescrii,
			@RequestParam(value = "psdescrif", required = false) String psdescrif,
			@RequestParam(value = "psdescria", required = false) String psdescria,
			@RequestParam(value = "pssel1", required = false) String pssel1_,
			@RequestParam(value = "pscoinc", required = false) String pscoinc,
			@RequestParam(value = "idsDescriptores", required = false) String idsDescriptores,
			@RequestParam(value = "codCampanha", required = false) String codCampanha_,
			HttpServletRequest request) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String pssel1 = ("".equals(pssel1_)) ? null : pssel1_;
			String pscodigo = ("".equals(pscodigo_)) ? null : pscodigo_;

			String psnombre = null;
			String psnombree = null;
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
				psnombre = ("".equals(psnombre_)) ? null : psnombre_;
			} else {
				psnombree = ("".equals(psnombre_)) ? null : psnombre_;
			}

			String prodAgrupadoE8codigo = ("".equals(prodAgrupadoE8codigo_)) ? null
					: prodAgrupadoE8codigo_;

			Producto filterProducto = new Producto(pscodigo, psnombre, psnoco,
					psdescri, pscose, psnombree, psnombrei, psnombref,
					psnombrea, psnocoe, psnocoi, psnocof, psnocoa, psdescrie,
					psdescrii, psdescrif, psdescria, pssel1, pscoinc,
					new ProdAgrupado(prodAgrupadoE8codigo, null, null));

			List<Descriptor> descriptores = new ArrayList<Descriptor>();
			// Generar el listado listado de etiquetas (comun)
			if (null != idsDescriptores && !"".equals(idsDescriptores)) {
				Descriptor descriptor = null;
				for (String id : idsDescriptores.split(",")) {
					descriptor = new Descriptor();// NOPMD 2012/02/29 (IDA)
					descriptor.setIdDescriptor(id);
					descriptores.add(descriptor);
				}
			}
			filterProducto.setDescriptores(descriptores);

			String codCampanha = ("".equals(codCampanha_)) ? null
					: codCampanha_;
			Campanha campanha = new Campanha();
			campanha.setCmcodigo(codCampanha);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Producto> productos = this.productoService
						.findAllLikeProductoSeleccionCampanha(filterProducto,
								campanha, pagination, false);

				if (productos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.productoService
						.findAllLikeProductoSeleccionCampanhaCount(
								filterProducto, campanha, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(productos);
				return data;
			} else {
				List<Producto> productos = this.productoService
						.findAllLikeProductoSeleccionCampanha(filterProducto,
								campanha, pagination, false);
				if (productos == null) {
					throw new Exception("No data Found.");
				}
				return productos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterProducto
	 *            Producto
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "producto", required = false) Producto filterProducto,
			HttpServletRequest request) {
		try {
			return productoService
					.findAllCount(filterProducto != null ? filterProducto
							: new Producto());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param producto
	 *            Producto
	 * @param response
	 *            HttpServletResponse
	 * @return Producto
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Producto edit(@RequestBody Producto producto, HttpServletResponse response) {
		try {
			Producto productoAux = this.productoService.update(producto);
			logger.info("Entity correctly inserted!");
			return productoAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'editProducto'.
	 * 
	 * @param producto
	 *            Producto
	 * @param response
	 *            HttpServletResponse
	 * @return Sector
	 */
	@RequestMapping(value = "/updateProducto", method = RequestMethod.PUT)
	public @ResponseBody
	Producto editProducto(@RequestBody Producto producto,
			HttpServletResponse response) {
		try {
			Producto productoAux = this.productoService
					.updateProducto(producto);
			logger.info("Entity correctly inserted!");
			return productoAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Producto add(@RequestBody Producto producto) {
		try {
			Producto productoAux = this.productoService.add(producto);
			logger.info("Entity correctly inserted!");
			return productoAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'addProducto'.
	 * 
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	@RequestMapping(value = "/addProducto", method = RequestMethod.POST)
	public @ResponseBody
	Producto addProducto(@RequestBody Producto producto) {
		try {
			Producto productoAux = this.productoService.addProducto(producto);
			logger.info("Entity correctly inserted!");
			return productoAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param pscodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{pscodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String pscodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Producto producto = new Producto();
			producto.setPscodigo(pscodigo);
			this.productoService.remove(producto);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + pscodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeProducto'.
	 * 
	 * @param pscodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "removeProducto/{pscodigo}", method = RequestMethod.DELETE)
	public void removeProducto(@PathVariable String pscodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Producto producto = new Producto();
			producto.setPscodigo(pscodigo);
			this.productoService.removeProducto(producto);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			logger.error("Unable to delete " + pscodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param productoIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> productoIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Producto> productoList = new ArrayList<Producto>();
		try {
			for (ArrayList<String> productoId : productoIds) {
				Iterator<String> iterator = productoId.iterator();
				Producto producto = new Producto();
				producto.setPscodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				productoList.add(producto);
			}
			this.productoService.removeMultiple(productoList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Loading entity group tree
	 * 
	 * @param response
	 *            Response
	 * @param request
	 *            Request
	 * @throws IOException
	 *             IOException
	 */
	@RequestMapping(value = "/productostree", method = RequestMethod.GET)
	public void getCategoriasTree(HttpServletRequest request,
			HttpServletResponse response) throws IOException {

		response.setCharacterEncoding("ISO-8859-1");
		response.setHeader("Cache-Control", "no-cache");
		response.setContentType("text/html;charset=utf-8");

		String mostrarHabituales = "";
		String pscodigo_ = "";
		String psnombre_ = "";
		String prodAgrupadoE8codigo_ = "";
		String idsDescriptores_ = "";
		Enumeration e = request.getParameterNames();
		while (e.hasMoreElements()) {
			String param = e.nextElement().toString();

			if (param.equals("mostrarHabituales")) {
				mostrarHabituales = request.getParameter(param);
			}
			if (param.equals("pscodigo")) {
				pscodigo_ = request.getParameter(param);
			}
			if (param.equals("psnombre")) {
				psnombre_ = request.getParameter(param);
			}
			if (param.equals("prodAgrupadoE8codigo")) {
				prodAgrupadoE8codigo_ = request.getParameter(param);
			}
			if (param.equals("idsDescriptores")) {
				idsDescriptores_ = request.getParameter(param);
			}
		}

		String pssel1 = null;

		if (mostrarHabituales.equals("true")) {
			pssel1 = Y41bConstantes.HABITUALES;
		}

		String idsDescriptores = ("".equals(idsDescriptores_)) ? null
				: idsDescriptores_;
		String pscodigo = ("".equals(pscodigo_)) ? null : pscodigo_;
		String psnombre = null;
		String psnombree = null;
		Locale locale = LocaleContextHolder.getLocale();
		String idioma = locale.getLanguage();

		if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
			psnombre = ("".equals(psnombre_)) ? null : psnombre_;
		} else {
			psnombree = ("".equals(psnombre_)) ? null : psnombre_;
		}

		String prodAgrupadoE8codigo = ("".equals(prodAgrupadoE8codigo_)) ? null
				: prodAgrupadoE8codigo_;

		Producto filterProducto = new Producto(pscodigo, psnombre, null, null,
				null, psnombree, null, null, null, null, null, null, null,
				null, null, null, null, pssel1, null, new ProdAgrupado(
						prodAgrupadoE8codigo, null, null));

		List<Descriptor> descriptores = new ArrayList<Descriptor>();
		// Generar el listado listado de etiquetas (comun)
		if (null != idsDescriptores && !"".equals(idsDescriptores)) {
			Descriptor descriptor = null;
			for (String id : idsDescriptores.split(",")) {
				descriptor = new Descriptor();// NOPMD 2012/02/29 (IDA)
				descriptor.setIdDescriptor(id);
				descriptores.add(descriptor);
			}
		}
		filterProducto.setDescriptores(descriptores);

		Pagination pagination = new Pagination();
		pagination.setSort("PSCODIGO");
		pagination.setAscDsc("ASC");

		Y41bArbolProductos arbolProductos = this.arbolProductosService
				.obtenerArbol(filterProducto, pagination);

		String json = Y41bProductosTree.obtieneJsonArbol(arbolProductos);

		json = json.replaceAll("", "A").replaceAll("", "E")
				.replaceAll("", "I").replaceAll("", "O").replaceAll("", "U");

		PrintWriter out = response.getWriter();
		out.println(json);
		out.flush();
		out.close();
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getProductoService'.
	 * 
	 * @return ProductoService
	 */
	protected ProductoService getProductoService() {
		return this.productoService;
	}

	/**
	 * Method 'setProductoService'.
	 * 
	 * @param productoService
	 *            ProductoService
	 * @return
	 */
	public void setProductoService(ProductoService productoService) {
		this.productoService = productoService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
