package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.ProdAgrupado;
import com.ejie.y41b.service.ProdAgrupadoService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * ProdAgrupadoController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/prodagrupado")
@SessionAttributes({ "codProdagrupado", "modoBusquedaProdagrupado",
		"modoProdagrupado" })
public class ProdAgrupadoController {

	private static final Logger logger = LoggerFactory
			.getLogger(ProdAgrupadoController.class);

	@Autowired
	private ProdAgrupadoService prodAgrupadoService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormMantenimiento'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "prodagrupados", method = RequestMethod.GET)
	public ModelAndView getCreateFormMantenimiento(Model model,
			HttpServletRequest request) {

		model.addAttribute("modoBusquedaProdagrupado", "");

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("prodagrupados", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "seleccionProdagrupado", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {

		model.addAttribute("modoBusquedaProdagrupado",
				Y41bConstantes.MODO_POPUP_SELECCION);

		return new ModelAndView("seleccionProdagrupado", "model", model);
	}

	/**
	 * Method 'getCreateFormAltaProdagrupado'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "altaProdagrupado", method = RequestMethod.GET)
	public ModelAndView getCreateFormAltaProdagrupado(Model model,
			HttpServletRequest request) {

		model.addAttribute("codProdagrupado", Y41bUIDGenerator.getInstance()
				.generateId(Y41bConstantes.PK_SIZE));

		model.addAttribute("modoProdagrupado", Y41bConstantes.MODO_POPUP_ALTA);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleProdagrupado", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormModProdagrupado'.
	 * 
	 * @param codProdagrupado
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "modProdagrupado/{codProdagrupado}", method = RequestMethod.GET)
	public ModelAndView getCreateFormModProdagrupado(
			@PathVariable String codProdagrupado, Model model,
			HttpServletRequest request) {

		model.addAttribute("codProdagrupado", codProdagrupado);

		model.addAttribute("modoProdagrupado",
				Y41bConstantes.MODO_POPUP_MODIFICACION);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		ProdAgrupado prodAgrupado = new ProdAgrupado();
		prodAgrupado.setE8codigo(codProdagrupado);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleProdagrupado", "model", model);
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param e8codigo
	 *            String
	 * @return prodAgrupado ProdAgrupado
	 */
	@RequestMapping(value = "/{e8codigo}", method = RequestMethod.GET)
	public @ResponseBody
	ProdAgrupado getById(@PathVariable String e8codigo) {
		ProdAgrupado prodAgrupado = new ProdAgrupado();
		prodAgrupado.setE8codigo(e8codigo);
		prodAgrupado = this.prodAgrupadoService.find(prodAgrupado);
		ProdAgrupadoController.logger
				.info("[GET - findBy_PK] : Obtener ProdAgrupado por PK");
		return prodAgrupado;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterProdAgrupado
	 *            ProdAgrupado
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<ProdAgrupado> getAll(@ModelAttribute ProdAgrupado filterProdAgrupado) {
		ProdAgrupadoController.logger
				.info("[GET - find_ALL] : Obtener ProdAgrupado por filtro");
		return this.prodAgrupadoService.findAll(filterProdAgrupado, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param prodAgrupado
	 *            ProdAgrupado
	 * @return ProdAgrupado
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	ProdAgrupado edit(@RequestBody ProdAgrupado prodAgrupado) {
		ProdAgrupado prodAgrupadoAux = this.prodAgrupadoService
				.update(prodAgrupado);
		ProdAgrupadoController.logger
				.info("[PUT] : ProdAgrupado actualizado correctamente");
		return prodAgrupadoAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param prodAgrupado
	 *            ProdAgrupado
	 * @return ProdAgrupado
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	ProdAgrupado add(@RequestBody ProdAgrupado prodAgrupado) {
		ProdAgrupado prodAgrupadoAux = this.prodAgrupadoService
				.add(prodAgrupado);
		ProdAgrupadoController.logger
				.info("[POST] : ProdAgrupado insertado correctamente");
		return prodAgrupadoAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param e8codigo
	 *            String
	 * @return prodAgrupado
	 */
	@RequestMapping(value = "/{e8codigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	ProdAgrupado remove(@PathVariable String e8codigo) {
		ProdAgrupado prodAgrupado = new ProdAgrupado();
		prodAgrupado.setE8codigo(e8codigo);
		this.prodAgrupadoService.remove(prodAgrupado);
		ProdAgrupadoController.logger
				.info("[DELETE] : ProdAgrupado borrado correctamente");
		return prodAgrupado;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param prodAgrupadoIds
	 *            List
	 * @return prodAgrupadoList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> prodAgrupadoIds) {
		List<ProdAgrupado> prodAgrupadoList = new ArrayList<ProdAgrupado>();
		for (List<String> prodAgrupadoId : prodAgrupadoIds) {
			Iterator<String> iterator = prodAgrupadoId.iterator();
			ProdAgrupado prodAgrupado = new ProdAgrupado(); // NOPMD - Objeto
															// nuevo en la lista
															// (parametro del
															// servicio)
			prodAgrupado.setE8codigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			prodAgrupadoList.add(prodAgrupado);
		}
		this.prodAgrupadoService.removeMultiple(prodAgrupadoList);
		ProdAgrupadoController.logger
				.info("[POST - DELETE_ALL] : ProdAgrupado borrados correctamente");
		return prodAgrupadoIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterProdAgrupado
	 *            ProdAgrupado
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute ProdAgrupado filterProdAgrupado,
			@ModelAttribute Pagination pagination) {
		List<ProdAgrupado> prodAgrupados = this.prodAgrupadoService.findAll(
				filterProdAgrupado, pagination);
		Long recordNum = this.prodAgrupadoService
				.findAllCount(filterProdAgrupado);
		ProdAgrupadoController.logger
				.info("[GET - jqGrid] : Obtener ProdAgrupado");
		return new JQGridJSONModel(pagination, recordNum, prodAgrupados);
	}

	/**
	 * Method 'getAllProdagrupado'. de tipo like
	 * 
	 * @param e8codigo_
	 *            String
	 * @param e8nombre_
	 *            String
	 * @param e8nombree_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/like", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllProdagrupado(
			@RequestParam(value = "e8codigo", required = false) String e8codigo_,
			@RequestParam(value = "e8nombre", required = false) String e8nombre_,
			@RequestParam(value = "e8nombree", required = false) String e8nombree_,
			HttpServletRequest request) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String e8codigo = ("".equals(e8codigo_)) ? null : e8codigo_;
			String e8nombre = null;
			String e8nombree = null;

			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
				e8nombre = ("".equals(e8nombre_)) ? null : e8nombre_;
			} else {
				e8nombree = ("".equals(e8nombre_)) ? null : e8nombre_;
			}

			ProdAgrupado filterProdAgrupado = new ProdAgrupado(e8codigo,
					e8nombre, e8nombree);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<ProdAgrupado> prodAgrupados = this.prodAgrupadoService
						.findAllLike(filterProdAgrupado, pagination, false);

				if (prodAgrupados == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.prodAgrupadoService.findAllLikeCount(
						filterProdAgrupado, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(prodAgrupados);
				return data;
			} else {
				List<ProdAgrupado> prodAgrupados = this.prodAgrupadoService
						.findAllLike(filterProdAgrupado, pagination, false);
				if (prodAgrupados == null) {
					throw new Exception("No data Found.");
				}
				return prodAgrupados;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

}
