package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.PosibleTramite;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.service.PosibleTramiteService;
import com.ejie.y41b.service.TramiteService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * PosibleTramiteController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/posibletramite")
public class PosibleTramiteController {

	private static final Logger logger = LoggerFactory
			.getLogger(PosibleTramiteController.class);

	@Autowired
	private PosibleTramiteService posibleTramiteService;
	@Autowired
	private TramiteService tramiteService;
	@Autowired
	private Properties appConfiguration;

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintPosiblesTramites", method = RequestMethod.GET)
	public String getCreateForm(Model model, HttpServletRequest request) {
		PosibleTramiteController.logger.info("[GET - View] : posibletramite");

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return "accessDeniedEscritorio";
		} else {
			return "posiblestramites";
		}
	}

	/**
	 * Method 'getCreateFormAlta'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "alta", method = RequestMethod.GET)
	public ModelAndView getCreateFormAltaReclamacion(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("pcodigo", Y41bUIDGenerator.getInstance()
				.generateId(Y41bConstantes.PK_SIZE));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("posiblestramitemodal", "model", model);
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param trposiblecodigo
	 *            String
	 * @return posibleTramite PosibleTramite
	 */
	@RequestMapping(value = "/{trposiblecodigo}", method = RequestMethod.GET)
	public @ResponseBody
	PosibleTramite getById(@PathVariable String trposiblecodigo) {
		PosibleTramite posibleTramite = new PosibleTramite();
		posibleTramite.setTrposiblecodigo(trposiblecodigo);
		posibleTramite = this.posibleTramiteService.find(posibleTramite);
		PosibleTramiteController.logger
				.info("[GET - findBy_PK] : Obtener PosibleTramite por PK");
		return posibleTramite;
	}

	/**
	 * Method 'findTramitePosiblesTemporal'.
	 * 
	 * @param pcodigo_
	 *            String
	 * @param trposiblecodigoorigen_
	 *            String
	 * @param tiposolicitud_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findTramitePosiblesTemporal", method = RequestMethod.GET)
	public @ResponseBody
	Object findTramitePosiblesTemporal(
			@RequestParam(value = "trcodigo", required = false) String trposiblecodigoorigen_,
			@RequestParam(value = "pcodigo", required = false) String pcodigo_,
			@RequestParam(value = "tiposolicitud", required = false) String tiposolicitud_,
			HttpServletRequest request) {
		try {
			String trposiblecodigoorigen = ("".equals(trposiblecodigoorigen_)) ? null
					: trposiblecodigoorigen_;
			String pcodigo = ("".equals(pcodigo_)) ? null : pcodigo_;
			String tiposolicitud = ("".equals(tiposolicitud_)) ? null
					: tiposolicitud_;

			TipoProcedimiento procedimiento = new TipoProcedimiento();
			procedimiento.setPcodigo(pcodigo);

			PosibleTramite posibleTramite = new PosibleTramite(null,
					trposiblecodigoorigen, null, procedimiento);
			posibleTramite.setTiposolicitud(tiposolicitud);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Tramite> tramites = this.posibleTramiteService
						.findAllPosibleTramiteTemporal(posibleTramite,
								pagination);

				if (tramites == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.posibleTramiteService
						.findAllPosibleTramiteTemporalCount(posibleTramite);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(tramites);
				return data;
			} else {
				List<Tramite> tramites = this.posibleTramiteService
						.findAllPosibleTramiteTemporal(posibleTramite,
								pagination);
				if (tramites == null) {
					throw new Exception("No data Found.");
				}
				return tramites;
			}

		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'findAllTramites'.
	 * 
	 * @param pcodigo_
	 *            String
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllTramites", method = RequestMethod.GET)
	public @ResponseBody
	Object findAllTramites(
			@RequestParam(value = "pcodigo", required = false) String pcodigo_,
			HttpServletRequest request) {
		try {

			String pcodigo = ("".equals(pcodigo_)) ? null : pcodigo_;

			Tramite tramite = new Tramite();
			tramite.setPcodigo(pcodigo);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Tramite> tramites = this.tramiteService.findAll(tramite,
						pagination);
				if (tramites == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.tramiteService.findAllCount(tramite);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(tramites);
				return data;
			} else {
				List<Tramite> tramites = this.tramiteService.findAll(tramite,
						pagination);
				if (tramites == null) {
					throw new Exception("No data Found.");
				}
				return tramites;
			}

		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterPosibleTramite
	 *            PosibleTramite
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<PosibleTramite> getAll(
			@ModelAttribute PosibleTramite filterPosibleTramite) {
		PosibleTramiteController.logger
				.info("[GET - find_ALL] : Obtener PosibleTramite por filtro");
		return this.posibleTramiteService.findAll(filterPosibleTramite, null);
	}

	/**
	 * Method 'findTramite'.
	 * 
	 * @param pcodigo
	 *            String
	 * @param trcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return posibleTramite
	 */

	@RequestMapping(value = "/findTramite", method = RequestMethod.GET)
	public @ResponseBody
	Object findTramite(
			@RequestParam(value = "trcodigo", required = false) String trcodigo,
			@RequestParam(value = "pcodigo", required = false) String pcodigo,
			HttpServletRequest request) {

		Tramite tramite = new Tramite();
		tramite.setPcodigo(pcodigo);
		tramite.setTrcodigo(trcodigo);

		tramite = this.posibleTramiteService.findTramite(tramite);
		PosibleTramiteController.logger
				.info("[findTramite] : tramite encontrado correctamente");
		return tramite;
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param posibleTramite
	 *            PosibleTramite
	 * @return PosibleTramite
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	PosibleTramite edit(@RequestBody PosibleTramite posibleTramite) {
		PosibleTramite posibleTramiteAux = this.posibleTramiteService
				.update(posibleTramite);
		PosibleTramiteController.logger
				.info("[PUT] : PosibleTramite actualizado correctamente");
		return posibleTramiteAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param posibleTramite
	 *            PosibleTramite
	 * @return PosibleTramite
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	PosibleTramite add(@RequestBody PosibleTramite posibleTramite) {
		PosibleTramite posibleTramiteAux = this.posibleTramiteService
				.add(posibleTramite);
		PosibleTramiteController.logger
				.info("[POST] : PosibleTramite insertado correctamente");
		return posibleTramiteAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param trposiblecodigoorigen
	 *            String
	 * @param tiposolicitud
	 *            String
	 * @param trcodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/removeTramite/{trposiblecodigoorigen}/{tiposolicitud}/{trcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	void remove(@PathVariable String trposiblecodigoorigen,
			@PathVariable String tiposolicitud, @PathVariable String trcodigo,
			HttpServletResponse response) {
		try {
			PosibleTramite posibleTramite = new PosibleTramite();
			posibleTramite.setTrposiblecodigoorigen(trposiblecodigoorigen);
			posibleTramite.setTrposiblecodigosiguiente(trcodigo);
			posibleTramite.setTiposolicitud(tiposolicitud);

			this.posibleTramiteService
					.removePosibleTramiteTemporal(posibleTramite);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {

			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}

	}

	/**
	 * Method 'remove'.
	 * 
	 * @param trposiblecodigoorigen
	 *            String
	 * @param trcodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/removeTramite/{trposiblecodigoorigen}/{trcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	void remove(@PathVariable String trposiblecodigoorigen,
			@PathVariable String trcodigo, HttpServletResponse response) {
		try {
			PosibleTramite posibleTramite = new PosibleTramite();
			posibleTramite.setTrposiblecodigoorigen(trposiblecodigoorigen);
			posibleTramite.setTrposiblecodigosiguiente(trcodigo);

			this.posibleTramiteService
					.removePosibleTramiteTemporal(posibleTramite);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {

			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}

	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param posibleTramiteIds
	 *            List
	 * @return posibleTramiteList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> posibleTramiteIds) {
		List<PosibleTramite> posibleTramiteList = new ArrayList<PosibleTramite>();
		for (List<String> posibleTramiteId : posibleTramiteIds) {
			Iterator<String> iterator = posibleTramiteId.iterator();
			PosibleTramite posibleTramite = new PosibleTramite(); // NOPMD -
																	// Objeto
																	// nuevo en
																	// la lista
																	// (parametro
																	// del
																	// servicio)
			posibleTramite.setTrposiblecodigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			posibleTramiteList.add(posibleTramite);
		}
		this.posibleTramiteService.removeMultiple(posibleTramiteList);
		PosibleTramiteController.logger
				.info("[POST - DELETE_ALL] : PosibleTramite borrados correctamente");
		return posibleTramiteIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterPosibleTramite
	 *            PosibleTramite
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute PosibleTramite filterPosibleTramite,
			@ModelAttribute Pagination pagination) {
		List<PosibleTramite> posibleTramites = this.posibleTramiteService
				.findAll(filterPosibleTramite, pagination);
		Long recordNum = this.posibleTramiteService
				.findAllCount(filterPosibleTramite);
		PosibleTramiteController.logger
				.info("[GET - jqGrid] : Obtener PosibleTramite");
		return new JQGridJSONModel(pagination, recordNum, posibleTramites);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param response
	 *            HttpServletResponse
	 * @return Tramite
	 */
	@RequestMapping(value = "/update", method = RequestMethod.PUT)
	public @ResponseBody
	Tramite edit(@RequestBody Tramite tramite, HttpServletResponse response) {
		try {
			Tramite tramiteAux = this.posibleTramiteService
					.updateTramite(tramite);
			logger.info("Entity correctly inserted!");
			return tramiteAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'addTramite'.
	 * 
	 * @param posibleTramite
	 *            PosibleTramite
	 * 
	 * 
	 * @return PosibleTramite
	 */
	@RequestMapping(value = "/anyadirTramite", method = RequestMethod.POST)
	public @ResponseBody
	PosibleTramite addTramite(@RequestBody PosibleTramite posibleTramite) {

		try {
			PosibleTramite posibleTramiteAux = this.posibleTramiteService
					.addPosibleTramiteTemporal(posibleTramite);
			return posibleTramiteAux;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}
}
