package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.rowset.serial.SerialBlob;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.PlantillaTramite;
import com.ejie.y41b.model.PlantillaTramiteBusqueda;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.service.PlantillaTramiteService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * * PlantillaTramiteController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/plantillatramite")
@SessionAttributes({ "modoPlantillaTramite" })
public class PlantillaTramiteController {

	private static final Logger logger = LoggerFactory
			.getLogger(PlantillaTramiteController.class);

	@Autowired
	private PlantillaTramiteService plantillaTramiteService;

	@Autowired
	private Properties appConfiguration;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */
	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * 
	 * 
	 * Metodos LISTADO Plantilla Tramite INICIO
	 * 
	 * 
	 * 
	 */

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("plantillatramite", "model", model);
		}
	}

	/**
	 * Method 'getByIdDocumentoTramiteDetalle'.
	 * 
	 * @param cofile
	 *            Long
	 * 
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "tramitefile/{cofile}", method = RequestMethod.GET)
	public @ResponseBody
	void getByIdDocumentoTramiteDetalle(@PathVariable String cofile,
			HttpServletResponse response) {
		try {
			PlantillaTramite plantillaTramite = new PlantillaTramite();
			plantillaTramite.setPtcodigo(cofile);
			plantillaTramite = this.plantillaTramiteService
					.obtenerDocumentoPlantilla(plantillaTramite);
			if (plantillaTramite == null) {
				throw new Exception(cofile.toString());
			}

			Blob contenido = plantillaTramite.getPtplantilla();
			byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader(
					"Content-Disposition",
					"attachment; filename=\""
							+ StringEscapeUtils.unescapeHtml(plantillaTramite
									.getPtnofile()) + "\"");
			response.setContentType(plantillaTramite.getPtcontenttypefile());
			response.setContentLength(plantillaTramite.getPtsizefile());
			response.getOutputStream().write(bContenido);

			// Vaciamos el stream
			response.getOutputStream().flush();

			// return documentoConsultaDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(cofile.toString());
		}
	}

	/**
	 * Method 'getAllDocsTramite'.
	 * 
	 * @param trcodigo_
	 *            String
	 * @param pcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/getAllDocsTramite", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllDocsTramite(
			@RequestParam(value = "trcodigo", required = false) String trcodigo_,
			@RequestParam(value = "pcodigo", required = false) String pcodigo,
			HttpServletRequest request) {
		try {
			// Importante para que no filtre nada si no viene el codigo del tipo
			// de decision
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;

			PlantillaTramite filterPlantillaTramite = new PlantillaTramite(
					null, Y41bConstantes.CODIGO_ORGANISMO_LAKUA, null, null,
					null, null, null, null, null, null, null, null, null,
					new Tramite(trcodigo, null, null, null, null, null, null,
							null, null), pcodigo, null, null);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<PlantillaTramiteBusqueda> plantillaTramitesBusqueda = this.plantillaTramiteService
						.findAllPlantillaTramiteByTramite(
								filterPlantillaTramite, pagination);

				if (plantillaTramitesBusqueda == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCountDocsTramite(filterPlantillaTramite,
						request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(plantillaTramitesBusqueda);
				return data;
			} else {
				List<PlantillaTramiteBusqueda> plantillaTramitesBusqueda = this.plantillaTramiteService
						.findAllPlantillaTramite(filterPlantillaTramite,
								pagination);
				if (plantillaTramitesBusqueda == null) {
					throw new Exception("No data Found.");
				}
				return plantillaTramitesBusqueda;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCountDocsTramite'.
	 * 
	 * @param filterPlantillaTramite
	 *            PlantillaTramite
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCountDocsTramite(
			@RequestParam(value = "plantillaTramite", required = false) PlantillaTramite filterPlantillaTramite,
			HttpServletRequest request) {
		try {
			return plantillaTramiteService
					.findAllPlantillaTramiteCount(filterPlantillaTramite != null ? filterPlantillaTramite
							: new PlantillaTramite());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * 
	 * 
	 * Metodos LISTADO Plantilla Tramite FIN
	 * 
	 * 
	 * 
	 */
	/**
	 * 
	 * 
	 * Metodos DETALLE Plantilla Tramite INICIO
	 * 
	 * 
	 * 
	 */

	/**
	 * Method 'getCreateFormModal'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintAlta", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		model.addAttribute("modoPlantillaTramite",
				Y41bConstantes.MODO_POPUP_ALTA);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("plantillatramitemodal", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormModal'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintMod", method = RequestMethod.GET)
	public ModelAndView getCreateFormMod(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		model.addAttribute("modoPlantillaTramite",
				Y41bConstantes.MODO_POPUP_MODIFICACION);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("plantillatramitemodal", "model", model);
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param ptcodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "removePlantillaTramite/{ptcodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String ptcodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			PlantillaTramite plantillaTramite = new PlantillaTramite();
			plantillaTramite.setPtcodigo(ptcodigo);
			this.plantillaTramiteService.remove(plantillaTramite);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			logger.error("Unable to delete " + ptcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'getPlantillaTramiteById'.
	 * 
	 * @param idPlantillaTramite
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return PlantillaTramite
	 */
	@RequestMapping(value = "/findPlantillaTramite/{idPlantillaTramite}", method = RequestMethod.GET)
	public @ResponseBody
	PlantillaTramite getPlantillaTramiteById(
			@PathVariable String idPlantillaTramite, HttpServletRequest request) {
		try {
			PlantillaTramite plantillaTramiteAux = new PlantillaTramite();
			plantillaTramiteAux.setPtcodigo(idPlantillaTramite);

			// Si no existe dejo introducirla
			PlantillaTramite plantillaTramite = this.plantillaTramiteService
					.find(plantillaTramiteAux);

			if (plantillaTramite == null) {
				throw new Exception(idPlantillaTramite.toString());
			}
			return plantillaTramite;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addPlantillaTramite'.
	 * 
	 * @param file
	 *            MultipartFile
	 * 
	 * @param response
	 *            HttpServletResponse
	 * @param modoPlantillaTramite
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return ConsultaFile
	 */
	@RequestMapping(value = "guardarPlantillaTramite", method = RequestMethod.POST)
	public @ResponseBody
	List<Map<String, Object>> addPlantillaTramite(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			@ModelAttribute(value = "modoPlantillaTramite") String modoPlantillaTramite,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			String trcodigo = request.getParameter("trcodigo");
			String ptcodigo = "";
			if (modoPlantillaTramite != null
					&& modoPlantillaTramite
							.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
				ptcodigo = Y41bUIDGenerator.getInstance().generateId(
						Y41bConstantes.PK_SIZE);
			} else if (modoPlantillaTramite
					.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
				ptcodigo = request.getParameter("ptcodigo");
			}

			String ptnombre = request.getParameter("ptnombre");
			String ptcoor = Y41bConstantes.CODIGO_ORGANISMO_LAKUA;

			String tiposolicitud = request.getParameter("tipoSolicitud");
			String noLocalizable_ = request.getParameter("noLocalizable");

			String noLocalizable = "";
			if (noLocalizable_ != null && noLocalizable_.equals("on")) {
				noLocalizable = Y41bConstantes.VALOR_SI;
			}

			PlantillaTramite plantillaTramite = new PlantillaTramite();
			plantillaTramite.setPtcodigo(ptcodigo);
			plantillaTramite.setPtcoor(ptcoor);
			Tramite tramite = new Tramite();
			tramite.setTrcodigo(trcodigo);
			plantillaTramite.setTramite(tramite);
			plantillaTramite.setPtultmodificacion(new Date());
			plantillaTramite.setTiposolicitud(tiposolicitud);
			plantillaTramite.setNolocalizable(noLocalizable);

			if (file != null) {
				Blob blob = new SerialBlob(file.getBytes());
				plantillaTramite.setPtplantilla(blob);
				plantillaTramite.setPtnofile(file.getOriginalFilename());
				plantillaTramite.setPtnombre(ptnombre);
				plantillaTramite.setPtcontenttypefile(file.getContentType());
				plantillaTramite.setPtsizefile((int) file.getSize());
			}

			PlantillaTramite plantillaTramiteAux = null;

			// Si no existe dejo introducirla
			if (modoPlantillaTramite != null
					&& modoPlantillaTramite
							.equals(Y41bConstantes.MODO_POPUP_ALTA)) {
				// Antes de insertar la plantilla compruebo que para ese tramite
				// no exista ninguna con ese nombre
				Long numReg = this.plantillaTramiteService
						.findAllCountPlantillaTramiteByNombre(plantillaTramite);
				if (numReg > 0) {
					// Si existe mando una excepcion
					throw new Y41bUDAException(
							"error.plantillatramite.duplicateException", true,
							null);
				}

				plantillaTramiteAux = this.plantillaTramiteService
						.add(plantillaTramite);
				logger.info("Entity correctly inserted!" + plantillaTramiteAux);
			} else if (modoPlantillaTramite
					.equals(Y41bConstantes.MODO_POPUP_MODIFICACION)) {
				plantillaTramiteAux = this.plantillaTramiteService
						.update(plantillaTramite);
				logger.info("Entity correctly update!" + plantillaTramiteAux);
			}

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			if (file != null) {
				filesMetaInfo.add(this.getFileReturnMap(file));
			}
			return filesMetaInfo;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * @param file
	 *            MultipartFile
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMap(MultipartFile file) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();
		mapaRetorno.put("url",
				"../plantillatramite/guardarPlantillaTramite?R01HNoPortal=true"
						+ file.getOriginalFilename());
		mapaRetorno.put("name", file.getOriginalFilename());
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno.put("delete_url",
				"../plantillatramite/guardarPlantillaTramite?R01HNoPortal=true"
						+ file.getOriginalFilename());
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/**
	 * 
	 * 
	 * Metodos DETALLE Plantilla Tramite FIN
	 * 
	 * 
	 * 
	 */

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getPlantillaTramiteService'.
	 * 
	 * @return PlantillaTramiteService
	 */
	protected PlantillaTramiteService getPlantillaTramiteService() {
		return this.plantillaTramiteService;
	}

	/**
	 * Method 'setPlantillaTramiteService'.
	 * 
	 * @param plantillaTramiteService
	 *            PlantillaTramiteService
	 * @return
	 */
	public void setPlantillaTramiteService(
			PlantillaTramiteService plantillaTramiteService) {
		this.plantillaTramiteService = plantillaTramiteService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
