package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.rowset.serial.SerialBlob;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Decision;
import com.ejie.y41b.model.PlantillaDecision;
import com.ejie.y41b.model.PlantillaDecisionBusqueda;
import com.ejie.y41b.service.PlantillaDecisionService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * * PlantillaDecisionController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/plantilladecision")
public class PlantillaDecisionController {

	private static final Logger logger = LoggerFactory
			.getLogger(PlantillaDecisionController.class);

	@Autowired
	private PlantillaDecisionService plantillaDecisionService;

	@Autowired
	private Properties appConfiguration;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */
	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * 
	 * 
	 * Metodos LISTADO Plantilla Decision INICIO
	 * 
	 * 
	 * 
	 */

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("plantilladecision", "model", model);
		}
	}

	/**
	 * Method 'getByIdDocumentoDecisionDetalle'.
	 * 
	 * @param cofile
	 *            Long
	 * 
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "decisionfile/{cofile}", method = RequestMethod.GET)
	public @ResponseBody
	void getByIdDocumentoDecisionDetalle(@PathVariable String cofile,
			HttpServletResponse response) {
		try {
			PlantillaDecision plantillaDecision = new PlantillaDecision();
			plantillaDecision.setPdcodigo(cofile);
			plantillaDecision = this.plantillaDecisionService
					.obtenerDocumentoPlantilla(plantillaDecision);
			if (plantillaDecision == null) {
				throw new Exception(cofile.toString());
			}

			Blob contenido = plantillaDecision.getPdplantilla();
			byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader(
					"Content-Disposition",
					"attachment; filename=\""
							+ StringEscapeUtils.unescapeHtml(plantillaDecision
									.getPdnofile()) + "\"");
			response.setContentType(plantillaDecision.getPdcontenttypefile());
			response.setContentLength(plantillaDecision.getPdsizefile());
			response.getOutputStream().write(bContenido);

			// Vaciamos el stream
			response.getOutputStream().flush();

			// return documentoConsultaDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(cofile.toString());
		}
	}

	/**
	 * Method 'getAllDocsDecision'.
	 * 
	 * @param decodigo_
	 *            String
	 * @param pcodigo
	 *            String
	 * @param detiposolicitud
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "/getAllDocsDecision", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllDocsDecision(
			@RequestParam(value = "decodigo", required = false) String decodigo_,
			@RequestParam(value = "pcodigo", required = false) String pcodigo,
			@RequestParam(value = "detiposolicitud", required = false) String detiposolicitud,
			HttpServletRequest request) {
		try {
			// Importante para que no filtre nada si no viene el codigo del tipo
			// de decision
			String decodigo = ("".equals(decodigo_)) ? null : decodigo_;

			PlantillaDecision filterPlantillaDecision = new PlantillaDecision(
					null, Y41bConstantes.CODIGO_ORGANISMO_LAKUA, null, null,
					null, null, null, null, null, null, null, null, null,
					new Decision(decodigo, null, null, null, null, pcodigo,
							detiposolicitud));

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<PlantillaDecisionBusqueda> plantillaDecisionsBusqueda = this.plantillaDecisionService
						.findAllPlantillaDecisionByDecision(
								filterPlantillaDecision, pagination);

				if (plantillaDecisionsBusqueda == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCountDocsDecision(filterPlantillaDecision,
						request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(plantillaDecisionsBusqueda);
				return data;
			} else {
				List<PlantillaDecisionBusqueda> plantillaDecisionsBusqueda = this.plantillaDecisionService
						.findAllPlantillaDecision(filterPlantillaDecision,
								pagination);
				if (plantillaDecisionsBusqueda == null) {
					throw new Exception("No data Found.");
				}
				return plantillaDecisionsBusqueda;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCountDocsDecision'.
	 * 
	 * @param filterPlantillaDecision
	 *            PlantillaDecision
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCountDocsDecision(
			@RequestParam(value = "plantillaDecision", required = false) PlantillaDecision filterPlantillaDecision,
			HttpServletRequest request) {
		try {
			return plantillaDecisionService
					.findAllPlantillaDecisionCount(filterPlantillaDecision != null ? filterPlantillaDecision
							: new PlantillaDecision());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * 
	 * 
	 * Metodos LISTADO Plantilla Decision FIN
	 * 
	 * 
	 * 
	 */
	/**
	 * 
	 * 
	 * Metodos DETALLE Plantilla Decision INICIO
	 * 
	 * 
	 * 
	 */

	/**
	 * Method 'getCreateFormModal'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintModal", method = RequestMethod.GET)
	public ModelAndView getCreateFormModal(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("plantilladecisionmodal", "model", model);
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param pdcodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "removePlantillaDecision/{pdcodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String pdcodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			PlantillaDecision plantillaDecision = new PlantillaDecision();
			plantillaDecision.setPdcodigo(pdcodigo);
			this.plantillaDecisionService.remove(plantillaDecision);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + pdcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'addPlantillaDecision'.
	 * 
	 * @param file
	 *            MultipartFile
	 * 
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return ConsultaFile
	 */
	@RequestMapping(value = "guardarPlantillaDecision", method = RequestMethod.POST)
	public @ResponseBody
	List<Map<String, Object>> addPlantillaDecision(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			String decodigo = request.getParameter("decodigo");
			String ptcodigo = Y41bUIDGenerator.getInstance().generateId(
					Y41bConstantes.PK_SIZE);
			String ptnombre = request.getParameter("ptnombre");
			String ptcoor = Y41bConstantes.CODIGO_ORGANISMO_LAKUA;

			PlantillaDecision plantillaDecision = new PlantillaDecision();
			plantillaDecision.setPdcodigo(ptcodigo);
			plantillaDecision.setPdcoor(ptcoor);
			Decision decision = new Decision();
			decision.setDecodigo(decodigo);
			plantillaDecision.setDecision(decision);
			plantillaDecision.setPdultmodificacion(new Date());

			if (file != null) {
				Blob blob = new SerialBlob(file.getBytes());
				plantillaDecision.setPdplantilla(blob);
				plantillaDecision.setPdnofile(file.getOriginalFilename());
				plantillaDecision.setPdnombre(ptnombre);
				plantillaDecision.setPdcontenttypefile(file.getContentType());
				plantillaDecision.setPdsizefile((int) file.getSize());
			}

			// Antes de insertar la plantilla compruebo que para esa decision no
			// exista ninguna con ese nombre
			Long numReg = this.plantillaDecisionService
					.findAllCountPlantillaDecisionByNombre(plantillaDecision);
			if (numReg > 0) {
				// Si existe mando una excepcion
				throw new Y41bUDAException(
						"error.plantilladecision.duplicateException", true,
						null);
			}
			// Si no existe dejo introducirla
			PlantillaDecision plantillaDecisionAux = this.plantillaDecisionService
					.add(plantillaDecision);

			logger.info("Entity correctly update!" + plantillaDecisionAux);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			if (file != null) {
				filesMetaInfo.add(this.getFileReturnMap(file));
			}
			return filesMetaInfo;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * @param file
	 *            MultipartFile
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMap(MultipartFile file) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();
		mapaRetorno.put("url",
				"../plantilladecision/guardarPlantillaDecision?R01HNoPortal=true"
						+ file.getOriginalFilename());
		mapaRetorno.put("name", file.getOriginalFilename());
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno.put("delete_url",
				"../plantilladecision/guardarPlantillaDecision?R01HNoPortal=true"
						+ file.getOriginalFilename());
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/**
	 * 
	 * 
	 * Metodos DETALLE Plantilla Decision FIN
	 * 
	 * 
	 * 
	 */

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getPlantillaDecisionService'.
	 * 
	 * @return PlantillaDecisionService
	 */
	protected PlantillaDecisionService getPlantillaDecisionService() {
		return this.plantillaDecisionService;
	}

	/**
	 * Method 'setPlantillaDecisionService'.
	 * 
	 * @param plantillaDecisionService
	 *            PlantillaDecisionService
	 * @return
	 */
	public void setPlantillaDecisionService(
			PlantillaDecisionService plantillaDecisionService) {
		this.plantillaDecisionService = plantillaDecisionService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}