package com.ejie.y41b.control;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.model.Empper;
import com.ejie.y41b.model.Peta1;
import com.ejie.y41b.service.Peta1Service;

/**
 * Peta1Controller  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/peta1")
public class Peta1Controller {

	private static final Logger logger = LoggerFactory
			.getLogger(Peta1Controller.class);

	@Autowired()
	private Peta1Service peta1Service;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		Peta1Controller.logger.info("[GET - View] : peta1");
		return "peta1";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param empperPecodigo
	 *            String
	 * @param m7cota1
	 *            String
	 * @param m7fecalta
	 *            Date
	 * @param m7usualta
	 *            String
	 * @return peta1 Peta1
	 */
	@RequestMapping(value = "/{empperPecodigo}/{m7cota1}/{m7fecalta}/{m7usualta}", method = RequestMethod.GET)
	public @ResponseBody()
	Peta1 getById(@PathVariable() String empperPecodigo,
			@PathVariable() String m7cota1, @PathVariable() Date m7fecalta,
			@PathVariable() String m7usualta) {
		Peta1 peta1 = new Peta1();
		peta1.setEmpper(new Empper());
		peta1.getEmpper().setPecodigo(empperPecodigo);
		peta1.setM7cota1(m7cota1);
		peta1.setM7fecalta(m7fecalta);
		peta1.setM7usualta(m7usualta);
		peta1 = this.peta1Service.find(peta1);
		Peta1Controller.logger.info("[GET - findBy_PK] : Obtener Peta1 por PK");
		return peta1;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterPeta1
	 *            Peta1
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Peta1> getAll(@ModelAttribute() Peta1 filterPeta1) {
		Peta1Controller.logger
				.info("[GET - find_ALL] : Obtener Peta1 por filtro");
		return this.peta1Service.findAll(filterPeta1, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param peta1
	 *            Peta1
	 * @return Peta1
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Peta1 edit(@RequestBody() Peta1 peta1) {
		Peta1 peta1Aux = this.peta1Service.update(peta1);
		Peta1Controller.logger.info("[PUT] : Peta1 actualizado correctamente");
		return peta1Aux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param peta1
	 *            Peta1
	 * @return Peta1
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Peta1 add(@RequestBody() Peta1 peta1) {
		Peta1 peta1Aux = this.peta1Service.add(peta1);
		Peta1Controller.logger.info("[POST] : Peta1 insertado correctamente");
		return peta1Aux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param empperPecodigo
	 *            String
	 * @param m7cota1
	 *            String
	 * @param m7fecalta
	 *            Date
	 * @param m7usualta
	 *            String
	 * @return peta1
	 */
	@RequestMapping(value = "/{empperPecodigo}/{m7cota1}/{m7fecalta}/{m7usualta}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Peta1 remove(@PathVariable() String empperPecodigo,
			@PathVariable() String m7cota1, @PathVariable() Date m7fecalta,
			@PathVariable() String m7usualta) {
		Peta1 peta1 = new Peta1();
		peta1.setEmpper(new Empper());
		peta1.getEmpper().setPecodigo(empperPecodigo);
		peta1.setM7cota1(m7cota1);
		peta1.setM7fecalta(m7fecalta);
		peta1.setM7usualta(m7usualta);
		this.peta1Service.remove(peta1);
		Peta1Controller.logger.info("[DELETE] : Peta1 borrado correctamente");
		return peta1;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param peta1Ids
	 *            List
	 * @return peta1List
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(@RequestBody() List<List<String>> peta1Ids) {
		List<Peta1> peta1List = new ArrayList<Peta1>();
		for (List<String> peta1Id : peta1Ids) {
			Iterator<String> iterator = peta1Id.iterator();
			Peta1 peta1 = new Peta1(); // NOPMD - Objeto nuevo en la lista
										// (parametro del servicio)
			peta1.setEmpper(new Empper()); // NOPMD - Objeto nuevo en la lista
											// (parametro del servicio)
			peta1.getEmpper().setPecodigo(
					ObjectConversionManager.convert(iterator.next(),
							String.class));
			peta1.setM7cota1(ObjectConversionManager.convert(iterator.next(),
					String.class));
			peta1.setM7fecalta(ObjectConversionManager.convert(iterator.next(),
					java.util.Date.class));
			peta1.setM7usualta(ObjectConversionManager.convert(iterator.next(),
					String.class));
			peta1List.add(peta1);
		}
		this.peta1Service.removeMultiple(peta1List);
		Peta1Controller.logger
				.info("[POST - DELETE_ALL] : Peta1 borrados correctamente");
		return peta1Ids;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterPeta1
	 *            Peta1
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(@ModelAttribute() Peta1 filterPeta1,
			@ModelAttribute() Pagination pagination) {
		List<Peta1> peta1s = this.peta1Service.findAll(filterPeta1, pagination);
		Long recordNum = this.peta1Service.findAllCount(filterPeta1);
		Peta1Controller.logger.info("[GET - jqGrid] : Obtener Peta1");
		return new JQGridJSONModel(pagination, recordNum, peta1s);
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param pecodigo
	 *            String
	 * @return List
	 */
	@RequestMapping(value = "/checks/{pecodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	List<Peta1> getChecks(@PathVariable() String pecodigo) {
		Peta1Controller.logger
				.info("[GET - find_ALL] : Obtener Arta1 por filtro");
		Peta1 filterPeta1 = new Peta1();
		Empper empper = new Empper();
		empper.setPecodigo(pecodigo);
		filterPeta1.setEmpper(empper);
		return this.peta1Service.findAll(filterPeta1, null);
	}

}
