package com.ejie.y41b.control;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.model.Empper;
import com.ejie.y41b.model.Pese;
import com.ejie.y41b.service.PeseService;

/**
 * PeseController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/pese")
public class PeseController {

	private static final Logger logger = LoggerFactory
			.getLogger(PeseController.class);

	@Autowired()
	private PeseService peseService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		PeseController.logger.info("[GET - View] : pese");
		return "pese";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param empperPecodigo
	 *            String
	 * @param m8cose
	 *            String
	 * @param m8fecalta
	 *            Date
	 * @param m8usualta
	 *            String
	 * @return pese Pese
	 */
	@RequestMapping(value = "/{empperPecodigo}/{m8cose}/{m8fecalta}/{m8usualta}", method = RequestMethod.GET)
	public @ResponseBody()
	Pese getById(@PathVariable() String empperPecodigo,
			@PathVariable() String m8cose, @PathVariable() Date m8fecalta,
			@PathVariable() String m8usualta) {
		Pese pese = new Pese();
		pese.setEmpper(new Empper());
		pese.getEmpper().setPecodigo(empperPecodigo);
		pese.setM8cose(m8cose);
		pese.setM8fecalta(m8fecalta);
		pese.setM8usualta(m8usualta);
		pese = this.peseService.find(pese);
		PeseController.logger.info("[GET - findBy_PK] : Obtener Pese por PK");
		return pese;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterPese
	 *            Pese
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Pese> getAll(@ModelAttribute() Pese filterPese) {
		PeseController.logger
				.info("[GET - find_ALL] : Obtener Pese por filtro");
		return this.peseService.findAll(filterPese, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param pese
	 *            Pese
	 * @return Pese
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Pese edit(@RequestBody() Pese pese) {
		Pese peseAux = this.peseService.update(pese);
		PeseController.logger.info("[PUT] : Pese actualizado correctamente");
		return peseAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param pese
	 *            Pese
	 * @return Pese
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Pese add(@RequestBody() Pese pese) {
		Pese peseAux = this.peseService.add(pese);
		PeseController.logger.info("[POST] : Pese insertado correctamente");
		return peseAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param empperPecodigo
	 *            String
	 * @param m8cose
	 *            String
	 * @return pese
	 */
	@RequestMapping(value = "/{empperPecodigo}/{m8cose}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Pese remove(@PathVariable() String empperPecodigo,
			@PathVariable() String m8cose) {
		Pese pese = new Pese();
		pese.setEmpper(new Empper());
		pese.getEmpper().setPecodigo(empperPecodigo);
		pese.setM8cose(m8cose);
		this.peseService.remove(pese);
		PeseController.logger.info("[DELETE] : Pese borrado correctamente");
		return pese;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param peseIds
	 *            List
	 * @return peseList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(@RequestBody() List<List<String>> peseIds) {
		List<Pese> peseList = new ArrayList<Pese>();
		for (List<String> peseId : peseIds) {
			Iterator<String> iterator = peseId.iterator();
			Pese pese = new Pese(); // NOPMD - Objeto nuevo en la lista
									// (parametro del servicio)
			pese.setEmpper(new Empper()); // NOPMD - Objeto nuevo en la lista
											// (parametro del servicio)
			pese.getEmpper().setPecodigo(
					ObjectConversionManager.convert(iterator.next(),
							String.class));
			pese.setM8cose(ObjectConversionManager.convert(iterator.next(),
					String.class));
			pese.setM8fecalta(ObjectConversionManager.convert(iterator.next(),
					java.util.Date.class));
			pese.setM8usualta(ObjectConversionManager.convert(iterator.next(),
					String.class));
			peseList.add(pese);
		}
		this.peseService.removeMultiple(peseList);
		PeseController.logger
				.info("[POST - DELETE_ALL] : Pese borrados correctamente");
		return peseIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterPese
	 *            Pese
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(@ModelAttribute() Pese filterPese,
			@ModelAttribute() Pagination pagination) {
		List<Pese> peses = this.peseService.findAll(filterPese, pagination);
		Long recordNum = this.peseService.findAllCount(filterPese);
		PeseController.logger.info("[GET - jqGrid] : Obtener Pese");
		return new JQGridJSONModel(pagination, recordNum, peses);
	}

}
