package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.PerfilService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Perfil;

/**
 * PerfilController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/perfil")
public class PerfilController {

	private static final Logger logger = LoggerFactory
			.getLogger(PerfilController.class);

	@Autowired
	private PerfilService perfilService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		PerfilController.logger.info("[GET - View] : perfil");
		return "perfil";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idPerfil
	 *            String
	 * @return perfil Perfil
	 */
	@RequestMapping(value = "/{idPerfil}", method = RequestMethod.GET)
	public @ResponseBody
	Perfil getById(@PathVariable String idPerfil) {
		Perfil perfil = new Perfil();
		perfil.setIdPerfil(idPerfil);
		perfil = this.perfilService.find(perfil);
		PerfilController.logger
				.info("[GET - findBy_PK] : Obtener Perfil por PK");
		return perfil;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterPerfil
	 *            Perfil
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Perfil> getAll(@ModelAttribute Perfil filterPerfil) {
		PerfilController.logger
				.info("[GET - find_ALL] : Obtener Perfil por filtro");
		return this.perfilService.findAll(filterPerfil, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param perfil
	 *            Perfil
	 * @return Perfil
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Perfil edit(@RequestBody Perfil perfil) {
		Perfil perfilAux = this.perfilService.update(perfil);
		PerfilController.logger
				.info("[PUT] : Perfil actualizado correctamente");
		return perfilAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param perfil
	 *            Perfil
	 * @return Perfil
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Perfil add(@RequestBody Perfil perfil) {
		Perfil perfilAux = this.perfilService.add(perfil);
		PerfilController.logger.info("[POST] : Perfil insertado correctamente");
		return perfilAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idPerfil
	 *            String
	 * @return perfil
	 */
	@RequestMapping(value = "/{idPerfil}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Perfil remove(@PathVariable String idPerfil) {
		Perfil perfil = new Perfil();
		perfil.setIdPerfil(idPerfil);
		this.perfilService.remove(perfil);
		PerfilController.logger.info("[DELETE] : Perfil borrado correctamente");
		return perfil;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param perfilIds
	 *            List
	 * @return perfilList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(@RequestBody List<List<String>> perfilIds) {
		List<Perfil> perfilList = new ArrayList<Perfil>();
		for (List<String> perfilId : perfilIds) {
			Iterator<String> iterator = perfilId.iterator();
			Perfil perfil = new Perfil(); // NOPMD - Objeto nuevo en la lista
											// (parametro del servicio)
			perfil.setIdPerfil(ObjectConversionManager.convert(iterator.next(),
					String.class));
			perfilList.add(perfil);
		}
		this.perfilService.removeMultiple(perfilList);
		PerfilController.logger
				.info("[POST - DELETE_ALL] : Perfil borrados correctamente");
		return perfilIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterPerfil
	 *            Perfil
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Perfil filterPerfil,
			@ModelAttribute Pagination pagination) {
		List<Perfil> perfils = this.perfilService.findAll(filterPerfil,
				pagination);
		Long recordNum = this.perfilService.findAllCount(filterPerfil);
		PerfilController.logger.info("[GET - jqGrid] : Obtener Perfil");
		return new JQGridJSONModel(pagination, recordNum, perfils);
	}

	/**
	 * Method 'getAllMantenimiento'.
	 * 
	 * @return List
	 */

	@RequestMapping(value = "/mantenimiento", method = RequestMethod.GET)
	public @ResponseBody
	List<Perfil> getAllMantenimiento() {

		Perfil filterPerfil = new Perfil();
		filterPerfil.setIsmantenimiento(Y41bConstantes.SI);

		PerfilController.logger
				.info("[GET - find_ALL] : Obtener Perfiles por filtro");
		return this.perfilService.findAll(filterPerfil, null);
	}

	/**
	 * Method 'getAllConExpedientes'.
	 * 
	 * @return List
	 */
	@RequestMapping(value = "/conExpedientesUsuario", method = RequestMethod.GET)
	public @ResponseBody
	List<Perfil> getAllConExpedientesUsuario() {

		Perfil filterPerfil = new Perfil();
		filterPerfil.setIsmantenimiento(Y41bConstantes.NO);

		PerfilController.logger
				.info("[GET - find_ALL] : Obtener Perfil por filtro");
		return this.perfilService.findAll(filterPerfil, null);
	}

	/**
	 * Method 'getAllConExpedientes'.
	 * 
	 * @return List
	 */
	@RequestMapping(value = "/conExpedientesUsuarioSinSanciones", method = RequestMethod.GET)
	public @ResponseBody
	List<Perfil> getAllConExpedientesUsuarioSinSanciones() {

		Perfil filterPerfil = new Perfil();
		filterPerfil.setIsmantenimiento(Y41bConstantes.NO);

		PerfilController.logger
				.info("[GET - find_ALL] : Obtener Perfil por filtro");
		return this.perfilService.findAllSinSanciones(filterPerfil, null);
	}

	/**
	 * Method 'getAllConExpedientesUsuarioControlMercado'.
	 * 
	 * @return List
	 */
	@RequestMapping(value = "/conExpedientesUsuarioControlMercado", method = RequestMethod.GET)
	public @ResponseBody
	List<Perfil> getAllConExpedientesUsuarioControlMercado() {

		Perfil filterPerfil = new Perfil();
		filterPerfil.setIsmantenimiento(Y41bConstantes.NO);

		PerfilController.logger
				.info("[GET - find_ALL] : Obtener Perfil por filtro");
		return this.perfilService.findAllControlMercado(filterPerfil, null);
	}

	/**
	 * Method 'getAllConExpedientes'.
	 * 
	 * @return List
	 */
	@RequestMapping(value = "/conExpedientes", method = RequestMethod.GET)
	public @ResponseBody
	List<Perfil> getAllConExpedientes() {

		Perfil filterPerfil = new Perfil();
		filterPerfil.setIsmantenimiento(Y41bConstantes.NO);

		PerfilController.logger
				.info("[GET - find_ALL] : Obtener Perfil por filtro");
		return this.perfilService.findAllPerfilFirma(filterPerfil, null);
	}

	/**
	 * Method 'getAllConExpedientes'.
	 * 
	 * @return List
	 */
	@RequestMapping(value = "/conExpedientesFirmaArbitros", method = RequestMethod.GET)
	public @ResponseBody
	List<Perfil> getAllConExpedientesFirmaArbitros() {

		Perfil filterPerfil = new Perfil();
		filterPerfil.setIsmantenimiento(Y41bConstantes.NO);

		PerfilController.logger
				.info("[GET - find_ALL] : Obtener Perfil por filtro");

		List<Perfil> lista = this.perfilService.findAllPerfilFirma(
				filterPerfil, null);

		// 0155021 comentamos esto para que de momento no se pueda utilizar
		if (Y41bConstantes.PORTAFIRMAS_ARBITROS_HABILITADO) {
			lista.add(new Perfil(Y41bConstantes.PERFIL_FIRMA_ARBITRO,
					"Arbitros", "Arbitroak"));
		}
		// 0155021

		return lista;
	}

	/**
	 * Method 'getAllConExpedientes'.
	 * 
	 * @return List
	 */
	@RequestMapping(value = "/tramites", method = RequestMethod.GET)
	public @ResponseBody
	List<Perfil> getAllPerfilTramites() {

		Perfil filterPerfil = new Perfil();
		filterPerfil.setIsmantenimiento(Y41bConstantes.NO);

		PerfilController.logger
				.info("[GET - find_ALL] : Obtener Perfil por filtro");
		return this.perfilService.findAllPerfilTramite(filterPerfil, null);
	}
}
