package com.ejie.y41b.control;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.ParametrosService;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Parametros;

/**
 * ParametrosController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/parametros")
public class ParametrosController {

	private static final Logger logger = LoggerFactory
			.getLogger(ParametrosController.class);

	@Autowired
	private ParametrosService parametrosService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintParametros", method = RequestMethod.GET)
	public String getCreateForm(Model model, HttpServletRequest request) {
		ParametrosController.logger.info("[GET - View] : parametros");

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() != null
				&& censoMonitor
						.getPerfilMaestros()
						.getIdPerfil()
						.equals(Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO)) {
			return "parametrosBusqueda";
		} else {
			return "accessDeniedEscritorio";
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param parametro
	 *            String
	 * @return Parametros Parametros
	 */
	@RequestMapping(value = "/{parametro}", method = RequestMethod.GET)
	public @ResponseBody
	Parametros getById(@PathVariable String parametro) {
		Parametros Parametros = new Parametros();
		Parametros.setParametro(parametro);
		Parametros = this.parametrosService.find(Parametros);
		ParametrosController.logger
				.info("[GET - findBy_PK] : Obtener Parametros por PK");
		return Parametros;
	}

	/**
	 * Method 'getCreateFormModProcedimental'.
	 * 
	 * @param codProcedimental
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "modParametros/{parametro}", method = RequestMethod.GET)
	public ModelAndView getCreateFormModProcedimental(
			@PathVariable String parametro, Model model,
			HttpServletRequest request) {

		model.addAttribute("parametro", parametro);

		model.addAttribute("modoParametros",
				Y41bConstantes.MODO_POPUP_MODIFICACION);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		Parametros parametros = new Parametros();
		parametros.setParametro(parametro);

		if (censoMonitor.getPerfilMaestros() != null
				&& censoMonitor
						.getPerfilMaestros()
						.getIdPerfil()
						.equals(Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO)) {
			return new ModelAndView("parametrosDetalle", "model", model);
		} else {
			return new ModelAndView("accessDeniedModal", "model", model);
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param parametros
	 *            Parametros
	 * @return Parametros
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Parametros edit(@RequestBody Parametros parametros) {
		Parametros parametrosAux = this.parametrosService.update(parametros);
		ParametrosController.logger
				.info("[POST] : Parametros insertado correctamente");
		return parametrosAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param parametros
	 *            Parametros
	 * @return Parametros
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Parametros add(@RequestBody Parametros parametros) {
		Parametros parametrosAux = this.parametrosService.add(parametros);
		ParametrosController.logger
				.info("[POST] : Parametros insertado correctamente");
		return parametrosAux;
	}

	/**
	 * Method 'getCreateFormAltaProcedimental'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "altaParametros", method = RequestMethod.GET)
	public ModelAndView getCreateFormAltaProcedimental(Model model,
			HttpServletRequest request) {

		model.addAttribute("parametro", "");

		model.addAttribute("modoParametros", Y41bConstantes.MODO_POPUP_ALTA);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() != null
				&& censoMonitor
						.getPerfilMaestros()
						.getIdPerfil()
						.equals(Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO)) {
			return new ModelAndView("parametrosDetalle", "model", model);
		} else {
			return new ModelAndView("accessDeniedModal", "model", model);
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param parametro
	 *            String
	 * @return parametros
	 */
	@RequestMapping(value = "/{parametro}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Parametros remove(@PathVariable String parametro) {
		Parametros parametros = new Parametros();
		parametros.setParametro(parametro);
		this.parametrosService.remove(parametros);
		ParametrosController.logger
				.info("[DELETE] : Parametros borrado correctamente");
		return parametros;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param parametrosIds
	 *            List
	 * @return parametrosList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> parametrosIds) {
		List<Parametros> parametrosList = new ArrayList<Parametros>();
		for (List<String> parametrosId : parametrosIds) {
			Iterator<String> iterator = parametrosId.iterator();
			Parametros parametros = new Parametros(); // NOPMD - Objeto
														// nuevo en la
														// lista
														// (parametro
														// del servicio)
			parametros.setParametro(ObjectConversionManager.convert(
					iterator.next(), String.class));
			parametrosList.add(parametros);
		}
		this.parametrosService.removeMultiple(parametrosList);
		ParametrosController.logger
				.info("[POST - DELETE_ALL] : Parametros borrados correctamente");
		return parametrosIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterParametros
	 *            Parametros
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Parametros filterParametros,
			@ModelAttribute Pagination pagination) {
		List<Parametros> parametross = this.parametrosService.findAll(
				filterParametros, pagination);
		Long recordNum = this.parametrosService.findAllCount(filterParametros);
		ParametrosController.logger.info("[GET - jqGrid] : Obtener Parametros");
		return new JQGridJSONModel(pagination, recordNum, parametross);
	}

	/**
	 * Method 'getComboCuestionproc'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "/combo", method = RequestMethod.GET)
	public @ResponseBody
	List<Parametros> getComboCuestionproc(HttpServletRequest request) {

		this.logger.info("[GET - find_ALL] : Obtener combo Cuestionproc");
		Parametros filterParametros = new Parametros();
		/*
		 * desde la ficha de expedientes
		 */
		Locale locale = LocaleContextHolder.getLocale();
		String idioma = locale.getLanguage();

		Pagination pagination = new Pagination();
		if (Y41bConstantes.CASTELLANO.equals(idioma)) {
			pagination.setSort("cpdesces");
		} else {
			pagination.setSort("cpdesceu");
		}
		pagination.setAscDsc("ASC");

		return parametrosService.findAll(filterParametros, pagination);
	}

	/**
	 * Method 'getAllParametros'. de tipo like
	 * 
	 * @param parametro_
	 *            String
	 * @param cpdesces_
	 *            String
	 * @param cpdesceu_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/like", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllProcedimental(
			@RequestParam(value = "parametro", required = false) String parametro_,
			@RequestParam(value = "valor", required = false) String valor_,
			@RequestParam(value = "descripciones", required = false) String descripciones_,
			HttpServletRequest request) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String parametro = ("".equals(parametro_)) ? null : parametro_;
			String descripciones = ("".equals(descripciones_)) ? null
					: descripciones_;
			String descripcioneu = null;
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();
			if (Y41bConstantes.EUSKERA.equals(idioma)) {
				descripcioneu = ("".equals(descripciones_)) ? null
						: descripciones_;
				descripciones = null;
			}
			String valor = ("".equals(valor_)) ? null : valor_;

			Parametros filterParametros = new Parametros(parametro, valor,
					descripciones, descripcioneu);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Parametros> parametroses = parametrosService.findAllLike(
						filterParametros, pagination, false);

				if (parametroses == null) {
					throw new Exception("No data Found.");
				}

				Long total = parametrosService.findAllLikeCount(
						filterParametros, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(parametroses);
				return data;
			} else {
				List<Parametros> parametroses = parametrosService.findAllLike(
						filterParametros, pagination, false);
				if (parametroses == null) {
					throw new Exception("No data Found.");
				}
				return parametroses;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

}
