package com.ejie.y41b.control;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;
import org.w3c.dom.Document;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y31.factory.Y31JanoServiceAbstractFactory;
import com.ejie.y31.service.Y31JanoService;
import com.ejie.y41b.adapter.services.Y41bSipcaService;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Claseingreso;
import com.ejie.y41b.model.Conceptopago;
import com.ejie.y41b.model.Errores;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.Estadopago;
import com.ejie.y41b.model.FiltroSanciones;
import com.ejie.y41b.model.Historico;
import com.ejie.y41b.model.Movimientos;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.Pagos;
import com.ejie.y41b.model.PagosBusqueda;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.model.Sanbandeja;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.model.T17Portal;
import com.ejie.y41b.model.Tipoconceptopago;
import com.ejie.y41b.service.ConceptopagoService;
import com.ejie.y41b.service.ErroresService;
import com.ejie.y41b.service.EstadopagoService;
import com.ejie.y41b.service.ExpedienService;
import com.ejie.y41b.service.HistoricoService;
import com.ejie.y41b.service.MovimientosService;
import com.ejie.y41b.service.OrganismoService;
import com.ejie.y41b.service.PagosService;
import com.ejie.y41b.service.ParametrosService;
import com.ejie.y41b.service.T17PortalService;
import com.ejie.y41b.service.TipoconceptopagoService;
import com.ejie.y41b.service.Y41bExcelGeneratorService;
import com.ejie.y41b.utils.Y41bLiquidacionUtils;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * PagosController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/pagos")
public class PagosController {

	private static final Logger logger = LoggerFactory.getLogger(PagosController.class);

	@Autowired()
	private PagosService pagosService;
	@Autowired()
	private Properties appConfiguration;
	@Resource()
	private ReloadableResourceBundleMessageSource appMessageSource;
	@Autowired()
	private Y41bExcelGeneratorService y41bExcelGeneratorService;

	@Autowired()
	private T17PortalService t17PortalService;

	@Autowired()
	private TipoconceptopagoService tipoconceptopagoService;

	@Autowired()
	private ConceptopagoService conceptopagoService;

	@Autowired()
	private ExpedienService expedienService;

	@Autowired()
	private ErroresService erroresService;

	@Autowired()
	private EstadopagoService estadopagoService;

	@Autowired()
	private ParametrosService parametrosService;
	@Autowired()
	private OrganismoService organismoService;
	@Autowired()
	private MovimientosService movimientosService;
	@Autowired()
	private HistoricoService historicoService;
	@Autowired()
	private Y41bSipcaService sipcaService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */
	@Autowired()
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody() void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintPagos", method = RequestMethod.GET)
	public String getCreateForm(Model model, HttpServletRequest request) {
		PagosController.logger.info("[GET - View] : pagos");
		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilEconomico() == null || censoMonitor.getPerfilEconomico().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return "accessDeniedEscritorio";
		} else {
			return "pagosBusqueda";
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintViaApremio", method = RequestMethod.GET)
	public ModelAndView getCreateFormViaApremio(Model model, HttpServletRequest request) {
		PagosController.logger.info("[GET - View] : viaApremio");
		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		Date fecha = Y41bUtils.addDays(Y41bUtils.obtenerFechaHoy(), -Y41bConstantes.NUM_70);
		Locale locale = LocaleContextHolder.getLocale();
		String idioma = locale.getLanguage();
		model.addAttribute("fechaNotiResoAnterior", Y41bUtils.parseDateToString(fecha, idioma));

		if (censoMonitor.getPerfilEconomico() == null || censoMonitor.getPerfilEconomico().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("viaApremioBusqueda", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormOtrosIngresos'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintOtrosIngresos", method = RequestMethod.GET)
	public String getCreateFormOtrosIngresos(Model model, HttpServletRequest request) {
		PagosController.logger.info("[GET - View] : OtrosIngresos");
		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilEconomico() == null || censoMonitor.getPerfilEconomico().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return "accessDeniedEscritorio";
		} else {
			return "otrosIngresosBusqueda";
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param sgcodigo
	 *            String
	 * @return Pagos
	 */
	@RequestMapping(value = "find/{sgcodigo}", method = RequestMethod.GET)
	public @ResponseBody() Pagos getById(@PathVariable() String sgcodigo) {
		try {
			Pagos pagos = new Pagos();
			pagos.setSgcodigo(sgcodigo);
			pagos = this.pagosService.find(pagos);

			if (pagos == null) {
				throw new Exception(sgcodigo.toString());
			}
			PagosController.logger.info("[GET - findBy_PK] : Obtener Pagos por PK");
			return pagos;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * @param sgcodigo
	 *            String
	 * @return Pagos
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "findHR/{sgcodigo}", method = RequestMethod.GET)
	public @ResponseBody() Pagos getByIdHR(@PathVariable() String sgcodigo) throws Exception {
		Pagos pagos = new Pagos();
		pagos.setSgcodigo(sgcodigo);
		if (!"nuevo".equals(sgcodigo)) {
			pagos = this.pagosService.findHR(pagos);
			String idEntidadOrganismo = pagos.getSgestablecimiento().getEscodigo();
			Organismo organismo = new Organismo();
			organismo.setEntidadId(idEntidadOrganismo);

			organismo = this.organismoService.findOrganismoById(organismo);
			if (organismo != null) {
				Establecimiento establecimiento = new Establecimiento();
				Locale locale = LocaleContextHolder.getLocale();
				String idioma = locale.getLanguage();
				if (Y41bConstantes.EUSKERA.equals(idioma)) {
					establecimiento.setEsnombre(organismo.getNombreEu());
				} else {
					establecimiento.setEsnombre(organismo.getNombreEs());
				}
				establecimiento.setEsnif(organismo.getCif());
				establecimiento.setEscodigo(organismo.getEntidadId());
				StringBuffer direccionCompleta = new StringBuffer();
				direccionCompleta.append(organismo.getNombreCalle()).append(", ").append(organismo.getNombrePortal())
						.append(" ").append(organismo.getNombreCp()).append(" ").append(organismo.getNombreLocalidad());
				establecimiento.setEsdireccionCompleta(direccionCompleta.toString());
				pagos.setSgestablecimiento(establecimiento);
			}
		} else {
			// Servicio central de publicaciones
			try {
				Calendar cal = Calendar.getInstance();
				cal.add(Calendar.MONTH, -1);
				cal.set(cal.get(Calendar.YEAR), cal.get(Calendar.MONTH), cal.getActualMaximum(Calendar.DAY_OF_MONTH));
				pagos.setSgfechaemision(cal.getTime());
				pagos.setSgfechalimitepago(
						Y41bUtils.parseDate(Y41bLiquidacionUtils.fechaLimitePago(Y41bConstantes.CASTELLANO),
								new Locale(Y41bConstantes.CASTELLANO)));
				Parametros parametros = new Parametros();
				parametros.setParametro(Y41bConstantes.ID_ORGANISMO_SERVICIO_CENTRAL_PUBLICACIONES);
				parametros = this.parametrosService.find(parametros);

				String idEntidadOrganismo = parametros.getValor();
				Organismo organismo = new Organismo();
				organismo.setEntidadId(idEntidadOrganismo);

				organismo = this.organismoService.findOrganismoById(organismo);
				Establecimiento establecimiento = new Establecimiento();
				Locale locale = LocaleContextHolder.getLocale();
				String idioma = locale.getLanguage();
				if (Y41bConstantes.EUSKERA.equals(idioma)) {
					establecimiento.setEsnombre(organismo.getNombreEu());
				} else {
					establecimiento.setEsnombre(organismo.getNombreEs());
				}
				establecimiento.setEsnif(organismo.getCif());
				establecimiento.setEscodigo(organismo.getEntidadId());
				StringBuffer direccionCompleta = new StringBuffer();
				direccionCompleta.append(organismo.getNombreCalle()).append(", ").append(organismo.getNombrePortal())
						.append(" ").append(organismo.getNombreCp()).append(" ").append(organismo.getNombreLocalidad());
				establecimiento.setEsdireccionCompleta(direccionCompleta.toString());
				pagos.setSgestablecimiento(establecimiento);
			} catch (Exception e) {
				throw new Y41bUDAException("error.hojareclamaciones.parametroServicioCentral", true, new Exception());
			}
			Date mesAnterior = Y41bUtils.addMonth(Y41bUtils.obtenerFechaHoy(), -1);
			String numExpediente = Y41bUtils.formatearDateToString(mesAnterior, "yyyy-MM", Y41bConstantes.CASTELLANO);
			pagos.setSgexpediente(numExpediente);
			String mesTextoEu = Y41bUtils.formatearDateToStringEuskera(mesAnterior, "MMMM", Y41bConstantes.EUSKERA);
			String mesTextoEs = Y41bUtils.formatearDateToString(mesAnterior, "MMMM", Y41bConstantes.CASTELLANO);
			pagos.setSgcomentarioes(this.appMessageSource
					.getMessage("pagos.hojareclamaciones", null, new Locale(Y41bConstantes.CASTELLANO)).toUpperCase()
					.concat(" ").concat(numExpediente).concat(" ").concat(mesTextoEs));
			pagos.setSgcomentarioeu(this.appMessageSource
					.getMessage("pagos.hojareclamaciones", null, new Locale(Y41bConstantes.EUSKERA)).toUpperCase()
					.concat(" ").concat(numExpediente).concat(" ").concat(mesTextoEu));

			Conceptopago conceptopago = new Conceptopago();
			conceptopago.setSdejercicio(
					Long.parseLong(Y41bUtils.formatearDateToString(mesAnterior, "yyyy", Y41bConstantes.CASTELLANO)));
			pagos.setConceptopago(conceptopago);

			pagos.setEstadopago(new Estadopago(Y41bConstantes.ESTADO_PAGO_PENDIENTE_INGRESO, "", ""));
		}
		PagosController.logger.info("[GET - findBy_PK] : Obtener Pagos por PK");
		return pagos;

	}

	/**
	 * Method 'getById'.
	 * 
	 * @param sgcodigo
	 *            String
	 * @return Pagos
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "findOI/{sgcodigo}", method = RequestMethod.GET)
	public @ResponseBody() Pagos getByIdOI(@PathVariable() String sgcodigo) throws Exception {
		Pagos pagos = new Pagos();
		pagos.setSgcodigo(sgcodigo);
		if (!"nuevo".equals(sgcodigo)) {
			pagos = this.pagosService.findHR(pagos);
			if (pagos.getConceptopagoInteres() != null
					&& !Y41bUtils.esNullOCadenaVacia(pagos.getConceptopagoInteres().getSdcodigo())) {
				Conceptopago conceptopagointeres = this.conceptopagoService.find(pagos.getConceptopagoInteres());
				pagos.setConceptopagoInteres(conceptopagointeres);
			}

			String idEntidadOrganismo = pagos.getSgestablecimiento().getEscodigo();
			Organismo organismo = new Organismo();
			organismo.setEntidadId(idEntidadOrganismo);

			organismo = this.organismoService.findOrganismoById(organismo);
			if (organismo != null) {
				Establecimiento establecimiento = new Establecimiento();
				Locale locale = LocaleContextHolder.getLocale();
				String idioma = locale.getLanguage();
				if (Y41bConstantes.EUSKERA.equals(idioma)) {
					establecimiento.setEsnombre(organismo.getNombreEu());
				} else {
					establecimiento.setEsnombre(organismo.getNombreEs());
				}
				establecimiento.setEsnif(organismo.getCif());
				establecimiento.setEscodigo(organismo.getEntidadId());
				StringBuffer direccionCompleta = new StringBuffer();
				direccionCompleta.append(organismo.getNombreCalle()).append(", ").append(organismo.getNombrePortal())
						.append(" ").append(organismo.getNombreCp()).append(" ").append(organismo.getNombreLocalidad());
				establecimiento.setEsdireccionCompleta(direccionCompleta.toString());
				pagos.setSgestablecimiento(establecimiento);
			}
		} else {
			Conceptopago conceptopago = new Conceptopago();
			conceptopago.setSdejercicio(Long.parseLong(
					Y41bUtils.formatearDateToString(Y41bUtils.obtenerFechaHoy(), "yyyy", Y41bConstantes.CASTELLANO)));
			pagos.setConceptopago(conceptopago);
			pagos.setEstadopago(new Estadopago(Y41bConstantes.ESTADO_PAGO_PENDIENTE_PAGO, "", ""));
			try {
				pagos.setSgfechalimitepago(
						Y41bUtils.parseDate(Y41bLiquidacionUtils.fechaLimitePago(Y41bConstantes.CASTELLANO),
								new Locale(Y41bConstantes.CASTELLANO)));
			} catch (Exception e) {
				pagos.setSgfechalimitepago(null);
			}
		}
		PagosController.logger.info("[GET - findBy_PK] : Obtener Pagos por PK");
		return pagos;

	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterPagos
	 *            Pagos
	 * @return List
	 */
	@RequestMapping(value = "/listar", method = RequestMethod.GET)
	public @ResponseBody() List<Pagos> getAll(@ModelAttribute() Pagos filterPagos) {
		PagosController.logger.info("[GET - find_ALL] : Obtener Pagos por filtro");
		return this.pagosService.findAll(filterPagos, null);
	}

	/**
	 * Method 'getAllPagos'.
	 * 
	 * @param filterPagos
	 *            PagosBusqueda
	 * @return List
	 */
	@RequestMapping(value = "/filtrar", method = RequestMethod.GET)
	public @ResponseBody() List<Pagos> getAll(@ModelAttribute() PagosBusqueda filterPagos) {
		PagosController.logger.info("[GET - find_ALL_Pagos] : Obtener Pagos por filtro");
		return this.pagosService.findAllPagos(filterPagos, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param pagos
	 *            Pagos
	 * @return Pagos
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody() Pagos edit(@RequestBody() Pagos pagos) {
		try {
			Pagos pagosBD = this.pagosService.find(pagos);
			pagosBD.setEstadopago(pagos.getEstadopago());
			pagosBD.setSgfechaemision(pagos.getSgfechaemision());
			pagosBD.setSgfechaestado(pagos.getSgfechaestado());
			pagosBD.setSgiban(pagos.getSgiban());
			pagosBD.setSgnombretitular(pagos.getSgnombretitular());

			Pagos pagosAux = this.pagosService.update(pagosBD);
			PagosController.logger.info("[PUT] : Pagos actualizado correctamente");

			return pagosAux;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param pagos
	 *            Pagos
	 * @return Pagos
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody() Pagos add(@RequestBody() Pagos pagos) {
		Pagos pagosAux = this.pagosService.add(pagos);
		PagosController.logger.info("[POST] : Pagos insertado correctamente");
		return pagosAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param sgcodigo
	 *            String
	 * @return pagos
	 */
	@RequestMapping(value = "/{sgcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody() Pagos remove(@PathVariable() String sgcodigo) {

		Pagos pagos = new Pagos();
		pagos.setSgcodigo(sgcodigo);
		// Solo se borran otros ingresos por lo que se llama a su find
		pagos = this.pagosService.findHR(pagos);

		Movimientos movimiento = new Movimientos();
		movimiento.setSfreferencia(pagos.getSgreferencia());
		List<Movimientos> lmovimiento = this.movimientosService.findAll(movimiento, null);

		Historico historico = null;
		List<Historico> lhistorico = null;
		Movimientos movimientoAux = new Movimientos();
		for (int i = 0; i < lmovimiento.size(); i++) {
			movimiento = lmovimiento.get(i);
			movimientoAux.setSfcodigo(movimiento.getSfcodigo());
			movimientoAux.setSfreferencia(movimiento.getSfreferencia());
			historico = this.crearHistorico(movimientoAux);
			lhistorico = this.historicoService.findAll(historico, null);
			for (int j = 0; j < lhistorico.size(); j++) {
				this.historicoService.remove(lhistorico.get(j));
			}
			this.movimientosService.remove(movimiento);
		}

		this.pagosService.remove(pagos);
		PagosController.logger.info("[DELETE] : Pagos borrado correctamente " + sgcodigo);
		return pagos;
	}

	/**
	 * 
	 * @param movimiento
	 *            Movimientos
	 * @return Historico
	 */
	private Historico crearHistorico(Movimientos movimiento) {
		return new Historico(null, movimiento);
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param pagosIds
	 *            List
	 * @return pagosList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody() List<List<String>> removeMultiple(@RequestBody() List<List<String>> pagosIds) {
		List<Pagos> pagosList = new ArrayList<Pagos>();
		for (List<String> pagosId : pagosIds) {
			Iterator<String> iterator = pagosId.iterator();
			Pagos pagos = new Pagos(); // NOPMD - Objeto nuevo en la lista
										// (parametro del servicio)
			pagos.setSgcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
			pagosList.add(pagos);
		}
		this.pagosService.removeMultiple(pagosList);
		PagosController.logger.info("[POST - DELETE_ALL] : Pagos borrados correctamente");
		return pagosIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterPagos
	 *            Pagos
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody() JQGridJSONModel getAllJQGrid(@ModelAttribute() Pagos filterPagos,
			@ModelAttribute() Pagination pagination) {
		List<Pagos> pagoss = this.pagosService.findAll(filterPagos, pagination);
		Long recordNum = this.pagosService.findAllCount(filterPagos);
		PagosController.logger.info("[GET - jqGrid] : Obtener Pagos");
		return new JQGridJSONModel(pagination, recordNum, pagoss);
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterPagosBusqueda
	 *            Pagos
	 * @param estado
	 *            String
	 * @param concepto
	 *            String
	 * @param pagination
	 *            Pagination
	 * @param httpRequest
	 *            HttpServletRequest
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/tablaPagos", method = RequestMethod.GET)
	public @ResponseBody() JQGridJSONModel getAllPagosJQGrid(@ModelAttribute() PagosBusqueda filterPagosBusqueda,
			@RequestParam(value = "sacodigo", required = false) String estado,
			@RequestParam(value = "sdcodigo", required = false) String concepto,
			@ModelAttribute() Pagination pagination, HttpServletRequest httpRequest) {

		HttpSession httpSession = httpRequest.getSession(false);
		PagosBusqueda filter = new PagosBusqueda();
		if (null != filterPagosBusqueda && null != filterPagosBusqueda.getSgcodigo()
				&& filterPagosBusqueda.getSgcodigo().equals("")) {
			filterPagosBusqueda.setSgcodigo(null);
		}

		if (null != filterPagosBusqueda && null != filterPagosBusqueda.getSgexpediente()
				&& filterPagosBusqueda.getSgexpediente().equals("")) {
			filterPagosBusqueda.setSgexpediente("");
		}

		if (null != filterPagosBusqueda && null != filterPagosBusqueda.getSgreferencia()
				&& filterPagosBusqueda.getSgreferencia().equals("")) {
			filterPagosBusqueda.setSgreferencia(null);
		}

		if (null != filterPagosBusqueda && null != filterPagosBusqueda.getSgestablecimiento()) {

			if (filterPagosBusqueda.getSgestablecimiento().equals("")) {
				filterPagosBusqueda.setSgestablecimiento(null);
			}
			if (null != filterPagosBusqueda.getSgestablecimiento().getEscodigo()
					&& filterPagosBusqueda.getSgestablecimiento().getEscodigo().equals("")) {
				filterPagosBusqueda.getSgestablecimiento().setEscodigo(null);
			}

		}

		if (null != filterPagosBusqueda) {
			if (estado != null && !"".equals(estado)) {
				filterPagosBusqueda.setEstadopago(new Estadopago(estado, null, null));
			}
		}
		if (null != filterPagosBusqueda) {
			if (concepto != null && !"".equals(concepto)) {
				filterPagosBusqueda.setConceptopago(new Conceptopago(concepto, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null, null, null, null, null, null, null, null));
			}
		}

		filter = this.prepararFiltro(filterPagosBusqueda, estado, concepto);

		httpSession.setAttribute("pagosBusqueda", filter);
		List<Pagos> pagoss = this.pagosService.findAllPagos(filter, pagination);
		Long recordNum = this.pagosService.findAllCountPagos(filter);
		PagosController.logger.info("[GET - jqGrid] : Obtener Pagos");
		return new JQGridJSONModel(pagination, recordNum, pagoss);
	}

	/**
	 * 
	 * @param filterPagosBusqueda
	 *            PagosBusqueda
	 * @param estado
	 *            String
	 * @param concepto
	 *            String
	 * @return PagosBusqueda
	 */
	private PagosBusqueda prepararFiltro(PagosBusqueda filterPagosBusqueda, String estado, String concepto) {

		Locale locale = LocaleContextHolder.getLocale();
		String idioma = locale.getLanguage();
		try {
			if (null != filterPagosBusqueda && null != filterPagosBusqueda.getSgfechaemisionhasta()
					&& !filterPagosBusqueda.getSgfechaemisionhasta().equals("")) {
				filterPagosBusqueda.setSgfechaemisionhasta(Y41bUtils.parseDateTime(Y41bUtils
						.parseDateToString(filterPagosBusqueda.getSgfechaemisionhasta(), idioma).concat(" 23:59:59"),
						locale));
			}
			if (null != filterPagosBusqueda && null != filterPagosBusqueda.getSgfechalimitepagohasta()
					&& !filterPagosBusqueda.getSgfechalimitepagohasta().equals("")) {
				filterPagosBusqueda.setSgfechalimitepagohasta(Y41bUtils.parseDateTime(Y41bUtils
						.parseDateToString(filterPagosBusqueda.getSgfechalimitepagohasta(), idioma).concat(" 23:59:59"),
						locale));
			}
		} catch (Exception e) {
			e.printStackTrace();
		}

		if (filterPagosBusqueda != null && !Y41bUtils.esNullOCadenaVacia(filterPagosBusqueda.getSgviaapremio())
				&& "on".equals(filterPagosBusqueda.getSgviaapremio())) {
			filterPagosBusqueda.setSgviaapremio(Y41bConstantes.VALOR_SI);
		}
		if (filterPagosBusqueda != null && !Y41bUtils.esNullOCadenaVacia(filterPagosBusqueda.getSgprontopago())
				&& "on".equals(filterPagosBusqueda.getSgprontopago())) {
			filterPagosBusqueda.setSgprontopago(Y41bConstantes.VALOR_SI);
		}
		return filterPagosBusqueda;
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param sgcodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bDetallePagos/{sgcodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bDetallePagos(@PathVariable() String sgcodigo, Model model,
			HttpServletRequest request) {

		Pagos detallePagos = new Pagos();
		detallePagos.setSgcodigo(sgcodigo);

		model.addAttribute("detallePagos", detallePagos);

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("sgcodigo", sgcodigo);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilEconomico() == null || censoMonitor.getPerfilEconomico().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("pagosDetalle", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param sgcodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bDetalleReferencia/{sgreferencia}", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bDetalleReferencia(@PathVariable() String sgreferencia, Model model,
			HttpServletRequest request) {

		Pagos detallePagos = new Pagos();
		detallePagos.setSgreferencia(sgreferencia.substring(0, 11));
		List<Pagos> lPagos = this.getAll(detallePagos);
		detallePagos = lPagos.get(0);

		model.addAttribute("detallePagos", detallePagos);

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("sgcodigo", detallePagos.getSgcodigo());

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilSanciones() == null || censoMonitor.getPerfilSanciones().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("pagosDetalle", "model", model);
		}
	}

	/**
	 * Metodo para generar un archivo excel con los filtrados correspondientes *
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excelPagos", method = RequestMethod.GET)
	public void getAllExcelPagos(HttpServletRequest request, HttpServletResponse response) {
		try {

			HttpSession httpSession = request.getSession();
			PagosBusqueda filtroPagos = (PagosBusqueda) httpSession.getAttribute("pagosBusqueda");

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy, "yyyyMMdd");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_BUSQUEDA_SANCIONES + fechaActual + ".xls";
			response.setHeader("Content-Disposition", "attachment; filename=\"" + nombre + "\"");

			String xslString = this.y41bExcelGeneratorService.getPagosExcel(filtroPagos);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}

	}

	/**
	 * Method 'getAllPagosViaApremioJQGrid'.
	 * 
	 * @param excodigo
	 *            String
	 * @param pagination
	 *            Pagination
	 * @param httpRequest
	 *            HttpServletRequest
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/tablaPagosViaApremio/{excodigo}", method = RequestMethod.GET)
	public @ResponseBody() JQGridJSONModel getAllPagosViaApremioJQGrid(@PathVariable() String excodigo,
			@ModelAttribute() Pagination pagination, HttpServletRequest httpRequest) {

		HttpSession httpSession = httpRequest.getSession(false);

		PagosBusqueda pagos = new PagosBusqueda();
		pagos.setSgidexpediente(excodigo);

		httpSession.setAttribute("pagosViaApremioBusqueda", pagos);
		List<Pagos> pagoss = this.pagosService.findAllPagos(pagos, pagination);
		Long recordNum = this.pagosService.findAllCountPagos(pagos);
		PagosController.logger.info("[GET - jqGrid] : Obtener Pagos");
		return new JQGridJSONModel(pagination, recordNum, pagoss);
	}

	/**
	 * 
	 * @param excoor
	 *            String
	 * @param exnror
	 *            BigDecimal
	 * @param exnran
	 *            BigDecimal
	 * @param escodigo
	 *            String
	 * @param importeDesde
	 *            String
	 * @param importeHasta
	 *            String
	 * @param fechaNotiReso
	 *            String
	 * @param fechaNotiOrden
	 *            String
	 * @param conRecursoAlzada
	 *            String
	 * @param sinRecursoAlzada
	 *            String
	 * @param sinLiquidacionesFirmes
	 *            String
	 * @param pagination
	 *            Pagination
	 * @param httpRequest
	 *            HttpServletRequest
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/tablaExpedientesViaApremio", method = RequestMethod.GET)
	public @ResponseBody() JQGridJSONModel getAllJQGridPrueba(
			@RequestParam(value = "excoor", required = false) String excoor,
			@RequestParam(value = "exnror", required = false) BigDecimal exnror,
			@RequestParam(value = "exnran", required = false) BigDecimal exnran,
			@RequestParam(value = "escodigo", required = false) String escodigo,
			@RequestParam(value = "importeDesde", required = false) String importeDesde,
			@RequestParam(value = "importeHasta", required = false) String importeHasta,
			@RequestParam(value = "fechaNotiReso", required = false) String fechaNotiReso,
			@RequestParam(value = "fechaNotiOrden", required = false) String fechaNotiOrden,
			@RequestParam(value = "conRecursoAlzada", required = false) String conRecursoAlzada,
			@RequestParam(value = "sinRecursoAlzada", required = false) String sinRecursoAlzada,
			@RequestParam(value = "sinLiquidacionesFirmes", required = false) String sinLiquidacionesFirmes,
			@RequestParam(value = "excluidos", required = false) String excluidos,
			@ModelAttribute() Pagination pagination, HttpServletRequest httpRequest) {

		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilEconomico() == null || censoMonitor.getPerfilEconomico().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			// Si perfil sin acceso devolvemos listado vacio
			return new JQGridJSONModel(pagination, 0L, new ArrayList<Sanbandeja>());
		}

		FiltroSanciones filtroSanciones = new FiltroSanciones();

		if (!Y41bUtils.esNullOCadenaVacia(excoor)) {
			filtroSanciones.setExcoor(excoor);
		}
		if (null != exnror) {
			filtroSanciones.setExnror(exnror);
		}
		if (null != exnran) {
			filtroSanciones.setExnran(exnran);
		}
		filtroSanciones.setEscodigo(escodigo);

		Locale locale = LocaleContextHolder.getLocale();
		try {
			if (null != fechaNotiReso) {
				filtroSanciones.setFechaNotiReso(Y41bUtils.parseDate(fechaNotiReso, locale));
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		try {
			if (null != fechaNotiOrden) {
				filtroSanciones.setFechaNotiOrden(Y41bUtils.parseDate(fechaNotiOrden, locale));
			}
		} catch (Exception e) {
			e.printStackTrace();
		}

		filtroSanciones.setImporteDesde(Y41bUtils.esNullOCadenaVacia(importeDesde) ? null
				: importeDesde.replaceAll("\\u002E", "").replace('\u002c', '\u002e'));
		filtroSanciones.setImporteHasta(Y41bUtils.esNullOCadenaVacia(importeHasta) ? null
				: importeHasta.replaceAll("\\u002E", "").replace('\u002c', '\u002e'));

		if (!Y41bUtils.esNullOCadenaVacia(conRecursoAlzada) && "on".equals(conRecursoAlzada)) {
			filtroSanciones.setConRecursoAlzada(true);
		}
		if (!Y41bUtils.esNullOCadenaVacia(sinRecursoAlzada) && "on".equals(sinRecursoAlzada)) {
			filtroSanciones.setSinRecursoAlzada(true);
		}
		if (!Y41bUtils.esNullOCadenaVacia(sinLiquidacionesFirmes) && "on".equals(sinLiquidacionesFirmes)) {
			filtroSanciones.setSinLiquidacionesFirmes(true);
		}

		if (!Y41bUtils.esNullOCadenaVacia(excluidos) && "on".equals(excluidos)) {
			filtroSanciones.setExexcluido(Y41bConstantes.VALOR_SI);
		}

		httpSession.setAttribute("viaApremioBusqueda", filtroSanciones);

		List<FiltroSanciones> listaSanciones = this.expedienService.findAllSancionesViaApremio(filtroSanciones,
				pagination);

		Long recordNum = this.expedienService.findAllCountSancionesViaApremio(filtroSanciones);
		PagosController.logger.info("[GET - jqGrid] : Obtener sanciones");
		return new JQGridJSONModel(pagination, recordNum, listaSanciones);
	}

	/**
	 * Method 'getAllOtrosIngresosJQGrid'.
	 * 
	 * @param filterPagosBusqueda
	 *            PagosBusqueda
	 * @param pagination
	 *            Pagination
	 * @param sdejercicio
	 *            Long
	 * @param httpRequest
	 *            HttpServletRequest
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/tablaOtrosIngresos", method = RequestMethod.GET)
	public @ResponseBody() JQGridJSONModel getAllOtrosIngresosJQGrid(
			@ModelAttribute() PagosBusqueda filterPagosBusqueda,
			@RequestParam(value = "sdejercicio", required = false) Long sdejercicio,
			@ModelAttribute() Pagination pagination, HttpServletRequest httpRequest) {

		HttpSession httpSession = httpRequest.getSession(false);

		if (null != filterPagosBusqueda && null != filterPagosBusqueda.getSgexpediente()
				&& filterPagosBusqueda.getSgexpediente().equals("")) {
			filterPagosBusqueda.setSgexpediente("");
		}

		if (Y41bUtils.esNullOCadenaVacia(filterPagosBusqueda.getExcoor())) {
			filterPagosBusqueda.setExcoor(null);
		}

		if (null != filterPagosBusqueda && null != filterPagosBusqueda.getExnror()
				&& filterPagosBusqueda.getExnror().equals("")) {
			filterPagosBusqueda.setExnror(null);
		}

		if (null != filterPagosBusqueda && null != filterPagosBusqueda.getSgreferencia()
				&& filterPagosBusqueda.getSgreferencia().equals("")) {
			filterPagosBusqueda.setSgreferencia(null);
		}

		if (null != filterPagosBusqueda) {
			if (sdejercicio != null && !"".equals(sdejercicio)) {
				Conceptopago cp = new Conceptopago();
				cp.setSdejercicio(sdejercicio);
				filterPagosBusqueda.setConceptopago(cp);
			}
		}

		if (null != filterPagosBusqueda && null != filterPagosBusqueda.getSgestablecimiento()) {

			if (filterPagosBusqueda.getSgestablecimiento().equals("")) {
				filterPagosBusqueda.setSgestablecimiento(null);
			}
			if (null != filterPagosBusqueda.getSgestablecimiento().getEscodigo()
					&& filterPagosBusqueda.getSgestablecimiento().getEscodigo().equals("")) {
				filterPagosBusqueda.getSgestablecimiento().setEscodigo(null);
			}

		}

		httpSession.setAttribute("pagosBusqueda", filterPagosBusqueda);
		List<Pagos> pagoss = this.pagosService.findAllOtrosPagos(filterPagosBusqueda, pagination);
		Long recordNum = this.pagosService.findAllCountOtrosPagos(filterPagosBusqueda);
		PagosController.logger.info("[GET - jqGrid] : Obtener Pagos");
		return new JQGridJSONModel(pagination, recordNum, pagoss);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param sgcodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bDetalleOtrosIngresos/{sgcodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bDetalleOtrosIngresos(@PathVariable() String sgcodigo, Model model,
			HttpServletRequest request) {

		Pagos detallePagos = new Pagos();
		detallePagos.setSgcodigo(sgcodigo);

		if (!"nuevo".equals(sgcodigo)) {
			detallePagos = this.pagosService.findHR(detallePagos);
		}

		model.addAttribute("detallePagos", detallePagos);

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default..language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default..layout"));

		model.addAttribute("sgcodigo", sgcodigo);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilEconomico() == null || censoMonitor.getPerfilEconomico().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("otrosIngresosDetalle", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param sgcodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "y41bDetalleOtrosIngresosHR/{sgcodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bDetalleIngresoHR(@PathVariable() String sgcodigo, Model model,
			HttpServletRequest request) throws Exception {

		Pagos detallePagos = new Pagos();
		detallePagos.setSgcodigo(sgcodigo);

		if (!"nuevo".equals(sgcodigo)) {
			detallePagos = this.pagosService.findHR(detallePagos);
		}

		model.addAttribute("detallePagos", detallePagos);
		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("sgcodigo", sgcodigo);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilEconomico() == null || censoMonitor.getPerfilEconomico().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("ingresoHojaReclamaciones", "model", model);
		}
	}

	/**
	 * Metodo para generar un archivo excel con los filtrados correspondientes *
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excelOtrosIngresos", method = RequestMethod.GET)
	public void getAllExcelOtrosIngresos(HttpServletRequest request, HttpServletResponse response) {
		try {

			HttpSession httpSession = request.getSession();
			PagosBusqueda filtroPagos = (PagosBusqueda) httpSession.getAttribute("pagosBusqueda");

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy, "yyyyMMdd");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_OTROS_INGRESOS + fechaActual + ".xls";
			response.setHeader("Content-Disposition", "attachment; filename=\"" + nombre + "\"");

			String xslString = this.y41bExcelGeneratorService.getOtrosIngresosExcel(filtroPagos);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}

	}

	/**
	 * Metodo para generar un archivo excel con los filtrados correspondientes *
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excelViaApremio", method = RequestMethod.GET)
	public void getAllExcelViaApremio(HttpServletRequest request, HttpServletResponse response) {
		try {

			HttpSession httpSession = request.getSession();
			FiltroSanciones filtroSanciones = (FiltroSanciones) httpSession.getAttribute("viaApremioBusqueda");

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy, "yyyyMMdd");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_VIA_APREMIO + fechaActual + ".xls";
			response.setHeader("Content-Disposition", "attachment; filename=\"" + nombre + "\"");

			String xslString = this.y41bExcelGeneratorService.getViaApremioExcel(filtroSanciones);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}

	}

	/**
	 * 
	 * @param file
	 *            MultipartFile
	 * @param tipo
	 *            String
	 * @return List<Map<String, Object>>
	 */
	@RequestMapping(value = "/subirFichero", method = RequestMethod.POST)
	public @ResponseBody() List<Map<String, Object>> subirFichero(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			@RequestParam(value = "tipo", required = false) String tipo, HttpServletResponse response,
			HttpServletRequest request) {

		String nombreOriginal = file.getOriginalFilename();
		try {

			Document documentItemSesion = com.ejie.y41b.utils.xlnets.Y41bUtils.getInstance().getDocumentItemSesion(
					Boolean.parseBoolean((String) this.appConfiguration.get("xlnets.loginApp.isSimulated")));
			Y31JanoService service = Y31JanoServiceAbstractFactory.getInstance();
			// Preparando los parmetros
			boolean preserveName = true;
			Long expirationSecs = new Long(
					Y41bConstantes.NUM_60 * Y41bConstantes.NUM_60 * Y41bConstantes.NUM_24 * Y41bConstantes.NUM_15); // 15
																													// dias
																													// en
			// segundos

			// FileInputStream file = new FileInputStream(
			// "C:/datos/h50b/fn77a101_01914_00011.dat");
			String destino = "";
			String numero = String.valueOf(this.pagosService.obtenerNumEnvio());

			String nombreNuevo = "";
			if ("L".equals(tipo)) {
				// fn77a101_01914_00011
				nombreNuevo = nombreOriginal.substring(0, Y41bConstantes.NUM_15)
						.concat(Y41bUtils.rellenaIzda(numero, "0", Y41bConstantes.NUM_5));
				this.pagosService.updateNombreFichero(nombreOriginal, nombreNuevo);
				destino = this.obtenerNombreFicheroEnvio(nombreNuevo);
			} else {
				// csb19_2_01914_00011.xml
				nombreNuevo = nombreOriginal.substring(0, Y41bConstantes.NUM_14)
						.concat(Y41bUtils.rellenaIzda(numero, "0", Y41bConstantes.NUM_5));
				destino = this.obtenerNombreFicheroEnvioDom(nombreNuevo);
			}

			InputStream is = file.getInputStream();
			BufferedReader buffer = new BufferedReader(new InputStreamReader(is));
			String line;
			StringBuffer input = new StringBuffer("");

			while ((line = buffer.readLine()) != null) {
				input.append(line).append("\n");
			}

			String nuevoInput = input.toString();
			if ("L".equals(tipo)) {
				// El fichero se define por posicion, concatemos los
				// fragmentos
				nuevoInput = nuevoInput.substring(0, Y41bConstantes.NUM_15)
						.concat(Y41bUtils.rellenaIzda(numero, "0", Y41bConstantes.NUM_6))
						.concat(nuevoInput.substring(Y41bConstantes.NUM_21));
			} else {
				// El fichero se define por nodos xml, reemplazamos el
				// cdigo junto con el nodo de apertura
				nuevoInput = nuevoInput.replaceFirst(
						nuevoInput.substring(nuevoInput.indexOf("<MsgId>csb19_2_01914_"),
								nuevoInput.indexOf("</MsgId>")),
						"<MsgId>csb19_2_01914_".concat(Y41bUtils.rellenaIzda(numero, "0", Y41bConstantes.NUM_5)));
				nuevoInput = nuevoInput.replaceFirst(
						nuevoInput.substring(nuevoInput.indexOf("<PmtInfId>"), nuevoInput.indexOf("</PmtInfId>")),
						"<PmtInfId>".concat(Y41bUtils.rellenaIzda(numero, "0", Y41bConstantes.NUM_6)));
			}
			PagosController.logger.debug("Destino pif: " + destino);
			PagosController.logger.debug(nuevoInput);

			InputStream is2 = new ByteArrayInputStream(nuevoInput.getBytes());

			// invocando el metodo
			service.put(documentItemSesion, is2, destino, preserveName, expirationSecs);

			// resultado = resul.getFilePath();

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			filesMetaInfo.add(this.getFileReturnMap(file));
			return filesMetaInfo;

		} catch (Exception e) {
			e.printStackTrace();
			PagosController.logger.error("Error producido en subir fichero a PIF " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Este m�todo compone el nombre del fichero de env�o
	 * 
	 * @param nombre
	 *            String
	 * @return String
	 */
	private String obtenerNombreFicheroEnvio(String nombre) {
		StringBuffer nombreFicheroSIPCA = new StringBuffer();
		nombreFicheroSIPCA.append(this.appConfiguration.get("PATH_DESTINO_ENVIO"));
		nombreFicheroSIPCA.append(nombre);
		return nombreFicheroSIPCA.toString();
	}

	/**
	 * Este m�todo compone el nombre del fichero de env�o
	 * 
	 * @param nombre
	 *            String
	 * @return String
	 */
	private String obtenerNombreFicheroEnvioDom(String nombre) {
		StringBuffer nombreFicheroSIPCA = new StringBuffer();
		nombreFicheroSIPCA.append(this.appConfiguration.get("PATH_DESTINO_DOMICILIACION"));
		nombreFicheroSIPCA.append(nombre);
		nombreFicheroSIPCA.append(".xml");
		return nombreFicheroSIPCA.toString();
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return this.appConfiguration
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * 
	 * @param sicodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/recuperarFichero/{sicodigo}", method = RequestMethod.GET)
	public void obtenerFicheroSIPCA(@PathVariable() String sicodigo, HttpServletResponse response) {
		try {
			Errores error = new Errores();
			error.setSicodigo(sicodigo);
			error = this.erroresService.find(error);

			// Ficheros: fn77a101_01914_00011,csb19_2_01914_00011.xml

			StringBuffer ruta = new StringBuffer("");
			ruta.append(this.appConfiguration.get("PATH_FICHEROS_RECOGIDOS_SIPCA")).append(error.getSificherosipca());

			Document documentItemSesion = com.ejie.y41b.utils.xlnets.Y41bUtils.getInstance().getDocumentItemSesion(
					Boolean.parseBoolean((String) this.appConfiguration.get("xlnets.loginApp.isSimulated")));
			Y31JanoService service = Y31JanoServiceAbstractFactory.getInstance();
			InputStream is = service.get(documentItemSesion, ruta.toString());
			byte[] resultado = IOUtils.toByteArray(new BufferedInputStream(is));

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(error.getSificherosipca()) + "\"");
			if (error.getSificherosipca().startsWith("csb19")) {
				response.setContentType("text/xml");
			} else {
				response.setContentType("text/plain");
			}
			response.setContentLength(resultado.length);
			response.getOutputStream().write(resultado);

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Exception e) {
			PagosController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);

		}
	}

	/**
	 * 
	 * @param datos
	 *            Object[]
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/generarLiquidacionesViaApremio", method = RequestMethod.POST)
	public void generarLiquidacionesViaApremio(@RequestBody() HashMap<String, String>[] datos,
			HttpServletResponse response) {
		try {
			this.pagosService.generarLiquidacionesViaApremio(datos);
		} catch (Exception e) {
			PagosController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);

		}
	}

	/**
	 * 
	 * @param portalId
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return T17Portal
	 */
	@RequestMapping(value = "/bloquePortal", method = RequestMethod.GET)
	public @ResponseBody() T17Portal getBloquePortal(@RequestParam(value = "portalId", required = true) String portalId,
			HttpServletRequest request) {
		try {
			T17Portal t17portal = this.t17PortalService.find(Long.parseLong(portalId));
			return t17portal;
		} catch (Exception e) {
			/*
			 * throw new ServiceUnavailableException(
			 * "Count Service is not responding.");
			 */
		}
		return null;
	}

	/**
	 * 
	 * @param pagination
	 *            Pagination
	 * @param httpRequest
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "/comboConceptoIngreso", method = RequestMethod.GET)
	public @ResponseBody() List<Tipoconceptopago> getComboConceptoIngreso(@ModelAttribute() Pagination pagination,
			HttpServletRequest httpRequest) {
		try {
			Claseingreso clase = new Claseingreso();
			clase.setSlcodigo(Y41bConstantes.CLASE_OTROS_INGRESOS);
			Tipoconceptopago tcp = new Tipoconceptopago();
			tcp.setClaseingreso(clase);
			List<Tipoconceptopago> list = this.tipoconceptopagoService.findAll(tcp, null);
			return list;
		} catch (Exception e) {
			PagosController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * @param pagination
	 *            Pagination
	 * @param httpRequest
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "/comboConceptoIngresoHR", method = RequestMethod.GET)
	public @ResponseBody() List<Tipoconceptopago> getComboConceptoIngresoHR(@ModelAttribute() Pagination pagination,
			HttpServletRequest httpRequest) {
		try {
			Claseingreso clase = new Claseingreso();
			clase.setSlcodigo(Y41bConstantes.CLASE_HOJAS_RECLAMACIONES);
			Tipoconceptopago tcp = new Tipoconceptopago();
			tcp.setClaseingreso(clase);
			return this.tipoconceptopagoService.findAll(tcp, null);
		} catch (Exception e) {
			PagosController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * @return List
	 */
	@RequestMapping(value = "/comboConceptoInteres", method = RequestMethod.GET)
	public @ResponseBody() List<Tipoconceptopago> getComboConceptoInteres() {
		try {
			Claseingreso clase = new Claseingreso();
			clase.setSlcodigo(Y41bConstantes.CLASE_INTERESES);
			Tipoconceptopago tcp = new Tipoconceptopago();
			tcp.setClaseingreso(clase);
			List<Tipoconceptopago> list = this.tipoconceptopagoService.findAll(tcp, null);
			return list;
		} catch (Exception e) {
			PagosController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * @param sdejercicio
	 *            Long
	 * @param conceptoIngreso
	 *            String
	 * @param conceptoInteres
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "/comboConceptoPago", method = RequestMethod.GET)
	public @ResponseBody() List<Conceptopago> getComboConcetoPago(
			@RequestParam(value = "sdejercicio", required = true) Long sdejercicio,
			@RequestParam(value = "conceptoIngreso", required = false) String conceptoIngreso,
			@RequestParam(value = "conceptoInteres", required = false) String conceptoInteres,
			HttpServletRequest request) {
		try {

			Conceptopago conceptopago = new Conceptopago();
			Tipoconceptopago tcp = new Tipoconceptopago();
			tcp.setSccodigo(Y41bUtils.esNullOCadenaVacia(conceptoIngreso) ? conceptoInteres : conceptoIngreso);
			conceptopago.setTipoconceptopago(tcp);
			conceptopago.setSdejercicio(sdejercicio);

			return this.conceptopagoService.findAll(conceptopago, null);

		} catch (Exception e) {
			PagosController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * @param conceptoPago
	 *            String
	 * @param conceptoPagoInteres
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "/comboPartidaContable", method = RequestMethod.GET)
	public @ResponseBody() List<Tipoconceptopago> getComboPartidaContable(
			@RequestParam(value = "conceptopago.sdcodigo", required = false) String conceptoPago,
			@RequestParam(value = "conceptopagoInteres.sdcodigo", required = false) String conceptoPagoInteres,
			HttpServletRequest request) {
		try {
			List<Tipoconceptopago> combo = new ArrayList<Tipoconceptopago>();
			if (!Y41bUtils.esNullOCadenaVacia(conceptoPago) || !Y41bUtils.esNullOCadenaVacia(conceptoPagoInteres)) {
				Conceptopago conceptopago = new Conceptopago();
				conceptopago
						.setSdcodigo(Y41bUtils.esNullOCadenaVacia(conceptoPago) ? conceptoPagoInteres : conceptoPago);
				conceptopago = this.conceptopagoService.find(conceptopago);

				Tipoconceptopago tipoconceptopago = null;
				String valor = "";
				valor = conceptopago.getSdaplicpresup();
				if (!Y41bUtils.esNullOCadenaVacia(valor)) {
					tipoconceptopago = new Tipoconceptopago();
					tipoconceptopago.setSccodigo(valor);
					tipoconceptopago.setScdesces(valor);
					tipoconceptopago.setScdesceu(valor);
					combo.add(tipoconceptopago);
				}
				valor = conceptopago.getSdaplicpresup01();
				if (!Y41bUtils.esNullOCadenaVacia(valor)) {
					tipoconceptopago = new Tipoconceptopago();
					tipoconceptopago.setSccodigo(valor);
					tipoconceptopago.setScdesces(valor);
					tipoconceptopago.setScdesceu(valor);
					combo.add(tipoconceptopago);
				}
				valor = conceptopago.getSdaplicpresup20();
				if (!Y41bUtils.esNullOCadenaVacia(valor)) {
					tipoconceptopago = new Tipoconceptopago();
					tipoconceptopago.setSccodigo(valor);
					tipoconceptopago.setScdesces(valor);
					tipoconceptopago.setScdesceu(valor);
					combo.add(tipoconceptopago);
				}
				valor = conceptopago.getSdaplicpresup48();
				if (!Y41bUtils.esNullOCadenaVacia(valor)) {
					tipoconceptopago = new Tipoconceptopago();
					tipoconceptopago.setSccodigo(valor);
					tipoconceptopago.setScdesces(valor);
					tipoconceptopago.setScdesceu(valor);
					combo.add(tipoconceptopago);
				}
			}
			return combo;
		} catch (Exception e) {
			PagosController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * @param pagination
	 *            Pagination
	 * @param httpRequest
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "/comboEstado", method = RequestMethod.GET)
	public @ResponseBody() List<Estadopago> getComboEstado(@ModelAttribute() Pagination pagination,
			HttpServletRequest httpRequest) {
		try {
			return this.estadopagoService.findAll(new Estadopago(), null);
		} catch (Exception e) {
			PagosController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * @param pagos
	 *            Pagos
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/generarLiquidacionesHR", method = RequestMethod.POST)
	public void generarLiquidacionesHR(@RequestBody() Pagos pagos, HttpServletResponse response) {
		try {
			this.pagosService.generarLiquidacionesHR(pagos);
		} catch (Exception e) {
			PagosController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);

		}
	}

	/**
	 * 
	 * @param httpRequest
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/guardarOtrosIngresos", method = RequestMethod.GET)
	public void guardarOtrosIngresos(HttpServletRequest httpRequest, HttpServletResponse response) {
		try {
			Pagos pagos = new Pagos();
			pagos.setSgcodsubvencion(httpRequest.getParameter("sgcodsubvencion"));
			pagos.setSgfechareintegro(
					Y41bUtils.formatearStringToDateFormato(httpRequest.getParameter("sgfechareintegro")));
			pagos.setSgcausareintegro(httpRequest.getParameter("sgcausareintegro"));
			pagos.setSgestablecimiento(new Establecimiento(httpRequest.getParameter("sgestablecimiento.escodigo")));
			pagos.setSgfechalimitepago(
					Y41bUtils.formatearStringToDateFormato(httpRequest.getParameter("sgfechalimitepago")));
			pagos.setSgfechaemision(Y41bUtils.formatearStringToDateFormato(httpRequest.getParameter("sgfechaemision")));
			pagos.setSgfechanot(Y41bUtils.formatearStringToDateFormato(httpRequest.getParameter("sgfechanot")));
			pagos.setSgcomentarioes(httpRequest.getParameter("sgcomentarioes"));
			pagos.setSgcomentarioeu(httpRequest.getParameter("sgcomentarioeu"));
			pagos.setSgexpediente(httpRequest.getParameter("sgexpediente"));
			// Eliminamos simbolo euro, puntos de miles y cambiamos comas por
			// punto
			String importe = httpRequest.getParameter("sgimporte").replace("\u20AC", "");
			importe = importe.replaceAll("\\u002E", "");
			importe = importe.replace('\u002C', '\u002E');
			pagos.setSgimporte(new BigDecimal(importe.trim()));

			pagos.setSgaplicpresupuestaria(httpRequest.getParameter("sgaplicpresupuestaria"));
			Conceptopago conceptopago = new Conceptopago();
			conceptopago.setSdcodigo(httpRequest.getParameter("conceptopago.sdcodigo"));
			pagos.setConceptopago(this.conceptopagoService.find(conceptopago));

			importe = httpRequest.getParameter("sgimporteinteres").replace("\u20AC", "");
			importe = importe.replaceAll("\\u002E", "");
			importe = importe.replace('\u002C', '\u002E');
			if (!"".equals(importe)) {
				pagos.setSgimporteinteres(new BigDecimal(importe.trim()));
			}
			pagos.setSgaplicpresupinteres(httpRequest.getParameter("sgaplicpresupinteres"));
			Conceptopago conceptopagoI = new Conceptopago();
			conceptopagoI.setSdcodigo(httpRequest.getParameter("conceptopagoInteres.sdcodigo"));
			if (!"".equals(conceptopagoI.getSdcodigo())) {
				pagos.setConceptopagoInteres(this.conceptopagoService.find(conceptopagoI));
			}

			Organismo organismo = new Organismo();
			organismo.setEntidadId(pagos.getSgestablecimiento().getEscodigo());
			organismo = this.organismoService.findOrganismoById(organismo);
			PagosController.logger.info("Convertir organismo en saninterv");
			Saninterv saninterv = new Saninterv();
			saninterv.setUaentidad_id(organismo.getEntidadId());
			saninterv.setNombreMunicipio(organismo.getNombreMunicipio());

			saninterv.setUanombre(organismo.getNombreEs());
			saninterv.setUanif(organismo.getCif());
			saninterv.setUanrtel(organismo.getTelefono());

			saninterv.setUacoem(organismo.getEmail());
			saninterv.setUaprovId(organismo.getNoraProvinciaId());
			saninterv.setUamunId(organismo.getNoraMunicipioId());
			saninterv.setUalocId(organismo.getNoraLocalidadId());
			saninterv.setUacalleId(organismo.getNoraCalleId());
			saninterv.setUacpId(organismo.getNoraCpId());
			saninterv.setUaportalId(organismo.getNoraPortalId());
			saninterv.setUanombrePiso(organismo.getNombrePortal());
			saninterv.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTE_OTRO);
			pagos.setSgestablecimiento(pagos.getSgestablecimiento());
			PagosController.logger.info("Llamada SIPCA. generarDocumentoPasarelaPagosOtrosIngresos().");
			this.sipcaService.generarDocOtrosIngresos(pagos, saninterv, httpRequest, response);
		} catch (Exception e) {
			PagosController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);

		}
	}

	/**
	 * 
	 * @param file
	 *            MultipartFile
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMap(MultipartFile file) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();
		mapaRetorno.put("url", "/y41bVistaWar/tramiteNotificacion/guardarNotificacion/" + file.getOriginalFilename());
		mapaRetorno.put("name", file.getOriginalFilename());
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno.put("delete_url",
				"/y41bVistaWar/tramiteNotificacion/guardarNotificacion/" + file.getOriginalFilename());
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/**
	 * 
	 * @param datos
	 *            Object[]
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excluirViaApremio", method = RequestMethod.POST)
	public void excluirViaApremio(@RequestBody() HashMap<String, String>[] datos, HttpServletResponse response,
			HttpServletRequest request) {
		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		try {
			this.pagosService.excluirViaApremio(datos, censoMonitor);
		} catch (Exception e) {
			PagosController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);

		}
	}

	/**
	 * 
	 * @param datos
	 *            Object[]
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/incluirViaApremio", method = RequestMethod.POST)
	public void incluirViaApremio(@RequestBody() HashMap<String, String>[] datos, HttpServletResponse response,
			HttpServletRequest request) {
		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		try {
			this.pagosService.incluirViaApremio(datos, censoMonitor);
		} catch (Exception e) {
			PagosController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);

		}
	}
}
