package com.ejie.y41b.control;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Contacto;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.Y41bArbolOrganismos;
import com.ejie.y41b.service.ArbolOrganismosService;
import com.ejie.y41b.service.OrganismoService;
import com.ejie.y41b.utils.tree.Y41bOrganismosTree;

/**
 * * OrganismoController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/organismo")
public class OrganismoController {

	private static final Logger logger = LoggerFactory.getLogger(OrganismoController.class);

	@Autowired()
	private OrganismoService organismoService;

	@Autowired()
	private ArbolOrganismosService arbolOrganismosService;

	@Autowired()
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage", this.appConfiguration.get("Y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("Y41bVistaWar.default.layout"));
		return new ModelAndView("organismo", "model", model);
	}

	/**
	 * Method 'getCreateFormModal'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintModal", method = RequestMethod.GET)
	public ModelAndView getCreateFormModal(Model model) {
		model.addAttribute("defaultLanguage", this.appConfiguration.get("Y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("Y41bVistaWar.default.layout"));
		return new ModelAndView("organismoModal", "model", model);
	}

	/**
	 * Method 'getCreateFormModal'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintSeleccionOrganismos", method = RequestMethod.GET)
	public ModelAndView getCreateFormOrganismosSeleccionModal(Model model) {
		model.addAttribute("defaultLanguage", this.appConfiguration.get("Y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("Y41bVistaWar.default.layout"));
		return new ModelAndView("arbolOrganismosModal", "model", model);
	}

	/**
	 * Method 'getCreateFormOrganismosDetalleModal'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            Request
	 * @return String
	 */
	@RequestMapping(value = "maintDetalleOrganismos", method = RequestMethod.GET)
	public ModelAndView getCreateFormOrganismosDetalleModal(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", this.appConfiguration.get("Y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("Y41bVistaWar.default.layout"));

		Organismo organismo = new Organismo();
		organismo.setCodOrg("");
		if (request.getParameter("codOrg") != null) {
			organismo.setCodOrg(request.getParameter("codOrg"));
		}
		// organismo = this.organismoService.findOrganismoKnet(organismo);
		Organismo organismoAux = this.organismoService.findOrganismoKbide(organismo);

		model.addAttribute("organismo", organismoAux);
		return new ModelAndView("com_envios_OrganismoDetalleModal", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param codOrg
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/getByCodOrg/{codOrg}", method = RequestMethod.GET)
	public @ResponseBody() Organismo getById(@PathVariable() String codOrg) {
		try {
			Organismo organismo = new Organismo();
			organismo.setCodOrg(codOrg);
			organismo = this.organismoService.findOrganismo(organismo);
			if (organismo == null) {
				throw new Exception(codOrg.toString());
			}
			return organismo;
		} catch (Exception e) {
			throw new ResourceNotFoundException(codOrg.toString());
		}
	}

	/**
	 * Method 'getById'. Solo Kontsumonet
	 * 
	 * @param codOrg
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/knet/{codOrg}", method = RequestMethod.GET)
	public @ResponseBody() Organismo getByIdKnet(@PathVariable() String codOrg) {
		try {
			Organismo organismo = new Organismo();
			organismo.setCodOrg(codOrg);
			organismo = this.organismoService.findOrganismoKnet(organismo);

			if (organismo == null) {
				throw new Exception(codOrg.toString());
			}
			return organismo;
		} catch (Exception e) {
			throw new ResourceNotFoundException(codOrg.toString());
		}
	}

	/**
	 * Method 'getById'. Solo Kontsumobide
	 * 
	 * @param codOrg
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/kbide/{codOrg}", method = RequestMethod.GET)
	public @ResponseBody() Organismo getByIdKbide(@PathVariable() String codOrg) {
		try {
			Organismo organismo = new Organismo();
			organismo.setCodOrg(codOrg);
			organismo = this.organismoService.findOrganismoKbide(organismo);

			if (organismo == null) {
				throw new Exception(codOrg.toString());
			}
			return organismo;
		} catch (Exception e) {
			throw new ResourceNotFoundException(codOrg.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param codOrg
	 *            String
	 * @param entidadId
	 *            String
	 * @param nombreEs
	 *            String
	 * @param nombreEu
	 *            String
	 * @param activa
	 *            String
	 * @param iskontsumogest
	 *            String
	 * @param iskontsumonet
	 *            String
	 * @param isofertaform
	 *            String
	 * @param isconsultasweb
	 *            String
	 * @param isnacional
	 *            String
	 * @param observaciones
	 *            String
	 * @param telefono
	 *            String
	 * @param fax
	 *            String
	 * @param email
	 *            String
	 * @param url
	 *            String
	 * @param usuario
	 *            String
	 * @param password
	 *            String
	 * @param noraPaisId
	 *            String
	 * @param nombrePais
	 *            String
	 * @param noraProvinciaId
	 *            String
	 * @param nombreProvincia
	 *            String
	 * @param noraMunicipioId
	 *            String
	 * @param nombreMunicipio
	 *            String
	 * @param noraLocalidadId
	 *            String
	 * @param nombreLocalidad
	 *            String
	 * @param noraCalleId
	 *            String
	 * @param nombreCalle
	 *            String
	 * @param noraCpId
	 *            String
	 * @param nombreCp
	 *            String
	 * @param noraPortalId
	 *            String
	 * @param nombrePortal
	 *            String
	 * @param usuultmod
	 *            String
	 * @param fecultmod
	 *            Date
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody() Object getAll(@RequestParam(value = "codOrg", required = false) String codOrg,
			@RequestParam(value = "entidadId", required = false) String entidadId,
			@RequestParam(value = "nombreEs", required = false) String nombreEs,
			@RequestParam(value = "nombreEu", required = false) String nombreEu,
			@RequestParam(value = "activa", required = false) String activa,
			@RequestParam(value = "iskontsumogest", required = false) String iskontsumogest,
			@RequestParam(value = "iskontsumonet", required = false) String iskontsumonet,
			@RequestParam(value = "isofertaform", required = false) String isofertaform,
			@RequestParam(value = "isconsultasweb", required = false) String isconsultasweb,
			@RequestParam(value = "isnacional", required = false) String isnacional,
			@RequestParam(value = "observaciones", required = false) String observaciones,
			@RequestParam(value = "telefono", required = false) String telefono,
			@RequestParam(value = "fax", required = false) String fax,
			@RequestParam(value = "email", required = false) String email,
			@RequestParam(value = "url", required = false) String url,
			@RequestParam(value = "usuario", required = false) String usuario,
			@RequestParam(value = "password", required = false) String password,
			@RequestParam(value = "noraPaisId", required = false) String noraPaisId,
			@RequestParam(value = "nombrePais", required = false) String nombrePais,
			@RequestParam(value = "noraProvinciaId", required = false) String noraProvinciaId,
			@RequestParam(value = "nombreProvincia", required = false) String nombreProvincia,
			@RequestParam(value = "noraMunicipioId", required = false) String noraMunicipioId,
			@RequestParam(value = "nombreMunicipio", required = false) String nombreMunicipio,
			@RequestParam(value = "noraLocalidadId", required = false) String noraLocalidadId,
			@RequestParam(value = "nombreLocalidad", required = false) String nombreLocalidad,
			@RequestParam(value = "noraCalleId", required = false) String noraCalleId,
			@RequestParam(value = "nombreCalle", required = false) String nombreCalle,
			@RequestParam(value = "noraCpId", required = false) String noraCpId,
			@RequestParam(value = "nombreCp", required = false) String nombreCp,
			@RequestParam(value = "noraPortalId", required = false) String noraPortalId,
			@RequestParam(value = "nombrePortal", required = false) String nombrePortal,
			@RequestParam(value = "usuultmod", required = false) String usuultmod,
			@RequestParam(value = "fecultmod", required = false) Date fecultmod, HttpServletRequest request) {
		try {
			Organismo filterOrganismo = new Organismo(codOrg, entidadId, nombreEs, nombreEu, activa, iskontsumogest,
					iskontsumonet, isofertaform, isconsultasweb, isnacional, observaciones, telefono, fax, email, url,
					usuario, password, noraPaisId, nombrePais, noraProvinciaId, nombreProvincia, noraMunicipioId,
					nombreMunicipio, noraLocalidadId, nombreLocalidad, noraCalleId, nombreCalle, noraCpId, nombreCp,
					noraPortalId, nombrePortal, usuultmod, fecultmod);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Organismo> organismos = this.organismoService.findAll(filterOrganismo, pagination);

				if (organismos == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterOrganismo, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(organismos);
				return data;
			} else {
				List<Organismo> organismos = this.organismoService.findAll(filterOrganismo, pagination);
				if (organismos == null) {
					throw new Exception("No data Found.");
				}
				return organismos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * 
	 * @param codOrg_
	 *            String
	 * @param nombre_
	 *            String
	 * @param cif_
	 *            String
	 * @param activa_
	 *            String
	 * @param provinciaId_
	 *            provId
	 * @param municipioId_
	 *            muniId
	 * @param localidadId_
	 *            locaId
	 * @param request
	 *            req
	 * @return object
	 */
	@RequestMapping(value = "/like", method = RequestMethod.GET)
	public @ResponseBody() Object getAllOrganismos(
			@RequestParam(value = "y41bBusquedaOrganismoCodigoOrganismoId", required = false) String codOrg_,
			@RequestParam(value = "y41bBusquedaOrganismoNombre", required = false) String nombre_,
			@RequestParam(value = "y41bBusquedaOrganismoCif", required = false) String cif_,
			@RequestParam(value = "y41bBusquedaOrganismoMuestrarNoActivas", required = false) String activa_,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "localidadId", required = false) String localidadId_, HttpServletRequest request) {

		// Idioma
		Locale locale = LocaleContextHolder.getLocale();

		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String nombre = ("".equals(nombre_)) ? null : nombre_;
			String cif = ("".equals(cif_)) ? null : cif_;
			String activa = (activa_ == null ? null : "S");
			String provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
			String municipioId = ("".equals(municipioId_)) ? null : municipioId_;
			String localidadId = ("".equals(localidadId_)) ? null : localidadId_;

			Organismo filterOrganismo = new Organismo();
			filterOrganismo.setCodOrg(codOrg);
			if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
				filterOrganismo.setNombreEu(nombre);
			} else {
				filterOrganismo.setNombreEs(nombre);
			}
			filterOrganismo.setCif(cif);
			filterOrganismo.setNoraProvinciaId(provinciaId);
			filterOrganismo.setNoraMunicipioId(municipioId);
			filterOrganismo.setNoraLocalidadId(localidadId);
			filterOrganismo.setIncluirNoactivos(activa);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Organismo> organismos = this.organismoService.findAllLikeOrganismoKbide(filterOrganismo,
						pagination, false);

				if (organismos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.organismoService.findAllLikeOrganismoKbideCount(filterOrganismo, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(organismos);
				return data;
			} else {
				List<Organismo> organismos = this.organismoService.findAllLikeOrganismoKbide(filterOrganismo,
						pagination, false);
				if (organismos == null) {
					throw new Exception("No data Found.");
				}
				return organismos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * 
	 * @param codOrg_
	 *            String
	 * @param nombre_
	 *            String
	 * @param cif_
	 *            String
	 * @param activa_
	 *            String
	 * @param provinciaId_
	 *            provId
	 * @param municipioId_
	 *            muniId
	 * @param localidadId_
	 *            locaId
	 * @param request
	 *            req
	 * @return object
	 */
	@RequestMapping(value = "/likeKbideKnet", method = RequestMethod.GET)
	public @ResponseBody() Object getAllOrganismosKbideKnet(
			@RequestParam(value = "y41bBusquedaOrganismoCodigoOrganismoId", required = false) String codOrg_,
			@RequestParam(value = "y41bBusquedaOrganismoNombre", required = false) String nombre_,
			@RequestParam(value = "y41bBusquedaOrganismoCif", required = false) String cif_,
			@RequestParam(value = "y41bBusquedaOrganismoMuestrarNoActivas", required = false) String activa_,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "localidadId", required = false) String localidadId_, HttpServletRequest request) {

		// Idioma
		Locale locale = LocaleContextHolder.getLocale();

		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String nombre = ("".equals(nombre_)) ? null : nombre_;
			String cif = ("".equals(cif_)) ? null : cif_;
			String activa = (activa_ == null ? null : "S");
			String provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
			String municipioId = ("".equals(municipioId_)) ? null : municipioId_;
			String localidadId = ("".equals(localidadId_)) ? null : localidadId_;

			Organismo filterOrganismo = new Organismo();
			filterOrganismo.setCodOrg(codOrg);
			if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
				filterOrganismo.setNombreEu(nombre);
			} else {
				filterOrganismo.setNombreEs(nombre);
			}
			filterOrganismo.setCif(cif);
			filterOrganismo.setNoraProvinciaId(provinciaId);
			filterOrganismo.setNoraMunicipioId(municipioId);
			filterOrganismo.setNoraLocalidadId(localidadId);
			filterOrganismo.setIncluirNoactivos(activa);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Organismo> organismos = this.organismoService.findAllLikeOrganismoKbideKnet(filterOrganismo,
						pagination, false);

				if (organismos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.organismoService.findAllLikeOrganismoKbideKnetCount(filterOrganismo, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(organismos);
				return data;
			} else {
				List<Organismo> organismos = this.organismoService.findAllLikeOrganismoKbideKnet(filterOrganismo,
						pagination, false);
				if (organismos == null) {
					throw new Exception("No data Found.");
				}
				return organismos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * 
	 * @param codOrg_
	 *            String
	 * @param nombre_
	 *            String
	 * @param cif_
	 *            String
	 * @param activa_
	 *            String
	 * @param provinciaId_
	 *            provId
	 * @param municipioId_
	 *            muniId
	 * @param localidadId_
	 *            locaId
	 * @param request
	 *            req
	 * @return object
	 */
	@RequestMapping(value = "/likeCambioInstructor", method = RequestMethod.GET)
	public @ResponseBody() Object getAllOrganismosCambioInstructor(
			@RequestParam(value = "y41bBusquedaOrganismoCodigoOrganismoId", required = false) String codOrg_,
			@RequestParam(value = "y41bBusquedaOrganismoNombre", required = false) String nombre_,
			@RequestParam(value = "y41bBusquedaOrganismoCif", required = false) String cif_,
			@RequestParam(value = "y41bBusquedaOrganismoMuestrarNoActivas", required = false) String activa_,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "localidadId", required = false) String localidadId_, HttpServletRequest request) {

		// Idioma
		Locale locale = LocaleContextHolder.getLocale();

		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String nombre = ("".equals(nombre_)) ? null : nombre_;
			String cif = ("".equals(cif_)) ? null : cif_;
			String activa = (activa_ == null ? null : "S");
			String provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
			String municipioId = ("".equals(municipioId_)) ? null : municipioId_;
			String localidadId = ("".equals(localidadId_)) ? null : localidadId_;

			Organismo filterOrganismo = new Organismo();
			filterOrganismo.setCodOrg(codOrg);
			if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
				filterOrganismo.setNombreEu(nombre);
			} else {
				filterOrganismo.setNombreEs(nombre);
			}
			filterOrganismo.setCif(cif);
			filterOrganismo.setNoraProvinciaId(provinciaId);
			filterOrganismo.setNoraMunicipioId(municipioId);
			filterOrganismo.setNoraLocalidadId(localidadId);
			filterOrganismo.setIncluirNoactivos(activa);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Organismo> organismos = this.organismoService.findAllLikeOrganismoCambioInstructor(filterOrganismo,
						pagination, false);

				if (organismos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.organismoService.findAllLikeOrganismoCambioInstructorCount(filterOrganismo, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(organismos);
				return data;
			} else {
				List<Organismo> organismos = this.organismoService.findAllLikeOrganismoCambioInstructor(filterOrganismo,
						pagination, false);
				if (organismos == null) {
					throw new Exception("No data Found.");
				}
				return organismos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllTraslado'.
	 * 
	 * @param codOrg_
	 *            String
	 * @param nombre_
	 *            String
	 * @param cif_
	 *            String
	 * @param activa_
	 *            String
	 * @param provinciaId_
	 *            String
	 * @param municipioId_
	 *            String
	 * @param localidadId_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/liketraslado", method = RequestMethod.GET)
	public @ResponseBody Object getAllTraslado(
			@RequestParam(value = "y41bBusquedaOrganismoCodigoOrganismoId", required = false) String codOrg_,
			@RequestParam(value = "y41bBusquedaOrganismoNombre", required = false) String nombre_,
			@RequestParam(value = "y41bBusquedaOrganismoCif", required = false) String cif_,
			@RequestParam(value = "y41bBusquedaOrganismoMuestrarNoActivas", required = false) String activa_,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "localidadId", required = false) String localidadId_, HttpServletRequest request) {
		try {
			// Idioma
			Locale locale = LocaleContextHolder.getLocale();
			// control de los campos susceptibles de llegar a "" desde el filtro
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String nombreOrg = ("".equals(nombre_)) ? null : nombre_;
			String cif = ("".equals(cif_)) ? null : cif_;
			String provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
			String municipioId = ("".equals(municipioId_)) ? null : municipioId_;
			String localidadId = ("".equals(localidadId_)) ? null : localidadId_;
			// control checks
			String incluirNoactivos = (activa_ == null ? null : "S");

			Organismo filterOrganismo = new Organismo();
			filterOrganismo.setIncluirNoactivos(incluirNoactivos);
			filterOrganismo.setCodOrg(codOrg);
			if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
				filterOrganismo.setNombreEu(nombreOrg);
			} else {
				filterOrganismo.setNombreEs(nombreOrg);
			}
			filterOrganismo.setCif(cif);
			filterOrganismo.setNoraProvinciaId(provinciaId);
			filterOrganismo.setNoraMunicipioId(municipioId);
			filterOrganismo.setNoraLocalidadId(localidadId);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Organismo> organismos = this.organismoService.findAllLikeOrganismoKnet(filterOrganismo, pagination,
						false);

				if (organismos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.organismoService.findAllLikeOrganismoKnetCount(filterOrganismo, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(organismos);
				return data;
			} else {
				List<Organismo> organismos = this.organismoService.findAllLikeOrganismoKnet(filterOrganismo, pagination,
						false);
				if (organismos == null) {
					throw new Exception("No data Found.");
				}
				return organismos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllTraslado'.
	 * 
	 * @param codOrg_
	 *            String
	 * @param nombre_
	 *            String
	 * @param cif_
	 *            String
	 * @param activa_
	 *            String
	 * @param provinciaId_
	 *            String
	 * @param municipioId_
	 *            String
	 * @param localidadId_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/likedecisiontraslado", method = RequestMethod.GET)
	public @ResponseBody Object getAllDecisionTraslado(
			@RequestParam(value = "y41bBusquedaOrganismoCodigoOrganismoId", required = false) String codOrg_,
			@RequestParam(value = "y41bBusquedaOrganismoNombre", required = false) String nombre_,
			@RequestParam(value = "y41bBusquedaOrganismoCif", required = false) String cif_,
			@RequestParam(value = "y41bBusquedaOrganismoMuestrarNoActivas", required = false) String activa_,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "localidadId", required = false) String localidadId_, HttpServletRequest request) {
		try {
			// Idioma
			Locale locale = LocaleContextHolder.getLocale();
			// control de los campos susceptibles de llegar a "" desde el filtro
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String nombreOrg = ("".equals(nombre_)) ? null : nombre_;
			String cif = ("".equals(cif_)) ? null : cif_;
			String provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
			String municipioId = ("".equals(municipioId_)) ? null : municipioId_;
			String localidadId = ("".equals(localidadId_)) ? null : localidadId_;
			// control checks
			String incluirNoactivos = (activa_ == null ? null : "S");

			Organismo filterOrganismo = new Organismo();
			filterOrganismo.setIncluirNoactivos(incluirNoactivos);
			filterOrganismo.setCodOrg(codOrg);
			if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
				filterOrganismo.setNombreEu(nombreOrg);
			} else {
				filterOrganismo.setNombreEs(nombreOrg);
			}
			filterOrganismo.setCif(cif);
			filterOrganismo.setNoraProvinciaId(provinciaId);
			filterOrganismo.setNoraMunicipioId(municipioId);
			filterOrganismo.setNoraLocalidadId(localidadId);

			Pagination pagination = null;

			HttpSession httpSession = request.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			String codOrgConectado = censoMonitor.getOrganismo().getCodOrg();

			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<Organismo> organismos = this.organismoService.findAllLikeOrganismo(filterOrganismo,
						codOrgConectado, pagination, false);

				if (organismos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.organismoService.findAllLikeOrganismoCount(filterOrganismo, codOrgConectado, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(organismos);
				return data;
			} else {
				List<Organismo> organismos = this.organismoService.findAllLikeOrganismo(filterOrganismo,
						codOrgConectado, pagination, false);
				if (organismos == null) {
					throw new Exception("No data Found.");
				}
				return organismos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllNotificacionProductor'.
	 * 
	 * @param codOrg_
	 *            String
	 * @param nombre_
	 *            String
	 * @param cif_
	 *            String
	 * @param activa_
	 *            String
	 * @param provinciaId_
	 *            String
	 * @param municipioId_
	 *            String
	 * @param localidadId_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/likeNotificacionProductor", method = RequestMethod.GET)
	public @ResponseBody Object getAllNotificacionProductor(
			@RequestParam(value = "y41bBusquedaOrganismoCodigoOrganismoId", required = false) String codOrg_,
			@RequestParam(value = "y41bBusquedaOrganismoNombre", required = false) String nombre_,
			@RequestParam(value = "y41bBusquedaOrganismoCif", required = false) String cif_,
			@RequestParam(value = "y41bBusquedaOrganismoMuestrarNoActivas", required = false) String activa_,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "localidadId", required = false) String localidadId_, HttpServletRequest request) {
		try {
			// Idioma
			Locale locale = LocaleContextHolder.getLocale();
			// control de los campos susceptibles de llegar a "" desde el filtro
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String nombreOrg = ("".equals(nombre_)) ? null : nombre_;
			String cif = ("".equals(cif_)) ? null : cif_;
			String provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
			String municipioId = ("".equals(municipioId_)) ? null : municipioId_;
			String localidadId = ("".equals(localidadId_)) ? null : localidadId_;
			// control checks
			String incluirNoactivos = (activa_ == null ? null : "S");

			Organismo filterOrganismo = new Organismo();
			filterOrganismo.setIncluirNoactivos(incluirNoactivos);
			filterOrganismo.setCodOrg(codOrg);
			if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
				filterOrganismo.setNombreEu(nombreOrg);
			} else {
				filterOrganismo.setNombreEs(nombreOrg);
			}
			filterOrganismo.setCif(cif);
			filterOrganismo.setNoraProvinciaId(provinciaId);
			filterOrganismo.setNoraMunicipioId(municipioId);
			filterOrganismo.setNoraLocalidadId(localidadId);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Organismo> organismos = this.organismoService
						.findAllLikeOrganismosNotificacionProductor(filterOrganismo, pagination, false);

				if (organismos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.organismoService.findAllLikeOrganismosNotificacionProductorCount(filterOrganismo,
						false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(organismos);
				return data;
			} else {
				List<Organismo> organismos = this.organismoService
						.findAllLikeOrganismosNotificacionProductor(filterOrganismo, pagination, false);
				if (organismos == null) {
					throw new Exception("No data Found.");
				}
				return organismos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllComunicacionExterna'.
	 * 
	 * @param codOrg_
	 *            String
	 * @param nombre_
	 *            String
	 * @param cif_
	 *            String
	 * @param activa_
	 *            String
	 * @param provinciaId_
	 *            String
	 * @param municipioId_
	 *            String
	 * @param localidadId_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/likeComunicacionExterna", method = RequestMethod.GET)
	public @ResponseBody Object getAllComunicacionExterna(
			@RequestParam(value = "y41bBusquedaOrganismoCodigoOrganismoId", required = false) String codOrg_,
			@RequestParam(value = "y41bBusquedaOrganismoNombre", required = false) String nombre_,
			@RequestParam(value = "y41bBusquedaOrganismoCif", required = false) String cif_,
			@RequestParam(value = "y41bBusquedaOrganismoMuestrarNoActivas", required = false) String activa_,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "localidadId", required = false) String localidadId_, HttpServletRequest request) {
		try {
			// Idioma
			Locale locale = LocaleContextHolder.getLocale();
			// control de los campos susceptibles de llegar a "" desde el filtro
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String nombreOrg = ("".equals(nombre_)) ? null : nombre_;
			String cif = ("".equals(cif_)) ? null : cif_;
			String provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
			String municipioId = ("".equals(municipioId_)) ? null : municipioId_;
			String localidadId = ("".equals(localidadId_)) ? null : localidadId_;
			// control checks
			String incluirNoactivos = (activa_ == null ? null : "S");

			Organismo filterOrganismo = new Organismo();
			filterOrganismo.setIncluirNoactivos(incluirNoactivos);
			filterOrganismo.setCodOrg(codOrg);
			if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
				filterOrganismo.setNombreEu(nombreOrg);
			} else {
				filterOrganismo.setNombreEs(nombreOrg);
			}
			filterOrganismo.setCif(cif);
			filterOrganismo.setNoraProvinciaId(provinciaId);
			filterOrganismo.setNoraMunicipioId(municipioId);
			filterOrganismo.setNoraLocalidadId(localidadId);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Organismo> organismos = this.organismoService
						.findAllLikeOrganismosComunicacionExterna(filterOrganismo, pagination, false);

				if (organismos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.organismoService.findAllLikeOrganismosComunicacionExternaCount(filterOrganismo,
						false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(organismos);
				return data;
			} else {
				List<Organismo> organismos = this.organismoService
						.findAllLikeOrganismosComunicacionExterna(filterOrganismo, pagination, false);
				if (organismos == null) {
					throw new Exception("No data Found.");
				}
				return organismos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterOrganismo
	 *            Organismo
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody() Long getAllCount(
			@RequestParam(value = "organismo", required = false) Organismo filterOrganismo,
			HttpServletRequest request) {
		try {
			return this.organismoService.findAllCount(filterOrganismo != null ? filterOrganismo : new Organismo());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param response
	 *            HttpServletResponse
	 * @return Organismo
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody() Organismo edit(@RequestBody() Organismo organismo, HttpServletResponse response) {
		try {
			Organismo organismoAux = this.organismoService.update(organismo);
			logger.info("Entity correctly inserted!");
			return organismoAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody() Organismo add(@RequestBody() Organismo organismo) {
		try {
			Organismo organismoAux = this.organismoService.add(organismo);
			logger.info("Entity correctly inserted!");
			return organismoAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param codOrg
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{codOrg}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String codOrg, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Organismo organismo = new Organismo();
			organismo.setCodOrg(codOrg);
			this.organismoService.remove(organismo);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + codOrg);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param organismoIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody() ArrayList<ArrayList<String>> organismoIds, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Organismo> organismoList = new ArrayList<Organismo>();
		try {
			for (ArrayList<String> organismoId : organismoIds) {
				Iterator<String> iterator = organismoId.iterator();
				Organismo organismo = new Organismo();
				organismo.setCodOrg(ObjectConversionManager.convert(iterator.next(), String.class));
				organismoList.add(organismo);
			}
			this.organismoService.removeMultiple(organismoList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Carga del arbol de organismos para destinatarios de envios
	 * 
	 * @param response
	 *            Response
	 * @param request
	 *            Request
	 * @throws IOException
	 *             IOException
	 */
	@RequestMapping(value = "/arbolSeleccionOrganismos", method = RequestMethod.GET)
	public void getArbolOrganismos(HttpServletResponse response, HttpServletRequest request) throws IOException {

		response.setCharacterEncoding("ISO-8859-1");
		response.setHeader("Cache-Control", "no-cache");
		response.setContentType("text/html;charset=utf-8");

		Pagination pagination = new Pagination();

		Locale locale = LocaleContextHolder.getLocale();

		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			pagination.setSort("nombre_Es");
		} else {
			pagination.setSort("nombre_Eu");
		}
		pagination.setAscDsc(Y41bConstantes.ORDENACION_ASC);

		HttpSession httpSession = request.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		String codOrgConectado = censoMonitor.getOrganismo().getCodOrg();

		Y41bArbolOrganismos arbol = this.arbolOrganismosService.obtenerArbol(false, codOrgConectado, pagination);

		String json = Y41bOrganismosTree.obtieneJsonArbol(arbol);

		PrintWriter out = response.getWriter();
		out.println(json);
		out.flush();
		out.close();
	}

	/**
	 * Method 'getAllDestinatarios'.
	 * 
	 * @param tipo
	 *            Integer Diferenciar entre selección =0 y seleccionados = 1
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/destinatarios", method = RequestMethod.GET)
	public @ResponseBody() Object getAllDestinatarios(@RequestParam(value = "tipo", required = false) Integer tipo,
			HttpServletRequest request) {

		// parseo de fechas
		// Locale locale = LocaleContextHolder.getLocale();

		try {

			Pagination pagination = null;

			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<Organismo> lstOrganismo = new ArrayList<Organismo>();

				Long total = Long.parseLong(lstOrganismo.size() + "");
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(lstOrganismo);
				return data;
			} else {
				List<Organismo> lstOrganismo = new ArrayList<Organismo>();

				return lstOrganismo;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler()
	public @ResponseBody() String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getOrganismoService'.
	 * 
	 * @return OrganismoService
	 */
	protected OrganismoService getOrganismoService() {
		return this.organismoService;
	}

	/**
	 * Method 'setOrganismoService'.
	 * 
	 * @param organismoService
	 *            OrganismoService
	 * @return
	 */
	public void setOrganismoService(OrganismoService organismoService) {
		this.organismoService = organismoService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Filtra por los campos recuperando todos los organismos Kbide y Knet
	 * 
	 * @param codOrg_
	 *            String
	 * @param nombre_
	 *            String
	 * @param cif_
	 *            String
	 * @param activa_
	 *            String
	 * @param provinciaId_
	 *            provId
	 * @param municipioId_
	 *            muniId
	 * @param localidadId_
	 *            locaId
	 * @param request
	 *            req
	 * @return object
	 */
	@RequestMapping(value = "/liketodos", method = RequestMethod.GET)
	public @ResponseBody() Object getAllOrganismosTodos(
			@RequestParam(value = "y41bBusquedaOrganismoCodigoOrganismoId", required = false) String codOrg_,
			@RequestParam(value = "y41bBusquedaOrganismoNombre", required = false) String nombre_,
			@RequestParam(value = "y41bBusquedaOrganismoCif", required = false) String cif_,
			@RequestParam(value = "y41bBusquedaOrganismoMuestrarNoActivas", required = false) String activa_,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "localidadId", required = false) String localidadId_, HttpServletRequest request) {

		// Idioma
		Locale locale = LocaleContextHolder.getLocale();

		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String nombre = ("".equals(nombre_)) ? null : nombre_;
			String cif = ("".equals(cif_)) ? null : cif_;
			String activa = (activa_ == null ? null : "S");
			String provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
			String municipioId = ("".equals(municipioId_)) ? null : municipioId_;
			String localidadId = ("".equals(localidadId_)) ? null : localidadId_;

			Organismo filterOrganismo = new Organismo();
			filterOrganismo.setCodOrg(codOrg);
			if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
				filterOrganismo.setNombreEu(nombre);
			} else {
				filterOrganismo.setNombreEs(nombre);
			}
			filterOrganismo.setCif(cif);
			filterOrganismo.setNoraProvinciaId(provinciaId);
			filterOrganismo.setNoraMunicipioId(municipioId);
			filterOrganismo.setNoraLocalidadId(localidadId);
			filterOrganismo.setIncluirNoactivos(activa);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Organismo> organismos = this.organismoService.findAllLikeOrganismoKTodos(filterOrganismo,
						pagination, false);

				if (organismos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.organismoService.findAllLikeOrganismoKTodosCount(filterOrganismo, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(organismos);
				return data;
			} else {
				List<Organismo> organismos = this.organismoService.findAllLikeOrganismoKTodos(filterOrganismo,
						pagination, false);
				if (organismos == null) {
					throw new Exception("No data Found.");
				}
				return organismos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Filtra por los campos recuperando todos los organismos Kbide y Knet
	 * 
	 * @param codOrg_
	 *            String
	 * @param nombre_
	 *            String
	 * @param cif_
	 *            String
	 * @param activa_
	 *            String
	 * @param provinciaId_
	 *            provId
	 * @param municipioId_
	 *            muniId
	 * @param localidadId_
	 *            locaId
	 * @param request
	 *            req
	 * @return object
	 */
	@RequestMapping(value = "/likecrearsolicitudes", method = RequestMethod.GET)
	public @ResponseBody() Object getAllOrganismosCrearSolicitudes(
			@RequestParam(value = "y41bBusquedaOrganismoCodigoOrganismoId", required = false) String codOrg_,
			@RequestParam(value = "y41bBusquedaOrganismoNombre", required = false) String nombre_,
			@RequestParam(value = "y41bBusquedaOrganismoCif", required = false) String cif_,
			@RequestParam(value = "y41bBusquedaOrganismoMuestrarNoActivas", required = false) String activa_,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "localidadId", required = false) String localidadId_, HttpServletRequest request) {

		// Idioma
		Locale locale = LocaleContextHolder.getLocale();

		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String nombre = ("".equals(nombre_)) ? null : nombre_;
			String cif = ("".equals(cif_)) ? null : cif_;
			String activa = (activa_ == null ? null : "S");
			String provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
			String municipioId = ("".equals(municipioId_)) ? null : municipioId_;
			String localidadId = ("".equals(localidadId_)) ? null : localidadId_;

			Organismo filterOrganismo = new Organismo();
			filterOrganismo.setCodOrg(codOrg);
			if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
				filterOrganismo.setNombreEu(nombre);
			} else {
				filterOrganismo.setNombreEs(nombre);
			}
			filterOrganismo.setCif(cif);
			filterOrganismo.setNoraProvinciaId(provinciaId);
			filterOrganismo.setNoraMunicipioId(municipioId);
			filterOrganismo.setNoraLocalidadId(localidadId);
			filterOrganismo.setIncluirNoactivos(activa);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Organismo> organismos = this.organismoService
						.findAllLikeOrganismosCrearSolicitudes(filterOrganismo, pagination, false);

				if (organismos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.organismoService.findAllLikeOrganismosCrearSolicitudesCount(filterOrganismo, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(organismos);
				return data;
			} else {
				List<Organismo> organismos = this.organismoService
						.findAllLikeOrganismosCrearSolicitudes(filterOrganismo, pagination, false);
				if (organismos == null) {
					throw new Exception("No data Found.");
				}
				return organismos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Filtra por los campos recuperando todos los organismos UsuariosKbide13
	 * 
	 * @param codOrg_
	 *            String
	 * @param nombre_
	 *            String
	 * @param cif_
	 *            String
	 * @param activa_
	 *            String
	 * @param provinciaId_
	 *            provId
	 * @param municipioId_
	 *            muniId
	 * @param localidadId_
	 *            locaId
	 * @param request
	 *            req
	 * @return object
	 */
	@RequestMapping(value = "/likeusuarioskbide13", method = RequestMethod.GET)
	public @ResponseBody() Object getAllOrganismosUsuariosKbide13(
			@RequestParam(value = "y41bBusquedaOrganismoCodigoOrganismoId", required = false) String codOrg_,
			@RequestParam(value = "y41bBusquedaOrganismoNombre", required = false) String nombre_,
			@RequestParam(value = "y41bBusquedaOrganismoCif", required = false) String cif_,
			@RequestParam(value = "y41bBusquedaOrganismoMuestrarNoActivas", required = false) String activa_,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "localidadId", required = false) String localidadId_, HttpServletRequest request) {

		// Idioma
		Locale locale = LocaleContextHolder.getLocale();

		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String nombre = ("".equals(nombre_)) ? null : nombre_;
			String cif = ("".equals(cif_)) ? null : cif_;
			String activa = (activa_ == null ? null : "S");
			String provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
			String municipioId = ("".equals(municipioId_)) ? null : municipioId_;
			String localidadId = ("".equals(localidadId_)) ? null : localidadId_;

			Organismo filterOrganismo = new Organismo();
			filterOrganismo.setCodOrg(codOrg);
			if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
				filterOrganismo.setNombreEu(nombre);
			} else {
				filterOrganismo.setNombreEs(nombre);
			}
			filterOrganismo.setCif(cif);
			filterOrganismo.setNoraProvinciaId(provinciaId);
			filterOrganismo.setNoraMunicipioId(municipioId);
			filterOrganismo.setNoraLocalidadId(localidadId);
			filterOrganismo.setIncluirNoactivos(activa);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Organismo> organismos = this.organismoService.findAllLikeOrganismosUsuariosKbide13(filterOrganismo,
						pagination, false);

				if (organismos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.organismoService.findAllLikeOrganismosUsuariosKbide13Count(filterOrganismo, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(organismos);
				return data;
			} else {
				List<Organismo> organismos = this.organismoService.findAllLikeOrganismosUsuariosKbide13(filterOrganismo,
						pagination, false);
				if (organismos == null) {
					throw new Exception("No data Found.");
				}
				return organismos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Filtra por los campos recuperando todos los organismos TrasladoConsumo
	 * 
	 * @param codOrg_
	 *            String
	 * @param nombre_
	 *            String
	 * @param cif_
	 *            String
	 * @param activa_
	 *            String
	 * @param provinciaId_
	 *            provId
	 * @param municipioId_
	 *            muniId
	 * @param localidadId_
	 *            locaId
	 * @param request
	 *            req
	 * @return object
	 */
	@RequestMapping(value = "/liketrasladoconsumo", method = RequestMethod.GET)
	public @ResponseBody() Object getAllOrganismosTrasladoConsumo(
			@RequestParam(value = "y41bBusquedaOrganismoCodigoOrganismoId", required = false) String codOrg_,
			@RequestParam(value = "y41bBusquedaOrganismoNombre", required = false) String nombre_,
			@RequestParam(value = "y41bBusquedaOrganismoCif", required = false) String cif_,
			@RequestParam(value = "y41bBusquedaOrganismoMuestrarNoActivas", required = false) String activa_,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "localidadId", required = false) String localidadId_, HttpServletRequest request) {

		// Idioma
		Locale locale = LocaleContextHolder.getLocale();

		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String nombre = ("".equals(nombre_)) ? null : nombre_;
			String cif = ("".equals(cif_)) ? null : cif_;
			String activa = (activa_ == null ? null : "S");
			String provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
			String municipioId = ("".equals(municipioId_)) ? null : municipioId_;
			String localidadId = ("".equals(localidadId_)) ? null : localidadId_;

			Organismo filterOrganismo = new Organismo();
			filterOrganismo.setCodOrg(codOrg);
			if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
				filterOrganismo.setNombreEu(nombre);
			} else {
				filterOrganismo.setNombreEs(nombre);
			}
			filterOrganismo.setCif(cif);
			filterOrganismo.setNoraProvinciaId(provinciaId);
			filterOrganismo.setNoraMunicipioId(municipioId);
			filterOrganismo.setNoraLocalidadId(localidadId);
			filterOrganismo.setIncluirNoactivos(activa);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Organismo> organismos = this.organismoService.findAllLikeOrganismosTrasladoConsumo(filterOrganismo,
						pagination, false);

				if (organismos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.organismoService.findAllLikeOrganismosTrasladoConsumoCount(filterOrganismo, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(organismos);
				return data;
			} else {
				List<Organismo> organismos = this.organismoService.findAllLikeOrganismosTrasladoConsumo(filterOrganismo,
						pagination, false);
				if (organismos == null) {
					throw new Exception("No data Found.");
				}
				return organismos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Filtra por los campos recuperando todos los organismos InhibicionConsumo
	 * 
	 * @param codOrg_
	 *            String
	 * @param nombre_
	 *            String
	 * @param cif_
	 *            String
	 * @param activa_
	 *            String
	 * @param provinciaId_
	 *            provId
	 * @param municipioId_
	 *            muniId
	 * @param localidadId_
	 *            locaId
	 * @param request
	 *            req
	 * @return object
	 */
	@RequestMapping(value = "/likeinhibicionconsumo", method = RequestMethod.GET)
	public @ResponseBody() Object getAllOrganismosInhibicionConsumo(
			@RequestParam(value = "y41bBusquedaOrganismoCodigoOrganismoId", required = false) String codOrg_,
			@RequestParam(value = "y41bBusquedaOrganismoNombre", required = false) String nombre_,
			@RequestParam(value = "y41bBusquedaOrganismoCif", required = false) String cif_,
			@RequestParam(value = "y41bBusquedaOrganismoMuestrarNoActivas", required = false) String activa_,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "localidadId", required = false) String localidadId_, HttpServletRequest request) {

		// Idioma
		Locale locale = LocaleContextHolder.getLocale();

		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String nombre = ("".equals(nombre_)) ? null : nombre_;
			String cif = ("".equals(cif_)) ? null : cif_;
			String activa = (activa_ == null ? null : "S");
			String provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
			String municipioId = ("".equals(municipioId_)) ? null : municipioId_;
			String localidadId = ("".equals(localidadId_)) ? null : localidadId_;

			Organismo filterOrganismo = new Organismo();
			filterOrganismo.setCodOrg(codOrg);
			if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
				filterOrganismo.setNombreEu(nombre);
			} else {
				filterOrganismo.setNombreEs(nombre);
			}
			filterOrganismo.setCif(cif);
			filterOrganismo.setNoraProvinciaId(provinciaId);
			filterOrganismo.setNoraMunicipioId(municipioId);
			filterOrganismo.setNoraLocalidadId(localidadId);
			filterOrganismo.setIncluirNoactivos(activa);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Organismo> organismos = this.organismoService
						.findAllLikeOrganismosInhibicionConsumo(filterOrganismo, pagination, false);

				if (organismos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.organismoService.findAllLikeOrganismosInhibicionConsumoCount(filterOrganismo, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(organismos);
				return data;
			} else {
				List<Organismo> organismos = this.organismoService
						.findAllLikeOrganismosInhibicionConsumo(filterOrganismo, pagination, false);
				if (organismos == null) {
					throw new Exception("No data Found.");
				}
				return organismos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Filtra por los campos recuperando todos los organismos omicasociacion
	 * 
	 * @param codOrg_
	 *            String
	 * @param nombre_
	 *            String
	 * @param cif_
	 *            String
	 * @param activa_
	 *            String
	 * @param provinciaId_
	 *            provId
	 * @param municipioId_
	 *            muniId
	 * @param localidadId_
	 *            locaId
	 * @param request
	 *            req
	 * @return object
	 */
	@RequestMapping(value = "/likeomicasociacion", method = RequestMethod.GET)
	public @ResponseBody() Object getAllOrganismosOmicAsociacion(
			@RequestParam(value = "y41bBusquedaOrganismoCodigoOrganismoId", required = false) String codOrg_,
			@RequestParam(value = "y41bBusquedaOrganismoNombre", required = false) String nombre_,
			@RequestParam(value = "y41bBusquedaOrganismoCif", required = false) String cif_,
			@RequestParam(value = "y41bBusquedaOrganismoMuestrarNoActivas", required = false) String activa_,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "localidadId", required = false) String localidadId_, HttpServletRequest request) {

		// Idioma
		Locale locale = LocaleContextHolder.getLocale();

		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String nombre = ("".equals(nombre_)) ? null : nombre_;
			String cif = ("".equals(cif_)) ? null : cif_;
			String activa = (activa_ == null ? null : "S");
			String provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
			String municipioId = ("".equals(municipioId_)) ? null : municipioId_;
			String localidadId = ("".equals(localidadId_)) ? null : localidadId_;

			Organismo filterOrganismo = new Organismo();
			filterOrganismo.setCodOrg(codOrg);
			if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
				filterOrganismo.setNombreEu(nombre);
			} else {
				filterOrganismo.setNombreEs(nombre);
			}
			filterOrganismo.setCif(cif);
			filterOrganismo.setNoraProvinciaId(provinciaId);
			filterOrganismo.setNoraMunicipioId(municipioId);
			filterOrganismo.setNoraLocalidadId(localidadId);
			filterOrganismo.setIncluirNoactivos(activa);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Organismo> organismos = this.organismoService.findAllLikeOrganismosOmicAsociacion(filterOrganismo,
						pagination, false);

				if (organismos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.organismoService.findAllLikeOrganismosOmicAsociacionCount(filterOrganismo, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(organismos);
				return data;
			} else {
				List<Organismo> organismos = this.organismoService.findAllLikeOrganismosOmicAsociacion(filterOrganismo,
						pagination, false);
				if (organismos == null) {
					throw new Exception("No data Found.");
				}
				return organismos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Filtra por los campos recuperando todos los organismos OOEE
	 * 
	 * @param codOrg_
	 *            String
	 * @param nombre_
	 *            String
	 * @param cif_
	 *            String
	 * @param activa_
	 *            String
	 * @param provinciaId_
	 *            provId
	 * @param municipioId_
	 *            muniId
	 * @param localidadId_
	 *            locaId
	 * @param request
	 *            req
	 * @return object
	 */
	@RequestMapping(value = "/likeooee", method = RequestMethod.GET)
	public @ResponseBody() Object getAllOOEE(
			@RequestParam(value = "y41bBusquedaOrganismoCodigoOrganismoId", required = false) String codOrg_,
			@RequestParam(value = "y41bBusquedaOrganismoNombre", required = false) String nombre_,
			@RequestParam(value = "y41bBusquedaOrganismoCif", required = false) String cif_,
			@RequestParam(value = "y41bBusquedaOrganismoMuestrarNoActivas", required = false) String activa_,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "localidadId", required = false) String localidadId_, HttpServletRequest request) {

		// Idioma
		Locale locale = LocaleContextHolder.getLocale();

		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String nombre = ("".equals(nombre_)) ? null : nombre_;
			String cif = ("".equals(cif_)) ? null : cif_;
			String activa = (activa_ == null ? null : "S");
			String provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
			String municipioId = ("".equals(municipioId_)) ? null : municipioId_;
			String localidadId = ("".equals(localidadId_)) ? null : localidadId_;

			Organismo filterOrganismo = new Organismo();
			filterOrganismo.setCodOrg(codOrg);
			if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
				filterOrganismo.setNombreEu(nombre);
			} else {
				filterOrganismo.setNombreEs(nombre);
			}
			filterOrganismo.setCif(cif);
			filterOrganismo.setNoraProvinciaId(provinciaId);
			filterOrganismo.setNoraMunicipioId(municipioId);
			filterOrganismo.setNoraLocalidadId(localidadId);
			filterOrganismo.setIncluirNoactivos(activa);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Organismo> organismos = this.organismoService.findAllLikeOrganismosOOEE(filterOrganismo,
						pagination, false);

				if (organismos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.organismoService.findAllLikeOrganismosOOEECount(filterOrganismo, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(organismos);
				return data;
			} else {
				List<Organismo> organismos = this.organismoService.findAllLikeOrganismosOOEE(filterOrganismo,
						pagination, false);
				if (organismos == null) {
					throw new Exception("No data Found.");
				}
				return organismos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Filtra por los campos recuperando todos los organismos AACC
	 * 
	 * @param codOrg_
	 *            String
	 * @param nombre_
	 *            String
	 * @param cif_
	 *            String
	 * @param activa_
	 *            String
	 * @param provinciaId_
	 *            provId
	 * @param municipioId_
	 *            muniId
	 * @param localidadId_
	 *            locaId
	 * @param request
	 *            req
	 * @return object
	 */
	@RequestMapping(value = "/likeaacc", method = RequestMethod.GET)
	public @ResponseBody() Object getAllAACC(
			@RequestParam(value = "y41bBusquedaOrganismoCodigoOrganismoId", required = false) String codOrg_,
			@RequestParam(value = "y41bBusquedaOrganismoNombre", required = false) String nombre_,
			@RequestParam(value = "y41bBusquedaOrganismoCif", required = false) String cif_,
			@RequestParam(value = "y41bBusquedaOrganismoMuestrarNoActivas", required = false) String activa_,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "localidadId", required = false) String localidadId_, HttpServletRequest request) {

		// Idioma
		Locale locale = LocaleContextHolder.getLocale();

		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String nombre = ("".equals(nombre_)) ? null : nombre_;
			String cif = ("".equals(cif_)) ? null : cif_;
			String activa = (activa_ == null ? null : "S");
			String provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
			String municipioId = ("".equals(municipioId_)) ? null : municipioId_;
			String localidadId = ("".equals(localidadId_)) ? null : localidadId_;

			Organismo filterOrganismo = new Organismo();
			filterOrganismo.setCodOrg(codOrg);
			if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
				filterOrganismo.setNombreEu(nombre);
			} else {
				filterOrganismo.setNombreEs(nombre);
			}
			filterOrganismo.setCif(cif);
			filterOrganismo.setNoraProvinciaId(provinciaId);
			filterOrganismo.setNoraMunicipioId(municipioId);
			filterOrganismo.setNoraLocalidadId(localidadId);
			filterOrganismo.setIncluirNoactivos(activa);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Organismo> organismos = this.organismoService.findAllLikeOrganismosAACC(filterOrganismo,
						pagination, false);

				if (organismos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.organismoService.findAllLikeOrganismosAACCCount(filterOrganismo, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(organismos);
				return data;
			} else {
				List<Organismo> organismos = this.organismoService.findAllLikeOrganismosAACC(filterOrganismo,
						pagination, false);
				if (organismos == null) {
					throw new Exception("No data Found.");
				}
				return organismos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Filtra por los campos recuperando todos los organismos AACC
	 * 
	 * @param codOrg_
	 *            String
	 * @param nombre_
	 *            String
	 * @param cif_
	 *            String
	 * @param activa_
	 *            String
	 * @param provinciaId_
	 *            provId
	 * @param municipioId_
	 *            muniId
	 * @param localidadId_
	 *            locaId
	 * @param request
	 *            req
	 * @return object
	 */
	@RequestMapping(value = "/likeotros", method = RequestMethod.GET)
	public @ResponseBody() Object getAllOtros(
			@RequestParam(value = "y41bBusquedaOrganismoCodigoOrganismoId", required = false) String codOrg_,
			@RequestParam(value = "y41bBusquedaOrganismoNombre", required = false) String nombre_,
			@RequestParam(value = "y41bBusquedaOrganismoCif", required = false) String cif_,
			@RequestParam(value = "y41bBusquedaOrganismoMuestrarNoActivas", required = false) String activa_,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "localidadId", required = false) String localidadId_, HttpServletRequest request) {

		// Idioma
		Locale locale = LocaleContextHolder.getLocale();

		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String nombre = ("".equals(nombre_)) ? null : nombre_;
			String cif = ("".equals(cif_)) ? null : cif_;
			String activa = (activa_ == null ? null : "S");
			String provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
			String municipioId = ("".equals(municipioId_)) ? null : municipioId_;
			String localidadId = ("".equals(localidadId_)) ? null : localidadId_;

			Organismo filterOrganismo = new Organismo();
			filterOrganismo.setCodOrg(codOrg);
			if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
				filterOrganismo.setNombreEu(nombre);
			} else {
				filterOrganismo.setNombreEs(nombre);
			}
			filterOrganismo.setCif(cif);
			filterOrganismo.setNoraProvinciaId(provinciaId);
			filterOrganismo.setNoraMunicipioId(municipioId);
			filterOrganismo.setNoraLocalidadId(localidadId);
			filterOrganismo.setIncluirNoactivos(activa);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Organismo> organismos = this.organismoService.findAllLikeOrganismosOtros(filterOrganismo,
						pagination, false);

				if (organismos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.organismoService.findAllLikeOrganismosOtrosCount(filterOrganismo, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(organismos);
				return data;
			} else {
				List<Organismo> organismos = this.organismoService.findAllLikeOrganismosOtros(filterOrganismo,
						pagination, false);
				if (organismos == null) {
					throw new Exception("No data Found.");
				}
				return organismos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Filtra por los campos recuperando todos los organismos
	 * UsuariosDenunciasEmpresas
	 * 
	 * @param codOrg_
	 *            String
	 * @param nombre_
	 *            String
	 * @param cif_
	 *            String
	 * @param activa_
	 *            String
	 * @param provinciaId_
	 *            provId
	 * @param municipioId_
	 *            muniId
	 * @param localidadId_
	 *            locaId
	 * @param request
	 *            req
	 * @return object
	 */
	@RequestMapping(value = "/likeusuariosdenunciasempresas", method = RequestMethod.GET)
	public @ResponseBody() Object getAllUsuariosDenunciasEmpresas(
			@RequestParam(value = "y41bBusquedaOrganismoCodigoOrganismoId", required = false) String codOrg_,
			@RequestParam(value = "y41bBusquedaOrganismoNombre", required = false) String nombre_,
			@RequestParam(value = "y41bBusquedaOrganismoCif", required = false) String cif_,
			@RequestParam(value = "y41bBusquedaOrganismoMuestrarNoActivas", required = false) String activa_,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "localidadId", required = false) String localidadId_, HttpServletRequest request) {

		// Idioma
		Locale locale = LocaleContextHolder.getLocale();

		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String nombre = ("".equals(nombre_)) ? null : nombre_;
			String cif = ("".equals(cif_)) ? null : cif_;
			String activa = (activa_ == null ? null : "S");
			String provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
			String municipioId = ("".equals(municipioId_)) ? null : municipioId_;
			String localidadId = ("".equals(localidadId_)) ? null : localidadId_;

			Organismo filterOrganismo = new Organismo();
			filterOrganismo.setCodOrg(codOrg);
			if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
				filterOrganismo.setNombreEu(nombre);
			} else {
				filterOrganismo.setNombreEs(nombre);
			}
			filterOrganismo.setCif(cif);
			filterOrganismo.setNoraProvinciaId(provinciaId);
			filterOrganismo.setNoraMunicipioId(municipioId);
			filterOrganismo.setNoraLocalidadId(localidadId);
			filterOrganismo.setIncluirNoactivos(activa);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Organismo> organismos = this.organismoService.findAllLikeUsuariosDenunciasEmpresas(filterOrganismo,
						pagination, false);

				if (organismos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.organismoService.findAllLikeUsuariosDenunciasEmpresasCount(filterOrganismo, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(organismos);
				return data;
			} else {
				List<Organismo> organismos = this.organismoService.findAllLikeUsuariosDenunciasEmpresas(filterOrganismo,
						pagination, false);
				if (organismos == null) {
					throw new Exception("No data Found.");
				}
				return organismos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Filtra por los campos recuperando todos los organismos CensoUsuarios
	 * 
	 * @param codOrg_
	 *            String
	 * @param nombre_
	 *            String
	 * @param cif_
	 *            String
	 * @param activa_
	 *            String
	 * @param provinciaId_
	 *            provId
	 * @param municipioId_
	 *            muniId
	 * @param localidadId_
	 *            locaId
	 * @param request
	 *            req
	 * @return object
	 */
	@RequestMapping(value = "/likecensousuarios", method = RequestMethod.GET)
	public @ResponseBody() Object getAllCensoUsuarios(
			@RequestParam(value = "y41bBusquedaOrganismoCodigoOrganismoId", required = false) String codOrg_,
			@RequestParam(value = "y41bBusquedaOrganismoNombre", required = false) String nombre_,
			@RequestParam(value = "y41bBusquedaOrganismoCif", required = false) String cif_,
			@RequestParam(value = "y41bBusquedaOrganismoMuestrarNoActivas", required = false) String activa_,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "localidadId", required = false) String localidadId_, HttpServletRequest request) {

		// Idioma
		Locale locale = LocaleContextHolder.getLocale();

		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String nombre = ("".equals(nombre_)) ? null : nombre_;
			String cif = ("".equals(cif_)) ? null : cif_;
			String activa = (activa_ == null ? null : "S");
			String provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
			String municipioId = ("".equals(municipioId_)) ? null : municipioId_;
			String localidadId = ("".equals(localidadId_)) ? null : localidadId_;

			Organismo filterOrganismo = new Organismo();
			filterOrganismo.setCodOrg(codOrg);
			if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
				filterOrganismo.setNombreEu(nombre);
			} else {
				filterOrganismo.setNombreEs(nombre);
			}
			filterOrganismo.setCif(cif);
			filterOrganismo.setNoraProvinciaId(provinciaId);
			filterOrganismo.setNoraMunicipioId(municipioId);
			filterOrganismo.setNoraLocalidadId(localidadId);
			filterOrganismo.setIncluirNoactivos(activa);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Organismo> organismos = this.organismoService.findAllLikeCensoUsuarios(filterOrganismo, pagination,
						false);

				if (organismos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.organismoService.findAllLikeCensoUsuariosCount(filterOrganismo, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(organismos);
				return data;
			} else {
				List<Organismo> organismos = this.organismoService.findAllLikeCensoUsuarios(filterOrganismo, pagination,
						false);
				if (organismos == null) {
					throw new Exception("No data Found.");
				}
				return organismos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getByIdOrganismoCrearSolicitudes'. Solo Kontsumobide
	 * 
	 * @param codOrg
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/crearsolicitudes/{codOrg}", method = RequestMethod.GET)
	public @ResponseBody() Organismo getByIdOrganismoCrearSolicitudes(@PathVariable() String codOrg) {
		try {
			Organismo organismo = new Organismo();
			organismo.setCodOrg(codOrg);
			organismo = this.organismoService.findOrganismoCrearSolicitudes(organismo);

			if (organismo == null) {
				throw new Exception(codOrg.toString());
			}
			return organismo;
		} catch (Exception e) {
			throw new ResourceNotFoundException(codOrg.toString());
		}
	}

	/**
	 * Method 'getByIdOrganismoNotificacionProductor'. Solo Kontsumobide
	 * 
	 * @param codOrg
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/NotificacionProductor/{codOrg}", method = RequestMethod.GET)
	public @ResponseBody() Organismo getByIdOrganismoNotificacionProductor(@PathVariable() String codOrg) {
		try {
			Organismo organismo = new Organismo();
			organismo.setCodOrg(codOrg);
			organismo = this.organismoService.findOrganismoNotificacionProductor(organismo);

			if (organismo == null) {
				throw new Exception(codOrg.toString());
			}
			return organismo;
		} catch (Exception e) {
			throw new ResourceNotFoundException(codOrg.toString());
		}
	}

	/**
	 * Method 'getByIdOrganismoComunicacionExterna'. Solo Kontsumobide
	 * 
	 * @param codOrg
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/ComunicacionExterna/{codOrg}", method = RequestMethod.GET)
	public @ResponseBody() Organismo getByIdOrganismoComunicacionExterna(@PathVariable() String codOrg) {
		try {
			Organismo organismo = new Organismo();
			organismo.setCodOrg(codOrg);
			organismo = this.organismoService.findOrganismoComunicacionExterna(organismo);

			if (organismo == null) {
				throw new Exception(codOrg.toString());
			}
			return organismo;
		} catch (Exception e) {
			throw new ResourceNotFoundException(codOrg.toString());
		}
	}

	/**
	 * Method 'getByIdOrganismoUsuariosKbide13'
	 * 
	 * @param codOrg
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/usuarioskbide13/{codOrg}", method = RequestMethod.GET)
	public @ResponseBody() Organismo getByIdOrganismoUsuariosKbide13(@PathVariable() String codOrg) {
		try {
			Organismo organismo = new Organismo();
			organismo.setCodOrg(codOrg);
			organismo = this.organismoService.findOrganismoUsuariosKbide13(organismo);

			if (organismo == null) {
				throw new Exception(codOrg.toString());
			}
			return organismo;
		} catch (Exception e) {
			throw new ResourceNotFoundException(codOrg.toString());
		}
	}

	/**
	 * Method 'getByIdOrganismoTrasladoConsumo'
	 * 
	 * @param codOrg
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/trasladoconsumo/{codOrg}", method = RequestMethod.GET)
	public @ResponseBody() Organismo getByIdOrganismoTrasladoConsumo(@PathVariable() String codOrg) {
		try {
			Organismo organismo = new Organismo();
			organismo.setCodOrg(codOrg);
			organismo = this.organismoService.findOrganismoTrasladoConsumo(organismo);

			if (organismo == null) {
				throw new Exception(codOrg.toString());
			}
			return organismo;
		} catch (Exception e) {
			throw new ResourceNotFoundException(codOrg.toString());
		}
	}

	/**
	 * Method 'getByIdOrganismoInhibicionConsumo'
	 * 
	 * @param codOrg
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/inhibicionconsumo/{codOrg}", method = RequestMethod.GET)
	public @ResponseBody() Organismo getByIdOrganismoInhibicionConsumo(@PathVariable() String codOrg) {
		try {
			Organismo organismo = new Organismo();
			organismo.setCodOrg(codOrg);
			organismo = this.organismoService.findOrganismoInhibicionConsumo(organismo);

			if (organismo == null) {
				throw new Exception(codOrg.toString());
			}
			return organismo;
		} catch (Exception e) {
			throw new ResourceNotFoundException(codOrg.toString());
		}
	}

	/**
	 * Method 'getByIdOOEE'
	 * 
	 * @param codOrg
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/ooee/{codOrg}", method = RequestMethod.GET)
	public @ResponseBody() Organismo getByIdOOEE(@PathVariable() String codOrg) {
		try {
			Organismo organismo = new Organismo();
			organismo.setCodOrg(codOrg);
			organismo = this.organismoService.findOrganismoOOEE(organismo);

			if (organismo == null) {
				throw new Exception(codOrg.toString());
			}
			return organismo;
		} catch (Exception e) {
			throw new ResourceNotFoundException(codOrg.toString());
		}
	}

	/**
	 * Method 'getByIdAACC'
	 * 
	 * @param codOrg
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/aacc/{codOrg}", method = RequestMethod.GET)
	public @ResponseBody() Organismo getByIdAACC(@PathVariable() String codOrg) {
		try {
			Organismo organismo = new Organismo();
			organismo.setCodOrg(codOrg);
			organismo = this.organismoService.findOrganismoAACC(organismo);

			if (organismo == null) {
				throw new Exception(codOrg.toString());
			}
			return organismo;
		} catch (Exception e) {
			throw new ResourceNotFoundException(codOrg.toString());
		}
	}

	/**
	 * Method 'getByIdAACC'
	 * 
	 * @param codOrg
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/otros/{codOrg}", method = RequestMethod.GET)
	public @ResponseBody() Organismo getByIdOtros(@PathVariable() String codOrg) {
		try {
			Organismo organismo = new Organismo();
			organismo.setCodOrg(codOrg);
			organismo = this.organismoService.findOrganismoOtros(organismo);

			if (organismo == null) {
				throw new Exception(codOrg.toString());
			}
			return organismo;
		} catch (Exception e) {
			throw new ResourceNotFoundException(codOrg.toString());
		}
	}

	/**
	 * Method 'getByIdUsuariosDenunciasEmpresas'
	 * 
	 * @param codOrg
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/usuariosdenunciasempresas/{codOrg}", method = RequestMethod.GET)
	public @ResponseBody() Organismo getByIdUsuariosDenunciasEmpresas(@PathVariable() String codOrg) {
		try {
			Organismo organismo = new Organismo();
			organismo.setCodOrg(codOrg);
			organismo = this.organismoService.findUsuariosDenunciasEmpresas(organismo);

			if (organismo == null) {
				throw new Exception(codOrg.toString());
			}
			return organismo;
		} catch (Exception e) {
			throw new ResourceNotFoundException(codOrg.toString());
		}
	}

	/**
	 * Method 'getByIdCensoUsuarios'
	 * 
	 * @param codOrg
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/censousuarios/{codOrg}", method = RequestMethod.GET)
	public @ResponseBody() Organismo getByIdCensoUsuarios(@PathVariable() String codOrg) {
		try {
			Organismo organismo = new Organismo();
			organismo.setCodOrg(codOrg);
			organismo = this.organismoService.findCensoUsuarios(organismo);

			if (organismo == null) {
				throw new Exception(codOrg.toString());
			}
			return organismo;
		} catch (Exception e) {
			throw new ResourceNotFoundException(codOrg.toString());
		}
	}

	/**
	 * Method 'getByIdOrganismoOmicAsociacion'
	 * 
	 * @param codOrg
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/omicasociacion/{codOrg}", method = RequestMethod.GET)
	public @ResponseBody() Organismo getByIdOrganismoOmicAsociacion(@PathVariable() String codOrg) {
		try {
			Organismo organismo = new Organismo();
			organismo.setCodOrg(codOrg);
			organismo = this.organismoService.findOrganismoOmicAsociacion(organismo);

			if (organismo == null) {
				throw new Exception(codOrg.toString());
			}
			return organismo;
		} catch (Exception e) {
			throw new ResourceNotFoundException(codOrg.toString());
		}
	}

	/**
	 * Method 'getByIdOrganismoOmicAsociacion'
	 * 
	 * @param entidadId
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/organismoByEntidadId/{entidadId}", method = RequestMethod.GET)
	public @ResponseBody() Organismo getOrganismoByEntidadId(@PathVariable() String entidadId) {
		try {
			Organismo organismo = new Organismo();
			organismo.setEntidadId(entidadId);
			organismo = this.organismoService.findOrganismoById(organismo);

			if (organismo == null) {
				throw new Exception(entidadId.toString());
			}
			return organismo;
		} catch (Exception e) {
			throw new ResourceNotFoundException(entidadId.toString());
		}
	}

	/**
	 * Filtra por los campos recuperando todos los organismos Kbide y Knet
	 * 
	 * @param codOrg_
	 *            String
	 * @param nombre_
	 *            String
	 * @param cif_
	 *            String
	 * @param activa_
	 *            String
	 * @param provinciaId_
	 *            provId
	 * @param municipioId_
	 *            muniId
	 * @param localidadId_
	 *            locaId
	 * @param request
	 *            req
	 * @return object
	 */
	@RequestMapping(value = "/likearbitraje", method = RequestMethod.GET)
	public @ResponseBody() Object getAllOrganismosArbitraje(
			@RequestParam(value = "y41bBusquedaOrganismoCodigoOrganismoId", required = false) String codOrg_,
			@RequestParam(value = "y41bBusquedaOrganismoNombre", required = false) String nombre_,
			@RequestParam(value = "y41bBusquedaOrganismoCif", required = false) String cif_,
			@RequestParam(value = "y41bBusquedaOrganismoMuestrarNoActivas", required = false) String activa_,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "localidadId", required = false) String localidadId_, HttpServletRequest request) {

		// Idioma
		Locale locale = LocaleContextHolder.getLocale();

		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String nombre = ("".equals(nombre_)) ? null : nombre_;
			String cif = ("".equals(cif_)) ? null : cif_;
			String activa = (activa_ == null ? null : "S");
			String provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
			String municipioId = ("".equals(municipioId_)) ? null : municipioId_;
			String localidadId = ("".equals(localidadId_)) ? null : localidadId_;

			Organismo filterOrganismo = new Organismo();
			filterOrganismo.setCodOrg(codOrg);
			if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
				filterOrganismo.setNombreEu(nombre);
			} else {
				filterOrganismo.setNombreEs(nombre);
			}
			filterOrganismo.setCif(cif);
			filterOrganismo.setNoraProvinciaId(provinciaId);
			filterOrganismo.setNoraMunicipioId(municipioId);
			filterOrganismo.setNoraLocalidadId(localidadId);
			filterOrganismo.setIncluirNoactivos(activa);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Organismo> organismos = this.organismoService.findAllLikeOrganismoArbitraje(filterOrganismo,
						pagination, false);

				if (organismos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.organismoService.findAllLikeOrganismoArbitrajeCount(filterOrganismo, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(organismos);
				return data;
			} else {
				List<Organismo> organismos = this.organismoService.findAllLikeOrganismoArbitraje(filterOrganismo,
						pagination, false);
				if (organismos == null) {
					throw new Exception("No data Found.");
				}
				return organismos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Filtra por los campos recuperando todos los organismos Kbide y Knet
	 * 
	 * @param codOrg_
	 *            String
	 * @param nombre_
	 *            String
	 * @param cif_
	 *            String
	 * @param activa_
	 *            String
	 * @param provinciaId_
	 *            provId
	 * @param municipioId_
	 *            muniId
	 * @param localidadId_
	 *            locaId
	 * @param request
	 *            req
	 * @return object
	 */
	@RequestMapping(value = "/likearbitrajejjaa", method = RequestMethod.GET)
	public @ResponseBody() Object getAllOrganismosArbitrajejjaa(
			@RequestParam(value = "y41bBusquedaOrganismoCodigoOrganismoId", required = false) String codOrg_,
			@RequestParam(value = "y41bBusquedaOrganismoNombre", required = false) String nombre_,
			@RequestParam(value = "y41bBusquedaOrganismoCif", required = false) String cif_,
			@RequestParam(value = "y41bBusquedaOrganismoMuestrarNoActivas", required = false) String activa_,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "localidadId", required = false) String localidadId_, HttpServletRequest request) {

		// Idioma
		Locale locale = LocaleContextHolder.getLocale();

		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String nombre = ("".equals(nombre_)) ? null : nombre_;
			String cif = ("".equals(cif_)) ? null : cif_;
			String activa = (activa_ == null ? null : "S");
			String provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
			String municipioId = ("".equals(municipioId_)) ? null : municipioId_;
			String localidadId = ("".equals(localidadId_)) ? null : localidadId_;

			Organismo filterOrganismo = new Organismo();
			filterOrganismo.setCodOrg(codOrg);
			if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
				filterOrganismo.setNombreEu(nombre);
			} else {
				filterOrganismo.setNombreEs(nombre);
			}
			filterOrganismo.setCif(cif);
			filterOrganismo.setNoraProvinciaId(provinciaId);
			filterOrganismo.setNoraMunicipioId(municipioId);
			filterOrganismo.setNoraLocalidadId(localidadId);
			filterOrganismo.setIncluirNoactivos(activa);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Organismo> organismos = this.organismoService.findAllLikeOrganismoArbitrajeJjaa(filterOrganismo,
						pagination, false);

				if (organismos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.organismoService.findAllLikeOrganismoArbitrajeCountJjaa(filterOrganismo, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(organismos);
				return data;
			} else {
				List<Organismo> organismos = this.organismoService.findAllLikeOrganismoArbitrajeJjaa(filterOrganismo,
						pagination, false);
				if (organismos == null) {
					throw new Exception("No data Found.");
				}
				return organismos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Filtra por los campos recuperando todos los organismos Control Mercado
	 * 
	 * @param codOrg_
	 *            String
	 * @param nombre_
	 *            String
	 * @param cif_
	 *            String
	 * @param activa_
	 *            String
	 * @param provinciaId_
	 *            provId
	 * @param municipioId_
	 *            muniId
	 * @param localidadId_
	 *            locaId
	 * @param request
	 *            req
	 * @return object
	 */
	@RequestMapping(value = "/likeusuarioscontrolmercado", method = RequestMethod.GET)
	public @ResponseBody() Object getAllOrganismosUsuarioscontrolmercado(
			@RequestParam(value = "y41bBusquedaOrganismoCodigoOrganismoId", required = false) String codOrg_,
			@RequestParam(value = "y41bBusquedaOrganismoNombre", required = false) String nombre_,
			@RequestParam(value = "y41bBusquedaOrganismoCif", required = false) String cif_,
			@RequestParam(value = "y41bBusquedaOrganismoMuestrarNoActivas", required = false) String activa_,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "localidadId", required = false) String localidadId_, HttpServletRequest request) {

		// Idioma
		Locale locale = LocaleContextHolder.getLocale();

		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String nombre = ("".equals(nombre_)) ? null : nombre_;
			String cif = ("".equals(cif_)) ? null : cif_;
			String activa = (activa_ == null ? null : "S");
			String provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
			String municipioId = ("".equals(municipioId_)) ? null : municipioId_;
			String localidadId = ("".equals(localidadId_)) ? null : localidadId_;

			Organismo filterOrganismo = new Organismo();
			filterOrganismo.setCodOrg(codOrg);
			if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
				filterOrganismo.setNombreEu(nombre);
			} else {
				filterOrganismo.setNombreEs(nombre);
			}
			filterOrganismo.setCif(cif);
			filterOrganismo.setNoraProvinciaId(provinciaId);
			filterOrganismo.setNoraMunicipioId(municipioId);
			filterOrganismo.setNoraLocalidadId(localidadId);
			filterOrganismo.setIncluirNoactivos(activa);

			Pagination pagination = null;
			List<Organismo> organismos = this.organismoService
					.findAllLikeOrganismosUsuariosControlMercado(filterOrganismo, pagination, false);
			if (organismos == null) {
				throw new Exception("No data Found.");
			}
			return organismos;

		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Filtra por los campos recuperando todos los organismos asociaciones de
	 * euskadi vista y42bv09
	 * 
	 * @param codOrg_
	 *            String
	 * @param nombre_
	 *            String
	 * @param cif_
	 *            String
	 * @param activa_
	 *            String
	 * @param provinciaId_
	 *            provId
	 * @param municipioId_
	 *            muniId
	 * @param localidadId_
	 *            locaId
	 * @param request
	 *            req
	 * @return object
	 */
	@RequestMapping(value = "/likeAaccEuskadi", method = RequestMethod.GET)
	public @ResponseBody() Object getAllOrganismosAaccEuskadi(
			@RequestParam(value = "y41bBusquedaOrganismoCodigoOrganismoId", required = false) String codOrg_,
			@RequestParam(value = "y41bBusquedaOrganismoNombre", required = false) String nombre_,
			@RequestParam(value = "y41bBusquedaOrganismoCif", required = false) String cif_,
			@RequestParam(value = "y41bBusquedaOrganismoMuestrarNoActivas", required = false) String activa_,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "localidadId", required = false) String localidadId_, HttpServletRequest request) {

		// Idioma
		Locale locale = LocaleContextHolder.getLocale();

		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String nombre = ("".equals(nombre_)) ? null : nombre_;
			String cif = ("".equals(cif_)) ? null : cif_;
			String activa = (activa_ == null ? null : "S");
			String provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
			String municipioId = ("".equals(municipioId_)) ? null : municipioId_;
			String localidadId = ("".equals(localidadId_)) ? null : localidadId_;

			Organismo filterOrganismo = new Organismo();
			filterOrganismo.setCodOrg(codOrg);
			if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
				filterOrganismo.setNombreEu(nombre);
			} else {
				filterOrganismo.setNombreEs(nombre);
			}
			filterOrganismo.setCif(cif);
			filterOrganismo.setNoraProvinciaId(provinciaId);
			filterOrganismo.setNoraMunicipioId(municipioId);
			filterOrganismo.setNoraLocalidadId(localidadId);
			filterOrganismo.setIncluirNoactivos(activa);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Organismo> organismos = this.organismoService.findAllLikeOrganismoAaccEuskadi(filterOrganismo,
						pagination, false);

				if (organismos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.organismoService.findAllLikeOrganismoAaccEuskadiCount(filterOrganismo, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(organismos);
				return data;
			} else {
				List<Organismo> organismos = this.organismoService.findAllLikeOrganismoAaccEuskadi(filterOrganismo,
						pagination, false);
				if (organismos == null) {
					throw new Exception("No data Found.");
				}
				return organismos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param codOrg
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/getContactoByCodOrg/{codOrg}", method = RequestMethod.GET)
	public @ResponseBody() Contacto getContactoByIdOrg(@PathVariable() String codOrg) {
		try {
			Organismo organismo = new Organismo();
			organismo.setCodOrg(codOrg);

			Contacto contacto = new Contacto();
			contacto = this.organismoService.findContacto(organismo);
			if (organismo == null) {
				throw new Exception(codOrg.toString());
			}
			return contacto;
		} catch (Exception e) {
			throw new ResourceNotFoundException(codOrg.toString());
		}
	}

}
