package com.ejie.y41b.control;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Ooee;
import com.ejie.y41b.service.OoeeService;
import com.ejie.y41b.service.Y41bExcelGeneratorService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * OoeeController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/ooee")
public class OoeeController {

	private static final Logger logger = LoggerFactory
			.getLogger(OoeeController.class);

	@Autowired()
	private OoeeService ooeeService;

	@Autowired()
	private Y41bExcelGeneratorService y41bExcelGeneratorService;

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {
		OoeeController.logger.info("[GET - View] : ooee");
		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| (censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO) && censoMonitor
						.getPerfilArbitraje().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO))) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("ooee", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "seleccionOoee", method = RequestMethod.GET)
	public ModelAndView getCreateFormModal(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusquedaOoee",
				Y41bConstantes.MODO_POPUP_SELECCION);

		return new ModelAndView("ooeeSeleccion", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param oecodigo
	 *            String
	 * @return ooee Ooee
	 */
	@RequestMapping(value = "/getById/{oecodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	Ooee getById(@PathVariable() String oecodigo) {
		try {
			Ooee ooee = new Ooee();
			ooee.setOecodigo(oecodigo);
			ooee = this.ooeeService.find(ooee);
			OoeeController.logger
					.info("[GET - findBy_PK] : Obtener Ooee por PK");
			if (ooee == null) {
				throw new Exception(oecodigo.toString());
			}
			return ooee;
		} catch (Exception e) {
			throw new ResourceNotFoundException(oecodigo.toString());
		}

	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterOoee
	 *            Ooee
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Ooee> getAll(@ModelAttribute() Ooee filterOoee) {
		OoeeController.logger
				.info("[GET - find_ALL] : Obtener Ooee por filtro");
		return this.ooeeService.findAll(filterOoee, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param ooee
	 *            Ooee
	 * @param request
	 *            HttpServletRequest
	 * @return Ooee
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Ooee edit(@RequestBody() Ooee ooee, HttpServletRequest request) {
		Ooee ooeeAux = this.ooeeService.update(ooee);
		OoeeController.logger.info("[PUT] : Ooee actualizado correctamente");
		return ooeeAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param ooee
	 *            Ooee
	 * @return Ooee
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Ooee add(@RequestBody() Ooee ooee) {
		Ooee ooeeAux = this.ooeeService.add(ooee);
		OoeeController.logger.info("[POST] : Ooee insertado correctamente");
		return ooeeAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param oecodigo
	 *            String
	 * @return ooee
	 */
	@RequestMapping(value = "/{oecodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Ooee remove(@PathVariable() String oecodigo) {
		try {
			Ooee ooee = new Ooee();
			ooee.setOecodigo(oecodigo);
			this.ooeeService.remove(ooee);
			OoeeController.logger.info("[DELETE] : Ooee borrado correctamente");
			return ooee;
		} catch (Y41bUDAException e) {
			OoeeController.logger
					.info("[DELETE] : Ooee no se ha podido borrar");
			throw e;
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param ooeeIds
	 *            List
	 * @return ooeeList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(@RequestBody() List<List<String>> ooeeIds) {
		List<Ooee> ooeeList = new ArrayList<Ooee>();
		for (List<String> ooeeId : ooeeIds) {
			Iterator<String> iterator = ooeeId.iterator();
			Ooee ooee = new Ooee(); // NOPMD - Objeto nuevo en la lista
									// (parametro del servicio)
			ooee.setOecodigo(ObjectConversionManager.convert(iterator.next(),
					String.class));
			ooeeList.add(ooee);
		}
		this.ooeeService.removeMultiple(ooeeList);
		OoeeController.logger
				.info("[POST - DELETE_ALL] : Ooee borrados correctamente");
		return ooeeIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterOoee
	 *            Ooee
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/busqueda", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(@ModelAttribute() Ooee filterOoee,
			@ModelAttribute() Pagination pagination) {

		if (!Y41bUtils.esNullOCadenaVacia(filterOoee.getOenombre())) {
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();
			if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
				filterOoee.getOrganismo().setNombreEs(filterOoee.getOenombre());
			} else if (Y41bConstantes.EUSKERA.equalsIgnoreCase(idioma)) {
				filterOoee.getOrganismo().setNombreEu(filterOoee.getOenombre());
			}
		}
		List<Ooee> ooees = this.ooeeService.findAllBusqueda(filterOoee,
				pagination);
		Long recordNum = this.ooeeService.findAllBusquedaCount(filterOoee);
		OoeeController.logger.info("[GET - jqGrid] : Obtener Ooee");
		return new JQGridJSONModel(pagination, recordNum, ooees);
	}

	/**
	 * Method 'getCreateFormDetalle'.
	 * 
	 * @param oecodigo
	 *            String
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "/detalle/{oecodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormDetalle(@PathVariable() String oecodigo,
			Model model) {
		OoeeController.logger.info("[GET - View] : ooee");
		model.addAttribute("oecodigo", oecodigo);
		model.addAttribute("modo", Y41bConstantes.MODO_POPUP_MODIFICACION);
		return new ModelAndView("ooeeDetalle", "model", model);
	}

	/**
	 * Method 'getCreateFormDetalle'.
	 * 
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "/alta", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(Model model) {
		OoeeController.logger.info("[GET - View] : ooee");
		model.addAttribute("modo", Y41bConstantes.MODO_POPUP_ALTA);
		return new ModelAndView("ooeeDetalle", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param oecodigo
	 *            String
	 * @return ooee Ooee
	 */
	@RequestMapping(value = "/existe/{oecodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	long existe(@PathVariable() String oecodigo) {
		Ooee ooee = new Ooee();
		ooee.setOecodigo(oecodigo);
		return this.ooeeService.findAllCount(ooee);
	}

	/**
	 * Method 'borrarTemporales'.
	 * 
	 * @param oecodigo
	 *            String
	 */
	@RequestMapping(value = "/borrarTemporales/{oecodigo}", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	void borrarTemporales(@PathVariable() String oecodigo) {
		Ooee ooee = new Ooee();
		ooee.setOecodigo(oecodigo);
		this.ooeeService.borrarTemporales(ooee);
		OoeeController.logger
				.info("[DELETE] : Ooee Temporalres borrado correctamente");

	}

	/**
	 * Method 'getAllExcel'.
	 * 
	 * @param filterOoee
	 *            Ooee
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excel", method = RequestMethod.GET)
	public void getAllExcel(@ModelAttribute() Ooee filterOoee,
			HttpServletRequest request, HttpServletResponse response) {
		try {
			if (!Y41bUtils.esNullOCadenaVacia(filterOoee.getOenombre())) {
				Locale locale = LocaleContextHolder.getLocale();
				String idioma = locale.getLanguage();
				if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
					filterOoee.getOrganismo().setNombreEs(
							filterOoee.getOenombre());
				} else if (Y41bConstantes.EUSKERA.equalsIgnoreCase(idioma)) {
					filterOoee.getOrganismo().setNombreEu(
							filterOoee.getOenombre());
				}
			}

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy,
					"yyyyMMddHHmmss");
			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_OOEE + fechaActual + ".xls";
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ StringEscapeUtils.unescapeHtml(nombre) + "\"");

			String xslString = this.y41bExcelGeneratorService
					.getOoeeExcel(filterOoee);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody()
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;
		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			// throw new ResourceNotFoundException("No data Found.");
		}
	}
}
