package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Motivo;
import com.ejie.y41b.model.UnidadesDir3;
import com.ejie.y41b.service.UnidadesDir3Service;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * * OficinasDir3Controller
 * 
 *  
 */

@Controller
@RequestMapping(value = "/oficinasDir3")
public class OficinasDir3Controller {

	private static final Logger logger = LoggerFactory.getLogger(OficinasDir3Controller.class);

	@Autowired
	private UnidadesDir3Service unidadesDir3Service;

	@Autowired
	private Properties appConfiguration;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "seleccionOficinasDir3", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("seleccionOficinasDir3", "model", model);
	}

	/**
	 * Method 'getAllOficinasDir3'. de tipo like
	 * 
	 * @param codOficina_
	 *            String
	 * @param descOficina_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/like", method = RequestMethod.GET)
	public @ResponseBody Object getAllOficinasDir3(
			@RequestParam(value = "codOficina", required = false) String codOficina_,
			@RequestParam(value = "descOficina", required = false) String descOficina_, HttpServletRequest request) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String codOficina = ("".equals(codOficina_)) ? null : codOficina_;
			String descOficina = ("".equals(descOficina_)) ? null : descOficina_;

			UnidadesDir3 filterUnidadesDir3 = new UnidadesDir3(codOficina, descOficina);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<UnidadesDir3> listUnidadesDir3 = this.unidadesDir3Service.findAllLikeOficinas(filterUnidadesDir3,
						pagination, false);

				if (listUnidadesDir3 == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.unidadesDir3Service.findAllLikeCountOficinas(filterUnidadesDir3, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listUnidadesDir3);
				return data;
			} else {
				List<UnidadesDir3> listUnidadesDir3 = this.unidadesDir3Service.findAllLikeOficinas(filterUnidadesDir3,
						pagination, false);
				if (listUnidadesDir3 == null) {
					throw new Exception("No data Found.");
				}
				return listUnidadesDir3;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

}
