package com.ejie.y41b.control;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.model.Oeta1;
import com.ejie.y41b.model.Ooee;
import com.ejie.y41b.service.Oeta1Service;

/**
 * Oeta1Controller  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/oeta1")
public class Oeta1Controller {

	private static final Logger logger = LoggerFactory
			.getLogger(Oeta1Controller.class);

	@Autowired()
	private Oeta1Service oeta1Service;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		Oeta1Controller.logger.info("[GET - View] : oeta1");
		return "oeta1";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param ooeeOecodigo
	 *            String
	 * @param m5cota1
	 *            String
	 * @param m5fecalta
	 *            Date
	 * @param m5usualta
	 *            String
	 * @return oeta1 Oeta1
	 */
	@RequestMapping(value = "/{ooeeOecodigo}/{m5cota1}/{m5fecalta}/{m5usualta}", method = RequestMethod.GET)
	public @ResponseBody()
	Oeta1 getById(@PathVariable() String ooeeOecodigo,
			@PathVariable() String m5cota1, @PathVariable() Date m5fecalta,
			@PathVariable() String m5usualta) {
		Oeta1 oeta1 = new Oeta1();
		oeta1.setOoee(new Ooee());
		oeta1.getOoee().setOecodigo(ooeeOecodigo);
		oeta1.setM5cota1(m5cota1);
		oeta1.setM5fecalta(m5fecalta);
		oeta1.setM5usualta(m5usualta);
		oeta1 = this.oeta1Service.find(oeta1);
		Oeta1Controller.logger.info("[GET - findBy_PK] : Obtener Oeta1 por PK");
		return oeta1;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterOeta1
	 *            Oeta1
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Oeta1> getAll(@ModelAttribute() Oeta1 filterOeta1) {
		Oeta1Controller.logger
				.info("[GET - find_ALL] : Obtener Oeta1 por filtro");
		return this.oeta1Service.findAll(filterOeta1, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param oeta1
	 *            Oeta1
	 * @return Oeta1
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Oeta1 edit(@RequestBody() Oeta1 oeta1) {
		Oeta1 oeta1Aux = this.oeta1Service.update(oeta1);
		Oeta1Controller.logger.info("[PUT] : Oeta1 actualizado correctamente");
		return oeta1Aux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param oeta1
	 *            Oeta1
	 * @return Oeta1
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Oeta1 add(@RequestBody() Oeta1 oeta1) {
		Oeta1 oeta1Aux = this.oeta1Service.add(oeta1);
		Oeta1Controller.logger.info("[POST] : Oeta1 insertado correctamente");
		return oeta1Aux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param ooeeOecodigo
	 *            String
	 * @param m5cota1
	 *            String
	 * @param m5fecalta
	 *            Date
	 * @param m5usualta
	 *            String
	 * @return oeta1
	 */
	@RequestMapping(value = "/{ooeeOecodigo}/{m5cota1}/{m5fecalta}/{m5usualta}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Oeta1 remove(@PathVariable() String ooeeOecodigo,
			@PathVariable() String m5cota1, @PathVariable() Date m5fecalta,
			@PathVariable() String m5usualta) {
		Oeta1 oeta1 = new Oeta1();
		oeta1.setOoee(new Ooee());
		oeta1.getOoee().setOecodigo(ooeeOecodigo);
		oeta1.setM5cota1(m5cota1);
		oeta1.setM5fecalta(m5fecalta);
		oeta1.setM5usualta(m5usualta);
		this.oeta1Service.remove(oeta1);
		Oeta1Controller.logger.info("[DELETE] : Oeta1 borrado correctamente");
		return oeta1;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param oeta1Ids
	 *            List
	 * @return oeta1List
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(@RequestBody() List<List<String>> oeta1Ids) {
		List<Oeta1> oeta1List = new ArrayList<Oeta1>();
		for (List<String> oeta1Id : oeta1Ids) {
			Iterator<String> iterator = oeta1Id.iterator();
			Oeta1 oeta1 = new Oeta1(); // NOPMD - Objeto nuevo en la lista
										// (parametro del servicio)
			oeta1.setOoee(new Ooee()); // NOPMD - Objeto nuevo en la lista
										// (parametro del servicio)
			oeta1.getOoee().setOecodigo(
					ObjectConversionManager.convert(iterator.next(),
							String.class));
			oeta1.setM5cota1(ObjectConversionManager.convert(iterator.next(),
					String.class));
			oeta1.setM5fecalta(ObjectConversionManager.convert(iterator.next(),
					java.util.Date.class));
			oeta1.setM5usualta(ObjectConversionManager.convert(iterator.next(),
					String.class));
			oeta1List.add(oeta1);
		}
		this.oeta1Service.removeMultiple(oeta1List);
		Oeta1Controller.logger
				.info("[POST - DELETE_ALL] : Oeta1 borrados correctamente");
		return oeta1Ids;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterOeta1
	 *            Oeta1
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(@ModelAttribute() Oeta1 filterOeta1,
			@ModelAttribute() Pagination pagination) {
		List<Oeta1> oeta1s = this.oeta1Service.findAll(filterOeta1, pagination);
		Long recordNum = this.oeta1Service.findAllCount(filterOeta1);
		Oeta1Controller.logger.info("[GET - jqGrid] : Obtener Oeta1");
		return new JQGridJSONModel(pagination, recordNum, oeta1s);
	}

	/**
	 * Method 'getChecks'.
	 * 
	 * @param oecodigo
	 *            String
	 * @return List
	 */
	@RequestMapping(value = "/checks/{oecodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	List<Oeta1> getChecks(@PathVariable() String oecodigo) {
		Oeta1Controller.logger
				.info("[GET - find_ALL] : Obtener Oeta1 por filtro");
		Oeta1 filterOeta1 = new Oeta1();
		Ooee ooee = new Ooee();
		ooee.setOecodigo(oecodigo);
		filterOeta1.setOoee(ooee);
		return this.oeta1Service.findAll(filterOeta1, null);
	}

}
