package com.ejie.y41b.control;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.model.Oese;
import com.ejie.y41b.model.Ooee;
import com.ejie.y41b.service.OeseService;

/**
 * OeseController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/oese")
public class OeseController {

	private static final Logger logger = LoggerFactory
			.getLogger(OeseController.class);

	@Autowired()
	private OeseService oeseService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		OeseController.logger.info("[GET - View] : oese");
		return "oese";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param ooeeOecodigo
	 *            String
	 * @param m6cose
	 *            String
	 * @param m6fecalta
	 *            Date
	 * @param m6usualta
	 *            String
	 * @return oese Oese
	 */
	@RequestMapping(value = "/{ooeeOecodigo}/{m6cose}/{m6fecalta}/{m6usualta}", method = RequestMethod.GET)
	public @ResponseBody()
	Oese getById(@PathVariable() String ooeeOecodigo,
			@PathVariable() String m6cose, @PathVariable() Date m6fecalta,
			@PathVariable() String m6usualta) {
		Oese oese = new Oese();
		oese.setOoee(new Ooee());
		oese.getOoee().setOecodigo(ooeeOecodigo);
		oese.setM6cose(m6cose);
		oese.setM6fecalta(m6fecalta);
		oese.setM6usualta(m6usualta);
		oese = this.oeseService.find(oese);
		OeseController.logger.info("[GET - findBy_PK] : Obtener Oese por PK");
		return oese;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterOese
	 *            Oese
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Oese> getAll(@ModelAttribute() Oese filterOese) {
		OeseController.logger
				.info("[GET - find_ALL] : Obtener Oese por filtro");
		return this.oeseService.findAll(filterOese, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param oese
	 *            Oese
	 * @return Oese
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Oese edit(@RequestBody() Oese oese) {
		Oese oeseAux = this.oeseService.update(oese);
		OeseController.logger.info("[PUT] : Oese actualizado correctamente");
		return oeseAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param oese
	 *            Oese
	 * @return Oese
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Oese add(@RequestBody() Oese oese) {
		Oese oeseAux = this.oeseService.add(oese);
		OeseController.logger.info("[POST] : Oese insertado correctamente");
		return oeseAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param ooeeOecodigo
	 *            String
	 * @param m6cose
	 *            String
	 * @return oese
	 */
	@RequestMapping(value = "/{ooeeOecodigo}/{m6cose}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Oese remove(@PathVariable() String ooeeOecodigo,
			@PathVariable() String m6cose) {
		Oese oese = new Oese();
		oese.setOoee(new Ooee());
		oese.getOoee().setOecodigo(ooeeOecodigo);
		oese.setM6cose(m6cose);
		this.oeseService.remove(oese);
		OeseController.logger.info("[DELETE] : Oese borrado correctamente");
		return oese;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param oeseIds
	 *            List
	 * @return oeseList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(@RequestBody() List<List<String>> oeseIds) {
		List<Oese> oeseList = new ArrayList<Oese>();
		for (List<String> oeseId : oeseIds) {
			Iterator<String> iterator = oeseId.iterator();
			Oese oese = new Oese(); // NOPMD - Objeto nuevo en la lista
									// (parametro del servicio)
			oese.setOoee(new Ooee()); // NOPMD - Objeto nuevo en la lista
										// (parametro del servicio)
			oese.getOoee().setOecodigo(
					ObjectConversionManager.convert(iterator.next(),
							String.class));
			oese.setM6cose(ObjectConversionManager.convert(iterator.next(),
					String.class));
			oese.setM6fecalta(ObjectConversionManager.convert(iterator.next(),
					java.util.Date.class));
			oese.setM6usualta(ObjectConversionManager.convert(iterator.next(),
					String.class));
			oeseList.add(oese);
		}
		this.oeseService.removeMultiple(oeseList);
		OeseController.logger
				.info("[POST - DELETE_ALL] : Oese borrados correctamente");
		return oeseIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterOese
	 *            Oese
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(@ModelAttribute() Oese filterOese,
			@ModelAttribute() Pagination pagination) {
		List<Oese> oeses = this.oeseService.findAll(filterOese, pagination);
		Long recordNum = this.oeseService.findAllCount(filterOese);
		OeseController.logger.info("[GET - jqGrid] : Obtener Oese");
		return new JQGridJSONModel(pagination, recordNum, oeses);
	}

}
