package com.ejie.y41b.control;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.model.Arbitro;
import com.ejie.y41b.model.Oear;
import com.ejie.y41b.model.Ooee;
import com.ejie.y41b.service.OearService;

/**
 * OearController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/oear")
public class OearController {

	private static final Logger logger = LoggerFactory
			.getLogger(OearController.class);

	@Autowired()
	private OearService oearService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		OearController.logger.info("[GET - View] : oear");
		return "oear";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param ooeeOecodigo
	 *            String
	 * @param arbitroArcodigo
	 *            String
	 * @param m2centroar
	 *            String
	 * @param m2fecalta
	 *            Date
	 * @param m2usualta
	 *            String
	 * @return oear Oear
	 */
	@RequestMapping(value = "/{ooeeOecodigo}/{arbitroArcodigo}/{m2centroar}/{m2fecalta}/{m2usualta}", method = RequestMethod.GET)
	public @ResponseBody()
	Oear getById(@PathVariable() String ooeeOecodigo,
			@PathVariable() String arbitroArcodigo,
			@PathVariable() String m2centroar, @PathVariable() Date m2fecalta,
			@PathVariable() String m2usualta) {
		Oear oear = new Oear();
		oear.setOoee(new Ooee());
		oear.setArbitro(new Arbitro());
		oear.getOoee().setOecodigo(ooeeOecodigo);
		oear.getArbitro().setArcodigo(arbitroArcodigo);
		oear.setM2centroar(m2centroar);
		oear.setM2fecalta(m2fecalta);
		oear.setM2usualta(m2usualta);
		oear = this.oearService.find(oear);
		OearController.logger.info("[GET - findBy_PK] : Obtener Oear por PK");
		return oear;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterOear
	 *            Oear
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Oear> getAll(@ModelAttribute() Oear filterOear) {
		OearController.logger
				.info("[GET - find_ALL] : Obtener Oear por filtro");
		return this.oearService.findAll(filterOear, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param oear
	 *            Oear
	 * @return Oear
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Oear edit(@RequestBody() Oear oear) {
		Oear oearAux = this.oearService.update(oear);
		OearController.logger.info("[PUT] : Oear actualizado correctamente");
		return oearAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param oear
	 *            Oear
	 * @return Oear
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Oear add(@RequestBody() Oear oear) {
		Oear oearAux = this.oearService.add(oear);
		OearController.logger.info("[POST] : Oear insertado correctamente");
		return oearAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param ooeeOecodigo
	 *            String
	 * @param arbitroArcodigo
	 *            String
	 * @return oear
	 */
	@RequestMapping(value = "/{ooeeOecodigo}/{arbitroArcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Oear remove(@PathVariable() String ooeeOecodigo,
			@PathVariable() String arbitroArcodigo) {
		Oear oear = new Oear();
		oear.setOoee(new Ooee());
		oear.setArbitro(new Arbitro());
		oear.getOoee().setOecodigo(ooeeOecodigo);
		oear.getArbitro().setArcodigo(arbitroArcodigo);
		this.oearService.remove(oear);
		OearController.logger.info("[DELETE] : Oear borrado correctamente");
		return oear;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param oearIds
	 *            List
	 * @return oearList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(@RequestBody() List<List<String>> oearIds) {
		List<Oear> oearList = new ArrayList<Oear>();
		for (List<String> oearId : oearIds) {
			Iterator<String> iterator = oearId.iterator();
			Oear oear = new Oear(); // NOPMD - Objeto nuevo en la lista
									// (parametro del servicio)
			oear.setOoee(new Ooee()); // NOPMD - Objeto nuevo en la lista
										// (parametro del servicio)
			oear.setArbitro(new Arbitro()); // NOPMD - Objeto nuevo en la lista
											// (parametro del servicio)
			oear.getOoee().setOecodigo(
					ObjectConversionManager.convert(iterator.next(),
							String.class));
			oear.getArbitro().setArcodigo(
					ObjectConversionManager.convert(iterator.next(),
							String.class));
			oear.setM2centroar(ObjectConversionManager.convert(iterator.next(),
					String.class));
			oear.setM2fecalta(ObjectConversionManager.convert(iterator.next(),
					java.util.Date.class));
			oear.setM2usualta(ObjectConversionManager.convert(iterator.next(),
					String.class));
			oearList.add(oear);
		}
		this.oearService.removeMultiple(oearList);
		OearController.logger
				.info("[POST - DELETE_ALL] : Oear borrados correctamente");
		return oearIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterOear
	 *            Oear
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(@ModelAttribute() Oear filterOear,
			@ModelAttribute() Pagination pagination) {
		List<Oear> oears = this.oearService.findAll(filterOear, pagination);
		Long recordNum = this.oearService.findAllCount(filterOear);
		OearController.logger.info("[GET - jqGrid] : Obtener Oear");
		return new JQGridJSONModel(pagination, recordNum, oears);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param ooeeOecodigo
	 *            String
	 * @param arbitroArcodigo
	 *            String
	 * @return oear Oear
	 * @throws Exception
	 */
	@RequestMapping(value = "/getCentroArbitro/{arbitroArcodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	Oear getOearEsCentro(@PathVariable() String ooeeOecodigo,
			@PathVariable() String arbitroArcodigo) throws Exception {
		Oear oear = new Oear();
		oear.setOoee(new Ooee());
		oear.setArbitro(new Arbitro());
		oear.getArbitro().setArcodigo(arbitroArcodigo);
		oear.setM2centroar("S");

		List<Oear> oears = this.oearService.findAll(oear, null);
		if (oears != null && oears.size() > 0) {
			OearController.logger
					.info("[GET - findBy_PK] : Obtener Oear por PK");
			return oears.get(0);

		} else {
			throw new Exception("No data Found.");
		}

	}

}
