/**
 * 
 */
package com.ejie.y41b.control;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.T17Autonomia;
import com.ejie.y41b.model.T17Calle;
import com.ejie.y41b.model.T17Localidad;
import com.ejie.y41b.model.T17Municipio;
import com.ejie.y41b.model.T17Pais;
import com.ejie.y41b.model.T17Portal;
import com.ejie.y41b.model.T17Provincia;
import com.ejie.y41b.model.T17TipoVia;
import com.ejie.y41b.service.T17AutonomiaService;
import com.ejie.y41b.service.T17CalleService;
import com.ejie.y41b.service.T17LocalidadService;
import com.ejie.y41b.service.T17MunicipioService;
import com.ejie.y41b.service.T17PaisService;
import com.ejie.y41b.service.T17PortalService;
import com.ejie.y41b.service.T17ProvinciaService;
import com.ejie.y41b.service.T17TipoViaService;

/**
 *  
 * 
 */
@Controller
@RequestMapping(value = "/nora")
public class NoraController {

	private static final Logger logger = LoggerFactory
			.getLogger(NoraController.class);

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private T17PaisService paisService;

	@Autowired()
	private T17ProvinciaService provinciaService;

	@Autowired()
	private T17MunicipioService municipioService;

	@Autowired()
	private T17LocalidadService localidadService;

	@Autowired()
	private T17CalleService calleService;

	@Autowired()
	private T17PortalService portalService;

	@Autowired()
	private T17TipoViaService tipoViaService;

	@Autowired()
	private T17AutonomiaService autonomiaService;

	@Resource()
	private ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintBusquedaCalle", method = RequestMethod.GET)
	public ModelAndView getCreateFormBusquedaCalle(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));
		return new ModelAndView("busquedaCalle", "model", model);
	}

	/********************************************************************************
	 * 
	 * COMBO
	 * 
	 *******************************************************************************/

	/********************************************************************************
	 * Provincias
	 *******************************************************************************/
	/**
	 * Method 'getProvincias'.
	 * 
	 * @return 'lista de provincias' para el COMBO
	 */
	@RequestMapping(value = "/provincias", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Provincia> getProvincias() {
		logger.debug("Cargar provincias");
		return this.provinciaService.findAll(null, null);
	}

	/**
	 * Method 'getProvinciasCAPV'.
	 * 
	 * @return 'lista de provincias CAPV' para el COMBO
	 */
	@RequestMapping(value = "/provinciascapv", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Provincia> getProvinciasCAPV() {
		T17Provincia t17provincia = new T17Provincia();
		t17provincia.setAutonomiaId(Y41bConstantes.CAPV);

		logger.debug("Cargar provincias CAPV");
		return this.provinciaService.findAll(t17provincia, null);
	}

	/********************************************************************************
	 * Municipios
	 *******************************************************************************/
	/**
	 * Method 'getMunicipios'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return 'lista de municipio' para el COMBO
	 */
	@RequestMapping(value = "/municipios", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Municipio> getMunicipios(HttpServletRequest request) {
		// @RequestParam(value = "provinciaId", required = false) String
		// provinciaId) {

		String provinciaId = "";
		if (!"".equalsIgnoreCase((String) request.getParameter("provinciaId"))
				&& null != (String) request.getParameter("provinciaId")) {
			provinciaId = request.getParameter("provinciaId");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("provinciaId2"))
				&& null != (String) request.getParameter("provinciaId2")) {
			provinciaId = request.getParameter("provinciaId2");
		}
		if (!"".equalsIgnoreCase((String) request
				.getParameter("dtnoraProvinciaId"))
				&& null != (String) request.getParameter("dtnoraProvinciaId")) {
			provinciaId = request.getParameter("dtnoraProvinciaId");
		}
		if (!"".equalsIgnoreCase((String) request
				.getParameter("esnoraProvinciaId"))
				&& null != (String) request.getParameter("esnoraProvinciaId")) {
			provinciaId = request.getParameter("esnoraProvinciaId");
		}

		if (!"".equalsIgnoreCase((String) request
				.getParameter("acnoraProvinciaId"))
				&& null != (String) request.getParameter("acnoraProvinciaId")) {
			provinciaId = request.getParameter("acnoraProvinciaId");
		}

		if (!"".equalsIgnoreCase((String) request
				.getParameter("organismo.noraProvinciaId"))
				&& null != (String) request
						.getParameter("organismo.noraProvinciaId")) {
			provinciaId = request.getParameter("organismo.noraProvinciaId");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("arprovId"))
				&& null != (String) request.getParameter("arprovId")) {
			provinciaId = request.getParameter("arprovId");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("arprovcId"))
				&& null != (String) request.getParameter("arprovcId")) {
			provinciaId = request.getParameter("arprovcId");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("srprovId"))
				&& null != (String) request.getParameter("srprovId")) {
			provinciaId = request.getParameter("srprovId");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("peprovId"))
				&& null != (String) request.getParameter("peprovId")) {
			provinciaId = request.getParameter("peprovId");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("adhesprovin"))
				&& null != (String) request.getParameter("adhesprovin")) {
			provinciaId = request.getParameter("adhesprovin");
		}
		if (!"".equalsIgnoreCase((String) request
				.getParameter("t4noraProvinciaId"))
				&& null != (String) request.getParameter("t4noraProvinciaId")) {
			provinciaId = request.getParameter("t4noraProvinciaId");
		}
		if (!"".equalsIgnoreCase((String) request
				.getParameter("noraProvinciaId"))
				&& null != (String) request.getParameter("noraProvinciaId")) {
			provinciaId = request.getParameter("noraProvinciaId");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("rporovincia"))
				&& null != (String) request.getParameter("rpprovincia")) {
			provinciaId = request.getParameter("rpprovincia");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("esprovincia"))
				&& null != (String) request.getParameter("esprovincia")) {
			provinciaId = request.getParameter("esprovincia");
		}

		T17Municipio t17Municipio = new T17Municipio();
		t17Municipio.setProvinciaId(provinciaId);

		return this.municipioService.findAll(t17Municipio, null);
	}

	/********************************************************************************
	 * Localidades
	 *******************************************************************************/
	/**
	 * Method 'getLocalidades'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return 'lista de municipio' para el COMBO
	 */
	@RequestMapping(value = "/localidades", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Localidad> getLocalidades(HttpServletRequest request) {
		// @RequestParam(value = "provinciaId", required = false) String
		// provinciaId,
		// @RequestParam(value = "municipioId", required = false) String
		// municipalityId) {

		String provinciaId = "";
		String municipioId = "";
		if (!"".equalsIgnoreCase((String) request.getParameter("provinciaId"))
				&& null != (String) request.getParameter("provinciaId")) {
			provinciaId = request.getParameter("provinciaId");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("provinciaId2"))
				&& null != (String) request.getParameter("provinciaId2")) {
			provinciaId = request.getParameter("provinciaId2");
		}
		if (!"".equalsIgnoreCase((String) request
				.getParameter("dtnoraProvinciaId"))
				&& null != (String) request.getParameter("dtnoraProvinciaId")) {
			provinciaId = request.getParameter("dtnoraProvinciaId");
		}
		if (!"".equalsIgnoreCase((String) request
				.getParameter("esnoraProvinciaId"))
				&& null != (String) request.getParameter("esnoraProvinciaId")) {
			provinciaId = request.getParameter("esnoraProvinciaId");
		}

		if (!"".equalsIgnoreCase((String) request
				.getParameter("acnoraProvinciaId"))
				&& null != (String) request.getParameter("acnoraProvinciaId")) {
			provinciaId = request.getParameter("acnoraProvinciaId");
		}
		if (!"".equalsIgnoreCase((String) request
				.getParameter("organismo.noraProvinciaId"))
				&& null != (String) request
						.getParameter("organismo.noraProvinciaId")) {
			provinciaId = request.getParameter("organismo.noraProvinciaId");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("arprovId"))
				&& null != (String) request.getParameter("arprovId")) {
			provinciaId = request.getParameter("arprovId");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("arprovcId"))
				&& null != (String) request.getParameter("arprovcId")) {
			provinciaId = request.getParameter("arprovcId");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("srprovId"))
				&& null != (String) request.getParameter("srprovId")) {
			provinciaId = request.getParameter("srprovId");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("peprovId"))
				&& null != (String) request.getParameter("peprovId")) {
			provinciaId = request.getParameter("peprovId");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("adhesprovin"))
				&& null != (String) request.getParameter("adhesprovin")) {
			provinciaId = request.getParameter("adhesprovin");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("rpprovincia"))
				&& null != (String) request.getParameter("rpprovincia")) {
			provinciaId = request.getParameter("rpprovincia");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("esprovincia"))
				&& null != (String) request.getParameter("esprovincia")) {
			provinciaId = request.getParameter("esprovincia");
		}

		if (!"".equalsIgnoreCase((String) request.getParameter("municipioId"))
				&& null != (String) request.getParameter("municipioId")) {
			municipioId = request.getParameter("municipioId");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("municipioId2"))
				&& null != (String) request.getParameter("municipioId2")) {
			municipioId = request.getParameter("municipioId2");
		}
		if (!"".equalsIgnoreCase((String) request
				.getParameter("dtnoraMunicipioId"))
				&& null != (String) request.getParameter("dtnoraMunicipioId")) {
			municipioId = request.getParameter("dtnoraMunicipioId");
		}
		if (!"".equalsIgnoreCase((String) request
				.getParameter("esnoraMunicipioId"))
				&& null != (String) request.getParameter("esnoraMunicipioId")) {
			municipioId = request.getParameter("esnoraMunicipioId");
		}
		if (!"".equalsIgnoreCase((String) request
				.getParameter("acnoraMunicipioId"))
				&& null != (String) request.getParameter("acnoraMunicipioId")) {
			municipioId = request.getParameter("acnoraMunicipioId");
		}
		if (!"".equalsIgnoreCase((String) request
				.getParameter("organismo.noraMunicipioId"))
				&& null != (String) request
						.getParameter("organismo.noraMunicipioId")) {
			municipioId = request.getParameter("organismo.noraMunicipioId");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("armunId"))
				&& null != (String) request.getParameter("armunId")) {
			municipioId = request.getParameter("armunId");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("armuncId"))
				&& null != (String) request.getParameter("armuncId")) {
			municipioId = request.getParameter("armuncId");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("srmunId"))
				&& null != (String) request.getParameter("srmunId")) {
			municipioId = request.getParameter("srmunId");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("pemunId"))
				&& null != (String) request.getParameter("pemunId")) {
			municipioId = request.getParameter("pemunId");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("adhesmunici"))
				&& null != (String) request.getParameter("adhesmunici")) {
			municipioId = request.getParameter("adhesmunici");
		}
		if (!"".equalsIgnoreCase((String) request
				.getParameter("t4noraProvinciaId"))
				&& null != (String) request.getParameter("t4noraProvinciaId")) {
			provinciaId = request.getParameter("t4noraProvinciaId");
		}
		if (!"".equalsIgnoreCase((String) request
				.getParameter("t4noraMunicipioId"))
				&& null != (String) request.getParameter("t4noraMunicipioId")) {
			municipioId = request.getParameter("t4noraMunicipioId");
		}
		if (!"".equalsIgnoreCase((String) request
				.getParameter("noraProvinciaId"))
				&& null != (String) request.getParameter("noraProvinciaId")) {
			provinciaId = request.getParameter("noraProvinciaId");
		}
		if (!"".equalsIgnoreCase((String) request
				.getParameter("noraMunicipioId"))
				&& null != (String) request.getParameter("noraMunicipioId")) {
			municipioId = request.getParameter("noraMunicipioId");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("rpmunicipio"))
				&& null != (String) request.getParameter("rpmunicipio")) {
			municipioId = request.getParameter("rpmunicipio");
		}
		if (!"".equalsIgnoreCase((String) request.getParameter("esmunicipio"))
				&& null != (String) request.getParameter("esmunicipio")) {
			municipioId = request.getParameter("esmunicipio");
		}

		T17Localidad t17Localidad = new T17Localidad();
		t17Localidad.setProvinciaId(provinciaId);
		t17Localidad.setMunicipioId(municipioId);

		return this.localidadService.findAll(t17Localidad, null);
	}

	/********************************************************************************
	 * Municipios
	 *******************************************************************************/
	/**
	 * Method 'getUpdateLocalidades'.
	 * 
	 * @param provinciaId
	 *            identificador de la provincia
	 * @return 'lista de provincias' para el COMBO
	 */
	@RequestMapping(value = "/updateMunicipios", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Municipio> getUpdateMunicipios(
			@RequestParam(value = "provinciaId", required = false) String provinciaId) {

		if (provinciaId != null && !provinciaId.equals("")
				&& !provinciaId.equals("null")) {

			T17Municipio t17Municipio = new T17Municipio();
			t17Municipio.setProvinciaId(provinciaId);

			return this.municipioService.findAll(t17Municipio, null);
		} else {
			return (List<T17Municipio>) new ArrayList<T17Municipio>();
		}
	}

	/********************************************************************************
	 * Localidades
	 *******************************************************************************/
	/**
	 * Method 'getUpdateLocalidades'.
	 * 
	 * @param provinciaId
	 *            identificador de la provincia
	 * @param municipioId
	 *            identificador de la municipio
	 * @return 'lista de provincias' para el COMBO
	 */
	@RequestMapping(value = "/updateLocalidad", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Localidad> getUpdateLocalidades(
			@RequestParam(value = "provinciaId", required = false) String provinciaId,
			@RequestParam(value = "municipioId", required = false) String municipioId) {

		if (provinciaId != null && !provinciaId.equals("")
				&& !provinciaId.equals("null") && municipioId != null
				&& !municipioId.equals("") && !municipioId.equals("null")) {

			T17Localidad t17Localidad = new T17Localidad();
			t17Localidad.setProvinciaId(provinciaId);
			t17Localidad.setMunicipioId(municipioId);

			return this.localidadService.findAll(t17Localidad, null);
		} else {
			return (List<T17Localidad>) new ArrayList<T17Localidad>();
		}
	}

	/********************************************************************************
	 * Codigo Postal
	 *******************************************************************************/
	/**
	 * Method 'getCodigoPostal'.
	 * 
	 * @param portal
	 *            identificador del portal
	 * @return 'lista de municipio' para el COMBO
	 */
	@RequestMapping(value = "/codigo_postal/{portal}", method = RequestMethod.GET)
	public @ResponseBody()
	T17Portal getCodigoPostal(@PathVariable() String portal) {

		T17Portal t17Portal = new T17Portal();
		t17Portal.setId(new Long(portal));
		return this.portalService.findCodigoPostal(t17Portal);

	}

	/********************************************************************************
	 * Localidades
	 *******************************************************************************/
	/**
	 * Method 'getCalles'.
	 * 
	 * @param provinciaId
	 *            identificador de la provincia
	 * @param municipalityId
	 *            identificador de la provincia
	 * @return 'lista de municipio' para el COMBO
	 */
	@RequestMapping(value = "/calles", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Calle> getCalles(
			@RequestParam(value = "provinciaId", required = false) String provinciaId,
			@RequestParam(value = "municipioId", required = false) String municipalityId) {

		T17Calle t17Calle = new T17Calle();
		t17Calle.setProvinciaId(provinciaId);
		t17Calle.setMunicipioId(municipalityId);

		return this.calleService.findAll(t17Calle, null);

	}

	/********************************************************************************
	 * Portal
	 *******************************************************************************/
	/**
	 * Method 'getPortales'.
	 * 
	 * @param localidadId
	 *            identificador de la localidad
	 * @param calleId
	 *            identificador de la calle
	 * @return 'lista de municipio' para el COMBO
	 */
	@RequestMapping(value = "/portales", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Portal> getPortales(
			@RequestParam(value = "localidadId", required = false) String localidadId,
			@RequestParam(value = "calleId", required = false) Long calleId) {

		if (// localidadId != null && !localidadId.equals("")&&
			// !localidadId.equals("null") &&
		calleId != null && calleId != 0) {
			T17Portal t17Portal = new T17Portal();
			// t17Portal.setLocalidadId(localidadId);
			t17Portal.setCalleId(calleId);

			return this.portalService.findAll(t17Portal, null);
		} else {
			return (List<T17Portal>) new ArrayList<T17Portal>();
		}
	}

	/********************************************************************************
	 * Paises
	 *******************************************************************************/
	/**
	 * Method 'getPaises'.
	 * 
	 * @return 'lista de paises' para el COMBO
	 */
	@RequestMapping(value = "paises", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Pais> getPaises() {
		logger.debug("Cargar paises");
		T17Pais pais = new T17Pais();
		// pais.setId("351");
		return this.paisService.findAll(pais, null);

	}

	/********************************************************************************
	 * CCAA
	 *******************************************************************************/
	/**
	 * Method 'getCCAA'.
	 * 
	 * @return 'lista de CCAA' para el COMBO
	 */
	@RequestMapping(value = "ccaas", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Autonomia> getCCAAs() {
		logger.debug("Cargar ccaas");
		T17Autonomia ccaa = new T17Autonomia();
		// pais.setId("351");
		return this.autonomiaService.findAll(ccaa, null);

	}

	/********************************************************************************
	 * Paises + [Desconocido]
	 *******************************************************************************/
	/**
	 * Method 'getPaisesDesconocido'.
	 * 
	 * @return 'lista de paises' para el COMBO
	 */
	@RequestMapping(value = "paisesDesconocido", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Pais> getPaisesDesconocido() {
		logger.debug("Cargar paises + desconocido");
		T17Pais pais = new T17Pais();

		List<T17Pais> paises = this.paisService.findAllSinEstado(pais, null);
		T17Pais desconocido = new T17Pais();
		desconocido.setId("-");

		Locale locale = LocaleContextHolder.getLocale();
		String desconocidoLang = this.appMessageSource.getMessage(
				"nora.desconocido", null, locale);
		desconocido.setDsO("[" + desconocidoLang + "]");

		paises.add(desconocido);

		return paises;
	}

	/********************************************************************************
	 * CCAAs + [Desconocido]
	 *******************************************************************************/
	/**
	 * Method 'getCCAAsDesconocido'.
	 * 
	 * @return 'lista de CCAA' para el COMBO
	 */
	@RequestMapping(value = "ccaasDesconocido", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Autonomia> getCCAAsDesconocido() {
		logger.debug("Cargar ccaas + desconocido");
		List<T17Autonomia> ccaas = this.getCCAAs();
		T17Autonomia desconocido = new T17Autonomia();
		desconocido.setId("-");

		Locale locale = LocaleContextHolder.getLocale();
		String desconocidoLang = this.appMessageSource.getMessage(
				"nora.desconocido", null, locale);
		desconocido.setDsO("[" + desconocidoLang + "]");

		ccaas.add(desconocido);
		return ccaas;
	}

	/********************************************************************************
	 * CP
	 *******************************************************************************/
	/**
	 * Method 'getCP'.
	 * 
	 * @param q
	 *            String
	 * @param c
	 *            String
	 * @return Lista
	 */
	@RequestMapping(value = "/cp", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Portal> getCP(@RequestParam(value = "q", required = true) String q,
			@RequestParam(value = "c", required = true) Boolean c) {

		// HashMap<String, String> aMap = null;
		// List<HashMap<String, String>> lst = new ArrayList<HashMap<String,
		// String>>();

		// aMap = new HashMap<String, String>();
		// aMap.put("label", "48940");
		// aMap.put("value", "48940");
		// lst.add(aMap);

		// aMap = new HashMap<String, String>();
		// aMap.put("label", "48003");
		// aMap.put("value", "48003");
		// lst.add(aMap);

		T17Portal t17Portal = new T17Portal();
		t17Portal.setCodigoPostal(q);
		return this.portalService.findAllLike_CodigoPostal(t17Portal, null, c);

	}

	/********************************************************************************
	 * Calle
	 *******************************************************************************/
	/**
	 * Method 'getCalle'.
	 * 
	 * @param q
	 *            String
	 * @param c
	 *            String
	 * @param provincia
	 *            String
	 * @param municipio
	 *            String
	 * 
	 * @return list
	 */
	@RequestMapping(value = "/calle", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Calle> getCalle(
			@RequestParam(value = "q", required = true) String q,
			@RequestParam(value = "c", required = true) Boolean c,
			@RequestParam(value = "provincia", required = true) String provincia,
			@RequestParam(value = "municipio", required = true) String municipio) {

		T17Calle t17Calle = new T17Calle();
		t17Calle.setDsO(q);
		t17Calle.setMunicipioId(municipio);
		t17Calle.setProvinciaId(provincia);

		return this.calleService.findAllLike_Calle(t17Calle, null, c);

	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 * 
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * 
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/********************************************************************************
	 * Codigo Postal
	 *******************************************************************************/
	/**
	 * Method 'getProvMun'. Recupera la provincia y el municipio a partir de un
	 * cod postal
	 * 
	 * @param codigoPostal
	 *            identificador del codigo postal
	 * @return T17Portal
	 */
	@RequestMapping(value = "/codigo_postal/obtenerprovmun/{codigoPostal}", method = RequestMethod.GET)
	public @ResponseBody()
	T17Calle getProvMun(@PathVariable() String codigoPostal) {

		T17Portal t17Portal = new T17Portal();
		t17Portal.setCodigoPostal(codigoPostal);
		return this.calleService.findProvMun(t17Portal);

	}

	/********************************************************************************
	 * Tipos via
	 *******************************************************************************/
	/**
	 * Method 'getAllTipoVia'.
	 * 
	 * @return 'lista de tipos de via' para el COMBO
	 */
	@RequestMapping(value = "/tipoVia", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17TipoVia> getAllTipoVia() {

		return this.tipoViaService.findAll(null, null);
	}

	/********************************************************************************
	 * Busqueda Calles
	 *******************************************************************************/
	/**
	 * Method 'getCallesLike'.
	 * 
	 * 
	 * @param dsO_
	 *            descripcion calle
	 * @param tipoViaId_
	 *            identificador del tipo de via
	 * @param provinciaId
	 *            identificador de la provincia
	 * @param municipalityId
	 *            identificador del municipio
	 * @param request
	 *            HttpServletRequest
	 * @return 'lista de municipio' para el COMBO
	 */
	@RequestMapping(value = "/busquedaCalles", method = RequestMethod.GET)
	public @ResponseBody()
	Object getCallesLike(
			@RequestParam(value = "dsO", required = false) String dsO_,
			@RequestParam(value = "tipoViaId", required = false) String tipoViaId_,
			@RequestParam(value = "provinciaId", required = false) String provinciaId,
			@RequestParam(value = "municipioId", required = false) String municipalityId,
			HttpServletRequest request) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String tipoViaId = ("".equals(tipoViaId_)) ? null : tipoViaId_;
			String dsO = ("".equals(dsO_)) ? null : dsO_;

			T17Calle t17Calle = new T17Calle();
			t17Calle.setProvinciaId(provinciaId);
			t17Calle.setMunicipioId(municipalityId);
			t17Calle.setTipoViaId(tipoViaId);
			t17Calle.setDsO(dsO);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<T17Calle> callesBusqueda = this.calleService
						.findAllCalleLike(t17Calle, pagination, false);

				if (callesBusqueda == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.calleService.findAllCalleLikeCount(t17Calle,
						false);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(callesBusqueda);
				return data;
			} else {

				List<T17Calle> callesBusqueda = this.calleService
						.findAllCalleLike(t17Calle, pagination, false);

				if (callesBusqueda == null) {
					throw new Exception("No data Found.");
				}
				return callesBusqueda;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getCalleById'.
	 * 
	 * @param id
	 *            long
	 * @return T17Calle
	 */
	@RequestMapping(value = "/getCalleById", method = RequestMethod.GET)
	public @ResponseBody()
	T17Calle getCalle(@RequestParam(value = "id", required = true) long id) {

		T17Calle t17Calle = new T17Calle();
		t17Calle.setId(id);
		t17Calle.setDsO(this.calleService.findCalleConTipoVia(t17Calle));
		return t17Calle;

	}

}
