package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.NaturalezaPeligroService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.NaturalezaPeligro;

/**
 * NaturalezaPeligroController  
 *  
 */
 
@Controller
@RequestMapping (value = "/naturalezapeligro")

public class NaturalezaPeligroController  {

	private static final Logger logger = LoggerFactory.getLogger(NaturalezaPeligroController.class);

	@Autowired
	private NaturalezaPeligroService naturalezaPeligroService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		NaturalezaPeligroController.logger.info("[GET - View] : naturalezapeligro");
		return "naturalezapeligro";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param idnaturalezapeligro String
	 * @return naturalezaPeligro NaturalezaPeligro
	 */
	@RequestMapping(value = "/{idnaturalezapeligro}", method = RequestMethod.GET)
	public @ResponseBody NaturalezaPeligro getById(@PathVariable String idnaturalezapeligro) {
        NaturalezaPeligro naturalezaPeligro = new NaturalezaPeligro();
		naturalezaPeligro.setIdnaturalezapeligro(idnaturalezapeligro);
        naturalezaPeligro = this.naturalezaPeligroService.find(naturalezaPeligro);
        NaturalezaPeligroController.logger.info("[GET - findBy_PK] : Obtener NaturalezaPeligro por PK");
        return naturalezaPeligro;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterNaturalezaPeligro NaturalezaPeligro
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<NaturalezaPeligro> getAll(@ModelAttribute NaturalezaPeligro filterNaturalezaPeligro) {
		NaturalezaPeligroController.logger.info("[GET - find_ALL] : Obtener NaturalezaPeligro por filtro");
	    return this.naturalezaPeligroService.findAll(filterNaturalezaPeligro, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param naturalezaPeligro NaturalezaPeligro 
	 * @return NaturalezaPeligro
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody NaturalezaPeligro edit(@RequestBody NaturalezaPeligro naturalezaPeligro) {		
        NaturalezaPeligro naturalezaPeligroAux = this.naturalezaPeligroService.update(naturalezaPeligro);
		NaturalezaPeligroController.logger.info("[PUT] : NaturalezaPeligro actualizado correctamente");
        return naturalezaPeligroAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param naturalezaPeligro NaturalezaPeligro 
	 * @return NaturalezaPeligro
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody NaturalezaPeligro add(@RequestBody NaturalezaPeligro naturalezaPeligro) {		
        NaturalezaPeligro naturalezaPeligroAux = this.naturalezaPeligroService.add(naturalezaPeligro);
        NaturalezaPeligroController.logger.info("[POST] : NaturalezaPeligro insertado correctamente");
    	return naturalezaPeligroAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param idnaturalezapeligro String
	 * @return naturalezaPeligro
	 */
	@RequestMapping(value = "/{idnaturalezapeligro}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody NaturalezaPeligro remove(@PathVariable String idnaturalezapeligro) {
        NaturalezaPeligro naturalezaPeligro = new NaturalezaPeligro();
        naturalezaPeligro.setIdnaturalezapeligro(idnaturalezapeligro);
        this.naturalezaPeligroService.remove(naturalezaPeligro);
       	NaturalezaPeligroController.logger.info("[DELETE] : NaturalezaPeligro borrado correctamente");
       	return naturalezaPeligro;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param naturalezaPeligroIds List
	 * @return naturalezaPeligroList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> naturalezaPeligroIds) {
        List<NaturalezaPeligro> naturalezaPeligroList = new ArrayList<NaturalezaPeligro>();
        for (List<String> naturalezaPeligroId:naturalezaPeligroIds) {
		    Iterator<String> iterator = naturalezaPeligroId.iterator();
		    NaturalezaPeligro naturalezaPeligro = new NaturalezaPeligro(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        naturalezaPeligro.setIdnaturalezapeligro(ObjectConversionManager.convert(iterator.next(), String.class));
		    naturalezaPeligroList.add(naturalezaPeligro);
	    }
        this.naturalezaPeligroService.removeMultiple(naturalezaPeligroList);
		NaturalezaPeligroController.logger.info("[POST - DELETE_ALL] : NaturalezaPeligro borrados correctamente");
		return naturalezaPeligroIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterNaturalezaPeligro NaturalezaPeligro
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute NaturalezaPeligro filterNaturalezaPeligro, @ModelAttribute Pagination pagination) {
        List<NaturalezaPeligro> naturalezaPeligros = this.naturalezaPeligroService.findAll(filterNaturalezaPeligro, pagination);
        Long recordNum = this.naturalezaPeligroService.findAllCount(filterNaturalezaPeligro);
        NaturalezaPeligroController.logger.info("[GET - jqGrid] : Obtener NaturalezaPeligro");
		return new JQGridJSONModel(pagination, recordNum, naturalezaPeligros);
	}
	
}	
