package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.MovimientosService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.Movimientos;

/**
 * MovimientosController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/movimientos")
public class MovimientosController {

	private static final Logger logger = LoggerFactory
			.getLogger(MovimientosController.class);

	@Autowired()
	private MovimientosService movimientosService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		MovimientosController.logger.info("[GET - View] : movimientos");
		return "movimientos";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param sfcodigo
	 *            String
	 * @return movimientos Movimientos
	 */
	@RequestMapping(value = "/{sfcodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	Movimientos getById(@PathVariable() String sfcodigo) {
		Movimientos movimientos = new Movimientos();
		movimientos.setSfcodigo(sfcodigo);
		movimientos = this.movimientosService.find(movimientos);
		MovimientosController.logger
				.info("[GET - findBy_PK] : Obtener Movimientos por PK");
		return movimientos;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterMovimientos
	 *            Movimientos
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Movimientos> getAll(@ModelAttribute() Movimientos filterMovimientos) {
		MovimientosController.logger
				.info("[GET - find_ALL] : Obtener Movimientos por filtro");
		return this.movimientosService.findAll(filterMovimientos, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param movimientos
	 *            Movimientos
	 * @return Movimientos
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Movimientos edit(@RequestBody() Movimientos movimientos) {
		Movimientos movimientosAux = this.movimientosService
				.update(movimientos);
		MovimientosController.logger
				.info("[PUT] : Movimientos actualizado correctamente");
		return movimientosAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param movimientos
	 *            Movimientos
	 * @return Movimientos
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Movimientos add(@RequestBody() Movimientos movimientos) {
		Movimientos movimientosAux = this.movimientosService.add(movimientos);
		MovimientosController.logger
				.info("[POST] : Movimientos insertado correctamente");
		return movimientosAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param sfcodigo
	 *            String
	 * @return movimientos
	 */
	@RequestMapping(value = "/{sfcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Movimientos remove(@PathVariable() String sfcodigo) {
		Movimientos movimientos = new Movimientos();
		movimientos.setSfcodigo(sfcodigo);
		this.movimientosService.remove(movimientos);
		MovimientosController.logger
				.info("[DELETE] : Movimientos borrado correctamente");
		return movimientos;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param movimientosIds
	 *            List
	 * @return movimientosList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(
			@RequestBody() List<List<String>> movimientosIds) {
		List<Movimientos> movimientosList = new ArrayList<Movimientos>();
		for (List<String> movimientosId : movimientosIds) {
			Iterator<String> iterator = movimientosId.iterator();
			Movimientos movimientos = new Movimientos(); // NOPMD - Objeto nuevo
															// en la lista
															// (parametro del
															// servicio)
			movimientos.setSfcodigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			movimientosList.add(movimientos);
		}
		this.movimientosService.removeMultiple(movimientosList);
		MovimientosController.logger
				.info("[POST - DELETE_ALL] : Movimientos borrados correctamente");
		return movimientosIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterMovimientos
	 *            Movimientos
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute() Movimientos filterMovimientos,
			@ModelAttribute() Pagination pagination) {
		List<Movimientos> movimientoss = this.movimientosService.findAll(
				filterMovimientos, pagination);
		Long recordNum = this.movimientosService
				.findAllCount(filterMovimientos);
		MovimientosController.logger
				.info("[GET - jqGrid] : Obtener Movimientos");
		return new JQGridJSONModel(pagination, recordNum, movimientoss);
	}

}
