package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.MotivosSolcolaboracionService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.MotivosSolcolaboracion;

/**
 * MotivosSolcolaboracionController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/motivossolcolaboracion")
public class MotivosSolcolaboracionController {

	private static final Logger logger = LoggerFactory
			.getLogger(MotivosSolcolaboracionController.class);

	@Autowired
	private MotivosSolcolaboracionService motivosSolcolaboracionService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		MotivosSolcolaboracionController.logger
				.info("[GET - View] : motivossolcolaboracion");
		return "motivossolcolaboracion";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param uo1codigo
	 *            String
	 * @return motivosSolcolaboracion MotivosSolcolaboracion
	 */
	@RequestMapping(value = "/{uo1codigo}", method = RequestMethod.GET)
	public @ResponseBody
	MotivosSolcolaboracion getById(@PathVariable String uo1codigo) {
		MotivosSolcolaboracion motivosSolcolaboracion = new MotivosSolcolaboracion();
		motivosSolcolaboracion.setUo1codigo(uo1codigo);
		motivosSolcolaboracion = this.motivosSolcolaboracionService
				.find(motivosSolcolaboracion);
		MotivosSolcolaboracionController.logger
				.info("[GET - findBy_PK] : Obtener MotivosSolcolaboracion por PK");
		return motivosSolcolaboracion;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterMotivosSolcolaboracion
	 *            MotivosSolcolaboracion
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<MotivosSolcolaboracion> getAll(
			@ModelAttribute MotivosSolcolaboracion filterMotivosSolcolaboracion) {
		MotivosSolcolaboracionController.logger
				.info("[GET - find_ALL] : Obtener MotivosSolcolaboracion por filtro");
		return this.motivosSolcolaboracionService.findAll(
				filterMotivosSolcolaboracion, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param motivosSolcolaboracion
	 *            MotivosSolcolaboracion
	 * @return MotivosSolcolaboracion
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	MotivosSolcolaboracion edit(
			@RequestBody MotivosSolcolaboracion motivosSolcolaboracion) {
		MotivosSolcolaboracion motivosSolcolaboracionAux = this.motivosSolcolaboracionService
				.update(motivosSolcolaboracion);
		MotivosSolcolaboracionController.logger
				.info("[PUT] : MotivosSolcolaboracion actualizado correctamente");
		return motivosSolcolaboracionAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param motivosSolcolaboracion
	 *            MotivosSolcolaboracion
	 * @return MotivosSolcolaboracion
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	MotivosSolcolaboracion add(
			@RequestBody MotivosSolcolaboracion motivosSolcolaboracion) {
		MotivosSolcolaboracion motivosSolcolaboracionAux = this.motivosSolcolaboracionService
				.add(motivosSolcolaboracion);
		MotivosSolcolaboracionController.logger
				.info("[POST] : MotivosSolcolaboracion insertado correctamente");
		return motivosSolcolaboracionAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param uo1codigo
	 *            String
	 * @return motivosSolcolaboracion
	 */
	@RequestMapping(value = "/{uo1codigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	MotivosSolcolaboracion remove(@PathVariable String uo1codigo) {
		MotivosSolcolaboracion motivosSolcolaboracion = new MotivosSolcolaboracion();
		motivosSolcolaboracion.setUo1codigo(uo1codigo);
		this.motivosSolcolaboracionService.remove(motivosSolcolaboracion);
		MotivosSolcolaboracionController.logger
				.info("[DELETE] : MotivosSolcolaboracion borrado correctamente");
		return motivosSolcolaboracion;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param motivosSolcolaboracionIds
	 *            List
	 * @return motivosSolcolaboracionList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> motivosSolcolaboracionIds) {
		List<MotivosSolcolaboracion> motivosSolcolaboracionList = new ArrayList<MotivosSolcolaboracion>();
		for (List<String> motivosSolcolaboracionId : motivosSolcolaboracionIds) {
			Iterator<String> iterator = motivosSolcolaboracionId.iterator();
			MotivosSolcolaboracion motivosSolcolaboracion = new MotivosSolcolaboracion(); // NOPMD
																							// -
																							// Objeto
																							// nuevo
																							// en
																							// la
																							// lista
																							// (parametro
																							// del
																							// servicio)
			motivosSolcolaboracion.setUo1codigo(ObjectConversionManager
					.convert(iterator.next(), String.class));
			motivosSolcolaboracionList.add(motivosSolcolaboracion);
		}
		this.motivosSolcolaboracionService
				.removeMultiple(motivosSolcolaboracionList);
		MotivosSolcolaboracionController.logger
				.info("[POST - DELETE_ALL] : MotivosSolcolaboracion borrados correctamente");
		return motivosSolcolaboracionIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterMotivosSolcolaboracion
	 *            MotivosSolcolaboracion
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute MotivosSolcolaboracion filterMotivosSolcolaboracion,
			@ModelAttribute Pagination pagination) {
		List<MotivosSolcolaboracion> motivosSolcolaboracions = this.motivosSolcolaboracionService
				.findAll(filterMotivosSolcolaboracion, pagination);
		Long recordNum = this.motivosSolcolaboracionService
				.findAllCount(filterMotivosSolcolaboracion);
		MotivosSolcolaboracionController.logger
				.info("[GET - jqGrid] : Obtener MotivosSolcolaboracion");
		return new JQGridJSONModel(pagination, recordNum,
				motivosSolcolaboracions);
	}

}
