package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Adjuntarprodagrupado;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Motivo;
import com.ejie.y41b.model.ProdAgrupado;
import com.ejie.y41b.model.Producto;
import com.ejie.y41b.service.AdjuntarprodagrupadoService;
import com.ejie.y41b.service.MotivoService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * * MotivoController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/motivo")
@SessionAttributes({ "codMotivo", "modoBusquedaMotivo", "modoMotivo" })
public class MotivoController {

	private static final Logger logger = LoggerFactory
			.getLogger(MotivoController.class);

	@Autowired
	private MotivoService motivoService;

	@Autowired
	private AdjuntarprodagrupadoService adjuntarprodagrupadoService;

	@Autowired
	private Properties appConfiguration;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormMantenimiento'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "motivos", method = RequestMethod.GET)
	public ModelAndView getCreateFormMantenimiento(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusquedaMotivo", "");

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("motivos", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "seleccionMotivo", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusquedaMotivo",
				Y41bConstantes.MODO_POPUP_SELECCION);

		return new ModelAndView("seleccionMotivos", "model", model);
	}

	/**
	 * Method 'getCreateFormAltaMotivo'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "altaMotivo", method = RequestMethod.GET)
	public ModelAndView getCreateFormAltaMotivo(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("codMotivo", Y41bUIDGenerator.getInstance()
				.generateId(Y41bConstantes.PK_SIZE));

		model.addAttribute("modoMotivo", Y41bConstantes.MODO_POPUP_ALTA);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleMotivo", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormModMotivo'.
	 * 
	 * @param codMotivo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "modMotivo/{codMotivo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormModMotivo(@PathVariable String codMotivo,
			Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("codMotivo", codMotivo);

		model.addAttribute("modoMotivo", Y41bConstantes.MODO_POPUP_MODIFICACION);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		Motivo motivo = new Motivo();
		motivo.setTircodigo(codMotivo);

		this.adjuntarprodagrupadoService.addProdAgrupadoTableTemporal(motivo);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleMotivo", "model", model);
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param tircodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{tircodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Motivo getById(@PathVariable String tircodigo) {
		try {
			Motivo motivo = new Motivo();
			motivo.setTircodigo(tircodigo);
			motivo = this.motivoService.find(motivo);
			if (motivo == null) {
				throw new Exception(tircodigo.toString());
			}
			return motivo;
		} catch (Exception e) {
			throw new ResourceNotFoundException(tircodigo.toString());
		}
	}

	/**
	 * Method 'getMotivoById'.
	 * 
	 * @param tircodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "findMotivo/{tircodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Motivo getMotivoById(@PathVariable String tircodigo) {
		try {
			Motivo motivo = new Motivo();
			motivo.setTircodigo(tircodigo);
			motivo = this.motivoService.find(motivo);
			if (motivo == null) {
				throw new Exception(tircodigo.toString());
			}
			return motivo;
		} catch (Exception e) {
			throw new ResourceNotFoundException(tircodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param tircodigo
	 *            String
	 * @param tirnombre
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "tircodigo", required = false) String tircodigo,
			@RequestParam(value = "tirnombre", required = false) String tirnombre,
			HttpServletRequest request) {
		try {
			Motivo filterMotivo = new Motivo(tircodigo, tirnombre, null);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Motivo> motivos = this.motivoService.findAll(filterMotivo,
						pagination);

				if (motivos == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterMotivo, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(motivos);
				return data;
			} else {
				List<Motivo> motivos = this.motivoService.findAll(filterMotivo,
						pagination);
				if (motivos == null) {
					throw new Exception("No data Found.");
				}
				return motivos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllMotivo'. de tipo like
	 * 
	 * @param tircodigo_
	 *            String
	 * @param tirnombre_
	 *            String
	 * @param prodAgrupadoE8codigo_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/like", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllMotivo(
			@RequestParam(value = "tircodigo", required = false) String tircodigo_,
			@RequestParam(value = "tirnombre", required = false) String tirnombre_,
			@RequestParam(value = "prodAgrupadoE8codigo", required = false) String prodAgrupadoE8codigo_,
			HttpServletRequest request) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String tircodigo = ("".equals(tircodigo_)) ? null : tircodigo_;
			String tirnombre = null;
			String tirnombree = null;
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
				tirnombre = ("".equals(tirnombre_)) ? null : tirnombre_;
			} else {
				tirnombree = ("".equals(tirnombre_)) ? null : tirnombre_;
			}

			String prodAgrupadoE8codigo = ("".equals(prodAgrupadoE8codigo_)) ? null
					: prodAgrupadoE8codigo_;

			Motivo filterMotivo = new Motivo(tircodigo, tirnombre, tirnombree,
					prodAgrupadoE8codigo);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Motivo> motivos = this.motivoService.findAllLike(
						filterMotivo, pagination, false);

				if (motivos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.motivoService.findAllLikeCount(filterMotivo,
						false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(motivos);
				return data;
			} else {
				List<Motivo> motivos = this.motivoService.findAllLike(
						filterMotivo, pagination, false);
				if (motivos == null) {
					throw new Exception("No data Found.");
				}
				return motivos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllMotivoProdServ'.
	 * 
	 * @param pscodigo
	 *            String
	 * @return Object
	 *  
	 */
	@RequestMapping(value = "/prodserv/{pscodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllMotivoProdServ(@PathVariable String pscodigo) {
		try {
			Producto producto = new Producto();
			producto.setPscodigo(pscodigo);
			Pagination pagination = null;
			List<Motivo> motivos = this.motivoService.findAllMotivoProducto(
					producto, pagination);
			if (motivos == null) {
				throw new Exception("No data Found.");
			}
			return motivos;
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllMotivoProdServAlta'.
	 * 
	 * @param pscodigo
	 *            String
	 * @return Object
	 *  
	 */
	@RequestMapping(value = "/prodservAlta/{pscodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllMotivoProdServAlta(@PathVariable String pscodigo) {
		try {
			Producto producto = new Producto();
			producto.setPscodigo(pscodigo);
			Pagination pagination = null;
			List<Motivo> motivos = this.motivoService
					.findAllMotivoProductoAlta(producto, pagination);
			if (motivos == null) {
				throw new Exception("No data Found.");
			}
			return motivos;
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterMotivo
	 *            Motivo
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "motivo", required = false) Motivo filterMotivo,
			HttpServletRequest request) {
		try {
			return motivoService
					.findAllCount(filterMotivo != null ? filterMotivo
							: new Motivo());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param motivo
	 *            Motivo
	 * @param response
	 *            HttpServletResponse
	 * @return Motivo
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Motivo edit(@RequestBody Motivo motivo, HttpServletResponse response) {
		try {
			Motivo motivoAux = this.motivoService.update(motivo);
			logger.info("Entity correctly inserted!");
			return motivoAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'editMotivo'.
	 * 
	 * @param motivo
	 *            Motivo
	 * @param response
	 *            HttpServletResponse
	 * @return Motivo
	 */
	@RequestMapping(value = "/updateMotivo", method = RequestMethod.PUT)
	public @ResponseBody
	Motivo editMotivo(@RequestBody Motivo motivo, HttpServletResponse response) {
		try {
			Motivo motivoAux = this.motivoService.updateMotivo(motivo);
			logger.info("Entity correctly inserted!");
			return motivoAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param motivo
	 *            Motivo
	 * @return Motivo
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Motivo add(@RequestBody Motivo motivo) {
		try {
			Motivo motivoAux = this.motivoService.add(motivo);
			logger.info("Entity correctly inserted!");
			return motivoAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'addMotivo'.
	 * 
	 * @param motivo
	 *            Motivo
	 * @param codMotivoAlta
	 *            String
	 * @return Motivo
	 */
	@RequestMapping(value = "/addMotivo", method = RequestMethod.POST)
	public @ResponseBody
	Motivo addMotivo(@RequestBody Motivo motivo,
			@ModelAttribute(value = "codMotivo") String codMotivoAlta) {
		try {
			Motivo motivoAux = this.motivoService.addMotivo(motivo,
					codMotivoAlta);
			logger.info("Entity correctly inserted!");
			return motivoAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param tircodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{tircodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String tircodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Motivo motivo = new Motivo();
			motivo.setTircodigo(tircodigo);
			this.motivoService.remove(motivo);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + tircodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeMotivo'.
	 * 
	 * @param tircodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "removeMotivo/{tircodigo}", method = RequestMethod.DELETE)
	public void removeMotivo(@PathVariable String tircodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Motivo motivo = new Motivo();
			motivo.setTircodigo(tircodigo);
			this.motivoService.updateFechaBaja(motivo);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			logger.error("Unable to delete " + tircodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param motivoIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> motivoIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Motivo> motivoList = new ArrayList<Motivo>();
		try {
			for (ArrayList<String> motivoId : motivoIds) {
				Iterator<String> iterator = motivoId.iterator();
				Motivo motivo = new Motivo();
				motivo.setTircodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				motivoList.add(motivo);
			}
			this.motivoService.removeMultiple(motivoList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'getAllProdAgrupados'.
	 * 
	 * @param codMotivo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllProdAgrupados", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllProdAgrupados(
			@ModelAttribute(value = "codMotivo") String codMotivo,
			HttpServletRequest request) {
		try {
			Adjuntarprodagrupado adjuntarprodagrupado = new Adjuntarprodagrupado();
			adjuntarprodagrupado.setTircodigo(codMotivo);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<ProdAgrupado> listProdAgrupado = null;

				listProdAgrupado = this.adjuntarprodagrupadoService
						.findAllProdAgrupados(adjuntarprodagrupado, pagination);

				if (listProdAgrupado == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.adjuntarprodagrupadoService
						.findAllProdAgrupadosCount(adjuntarprodagrupado);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listProdAgrupado);
				return data;
			} else {
				List<ProdAgrupado> listProdAgrupado = null;

				listProdAgrupado = this.adjuntarprodagrupadoService
						.findAllProdAgrupados(adjuntarprodagrupado, pagination);

				if (listProdAgrupado == null) {
					throw new Exception("No data Found.");
				}
				return listProdAgrupado;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addProdAgrupado'.
	 * 
	 * @param e8codigo
	 *            String
	 * @param codMotivo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return Adjuntarprodagrupado
	 */
	@RequestMapping(value = "/anyadirProdAgrupado/{e8codigo}", method = RequestMethod.POST)
	public @ResponseBody
	Adjuntarprodagrupado addProdAgrupado(@PathVariable String e8codigo,
			@ModelAttribute(value = "codMotivo") String codMotivo,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			Adjuntarprodagrupado adjuntarprodagrupado = new Adjuntarprodagrupado();
			adjuntarprodagrupado.setTircodigo(codMotivo);
			adjuntarprodagrupado.setE8codigo(e8codigo);

			this.adjuntarprodagrupadoService.add(adjuntarprodagrupado);

			logger.info("Entity correctly inserted!" + adjuntarprodagrupado);
			return adjuntarprodagrupado;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'removeProdAgrupado'.
	 * 
	 * @param e8codigo
	 *            String
	 * @param codMotivo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarProdAgrupado/{e8codigo}", method = RequestMethod.DELETE)
	public void removeProdAgrupado(@PathVariable String e8codigo,
			@ModelAttribute(value = "codMotivo") String codMotivo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Adjuntarprodagrupado adjuntarprodagrupado = new Adjuntarprodagrupado();
			adjuntarprodagrupado.setTircodigo(codMotivo);
			adjuntarprodagrupado.setE8codigo(e8codigo);

			this.adjuntarprodagrupadoService.remove(adjuntarprodagrupado);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getMotivoService'.
	 * 
	 * @return MotivoService
	 */
	protected MotivoService getMotivoService() {
		return this.motivoService;
	}

	/**
	 * Method 'setMotivoService'.
	 * 
	 * @param motivoService
	 *            MotivoService
	 * @return
	 */
	public void setMotivoService(MotivoService motivoService) {
		this.motivoService = motivoService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Method 'unBind' ProdMotivo
	 * 
	 * @param tircodigo
	 *            String
	 * @param prodAgrupadoE8codigo
	 *            String
	 * @return
	 */
	@RequestMapping(value = "/unbindProdMotivo", method = RequestMethod.POST)
	public void unBindProdMotivo(
			@RequestParam(value = "tircodigo", required = false) String tircodigo,
			@RequestParam(value = "prodAgrupadoE8codigo", required = false) String prodAgrupadoE8codigo) {
		Motivo motivo = new Motivo();
		ProdAgrupado prodAgrupado = new ProdAgrupado();
		if (tircodigo != null) {
			motivo.setTircodigo(tircodigo);
		}
		if (prodAgrupadoE8codigo != null) {
			prodAgrupado.setE8codigo(prodAgrupadoE8codigo);
		}
		motivo.getProdAgrupados().add(prodAgrupado);
		this.motivoService.removeProdMotivo(motivo);
	}

	/**
	 * Method 'bind' ProdMotivo
	 * 
	 * @param tircodigo
	 *            String
	 * @param prodAgrupadoE8codigo
	 *            String
	 */
	@RequestMapping(value = "/bindProdMotivo", method = RequestMethod.POST)
	public void bindProdMotivo(
			@RequestParam(value = "tircodigo", required = false) String tircodigo,
			@RequestParam(value = "prodAgrupadoE8codigo", required = false) String prodAgrupadoE8codigo) {
		Motivo motivo = new Motivo();
		ProdAgrupado prodAgrupado = new ProdAgrupado();
		if (tircodigo != null) {
			motivo.setTircodigo(tircodigo);
		}
		if (prodAgrupadoE8codigo != null) {
			prodAgrupado.setE8codigo(prodAgrupadoE8codigo);
		}
		motivo.getProdAgrupados().add(prodAgrupado);
		this.motivoService.addProdMotivo(motivo);
	}

	/**
	 * Method 'comboMotivo'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "/combo", method = RequestMethod.GET)
	public @ResponseBody()
	List<Motivo> comboMotivo(HttpServletRequest request) {

		Locale locale = LocaleContextHolder.getLocale();
		String idioma = locale.getLanguage();
		Pagination pagination = new Pagination();
		if (Y41bConstantes.CASTELLANO.equals(idioma)) {
			pagination.setSort("tirnombre");
		} else {
			pagination.setSort("tirnombree");
		}
		pagination.setAscDsc("DESC");
		return this.motivoService.findAll(new Motivo(), pagination);
	}
}
