package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.MetodopagoService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.Metodopago;

/**
 * MetodopagoController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/metodopago")
public class MetodopagoController {

	private static final Logger logger = LoggerFactory
			.getLogger(MetodopagoController.class);

	@Autowired()
	private MetodopagoService metodopagoService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		MetodopagoController.logger.info("[GET - View] : metodopago");
		return "metodopago";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param sbcodigo
	 *            String
	 * @return metodopago Metodopago
	 */
	@RequestMapping(value = "/{sbcodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	Metodopago getById(@PathVariable() String sbcodigo) {
		Metodopago metodopago = new Metodopago();
		metodopago.setSbcodigo(sbcodigo);
		metodopago = this.metodopagoService.find(metodopago);
		MetodopagoController.logger
				.info("[GET - findBy_PK] : Obtener Metodopago por PK");
		return metodopago;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterMetodopago
	 *            Metodopago
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Metodopago> getAll(@ModelAttribute() Metodopago filterMetodopago) {
		MetodopagoController.logger
				.info("[GET - find_ALL] : Obtener Metodopago por filtro");
		return this.metodopagoService.findAll(filterMetodopago, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param metodopago
	 *            Metodopago
	 * @return Metodopago
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Metodopago edit(@RequestBody() Metodopago metodopago) {
		Metodopago metodopagoAux = this.metodopagoService.update(metodopago);
		MetodopagoController.logger
				.info("[PUT] : Metodopago actualizado correctamente");
		return metodopagoAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param metodopago
	 *            Metodopago
	 * @return Metodopago
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Metodopago add(@RequestBody() Metodopago metodopago) {
		Metodopago metodopagoAux = this.metodopagoService.add(metodopago);
		MetodopagoController.logger
				.info("[POST] : Metodopago insertado correctamente");
		return metodopagoAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param sbcodigo
	 *            String
	 * @return metodopago
	 */
	@RequestMapping(value = "/{sbcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Metodopago remove(@PathVariable() String sbcodigo) {
		Metodopago metodopago = new Metodopago();
		metodopago.setSbcodigo(sbcodigo);
		this.metodopagoService.remove(metodopago);
		MetodopagoController.logger
				.info("[DELETE] : Metodopago borrado correctamente");
		return metodopago;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param metodopagoIds
	 *            List
	 * @return metodopagoList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(
			@RequestBody() List<List<String>> metodopagoIds) {
		List<Metodopago> metodopagoList = new ArrayList<Metodopago>();
		for (List<String> metodopagoId : metodopagoIds) {
			Iterator<String> iterator = metodopagoId.iterator();
			Metodopago metodopago = new Metodopago(); // NOPMD - Objeto nuevo en
														// la lista (parametro
														// del servicio)
			metodopago.setSbcodigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			metodopagoList.add(metodopago);
		}
		this.metodopagoService.removeMultiple(metodopagoList);
		MetodopagoController.logger
				.info("[POST - DELETE_ALL] : Metodopago borrados correctamente");
		return metodopagoIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterMetodopago
	 *            Metodopago
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(@ModelAttribute() Metodopago filterMetodopago,
			@ModelAttribute() Pagination pagination) {
		List<Metodopago> metodopagos = this.metodopagoService.findAll(
				filterMetodopago, pagination);
		Long recordNum = this.metodopagoService.findAllCount(filterMetodopago);
		MetodopagoController.logger.info("[GET - jqGrid] : Obtener Metodopago");
		return new JQGridJSONModel(pagination, recordNum, metodopagos);
	}

}
