package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.MensajecolaService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.Mensajecola;

/**
 * MensajecolaController  
 *  
 */
 
@Controller
@RequestMapping (value = "/mensajecola")

public class MensajecolaController  {

	private static final Logger logger = LoggerFactory.getLogger(MensajecolaController.class);

	@Autowired
	private MensajecolaService mensajecolaService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		MensajecolaController.logger.info("[GET - View] : mensajecola");
		return "mensajecola";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param swcodmensaje String
	 * @return mensajecola Mensajecola
	 */
	@RequestMapping(value = "/{swcodmensaje}", method = RequestMethod.GET)
	public @ResponseBody Mensajecola getById(@PathVariable String swcodmensaje) {
        Mensajecola mensajecola = new Mensajecola();
		mensajecola.setSwcodmensaje(swcodmensaje);
        mensajecola = this.mensajecolaService.find(mensajecola);
        MensajecolaController.logger.info("[GET - findBy_PK] : Obtener Mensajecola por PK");
        return mensajecola;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterMensajecola Mensajecola
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Mensajecola> getAll(@ModelAttribute Mensajecola filterMensajecola) {
		MensajecolaController.logger.info("[GET - find_ALL] : Obtener Mensajecola por filtro");
	    return this.mensajecolaService.findAll(filterMensajecola, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param mensajecola Mensajecola 
	 * @return Mensajecola
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Mensajecola edit(@RequestBody Mensajecola mensajecola) {		
        Mensajecola mensajecolaAux = this.mensajecolaService.update(mensajecola);
		MensajecolaController.logger.info("[PUT] : Mensajecola actualizado correctamente");
        return mensajecolaAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param mensajecola Mensajecola 
	 * @return Mensajecola
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Mensajecola add(@RequestBody Mensajecola mensajecola) {		
        Mensajecola mensajecolaAux = this.mensajecolaService.add(mensajecola);
        MensajecolaController.logger.info("[POST] : Mensajecola insertado correctamente");
    	return mensajecolaAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param swcodmensaje String
	 * @return mensajecola
	 */
	@RequestMapping(value = "/{swcodmensaje}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody Mensajecola remove(@PathVariable String swcodmensaje) {
        Mensajecola mensajecola = new Mensajecola();
        mensajecola.setSwcodmensaje(swcodmensaje);
        this.mensajecolaService.remove(mensajecola);
       	MensajecolaController.logger.info("[DELETE] : Mensajecola borrado correctamente");
       	return mensajecola;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param mensajecolaIds List
	 * @return mensajecolaList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> mensajecolaIds) {
        List<Mensajecola> mensajecolaList = new ArrayList<Mensajecola>();
        for (List<String> mensajecolaId:mensajecolaIds) {
		    Iterator<String> iterator = mensajecolaId.iterator();
		    Mensajecola mensajecola = new Mensajecola(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        mensajecola.setSwcodmensaje(ObjectConversionManager.convert(iterator.next(), String.class));
		    mensajecolaList.add(mensajecola);
	    }
        this.mensajecolaService.removeMultiple(mensajecolaList);
		MensajecolaController.logger.info("[POST - DELETE_ALL] : Mensajecola borrados correctamente");
		return mensajecolaIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterMensajecola Mensajecola
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute Mensajecola filterMensajecola, @ModelAttribute Pagination pagination) {
        List<Mensajecola> mensajecolas = this.mensajecolaService.findAll(filterMensajecola, pagination);
        Long recordNum = this.mensajecolaService.findAllCount(filterMensajecola);
        MensajecolaController.logger.info("[GET - jqGrid] : Obtener Mensajecola");
		return new JQGridJSONModel(pagination, recordNum, mensajecolas);
	}
	
}	
