package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.LocalidaService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.Localida;

/**
 * LocalidaController  
 *  
 */
 
@Controller
@RequestMapping (value = "/localida")

public class LocalidaController  {

	private static final Logger logger = LoggerFactory.getLogger(LocalidaController.class);

	@Autowired
	private LocalidaService localidaService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		LocalidaController.logger.info("[GET - View] : localida");
		return "localida";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param locodigo String
	 * @return localida Localida
	 */
	@RequestMapping(value = "/{locodigo}", method = RequestMethod.GET)
	public @ResponseBody Localida getById(@PathVariable String locodigo) {
        Localida localida = new Localida();
		localida.setLocodigo(locodigo);
        localida = this.localidaService.find(localida);
        LocalidaController.logger.info("[GET - findBy_PK] : Obtener Localida por PK");
        return localida;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterLocalida Localida
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Localida> getAll(@ModelAttribute Localida filterLocalida) {
		LocalidaController.logger.info("[GET - find_ALL] : Obtener Localida por filtro");
	    return this.localidaService.findAll(filterLocalida, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param localida Localida 
	 * @return Localida
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Localida edit(@RequestBody Localida localida) {		
        Localida localidaAux = this.localidaService.update(localida);
		LocalidaController.logger.info("[PUT] : Localida actualizado correctamente");
        return localidaAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param localida Localida 
	 * @return Localida
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Localida add(@RequestBody Localida localida) {		
        Localida localidaAux = this.localidaService.add(localida);
        LocalidaController.logger.info("[POST] : Localida insertado correctamente");
    	return localidaAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param locodigo String
	 * @return localida
	 */
	@RequestMapping(value = "/{locodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody Localida remove(@PathVariable String locodigo) {
        Localida localida = new Localida();
        localida.setLocodigo(locodigo);
        this.localidaService.remove(localida);
       	LocalidaController.logger.info("[DELETE] : Localida borrado correctamente");
       	return localida;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param localidaIds List
	 * @return localidaList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> localidaIds) {
        List<Localida> localidaList = new ArrayList<Localida>();
        for (List<String> localidaId:localidaIds) {
		    Iterator<String> iterator = localidaId.iterator();
		    Localida localida = new Localida(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        localida.setLocodigo(ObjectConversionManager.convert(iterator.next(), String.class));
		    localidaList.add(localida);
	    }
        this.localidaService.removeMultiple(localidaList);
		LocalidaController.logger.info("[POST - DELETE_ALL] : Localida borrados correctamente");
		return localidaIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterLocalida Localida
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute Localida filterLocalida, @ModelAttribute Pagination pagination) {
        List<Localida> localidas = this.localidaService.findAll(filterLocalida, pagination);
        Long recordNum = this.localidaService.findAllCount(filterLocalida);
        LocalidaController.logger.info("[GET - jqGrid] : Obtener Localida");
		return new JQGridJSONModel(pagination, recordNum, localidas);
	}
	
}	
