package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.LaudosTipoService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.LaudosTipo;

/**
 * LaudosTipoController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/laudostipo")
public class LaudosTipoController {

	private static final Logger logger = LoggerFactory
			.getLogger(LaudosTipoController.class);

	@Autowired
	private LaudosTipoService laudosTipoService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		LaudosTipoController.logger.info("[GET - View] : laudostipo");
		return "laudostipo";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param l21r3codigo
	 *            String
	 * @return laudosTipo LaudosTipo
	 */
	@RequestMapping(value = "/{l21r3codigo}", method = RequestMethod.GET)
	public @ResponseBody
	LaudosTipo getById(@PathVariable String l21r3codigo) {
		LaudosTipo laudosTipo = new LaudosTipo();
		laudosTipo.setL21r3codigo(l21r3codigo);
		laudosTipo = this.laudosTipoService.find(laudosTipo);
		LaudosTipoController.logger
				.info("[GET - findBy_PK] : Obtener LaudosTipo por PK");
		return laudosTipo;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterLaudosTipo
	 *            LaudosTipo
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<LaudosTipo> getAll(
			@RequestParam(value = "l21r3y41b", required = false) String l21r3y41b,
			@ModelAttribute LaudosTipo filterLaudosTipo) {
		LaudosTipoController.logger
				.info("[GET - find_ALL] : Obtener LaudosTipo por filtro");
		filterLaudosTipo.setL21r3y41b(l21r3y41b);
		return this.laudosTipoService.findAll(filterLaudosTipo, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param laudosTipo
	 *            LaudosTipo
	 * @return LaudosTipo
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	LaudosTipo edit(@RequestBody LaudosTipo laudosTipo) {
		LaudosTipo laudosTipoAux = this.laudosTipoService.update(laudosTipo);
		LaudosTipoController.logger
				.info("[PUT] : LaudosTipo actualizado correctamente");
		return laudosTipoAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param laudosTipo
	 *            LaudosTipo
	 * @return LaudosTipo
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	LaudosTipo add(@RequestBody LaudosTipo laudosTipo) {
		LaudosTipo laudosTipoAux = this.laudosTipoService.add(laudosTipo);
		LaudosTipoController.logger
				.info("[POST] : LaudosTipo insertado correctamente");
		return laudosTipoAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param l21r3codigo
	 *            String
	 * @return laudosTipo
	 */
	@RequestMapping(value = "/{l21r3codigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	LaudosTipo remove(@PathVariable String l21r3codigo) {
		LaudosTipo laudosTipo = new LaudosTipo();
		laudosTipo.setL21r3codigo(l21r3codigo);
		this.laudosTipoService.remove(laudosTipo);
		LaudosTipoController.logger
				.info("[DELETE] : LaudosTipo borrado correctamente");
		return laudosTipo;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param laudosTipoIds
	 *            List
	 * @return laudosTipoList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> laudosTipoIds) {
		List<LaudosTipo> laudosTipoList = new ArrayList<LaudosTipo>();
		for (List<String> laudosTipoId : laudosTipoIds) {
			Iterator<String> iterator = laudosTipoId.iterator();
			LaudosTipo laudosTipo = new LaudosTipo(); // NOPMD - Objeto nuevo en
														// la lista (parametro
														// del servicio)
			laudosTipo.setL21r3codigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			laudosTipoList.add(laudosTipo);
		}
		this.laudosTipoService.removeMultiple(laudosTipoList);
		LaudosTipoController.logger
				.info("[POST - DELETE_ALL] : LaudosTipo borrados correctamente");
		return laudosTipoIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterLaudosTipo
	 *            LaudosTipo
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute LaudosTipo filterLaudosTipo,
			@ModelAttribute Pagination pagination) {
		List<LaudosTipo> laudosTipos = this.laudosTipoService.findAll(
				filterLaudosTipo, pagination);
		Long recordNum = this.laudosTipoService.findAllCount(filterLaudosTipo);
		LaudosTipoController.logger.info("[GET - jqGrid] : Obtener LaudosTipo");
		return new JQGridJSONModel(pagination, recordNum, laudosTipos);
	}

}
