package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.LaudosAdoptadoService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.LaudosAdoptado;

/**
 * LaudosAdoptadoController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/laudosadoptado")
public class LaudosAdoptadoController {

	private static final Logger logger = LoggerFactory
			.getLogger(LaudosAdoptadoController.class);

	@Autowired
	private LaudosAdoptadoService laudosAdoptadoService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		LaudosAdoptadoController.logger.info("[GET - View] : laudosadoptado");
		return "laudosadoptado";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param l21r4codigo
	 *            String
	 * @return laudosAdoptado LaudosAdoptado
	 */
	@RequestMapping(value = "/{l21r4codigo}", method = RequestMethod.GET)
	public @ResponseBody
	LaudosAdoptado getById(@PathVariable String l21r4codigo) {
		LaudosAdoptado laudosAdoptado = new LaudosAdoptado();
		laudosAdoptado.setL21r4codigo(l21r4codigo);
		laudosAdoptado = this.laudosAdoptadoService.find(laudosAdoptado);
		LaudosAdoptadoController.logger
				.info("[GET - findBy_PK] : Obtener LaudosAdoptado por PK");
		return laudosAdoptado;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterLaudosAdoptado
	 *            LaudosAdoptado
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<LaudosAdoptado> getAll(
			@ModelAttribute LaudosAdoptado filterLaudosAdoptado) {
		LaudosAdoptadoController.logger
				.info("[GET - find_ALL] : Obtener LaudosAdoptado por filtro");
		return this.laudosAdoptadoService.findAll(filterLaudosAdoptado, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param laudosAdoptado
	 *            LaudosAdoptado
	 * @return LaudosAdoptado
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	LaudosAdoptado edit(@RequestBody LaudosAdoptado laudosAdoptado) {
		LaudosAdoptado laudosAdoptadoAux = this.laudosAdoptadoService
				.update(laudosAdoptado);
		LaudosAdoptadoController.logger
				.info("[PUT] : LaudosAdoptado actualizado correctamente");
		return laudosAdoptadoAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param laudosAdoptado
	 *            LaudosAdoptado
	 * @return LaudosAdoptado
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	LaudosAdoptado add(@RequestBody LaudosAdoptado laudosAdoptado) {
		LaudosAdoptado laudosAdoptadoAux = this.laudosAdoptadoService
				.add(laudosAdoptado);
		LaudosAdoptadoController.logger
				.info("[POST] : LaudosAdoptado insertado correctamente");
		return laudosAdoptadoAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param l21r4codigo
	 *            String
	 * @return laudosAdoptado
	 */
	@RequestMapping(value = "/{l21r4codigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	LaudosAdoptado remove(@PathVariable String l21r4codigo) {
		LaudosAdoptado laudosAdoptado = new LaudosAdoptado();
		laudosAdoptado.setL21r4codigo(l21r4codigo);
		this.laudosAdoptadoService.remove(laudosAdoptado);
		LaudosAdoptadoController.logger
				.info("[DELETE] : LaudosAdoptado borrado correctamente");
		return laudosAdoptado;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param laudosAdoptadoIds
	 *            List
	 * @return laudosAdoptadoList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> laudosAdoptadoIds) {
		List<LaudosAdoptado> laudosAdoptadoList = new ArrayList<LaudosAdoptado>();
		for (List<String> laudosAdoptadoId : laudosAdoptadoIds) {
			Iterator<String> iterator = laudosAdoptadoId.iterator();
			LaudosAdoptado laudosAdoptado = new LaudosAdoptado(); // NOPMD -
																	// Objeto
																	// nuevo en
																	// la lista
																	// (parametro
																	// del
																	// servicio)
			laudosAdoptado.setL21r4codigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			laudosAdoptadoList.add(laudosAdoptado);
		}
		this.laudosAdoptadoService.removeMultiple(laudosAdoptadoList);
		LaudosAdoptadoController.logger
				.info("[POST - DELETE_ALL] : LaudosAdoptado borrados correctamente");
		return laudosAdoptadoIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterLaudosAdoptado
	 *            LaudosAdoptado
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute LaudosAdoptado filterLaudosAdoptado,
			@ModelAttribute Pagination pagination) {
		List<LaudosAdoptado> laudosAdoptados = this.laudosAdoptadoService
				.findAll(filterLaudosAdoptado, pagination);
		Long recordNum = this.laudosAdoptadoService
				.findAllCount(filterLaudosAdoptado);
		LaudosAdoptadoController.logger
				.info("[GET - jqGrid] : Obtener LaudosAdoptado");
		return new JQGridJSONModel(pagination, recordNum, laudosAdoptados);
	}

}
