package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.rowset.serial.SerialBlob;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Laboratorio;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.service.AdjuntardocsService;
import com.ejie.y41b.service.DenunciaService;
import com.ejie.y41b.service.LaboratorioService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * LaboratorioController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/laboratorio")
@SessionAttributes({ "codLaboratorio", "modoBusquedaLaboratorio",
		"modoLaboratorio" })
public class LaboratorioController {

	private static final Logger logger = LoggerFactory
			.getLogger(LaboratorioController.class);

	@Autowired
	private LaboratorioService laboratorioService;
	@Autowired
	private AdjuntardocsService adjuntardocsService;
	@Autowired
	private DenunciaService denunciaService;

	@Autowired
	private Properties appConfiguration;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormMantenimiento'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "laboratorios", method = RequestMethod.GET)
	public ModelAndView getCreateFormMantenimiento(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusquedaLaboratorio", "");

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		model.addAttribute("modalBusqueda", "");

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("laboratorios", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormMantenimiento'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "laboratoriosModal", method = RequestMethod.GET)
	public ModelAndView getCreateFormMantenimientoModal(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusquedaLaboratorio", "");
		model.addAttribute("modalBusqueda", "S");

		return new ModelAndView("laboratoriosModal", "model", model);
	}

	/**
	 * Method 'getCreateFormAltaLaboratorio'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "altaLaboratorio", method = RequestMethod.GET)
	public ModelAndView getCreateFormAltaLaboratorio(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("codLaboratorio", Y41bUIDGenerator.getInstance()
				.generateId(Y41bConstantes.PK_SIZE));

		model.addAttribute("modoLaboratorio", Y41bConstantes.MODO_POPUP_ALTA);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("laboratorioDetalle", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormModCampanha'.
	 * 
	 * @param codLaboratorio_
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "modLaboratorio", method = RequestMethod.GET)
	public ModelAndView getCreateFormModLaboratorio(
			@RequestParam(value = "codLaboratorio", required = false) String codLaboratorio_,
			Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));

		String codLaboratorio = ("".equals(codLaboratorio_)) ? null
				: codLaboratorio_;

		model.addAttribute("codLaboratorio", codLaboratorio);

		model.addAttribute("modoLaboratorio",
				Y41bConstantes.MODO_POPUP_MODIFICACION);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		this.adjuntardocsService.addDocsTableTemporal(codLaboratorio);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("laboratorioDetalle", "model", model);
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param lacodigo
	 *            String
	 * @return laboratorio Laboratorio
	 */
	@RequestMapping(value = "/{lacodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Laboratorio getById(@PathVariable String lacodigo) {
		Laboratorio laboratorio = new Laboratorio();
		laboratorio.setLacodigo(lacodigo);
		laboratorio = this.laboratorioService.find(laboratorio);
		LaboratorioController.logger
				.info("[GET - findBy_PK] : Obtener Laboratorio por PK");
		return laboratorio;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterLaboratorio
	 *            Laboratorio
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Laboratorio> getAll(@ModelAttribute Laboratorio filterLaboratorio) {
		LaboratorioController.logger
				.info("[GET - find_ALL] : Obtener Laboratorio por filtro");
		return this.laboratorioService.findAll(filterLaboratorio, null);
	}

	/**
	 * Method 'getAllConsumidor'.
	 * 
	 * @param lacodigo_
	 *            String
	 * @param lanombre_
	 *            String
	 * @param ladescripcion_
	 *            String
	 * @param noraProvinciaId_
	 *            String
	 * @param noraMunicipioId_
	 *            String
	 * @param noraLocalidadId_
	 *            String
	 * @param noraPaisId_
	 *            String
	 * @param direccionNocapv_
	 *            String
	 * @param extranjero_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busqueda", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllLaboratorio(
			@RequestParam(value = "lacodigo", required = false) String lacodigo_,
			@RequestParam(value = "lanombre", required = false) String lanombre_,
			@RequestParam(value = "ladescripcion", required = false) String ladescripcion_,
			@RequestParam(value = "noraProvinciaId", required = false) String noraProvinciaId_,
			@RequestParam(value = "noraMunicipioId", required = false) String noraMunicipioId_,
			@RequestParam(value = "noraLocalidadId", required = false) String noraLocalidadId_,
			@RequestParam(value = "noraPaisId", required = false) String noraPaisId_,
			@RequestParam(value = "direccionNocapv", required = false) String direccionNocapv_,
			@RequestParam(value = "extranjero", required = false) String extranjero_,
			HttpServletRequest request) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String lacodigo = ("".equals(lacodigo_)) ? null : lacodigo_;
			String lanombre = ("".equals(lanombre_)) ? null : lanombre_;
			String ladescripcion = ("".equals(ladescripcion_)) ? null
					: ladescripcion_;

			String extranjero = "";
			String estado = "";
			String noraPaisId = "";
			String noraProvinciaId = "";
			String noraMunicipioId = "";
			String noraLocalidadId = "";
			String direccionNocapv = "";

			if (Y41bConstantes.NORA_LOCALIZACION_TODOS.equals(extranjero_)) {
				extranjero = null;
				noraPaisId = null;
				estado = null;
				noraProvinciaId = null;
				noraMunicipioId = null;
				noraLocalidadId = null;
				direccionNocapv = null;
			} else if (Y41bConstantes.NORA_LOCALIZACION_EXTRANJERO
					.equals(extranjero_)) {
				extranjero = Y41bConstantes.VALOR_SI;
				noraPaisId = ("".equals(noraPaisId_)) ? null : noraPaisId_;
				estado = null;
				noraProvinciaId = null;
				noraMunicipioId = null;
				noraLocalidadId = null;
				direccionNocapv = ("".equals(direccionNocapv_)) ? null
						: direccionNocapv_;
			} else if (Y41bConstantes.NORA_LOCALIZACION_ESTADO
					.equals(extranjero_)) {
				extranjero = null;
				noraPaisId = null;
				estado = Y41bConstantes.VALOR_SI;
				noraProvinciaId = ("".equals(noraProvinciaId_)) ? null
						: noraProvinciaId_;
				noraMunicipioId = ("".equals(noraMunicipioId_)) ? null
						: noraMunicipioId_;
				noraLocalidadId = ("".equals(noraLocalidadId_)) ? null
						: noraLocalidadId_;
				direccionNocapv = null;
			}

			Laboratorio filterLaboratorio = new Laboratorio(lacodigo, lanombre,
					null, null, null, null, null, noraProvinciaId, null,
					noraMunicipioId, null, noraLocalidadId, null, null, null,
					null, null, null, null, null, direccionNocapv, extranjero,
					noraPaisId, null, null, null, ladescripcion, null);
			filterLaboratorio.setEstado(estado);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Laboratorio> listLaboratorio = this.laboratorioService
						.findAllLike(filterLaboratorio, pagination, false);

				if (listLaboratorio == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.laboratorioService.findAllLikeCount(
						filterLaboratorio, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listLaboratorio);
				return data;
			} else {
				List<Laboratorio> listLaboratorio = this.laboratorioService
						.findAllLike(filterLaboratorio, pagination, false);
				if (listLaboratorio == null) {
					throw new Exception("No data Found.");
				}
				return listLaboratorio;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param laboratorio
	 *            Laboratorio
	 * @return Laboratorio
	 */
	@RequestMapping(value = "/updateLaboratorio", method = RequestMethod.PUT)
	public @ResponseBody
	Laboratorio edit(@RequestBody Laboratorio laboratorio) {
		try {
			Laboratorio laboratorioAux = this.laboratorioService
					.update(laboratorio);
			LaboratorioController.logger
					.info("[PUT] : Laboratorio actualizado correctamente");
			return laboratorioAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'addLaboratorio'.
	 * 
	 * @param laboratorio
	 *            Laboratorio
	 * @param codLaboratorioAlta
	 *            String
	 * @return Laboratorio
	 */
	@RequestMapping(value = "/addLaboratorio", method = RequestMethod.POST)
	public @ResponseBody
	Laboratorio addLaboratorio(@RequestBody Laboratorio laboratorio,
			@ModelAttribute(value = "codLaboratorio") String codLaboratorioAlta) {
		try {
			Laboratorio laboratorioAux = this.laboratorioService
					.addLaboratorio(laboratorio, codLaboratorioAlta);
			logger.info("Entity correctly inserted!");
			return laboratorioAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param lacodigo
	 *            String
	 * @return laboratorio
	 */
	@RequestMapping(value = "/{lacodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Laboratorio remove(@PathVariable String lacodigo) {
		Laboratorio laboratorio = new Laboratorio();
		laboratorio.setLacodigo(lacodigo);
		this.laboratorioService.remove(laboratorio);
		LaboratorioController.logger
				.info("[DELETE] : Laboratorio borrado correctamente");
		return laboratorio;
	}

	/**
	 * Method 'removeLaboratorio'.
	 * 
	 * @param lacodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "removeLaboratorio/{lacodigo}", method = RequestMethod.DELETE)
	public void removeLaboratorio(@PathVariable String lacodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Laboratorio laboratorio = new Laboratorio();
			laboratorio.setLacodigo(lacodigo);
			this.laboratorioService.removeLaboratorioBBDD(laboratorio);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			if (e.getException() instanceof DataIntegrityViolationException) {
				Laboratorio laboratorio = new Laboratorio();
				laboratorio.setLacodigo(lacodigo);
				this.laboratorioService.updateFechaBaja(laboratorio);
			} else {
				throw e;
			}
		} catch (Exception e) {
			logger.error("Unable to delete " + lacodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param laboratorioIds
	 *            List
	 * @return laboratorioList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> laboratorioIds) {
		List<Laboratorio> laboratorioList = new ArrayList<Laboratorio>();
		for (List<String> laboratorioId : laboratorioIds) {
			Iterator<String> iterator = laboratorioId.iterator();
			Laboratorio laboratorio = new Laboratorio(); // NOPMD - Objeto nuevo
															// en la lista
															// (parametro del
															// servicio)
			laboratorio.setLacodigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			laboratorioList.add(laboratorio);
		}
		this.laboratorioService.removeMultiple(laboratorioList);
		LaboratorioController.logger
				.info("[POST - DELETE_ALL] : Laboratorio borrados correctamente");
		return laboratorioIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterLaboratorio
	 *            Laboratorio
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Laboratorio filterLaboratorio,
			@ModelAttribute Pagination pagination) {
		List<Laboratorio> laboratorios = this.laboratorioService.findAll(
				filterLaboratorio, pagination);
		Long recordNum = this.laboratorioService
				.findAllCount(filterLaboratorio);
		LaboratorioController.logger
				.info("[GET - jqGrid] : Obtener Laboratorio");
		return new JQGridJSONModel(pagination, recordNum, laboratorios);
	}

	/**
	 * Method 'getAllLaboratorioDocs'.
	 * 
	 * @param codLaboratorio
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllLaboratorioDocs", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllLaboratorioDocs(
			@ModelAttribute(value = "codLaboratorio") String codLaboratorio,
			HttpServletRequest request) {
		try {
			Adjuntardocs adjuntardocsFilter = new Adjuntardocs();
			adjuntardocsFilter.setThidExpediente(codLaboratorio);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(
						adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.adjuntardocsService
						.findAllCount(adjuntardocsFilter);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjuntardocs);
				return data;
			} else {
				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAll(
						adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}
				return listAdjuntardocs;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getByIdDocumentoLaboratorio'.
	 * 
	 * @param iddocumento
	 *            String
	 * 
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findLaboratorioDocumento/{iddocumento}", method = RequestMethod.GET)
	public @ResponseBody
	void getByIdDocumentoLaboratorio(@PathVariable String iddocumento,
			HttpServletResponse response) {
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThcodocumento(iddocumento);

			adjuntardocsAux = this.adjuntardocsService
					.findDocByPK(adjuntardocsAux);

			Blob contenido = adjuntardocsAux.getThdatafile();
			byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader(
					"Content-Disposition",
					"attachment; filename=\""
							+ StringEscapeUtils.unescapeHtml(adjuntardocsAux
									.getThnofile()) + "\"");
			response.setContentType(adjuntardocsAux.getThcontenttypefile());
			response.setContentLength(adjuntardocsAux.getThsizefile());
			response.getOutputStream().write(bContenido);

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addLaboratorioDocs'.
	 * 
	 * @param file
	 *            MultipartFile
	 * @param codLaboratorioAlta
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return ConsultaFile
	 */
	@RequestMapping(value = "/addLaboratorioDocs", method = RequestMethod.POST)
	public @ResponseBody
	List<Map<String, Object>> addLaboratorioDocs(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			@ModelAttribute(value = "codLaboratorio") String codLaboratorioAlta,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();

			String tedesfile = request.getParameter("tedesfile");

			adjuntardocsAux.setThcodocumento(this.denunciaService
					.getNewPKDocumentoHecho().toString());

			Blob blob = new SerialBlob(file.getBytes());
			adjuntardocsAux.setThdatafile(blob);
			adjuntardocsAux.setThcontenttypefile(file.getContentType());
			adjuntardocsAux.setThnofile(file.getOriginalFilename());
			adjuntardocsAux.setThsizefile((int) file.getSize());

			adjuntardocsAux.setThidExpediente(codLaboratorioAlta);
			adjuntardocsAux.setThidTramite(codLaboratorioAlta);

			adjuntardocsAux.setThtedesfile(tedesfile);

			adjuntardocsAux
					.setThorigen(Y41bConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION);

			TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
			tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
			adjuntardocsAux.setTipoProcedimiento(tipoProcedimiento);

			adjuntardocsAux.setThfecha(new Date());

			adjuntardocsAux = this.adjuntardocsService.add(adjuntardocsAux);

			logger.info("Entity correctly inserted!" + adjuntardocsAux);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			filesMetaInfo.add(this.getFileReturnMap(file));
			return filesMetaInfo;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * @param file
	 *            MultipartFile
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMap(MultipartFile file) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();
		mapaRetorno.put("url", "/y41bVistaWar/laboratorio/addLaboratorioDocs/"
				+ file.getOriginalFilename());
		mapaRetorno.put("name", file.getOriginalFilename());
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno.put(
				"delete_url",
				"/y41bVistaWar/laboratorio/addLaboratorioDocs/"
						+ file.getOriginalFilename());
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/**
	 * Method 'removeLaboratorioDocs'.
	 * 
	 * @param iddocumento
	 *            String
	 * @param codLaboratorio
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarLaboratorioDocs/{iddocumento}", method = RequestMethod.DELETE)
	public void removeLaboratorioDocs(@PathVariable String iddocumento,
			@ModelAttribute(value = "codLaboratorio") String codLaboratorio,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThcodocumento(iddocumento);

			this.adjuntardocsService.remove(adjuntardocsAux);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}
}
