package com.ejie.y41b.control;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Jjaa;
import com.ejie.y41b.service.JjaaService;
import com.ejie.y41b.service.Y41bExcelGeneratorService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * JjaaController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/jjaa")
public class JjaaController {

	private static final Logger logger = LoggerFactory
			.getLogger(JjaaController.class);

	@Autowired()
	private JjaaService jjaaService;

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private Y41bExcelGeneratorService y41bExcelGeneratorService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {
		JjaaController.logger.info("[GET - View] : jjaa");
		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| (censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO) && censoMonitor
						.getPerfilArbitraje().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO))) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("jjaa", "model", model);
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param jacodigo
	 *            String
	 * @return jjaa Jjaa
	 */
	@RequestMapping(value = "/getById/{jacodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	Jjaa getById(@PathVariable() String jacodigo) {
		Jjaa jjaa = new Jjaa();
		jjaa.setJacodigo(jacodigo);
		jjaa = this.jjaaService.find(jjaa);
		JjaaController.logger.info("[GET - findBy_PK] : Obtener Jjaa por PK");
		return jjaa;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterJjaa
	 *            Jjaa
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Jjaa> getAll(@ModelAttribute() Jjaa filterJjaa) {
		JjaaController.logger
				.info("[GET - find_ALL] : Obtener Jjaa por filtro");
		return this.jjaaService.findAll(filterJjaa, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param jjaa
	 *            Jjaa
	 * @return Jjaa
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Jjaa edit(@RequestBody() Jjaa jjaa) {
		Jjaa jjaaAux = this.jjaaService.update(jjaa);
		JjaaController.logger.info("[PUT] : Jjaa actualizado correctamente");
		return jjaaAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param jjaa
	 *            Jjaa
	 * @return Jjaa
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Jjaa add(@RequestBody() Jjaa jjaa) {
		Jjaa jjaaAux = this.jjaaService.add(jjaa);
		JjaaController.logger.info("[POST] : Jjaa insertado correctamente");
		return jjaaAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param jacodigo
	 *            String
	 * @return jjaa
	 */
	@RequestMapping(value = "/{jacodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Jjaa remove(@PathVariable() String jacodigo) {
		Jjaa jjaa = new Jjaa();
		jjaa.setJacodigo(jacodigo);
		this.jjaaService.remove(jjaa);
		JjaaController.logger.info("[DELETE] : Jjaa borrado correctamente");
		return jjaa;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param jjaaIds
	 *            List
	 * @return jjaaList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(@RequestBody() List<List<String>> jjaaIds) {
		List<Jjaa> jjaaList = new ArrayList<Jjaa>();
		for (List<String> jjaaId : jjaaIds) {
			Iterator<String> iterator = jjaaId.iterator();
			Jjaa jjaa = new Jjaa(); // NOPMD - Objeto nuevo en la lista
									// (parametro del servicio)
			jjaa.setJacodigo(ObjectConversionManager.convert(iterator.next(),
					String.class));
			jjaaList.add(jjaa);
		}
		this.jjaaService.removeMultiple(jjaaList);
		JjaaController.logger
				.info("[POST - DELETE_ALL] : Jjaa borrados correctamente");
		return jjaaIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterJjaa
	 *            Jjaa
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(@ModelAttribute() Jjaa filterJjaa,
			@ModelAttribute() Pagination pagination) {
		if (!Y41bUtils.esNullOCadenaVacia(filterJjaa.getJanombre())) {
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();
			if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
				filterJjaa.getOrganismo().setNombreEs(filterJjaa.getJanombre());
			} else if (Y41bConstantes.EUSKERA.equalsIgnoreCase(idioma)) {
				filterJjaa.getOrganismo().setNombreEu(filterJjaa.getJanombre());
			}
		}
		List<Jjaa> jjaas = this.jjaaService.findAll(filterJjaa, pagination);
		Long recordNum = this.jjaaService.findAllCount(filterJjaa);
		JjaaController.logger.info("[GET - jqGrid] : Obtener Jjaa");
		return new JQGridJSONModel(pagination, recordNum, jjaas);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param jacodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/mod/{jacodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormTabs(@PathVariable() String jacodigo,
			Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			model.addAttribute("jacodigo", jacodigo);
			model.addAttribute("modo", Y41bConstantes.MODO_POPUP_MODIFICACION);
			return new ModelAndView("jjaaTabs", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/alta", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			model.addAttribute("jacodigo", "0");
			model.addAttribute("modo", Y41bConstantes.MODO_POPUP_ALTA);
			return new ModelAndView("jjaaTabs", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param jacodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/detalle/{jacodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormDetalle(@PathVariable() String jacodigo,
			Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			model.addAttribute("jacodigo", jacodigo);
			if ("0".equals(jacodigo)) {
				model.addAttribute("modo", Y41bConstantes.MODO_POPUP_ALTA);
			} else {
				model.addAttribute("modo",
						Y41bConstantes.MODO_POPUP_MODIFICACION);
			}
			return new ModelAndView("jjaaDetalle", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param jacodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/personal/{jacodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormPersonal(@PathVariable() String jacodigo,
			Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null
				|| censoMonitor.getPerfilMaestros().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			model.addAttribute("jacodigo", jacodigo);
			if ("0".equals(jacodigo)) {
				model.addAttribute("modo", Y41bConstantes.MODO_POPUP_ALTA);
			} else {
				model.addAttribute("modo",
						Y41bConstantes.MODO_POPUP_MODIFICACION);
			}
			return new ModelAndView("jjaaPersonal", "model", model);
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param jacodigo
	 *            String
	 * @return long
	 */
	@RequestMapping(value = "/existe/{jacodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	long existe(@PathVariable() String jacodigo) {
		Jjaa jjaa = new Jjaa();
		jjaa.setJacodigo(jacodigo);
		return this.jjaaService.findAllCount(jjaa);
	}

	/**
	 * Method 'getAllExcel'.
	 * 
	 * @param filterJjaa
	 *            Jjaa
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excel", method = RequestMethod.GET)
	public void getAllExcel(@ModelAttribute() Jjaa filterJjaa,
			HttpServletRequest request, HttpServletResponse response) {
		try {
			if (!Y41bUtils.esNullOCadenaVacia(filterJjaa.getJanombre())) {
				Locale locale = LocaleContextHolder.getLocale();
				String idioma = locale.getLanguage();
				if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
					filterJjaa.getOrganismo().setNombreEs(
							filterJjaa.getJanombre());
				} else if (Y41bConstantes.EUSKERA.equalsIgnoreCase(idioma)) {
					filterJjaa.getOrganismo().setNombreEu(
							filterJjaa.getJanombre());
				}
			}

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy,
					"yyyyMMddHHmmss");
			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_OOEE + fechaActual + ".xls";
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ StringEscapeUtils.unescapeHtml(nombre) + "\"");

			String xslString = this.y41bExcelGeneratorService
					.getJjaaExcel(filterJjaa);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "seleccionJjaa", method = RequestMethod.GET)
	public ModelAndView getCreateFormModal(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusquedaJjaa",
				Y41bConstantes.MODO_POPUP_SELECCION);

		return new ModelAndView("jjaaSeleccion", "model", model);
	}

}
