package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41b.service.InspeccionService;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.ConsumidorDetalle;
import com.ejie.y41b.model.EstablecimientoDetalle;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.service.ArbexpService;
import com.ejie.y41b.service.DenunciaService;
import com.ejie.y41b.service.IntervinientesService;
import com.ejie.y41b.service.SanexpService;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * IntervinientesController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/intervinientes")
@SessionAttributes({ "tramiteComun" })
public class IntervinientesController {

	private static final Logger logger = LoggerFactory
			.getLogger(IntervinientesController.class);

	@Autowired
	private IntervinientesService intervinientesService;

	@Autowired
	private DenunciaService denunciaService;

	@Autowired
	private InspeccionService inspeccionService;

	@Autowired
	private SanexpService sanexpService;

	@Autowired
	private ArbexpService arbexpService;

	@Autowired
	private Properties appConfiguration;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateFormAlta'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param idExpediente
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintAlta/{codProcedimiento}/{idExpediente}", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(
			@PathVariable String codProcedimiento,
			@PathVariable String idExpediente, Model model) {

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(idExpediente);

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);

		tramiteComun.setTipoProcedimiento(tipoProcedimiento);

		model.addAttribute("tramiteComun", tramiteComun);

		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));
		return new ModelAndView("intervinientes", "model", model);
	}

	/**
	 * Method 'getCreateFormAlta'.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param sacodigo
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "altaArb/{codProcedimiento}", method = RequestMethod.GET)
	public ModelAndView getCreateFormAltaArb(
			@PathVariable() String codProcedimiento,
			@RequestParam(value = "sacodigo", required = true) String sacodigo,
			Model model) {

		TramiteComun tramiteComun = new TramiteComun();
		tramiteComun.setIdExpediente(sacodigo);

		TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
		tipoProcedimiento.setPcodigo(codProcedimiento);

		tramiteComun.setTipoProcedimiento(tipoProcedimiento);

		model.addAttribute("tramiteComun", tramiteComun);

		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));
		return new ModelAndView("intervinientes", "model", model);
	}

	/**
	 * Method 'addInterviniente'.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param tramiteComun
	 *            TramiteComun
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return Intervinientes
	 */
	@RequestMapping(value = "/guardarInterviniente", method = RequestMethod.POST)
	public @ResponseBody
	Intervinientes addInterviniente(@RequestBody Intervinientes intervinientes,
			@ModelAttribute(value = "tramiteComun") TramiteComun tramiteComun,
			HttpServletRequest request) {
		try {

			CensoMonitor censoMonitor = (CensoMonitor) request
					.getSession(false).getAttribute(
							Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			TipoProcedimiento tipoProcedimiento = tramiteComun
					.getTipoProcedimiento();
			intervinientes.setIdExpediente(tramiteComun.getIdExpediente());
			if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
				// Se da de alta el interviniente
				this.denunciaService.addInterviniente(intervinientes);
			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_SANCIONES)) {
				/*
				 * if (intervinientes.getTipoInterviniente().equals(
				 * Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO)) { throw new
				 * Y41bUDAException( "sanciones.error.otroSancionadoNo", true,
				 * null); }
				 */
				// Se da de alta el interviniente
				this.sanexpService.addInterviniente(intervinientes,
						censoMonitor);
			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_ARBITRAJE)) {
				this.arbexpService.addInterviniente(intervinientes,
						censoMonitor);
			} else if (tipoProcedimiento != null
					&& tipoProcedimiento.getPcodigo() != null
					&& tipoProcedimiento.getPcodigo().equals(
							Y41bConstantes.TIPO_PROC_INSPECCIONES)) {
				// Se da de alta el interviniente
				this.inspeccionService.addInterviniente(intervinientes);
			}
			IntervinientesController.logger.info("Entity correctly inserted!");
			return intervinientes;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.intervinientes", true, e);
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param pcodigo
	 *            String
	 * @param idinterviniente
	 *            String
	 * @param idExpediente
	 *            String
	 * 
	 * @return intervinientes
	 */
	@RequestMapping(value = "/eliminar/{pcodigo}/{idExpediente}/{idinterviniente}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Intervinientes remove(@PathVariable String idinterviniente,
			@PathVariable String pcodigo, @PathVariable String idExpediente) {

		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdinterviniente(idinterviniente);
		intervinientes.setIdExpediente(idExpediente);

		if (pcodigo != null
				&& pcodigo.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {

			// Se da de alta el interviniente
			this.denunciaService.removeInterviniente(intervinientes);

		} else if (pcodigo != null
				&& pcodigo.equals(Y41bConstantes.TIPO_PROC_SANCIONES)) {

			Saninterv sanInterv = new Saninterv();
			sanInterv.setUaidinterv(new BigDecimal(idinterviniente));
			this.sanexpService.removeInterviniente(sanInterv);
		} else if (pcodigo != null
				&& pcodigo.equals(Y41bConstantes.TIPO_PROC_ARBITRAJE)) {

			Arbinterv arbInterv = new Arbinterv();
			arbInterv.setUaidinterv(new BigDecimal(idinterviniente));
			this.arbexpService.removeInterviniente(arbInterv);
		} else if (pcodigo != null
				&& pcodigo.equals(Y41bConstantes.TIPO_PROC_INSPECCIONES)) {

			// Se da de alta el interviniente
			this.inspeccionService.removeInterviniente(intervinientes);

		}

		IntervinientesController.logger
				.info("[DELETE] : Intervinientes borrado correctamente");
		return intervinientes;
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idExpediente
	 *            String
	 * @param dtcodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/detalleConsumidor/{idExpediente}/{dtcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	ConsumidorDetalle getConsumidorById(@PathVariable String idExpediente,
			@PathVariable String dtcodigo) {
		try {

			Intervinientes intervinien = new Intervinientes();
			intervinien.setDtcodigo(dtcodigo);
			intervinien.setIdExpediente(idExpediente);

			ConsumidorDetalle consumidorDetalle = this.denunciaService
					.findIntervinienteConsumidor(intervinien);
			if (consumidorDetalle == null) {
				throw new Exception(dtcodigo.toString());
			}
			return consumidorDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(dtcodigo.toString());
		}
	}

	/**
	 * Method 'getIntervinienteConsumidor'.
	 * 
	 * @param idinterviniente
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/detalleIntervinienteConsumidor/{idinterviniente}", method = RequestMethod.GET)
	public @ResponseBody
	ConsumidorDetalle getIntervinienteConsumidor(
			@PathVariable String idinterviniente) {
		try {

			Intervinientes intervinien = new Intervinientes();
			intervinien.setIdinterviniente(idinterviniente);

			ConsumidorDetalle consumidorDetalle = this.intervinientesService
					.findIntervinienteConsumidor(intervinien);
			if (consumidorDetalle == null) {
				throw new Exception(idinterviniente.toString());
			}
			return consumidorDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(idinterviniente.toString());
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idExpediente
	 *            String
	 * @param escodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/detalleEstablecimiento/{idExpediente}/{escodigo}", method = RequestMethod.GET)
	public @ResponseBody
	EstablecimientoDetalle getEstablecimientoById(
			@PathVariable String idExpediente, @PathVariable String escodigo) {
		try {
			Intervinientes intervinien = new Intervinientes();
			intervinien.setEscodigo(escodigo);
			intervinien.setIdExpediente(idExpediente);

			EstablecimientoDetalle establecimientoDetalle = this.denunciaService
					.findIntervinienteEstablecimiento(intervinien);
			if (establecimientoDetalle == null) {
				throw new Exception(escodigo.toString());
			}
			return establecimientoDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(escodigo.toString());
		}
	}

	/**
	 * Method 'getIntervinienteEstablecimiento'.
	 * 
	 * @param idinterviniente
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/detalleIntervinienteEstablecimiento/{idinterviniente}", method = RequestMethod.GET)
	public @ResponseBody
	EstablecimientoDetalle getIntervinienteEstablecimiento(
			@PathVariable String idinterviniente) {
		try {

			Intervinientes intervinien = new Intervinientes();
			intervinien.setIdinterviniente(idinterviniente);

			EstablecimientoDetalle establecimientoDetalle = this.intervinientesService
					.findIntervinienteEstablecimiento(intervinien);
			if (establecimientoDetalle == null) {
				throw new Exception(idinterviniente.toString());
			}
			return establecimientoDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(idinterviniente.toString());
		}
	}

	/**
	 * Method 'getEstablecimientoResponsableById'.
	 * 
	 * @param idExpediente
	 *            String
	 * @param escodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/detalleEstablecimientoResponsable/{idExpediente}/{escodigo}", method = RequestMethod.GET)
	public @ResponseBody
	EstablecimientoDetalle getEstablecimientoResponsableById(
			@PathVariable String idExpediente, @PathVariable String escodigo) {
		try {
			Intervinientes intervinien = new Intervinientes();
			intervinien.setEscodigo(escodigo);
			intervinien.setIdExpediente(idExpediente);

			EstablecimientoDetalle establecimientoDetalle = this.inspeccionService
					.findIntervinienteEstablecimientoResponsable(intervinien);
			if (establecimientoDetalle == null) {
				throw new Exception(escodigo.toString());
			}
			return establecimientoDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(escodigo.toString());
		}
	}

	/**
	 * Method 'getEstablecimientoVisitadoById'.
	 * 
	 * @param idExpediente
	 *            String
	 * @param escodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/detalleEstablecimientoVisitado/{idExpediente}/{escodigo}", method = RequestMethod.GET)
	public @ResponseBody
	EstablecimientoDetalle getEstablecimientoVisitadoById(
			@PathVariable String idExpediente, @PathVariable String escodigo) {
		try {
			Intervinientes intervinien = new Intervinientes();
			intervinien.setEscodigo(escodigo);
			intervinien.setIdExpediente(idExpediente);

			EstablecimientoDetalle establecimientoDetalle = this.inspeccionService
					.findIntervinienteEstablecimientoVisitado(intervinien);
			if (establecimientoDetalle == null) {
				throw new Exception(escodigo.toString());
			}
			return establecimientoDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(escodigo.toString());
		}
	}
}
