package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.InstructorService;
import com.ejie.y41b.utils.exception.Y41bUDAException;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.Instructor;

/**
 * InstructorController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/instructor")
public class InstructorController {

	private static final Logger logger = LoggerFactory
			.getLogger(InstructorController.class);

	@Autowired
	private InstructorService instructorService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		InstructorController.logger.info("[GET - View] : instructor");
		return "instructor";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param itcodigo
	 *            String
	 * @return instructor Instructor
	 */
	@RequestMapping(value = "/{itcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Instructor getById(@PathVariable String itcodigo) {
		Instructor instructor = new Instructor();
		instructor.setItcodigo(itcodigo);
		instructor = this.instructorService.find(instructor);
		InstructorController.logger
				.info("[GET - findBy_PK] : Obtener Instructor por PK");
		return instructor;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterInstructor
	 *            Instructor
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Instructor> getAll(@ModelAttribute Instructor filterInstructor) {
		InstructorController.logger
				.info("[GET - find_ALL] : Obtener Instructor por filtro");
		try {
			return this.instructorService.findAll(filterInstructor, null);
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("Error producido en getAll: " + e.getMessage(), e);
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param instructor
	 *            Instructor
	 * @return Instructor
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Instructor edit(@RequestBody Instructor instructor) {
		Instructor instructorAux = this.instructorService.update(instructor);
		InstructorController.logger
				.info("[PUT] : Instructor actualizado correctamente");
		return instructorAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param instructor
	 *            Instructor
	 * @return Instructor
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Instructor add(@RequestBody Instructor instructor) {
		Instructor instructorAux = this.instructorService.add(instructor);
		InstructorController.logger
				.info("[POST] : Instructor insertado correctamente");
		return instructorAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param itcodigo
	 *            String
	 * @return instructor
	 */
	@RequestMapping(value = "/{itcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Instructor remove(@PathVariable String itcodigo) {
		Instructor instructor = new Instructor();
		instructor.setItcodigo(itcodigo);
		this.instructorService.remove(instructor);
		InstructorController.logger
				.info("[DELETE] : Instructor borrado correctamente");
		return instructor;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param instructorIds
	 *            List
	 * @return instructorList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> instructorIds) {
		List<Instructor> instructorList = new ArrayList<Instructor>();
		for (List<String> instructorId : instructorIds) {
			Iterator<String> iterator = instructorId.iterator();
			Instructor instructor = new Instructor(); // NOPMD - Objeto nuevo en
														// la
			// lista (parametro del
			// servicio)
			instructor.setItcodigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			instructorList.add(instructor);
		}
		this.instructorService.removeMultiple(instructorList);
		InstructorController.logger
				.info("[POST - DELETE_ALL] : Instructor borrados correctamente");
		return instructorIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterInstructor
	 *            Instructor
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Instructor filterInstructor,
			@ModelAttribute Pagination pagination) {
		List<Instructor> instructors = this.instructorService.findAll(
				filterInstructor, pagination);
		Long recordNum = this.instructorService.findAllCount(filterInstructor);
		InstructorController.logger.info("[GET - jqGrid] : Obtener Instructor");
		return new JQGridJSONModel(pagination, recordNum, instructors);
	}

}
