package com.ejie.y41b.control;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.rowset.serial.SerialBlob;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.xpath.XPathAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.adapter.Y41bDokusiAdapterService;
import com.ejie.y41b.adapter.Y41bPifAdapterService;
import com.ejie.y41b.adapter.Y41bPlateaAdapterService;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Acta;
import com.ejie.y41b.model.ActaNueva;
import com.ejie.y41b.model.Actdec;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.AdjunInfraccHechoDenun;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Arbadhdoc;
import com.ejie.y41b.model.Arbdoctemp;
import com.ejie.y41b.model.BusquedaInspeccion;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.ComunicacionSoivre;
import com.ejie.y41b.model.DetalleConstatacion;
import com.ejie.y41b.model.DetalleDocumentos;
import com.ejie.y41b.model.DetalleInfraccion;
import com.ejie.y41b.model.DetalleMuestra;
import com.ejie.y41b.model.DetalleProtocolo;
import com.ejie.y41b.model.DocumentoExpediente;
import com.ejie.y41b.model.DocumentoHechoDetalle;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.InspeccionDetalle;
import com.ejie.y41b.model.InspeccionEnvios;
import com.ejie.y41b.model.InspeccionMovilidad;
import com.ejie.y41b.model.InspeccionesPropBandeja;
import com.ejie.y41b.model.InspeccionesTipoDocumento;
import com.ejie.y41b.model.Intervinientes;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.model.Perfil;
import com.ejie.y41b.model.PlantillaInspeccionDetalle;
import com.ejie.y41b.model.PosibleTramite;
import com.ejie.y41b.model.ProtocoloInspeccion;
import com.ejie.y41b.model.Sandoctemp;
import com.ejie.y41b.model.SolicitudCambioInstructor;
import com.ejie.y41b.model.TipProtocolo;
import com.ejie.y41b.model.TipoDocumento;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteGenerico;
import com.ejie.y41b.model.TramiteHechoDetalleKnet;
import com.ejie.y41b.model.TramiteInspeccionDetalle;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.model.dokusi.User;
import com.ejie.y41b.model.platea.Procedure;
import com.ejie.y41b.nshf.SignCertificateType;
import com.ejie.y41b.service.ActaNuevaService;
import com.ejie.y41b.service.ActaService;
import com.ejie.y41b.service.ActuacionService;
import com.ejie.y41b.service.AdjunInfraccHechoDenunService;
import com.ejie.y41b.service.AdjuntardocsService;
import com.ejie.y41b.service.ComunicacionSoivreService;
import com.ejie.y41b.service.DenunciaService;
import com.ejie.y41b.service.InspeccionService;
import com.ejie.y41b.service.InspeccionesPropBandejaService;
import com.ejie.y41b.service.InspeccionesTipoDocumentoService;
import com.ejie.y41b.service.InstramexpService;
import com.ejie.y41b.service.IntervinientesService;
import com.ejie.y41b.service.ParametrosService;
import com.ejie.y41b.service.PosibleTramiteService;
import com.ejie.y41b.service.SoltramexpService;
import com.ejie.y41b.service.TipPregProtocService;
import com.ejie.y41b.service.TramiteInspeccionService;
import com.ejie.y41b.service.Y41bExcelGeneratorService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.documentos.Y41bDocumento;
import com.ejie.y41b.utils.documentos.Y41bGenerarDocumento;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;
import com.ejie.y41b.utils.fichero.Y41bFicheroUtils;

import sun.misc.BASE64Decoder;

/**
 * InspeccionController  
 * 
 *  
 */
@Controller()
@RequestMapping(value = "/inspeccion")
@SessionAttributes(value = { "actaBusqueda", "inspeccionDetalle" })
public class InspeccionController {

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private ActaService actaService;

	@Autowired()
	private InspeccionService inspeccionService;

	@Autowired()
	private ActaNuevaService actaNuevaService;

	@Autowired()
	private Y41bExcelGeneratorService y41bExcelGeneratorService;

	@Autowired()
	private DenunciaService denunciaService;

	@Autowired()
	private ActuacionService actuacionService;

	@Autowired()
	private AdjuntardocsService adjuntardocsService;

	@Autowired()
	private AdjunInfraccHechoDenunService adjunInfraccHechoDenunService;

	@Autowired()
	private InstramexpService instramexpService;

	@Autowired()
	private TramiteInspeccionService tramiteInspeccionService;

	@Autowired
	private PosibleTramiteService posibleTramiteService;

	@Autowired
	private IntervinientesService intervinientesService;

	@Autowired()
	private InspeccionesPropBandejaService inspeccionesPropBandejaService;

	@Autowired()
	private TipPregProtocService tipPregProtocService;

	@Autowired
	private InspeccionesTipoDocumentoService inspeccionesTipoDocumentoService;

	@Autowired
	private SoltramexpService soltramexpService;

	@Autowired
	private ComunicacionSoivreService comunicacionSoivreService;

	@Autowired
	private ParametrosService parametrosService;

	@Autowired()
	private Y41bPlateaAdapterService y41bPlateaAdapterService;

	@Autowired()
	private Y41bDokusiAdapterService y41bDokusiAdapterService;

	@Autowired()
	private Y41bPifAdapterService y41bPifAdapterService;

	private static final Logger logger = LoggerFactory.getLogger(InspeccionController.class);

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired()
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(value = Y41bUDAException.class)
	public @ResponseBody() void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Metodo que evita que la llamada a 'inspeccionesBusquedaConPrecarga'
	 * devuelva una excepcion variable de sesion. Si no existe, entra aqui y la
	 * crea. Si ya existe, Spring ignora este metodo.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return Campanha
	 */
	@ModelAttribute(value = "actaBusqueda")
	public Acta getActa(HttpServletRequest request) {
		return new Acta();
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bSolicitudTramitacionDetalle", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bSolicitudTramitacionDetalle(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilInspecciones() == null || censoMonitor.getPerfilInspecciones().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bSolicitudTramitacionDetalle", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bMovilidad", method = RequestMethod.GET)
	public ModelAndView getCreateFormy41bMovilidad(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilInspecciones() == null || censoMonitor.getPerfilInspecciones().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bMovilidad", "model", model);
		}
	}

	/**
	 * Method 'getByIdTramitacion'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "/tramitacion/{atcodigo}", method = RequestMethod.GET)
	public @ResponseBody() Object getByIdTramitacion(@PathVariable() String atcodigo, HttpServletRequest request) {
		try {

			TramiteInspeccionDetalle tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
			tramiteInspeccionDetalle.setAtcodigo(atcodigo);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<TramiteInspeccionDetalle> tramitesInspeccion = this.inspeccionService
						.findAllTramiteInspeccion(tramiteInspeccionDetalle, pagination);

				if (tramitesInspeccion == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.inspeccionService.findAllTramiteInspeccionCount(tramiteInspeccionDetalle);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(tramitesInspeccion);
				return data;
			} else {
				List<TramiteInspeccionDetalle> tramitesInspeccion = this.inspeccionService
						.findAllTramiteInspeccion(tramiteInspeccionDetalle, pagination);
				if (tramitesInspeccion == null) {
					throw new Exception("No data Found.");
				}
				return tramitesInspeccion;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getDetalleByIdTramitacion'.
	 * 
	 * @param ehcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "/tramitacion/detalle/{ehcodigo}", method = RequestMethod.GET)
	public @ResponseBody() Object getDetalleByIdTramitacion(@PathVariable() String ehcodigo,
			HttpServletRequest request) {
		try {
			TramiteHechoDetalleKnet tramiteHechoDetalleKnet = new TramiteHechoDetalleKnet();
			tramiteHechoDetalleKnet.setEhcodigo(ehcodigo);

			tramiteHechoDetalleKnet = this.inspeccionService.findTramiteHecho(tramiteHechoDetalleKnet);

			if (tramiteHechoDetalleKnet == null) {
				throw new Exception("No data Found. /tramitacion/detalle/{ehcodigo}");
			}
			return tramiteHechoDetalleKnet;

		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found. /tramitacion/detalle/{ehcodigo}");
		}
	}

	/**
	 * Method 'getIntervinientesByHdcodigo'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "/intervinientes/{atcodigo}", method = RequestMethod.GET)
	public @ResponseBody() Object getIntervinientesByHdcodigo(@PathVariable() String atcodigo,
			HttpServletRequest request) {
		try {

			Intervinientes intervinientes = new Intervinientes();
			intervinientes.setIdExpediente(atcodigo);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Intervinientes> listaIntervinientes = this.denunciaService.findAllIntervinientes(intervinientes,
						pagination);

				if (listaIntervinientes == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.denunciaService.findAllIntervinientesCount(intervinientes);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listaIntervinientes);
				return data;
			} else {
				List<Intervinientes> listaIntervinientes = this.denunciaService.findAllIntervinientes(intervinientes,
						pagination);
				if (listaIntervinientes == null) {
					throw new Exception("No data Found.");
				}
				return listaIntervinientes;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found. /denuncia/intervinientes/{hdcodigo}");
		}
	}

	/**
	 * Method 'getDocsByAtcodigo'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "/documentosInspeccion/{atcodigo}", method = RequestMethod.GET)
	public @ResponseBody() Object getDocsByAtcodigo(@PathVariable() String atcodigo, HttpServletRequest request) {
		try {

			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdExpediente(atcodigo);
			TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
			tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
			tramiteComun.setTipoProcedimiento(tipoProcedimiento);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<DocumentoExpediente> documentosExpediente = this.instramexpService
						.findAllDocumentosHecho(tramiteComun, pagination);

				if (documentosExpediente == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.instramexpService.findAllDocumentosHechoCount(tramiteComun);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(documentosExpediente);
				return data;
			} else {
				List<DocumentoExpediente> documentosExpediente = this.instramexpService
						.findAllDocumentosHecho(tramiteComun, pagination);
				if (documentosExpediente == null) {
					throw new Exception("No data Found.");
				}
				return documentosExpediente;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'y41bTabsBusquedaResultadoInspecciones'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "y41bTabsBusquedaResultadoInspecciones/y41bAltaInspeccion", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bAltaInspeccion(Model model, HttpServletRequest request) {

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("estadoInspeccion", Y41bConstantes.MODO_POPUP_ALTA);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilInspecciones() == null || censoMonitor.getPerfilInspecciones().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bInspeccionDetalle", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormY41bAltaInspeccionInspeccion'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "y41bTabsInspeccion/y41bTabsAltaInspeccion", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bAltaInspeccionInspeccion(Model model, HttpServletRequest request) {

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		model.addAttribute("inspeccionDetalle", new InspeccionDetalle());

		if (censoMonitor.getPerfilInspecciones() == null || censoMonitor.getPerfilInspecciones().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bTabsInspeccionDetalle", "model", model);
		}
	}

	/**
	 * Method 'getY41bAltaInspeccionInspeccionGrabar'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "y41bTabsInspeccion/y41bTabsInspeccionGrabar", method = RequestMethod.POST)
	public @ResponseBody() Object getY41bAltaInspeccionInspeccionGrabar(HttpServletRequest request) {
		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		InspeccionDetalle inspeccionDetalle = this.parseRequestFormularioInspecciones(request, censoMonitor);
		inspeccionDetalle.setAccoor(censoMonitor.getOrganismo().getCodOrg());

		try {
			inspeccionDetalle = this.inspeccionService.addInspeccion(inspeccionDetalle);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(inspeccionDetalle.getAtcodigo());
		actuacion = this.actuacionService.find(actuacion);

		if (Y41bConstantes.PERFIL_INSTRUCTOR.equals(censoMonitor.getPerfilInspecciones().getIdPerfil())) {
			List<Acta> actas = new ArrayList<Acta>();
			Acta acta = actuacion.getActa();
			acta.setAccomo(censoMonitor.getMocodigo());
			actas.add(acta);
			this.actaService.updateInspector(actas, censoMonitor);
		}

		return inspeccionDetalle;
	}

	/**
	 * Method 'getCreateFormY41bModificacionInspeccion'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "y41bTabsBusquedaResultadoInspecciones/y41bModificacionInspeccion/{atcodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bModificacionInspeccionResultado(Model model, HttpServletRequest request,
			@PathVariable() String atcodigo) {

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(atcodigo);

		model.addAttribute("atcodigo", atcodigo);
		model.addAttribute("estadoInspeccion", Y41bConstantes.MODO_POPUP_MODIFICACION);

		Actuacion actuacionaux = new Actuacion();
		actuacionaux.setAtcodigo(atcodigo);

		InspeccionDetalle inspeccionDetalle = this.actaService.findInspeccion(actuacion, censoMonitor);

		// Si es inspeccion vieja, la redirige a la url correcta.
		if (!Y41bConstantes.VALOR_SI.equals(inspeccionDetalle.getIskontsumobide())) {
			return new ModelAndView(
					"redirect:/inspeccion/y41bTabsBusquedaResultadoInspecciones/y41bTabsInspeccionesDetalleAntiguas/"
							+ atcodigo);
		}

		model.addAttribute("inspeccionDetalle", inspeccionDetalle);
		httpSession.setAttribute("desde", Y41bConstantes.DESDE_BUSQUEDA);

		if (censoMonitor.getPerfilInspecciones() == null || censoMonitor.getPerfilInspecciones().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bInspeccionDetalle", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormY41bModificacionInspeccion'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "y41bTabsBusquedaResultadoInspecciones/y41bModificacionInspeccionSinCabecera/{atcodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bModificacionInspeccionResultadoSinCabecera(Model model,
			HttpServletRequest request, @PathVariable() String atcodigo) {

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(atcodigo);

		model.addAttribute("atcodigo", atcodigo);
		model.addAttribute("estadoInspeccion", Y41bConstantes.MODO_POPUP_MODIFICACION);

		Actuacion actuacionaux = new Actuacion();
		actuacionaux.setAtcodigo(atcodigo);

		InspeccionDetalle inspeccionDetalle = this.actaService.findInspeccion(actuacion, censoMonitor);

		// Si es inspeccion vieja, la redirige a la url correcta.
		if (!Y41bConstantes.VALOR_SI.equals(inspeccionDetalle.getIskontsumobide())) {
			return new ModelAndView(
					"redirect:/inspeccion/y41bTabsBusquedaResultadoInspecciones/y41bTabsInspeccionesDetalleAntiguas/"
							+ atcodigo);
		}

		model.addAttribute("inspeccionDetalle", inspeccionDetalle);
		httpSession.setAttribute("desde", Y41bConstantes.DESDE_BUSQUEDA);

		if (censoMonitor.getPerfilInspecciones() == null || censoMonitor.getPerfilInspecciones().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bInspeccionDetalleSinCabecera", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormY41bModificacionInspeccion'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "y41bTabsModificacionInspeccion/{atcodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bModificacionInspeccion(Model model, HttpServletRequest request,
			@PathVariable() String atcodigo) {

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(atcodigo);

		model.addAttribute("atcodigo", atcodigo);
		model.addAttribute("estadoInspeccion", Y41bConstantes.MODO_POPUP_MODIFICACION);

		Actuacion actuacionaux = new Actuacion();
		actuacionaux.setAtcodigo(atcodigo);

		InspeccionDetalle inspeccionDetalle = this.actaService.findInspeccion(actuacion, censoMonitor);

		model.addAttribute("inspeccionDetalle", inspeccionDetalle);
		httpSession.setAttribute("desde", Y41bConstantes.DESDE_INICIO);

		if (censoMonitor.getPerfilInspecciones() == null || censoMonitor.getPerfilInspecciones().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bInspeccionDetalle", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormY41bModificacionInspeccionSinCabecera'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "y41bTabsModificacionInspeccionSinCabecera/{atcodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bModificacionInspeccionSinCabecera(Model model, HttpServletRequest request,
			@PathVariable() String atcodigo) {

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(atcodigo);

		model.addAttribute("atcodigo", atcodigo);
		model.addAttribute("estadoInspeccion", Y41bConstantes.MODO_POPUP_MODIFICACION);

		Actuacion actuacionaux = new Actuacion();
		actuacionaux.setAtcodigo(atcodigo);

		InspeccionDetalle inspeccionDetalle = this.actaService.findInspeccion(actuacion, censoMonitor);

		model.addAttribute("inspeccionDetalle", inspeccionDetalle);
		httpSession.setAttribute("desde", Y41bConstantes.DESDE_BANDEJA);

		if (censoMonitor.getPerfilInspecciones() == null || censoMonitor.getPerfilInspecciones().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bInspeccionDetalleSinCabecera", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormY41bModificacionInspeccionInspeccion'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "y41bTabsModificacionInspeccion/y41bTabsModificacionInspeccion/{atcodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bModificacionInspeccionInspeccion(Model model, HttpServletRequest request,
			@PathVariable() String atcodigo) {

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilInspecciones() == null || censoMonitor.getPerfilInspecciones().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bTabsInspeccionDetalle", "model", model);
		}
	}

	/**
	 * Method 'getByIdInspeccion'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return inspeccionDetalle InspeccionDetalle
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "/findInspeccion/{atcodigo}", method = RequestMethod.GET)
	public @ResponseBody() InspeccionDetalle getByIdInspeccion(@PathVariable() String atcodigo,
			HttpServletRequest request) throws Exception {
		try {

			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(atcodigo);

			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			InspeccionDetalle inspeccionDetalle = this.actaService.findInspeccion(actuacion, censoMonitor);

			return inspeccionDetalle;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getCreateFormY41bModificacionInspeccionInspeccionGrabar'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 * @throws Exception
	 *             excepcion
	 */
	@RequestMapping(value = "y41bTabsModificacionInspeccion/y41bTabsModificacionInspeccionGrabar/{atcodigo}", method = RequestMethod.POST)
	public @ResponseBody() Object getCreateFormY41bModificacionInspeccionInspeccionGrabar(HttpServletRequest request,
			@PathVariable() String atcodigo) throws Exception {
		HttpSession httpSession = request.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		InspeccionDetalle inspeccionDetalle = this.parseRequestFormularioInspecciones(request, censoMonitor);
		inspeccionDetalle.setAtcodigo(atcodigo);

		return this.inspeccionService.updateInspeccion(inspeccionDetalle);
	}

	/**
	 * Recoge los datos del formulario de una Inspeccion y los transforma en un
	 * objeto.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return InspeccionDetalle
	 */
	private InspeccionDetalle parseRequestFormularioInspecciones(HttpServletRequest request,
			CensoMonitor censoMonitor) {

		InspeccionDetalle inspeccionDetalle = new InspeccionDetalle();
		// Cabecera acta
		Locale locale = LocaleContextHolder.getLocale();
		inspeccionDetalle.setAdcoor(censoMonitor.getOrganismo().getCodOrg());

		inspeccionDetalle.setAccoor(request.getParameter("accoor"));

		if (request.getParameter("acnran") != null && !request.getParameter("acnran").equals("")) {
			inspeccionDetalle.setAcnran(new BigDecimal(request.getParameter("acnran")));
		}

		inspeccionDetalle.setAcnror(request.getParameter("acnror"));

		Date acfere = null;
		try {
			acfere = Y41bUtils.parseDate(request.getParameter("acfere"), locale);
		} catch (Exception e) {

			e.printStackTrace();
		}
		inspeccionDetalle.setAcfere(acfere);

		// establecimiento responsable
		inspeccionDetalle.setAtcoes(request.getParameter("escodigo"));

		// forma de notificacion resp
		inspeccionDetalle.setAtformanotifestablecimientore(request.getParameter("atformanotifestablecimientore"));

		// forma de notificar a
		inspeccionDetalle.setAtdestnotificaresponsable(request.getParameter("atdestnotificaresponsable"));

		// establecimiento visitado
		inspeccionDetalle.setAccoes(request.getParameter("escodigoVisitado"));

		inspeccionDetalle.setAtformanotifestablecimientovi(request.getParameter("atformanotifestablecimientovi"));

		inspeccionDetalle.setAtidiomaestablecimientovi(request.getParameter("atidiomaestablecimientovi"));

		// forma de notificacion visitado
		inspeccionDetalle.setAtformanotifestablecimientovi(request.getParameter("atformanotifestablecimientovi"));

		// forma de notificar a
		inspeccionDetalle.setAtdestnotificavisitado(request.getParameter("atdestnotificavisitado"));

		// unidades
		BigDecimal udestruidas = null;
		BigDecimal devolucion = null;
		BigDecimal existentes = null;
		BigDecimal inmovilizadas = null;
		BigDecimal librecomercializacion = null;
		BigDecimal otros = null;
		BigDecimal recuperadas = null;
		BigDecimal pendientes = null;

		if (request.getParameter("atudestruidas") != null && !request.getParameter("atudestruidas").equals("")) {
			udestruidas = new BigDecimal(request.getParameter("atudestruidas"));
		}

		if (request.getParameter("atudevolucionorigen") != null
				&& !request.getParameter("atudevolucionorigen").equals("")) {
			devolucion = new BigDecimal(request.getParameter("atudevolucionorigen"));
		}

		if (request.getParameter("atuexistentes") != null && !request.getParameter("atuexistentes").equals("")) {
			existentes = new BigDecimal(request.getParameter("atuexistentes"));
		}

		if (request.getParameter("atuinmovilizadas") != null && !request.getParameter("atuinmovilizadas").equals("")) {
			inmovilizadas = new BigDecimal(request.getParameter("atuinmovilizadas"));
		}

		if (request.getParameter("atulibrecomercializacion") != null
				&& !request.getParameter("atulibrecomercializacion").equals("")) {
			librecomercializacion = new BigDecimal(request.getParameter("atulibrecomercializacion"));
		}

		if (request.getParameter("atuotros") != null && !request.getParameter("atuotros").equals("")) {
			otros = new BigDecimal(request.getParameter("atuotros"));
		}

		if (request.getParameter("aturecuperadas") != null && !request.getParameter("aturecuperadas").equals("")) {
			recuperadas = new BigDecimal(request.getParameter("aturecuperadas"));
		}

		if (request.getParameter("atupendientes") != null && !request.getParameter("atupendientes").equals("")) {
			pendientes = new BigDecimal(request.getParameter("atupendientes"));
		}

		inspeccionDetalle.setAtudestruidas(udestruidas);
		inspeccionDetalle.setAtudevolucionorigen(devolucion);
		inspeccionDetalle.setAtuexistentes(existentes);
		inspeccionDetalle.setAtuinmovilizadas(inmovilizadas);
		inspeccionDetalle.setAtulibrecomercializacion(librecomercializacion);
		inspeccionDetalle.setAtuotros(otros);
		inspeccionDetalle.setAturecuperadas(recuperadas);
		inspeccionDetalle.setAtupendientes(pendientes);

		// Producto servicio
		inspeccionDetalle.setAtcops(request.getParameter("ps"));
		inspeccionDetalle.setPscodigo(request.getParameter("ps"));
		inspeccionDetalle.setAtcopsnom(request.getParameter("productoPsnombre"));
		inspeccionDetalle.setAtcops(request.getParameter("ps"));

		inspeccionDetalle.setAtnoprse(request.getParameter("atnoprse"));
		inspeccionDetalle.setAtnomaps(request.getParameter("atnomaps"));
		inspeccionDetalle.setAtnomops(request.getParameter("atnomops"));
		inspeccionDetalle.setAtnrlops(request.getParameter("atnrlops"));
		inspeccionDetalle.setAtcodigobarras(request.getParameter("atcodigobarras"));
		Date atfedumi = null;
		try {
			atfedumi = Y41bUtils.parseDate(request.getParameter("atfedumi"), locale);
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
		inspeccionDetalle.setAtfedumi(atfedumi);

		Date atfefin = null;
		try {
			atfefin = Y41bUtils.parseDate(request.getParameter("atfefin"), locale);
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
		inspeccionDetalle.setAtfefin(atfefin);

		inspeccionDetalle.setAccodexpedienteorigen(request.getParameter("accodexpedienteorigen"));
		inspeccionDetalle.setAccoororigen(request.getParameter("accoororigen"));
		inspeccionDetalle.setActiororigen(request.getParameter("actiororigen"));
		inspeccionDetalle.setAcincumplimiento(request.getParameter("acincumplimiento"));

		inspeccionDetalle.setOrganismoCambio(request.getParameter("organismoCambio"));
		inspeccionDetalle.setEstablecimientoResponsableCambio(request.getParameter("establecimientoResponsableCambio"));
		inspeccionDetalle.setEstablecimientoVisitadoCambio(request.getParameter("establecimientoVisitadoCambio"));

		inspeccionDetalle.setAtonline(request.getParameter("atonline"));

		if (request.getParameter("atatablet").equalsIgnoreCase(Y41bConstantes.VALOR_SI)) {
			inspeccionDetalle.setAtatablet(Y41bConstantes.VALOR_SI);
		}

		return inspeccionDetalle;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/removeInspeccion/{atcodigo}", method = RequestMethod.DELETE)
	public void removeInspeccion(@PathVariable String atcodigo, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			InspeccionDetalle inspeccionDetalle = new InspeccionDetalle();
			inspeccionDetalle.setAtcodigo(atcodigo);
			this.inspeccionService.removeInspeccion(inspeccionDetalle);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			logger.error("Unable to delete " + atcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'copiarExpediente'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/copiarExpediente/{atcodigo}", method = RequestMethod.POST)
	public @ResponseBody() InspeccionDetalle copiarExpediente(@PathVariable() String atcodigo,
			HttpServletRequest request) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			InspeccionDetalle inspeccionDetalle = new InspeccionDetalle();
			inspeccionDetalle.setAtcodigo(atcodigo);

			inspeccionDetalle = this.inspeccionService.copiarInspeccion(inspeccionDetalle, censoMonitor);

			if (inspeccionDetalle == null) {
				throw new Exception("");
			}
			return inspeccionDetalle;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getEnviosByHdcodigo'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "/envios/{atcodigo}", method = RequestMethod.GET)
	public @ResponseBody() Object getEnviosByHdcodigo(@PathVariable() String atcodigo, HttpServletRequest request) {
		try {

			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(atcodigo);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<InspeccionEnvios> listaInspeccionEnvios = this.actuacionService.findAllInspeccionEnvios(actuacion,
						pagination);

				if (listaInspeccionEnvios == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.actuacionService.findAllInspeccionEnviosCount(actuacion);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listaInspeccionEnvios);
				return data;
			} else {
				List<InspeccionEnvios> listaInspeccionEnvios = this.actuacionService.findAllInspeccionEnvios(actuacion,
						pagination);
				if (listaInspeccionEnvios == null) {
					throw new Exception("No data Found.");
				}
				return listaInspeccionEnvios;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found. /denuncia/envios/{hdcodigo}");
		}
	}

	/**
	 * Method 'getInfracciones'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "/infraccionesInspeccion/{atcodigo}", method = RequestMethod.GET)
	public @ResponseBody() Object getInfracciones(@PathVariable() String atcodigo, HttpServletRequest request) {
		try {

			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(atcodigo);

			Pagination pagination = null;
			pagination = new Pagination();
			pagination.setPage(Long.valueOf(request.getParameter("page")));
			pagination.setRows(Long.valueOf(request.getParameter("rows")));
			pagination.setSort(request.getParameter("sidx"));
			pagination.setAscDsc(request.getParameter("sord"));
			List<DetalleInfraccion> detalleInfraccion = this.actaService.findInfracciones(actuacion, pagination, false);
			if (detalleInfraccion == null) {
				throw new Exception("No data Found.");
			}

			Long total = this.actaService.findInfraccionesCount(actuacion);

			JQGridJSONModel data = new JQGridJSONModel();
			data.setPage(request.getParameter("page"));
			data.setRecords(total.intValue());
			data.setTotal(total, pagination.getRows());
			data.setRows(detalleInfraccion);
			return data;

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getCreateFormY41bAltaInspeccionActas'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @return Object
	 */
	@RequestMapping(value = "/y41bTabsInspeccion/y41bTabsInspeccionActas", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bAltaInspeccionActas(Model model, HttpServletRequest request,
			@ModelAttribute(value = "inspeccionDetalle") InspeccionDetalle inspeccionDetalle) {

		model.addAttribute("codActa", Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(inspeccionDetalle.getAtcodigo());
		actuacion = this.actuacionService.find(actuacion);

		model.addAttribute("actuacion", actuacion);

		if (actuacion != null && Y41bUtils.isFilled(actuacion.getAtidcomunicacionsoivre())) {
			ComunicacionSoivre comunicacionSoivre = new ComunicacionSoivre();
			comunicacionSoivre.setIdcomunicacionsoivre(actuacion.getAtidcomunicacionsoivre());
			comunicacionSoivre = this.comunicacionSoivreService.find(comunicacionSoivre);

			model.addAttribute("numUnidadesSoivre", comunicacionSoivre.getV6numunidades());
		} else {
			model.addAttribute("numUnidadesSoivre", "");
		}

		// buscar el interviniente visitado
		Intervinientes intervinientes = new Intervinientes();
		intervinientes.setIdExpediente(inspeccionDetalle.getAtcodigo());
		intervinientes.setTipoInterviniente(Y41bConstantes.TIPO_INTERVINIENTE_ESTABLECIMIENT_VISITADO);

		List<Intervinientes> listIntervinientes = this.intervinientesService.findAll(intervinientes, null);
		if (listIntervinientes.size() > 0) {
			intervinientes = listIntervinientes.get(0);
		}

		model.addAttribute("intervinientes", intervinientes);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilInspecciones() == null || censoMonitor.getPerfilInspecciones().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bTabsActas", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormY41bAltaInspeccionTramitacion'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "y41bTabsInspeccion/y41bTabsInspeccionTramitacion", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bAltaInspeccionTramitacion(Model model, HttpServletRequest request) {

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilInspecciones() == null || censoMonitor.getPerfilInspecciones().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bTabsTramitacion", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormY41bAltaInspeccionOtrosDatos'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "y41bTabsInspeccion/y41bTabsInspeccionOtrosDatos", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bAltaInspeccionOtrosDatos(Model model, HttpServletRequest request) {

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilInspecciones() == null || censoMonitor.getPerfilInspecciones().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bTabsOtrosDatos", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormY41bAltaInspeccionProtocolo'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @param atcodigo
	 *            String
	 * @return Object
	 */

	@RequestMapping(value = "y41bTabsInspeccion/y41bTabsInspeccionProtocolo/{atcodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bAltaInspeccionProtocolo(Model model, HttpServletRequest request,
			@PathVariable() String atcodigo) {

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		ActaNueva actaNueva = new ActaNueva();
		actaNueva.setAncodins(atcodigo);
		// actaNueva.setAntipo(Y41bConstantes.ACTA_NUEVA_TIPO_INFRACCION);
		actaNueva.setAnligadoprotocolo(Y41bConstantes.VALOR_SI);

		Long numActaInfraccionProtocolo = this.actaNuevaService.findAllActaInfraccionProtocoloTramitadaCount(actaNueva);

		TramiteInspeccionDetalle tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
		tramiteInspeccionDetalle.setAtcodigo(atcodigo);
		Long numEmisionInformeProtocolo = this.tramiteInspeccionService
				.findAllTramiteEmisionInformeProtocoloTramitadoCount(tramiteInspeccionDetalle);

		if ((numActaInfraccionProtocolo != null && numActaInfraccionProtocolo > 0)
				|| (numEmisionInformeProtocolo != null && numEmisionInformeProtocolo > 0)) {
			model.addAttribute("tieneacta", true);
		}

		if (censoMonitor.getPerfilInspecciones() == null || censoMonitor.getPerfilInspecciones().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bTabsProtocolo", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormY41bTabsBusquedaResultadoInspecciones'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "y41bTabsBusquedaResultadoInspecciones", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bTabsBusquedaResultadoInspecciones(Model model, HttpServletRequest request) {

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilInspecciones() == null || censoMonitor.getPerfilInspecciones().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bTabsBusquedaResultadoInspecciones", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormY41bTabsBusquedaResultadoInspeccionesModal'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "y41bTabsBusquedaResultadoInspeccionesModal", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bTabsBusquedaResultadoInspeccionesModal(Model model,
			HttpServletRequest request) {

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		// precarga de los valores del conectado
		Acta actaBusqueda = new Acta();

		String codOrg = "";

		if (censoMonitor.getOrganismo() != null) {
			codOrg = censoMonitor.getOrganismo().getCodOrg();
		}

		actaBusqueda.setAccoor(codOrg);
		model.addAttribute("actaBusqueda", actaBusqueda);

		if (censoMonitor.getPerfilInspecciones() == null || censoMonitor.getPerfilInspecciones().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bTabsBusquedaResultadoInspeccionesModal", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormY41bTabsBusquedaResultadoInspecciones'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "y41bTabsBusquedaResultadoInspeccionesCon", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bTabsBusquedaResultadoInspeccionesCon(Model model, HttpServletRequest request) {

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		// precarga de los valores del conectado
		Acta actaBusqueda = new Acta();

		String codOrg = "";

		if (censoMonitor.getOrganismo() != null) {
			codOrg = censoMonitor.getOrganismo().getCodOrg();
		}

		actaBusqueda.setAccoor(codOrg);
		model.addAttribute("actaBusqueda", actaBusqueda);

		if (censoMonitor.getPerfilInspecciones() == null || censoMonitor.getPerfilInspecciones().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bTabsBusquedaResultadoInspecciones", "model", model);
		}
	}

	/**
	 * Method 'y41bTabsBusquedaResultadoInspeccionesCon'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "y41bTabsBusquedaResultadoInspeccionesCon/y41bTabBusquedaInspecciones", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bTabBusquedaInspecciones(Model model, HttpServletRequest request) {

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (!model.containsAttribute("actaBusqueda")) {
			// precarga de los valores del conectado
			Acta actaBusqueda = new Acta();

			String codOrg = "";

			if (censoMonitor.getOrganismo() != null) {
				codOrg = censoMonitor.getOrganismo().getCodOrg();
			}

			actaBusqueda.setAccoor(codOrg);
			model.addAttribute("actaBusqueda", actaBusqueda);
		}
		Map<String, Object> modelMap = model.asMap();
		modelMap.get("actaBusqueda");

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		if (censoMonitor.getPerfilInspecciones() == null || censoMonitor.getPerfilInspecciones().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bTabBusquedaInspecciones", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bTabsBusquedaResultadoInspeccionesCon/y41bTabResultadoInspecciones", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bTabResultadoInspecciones(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilInspecciones() == null || censoMonitor.getPerfilInspecciones().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bTabResultadoInspecciones", "model", model);
		}
	}

	/**
	 * Method 'busquedaInspecciones'.
	 * 
	 * @param accoor_
	 *            String
	 * @param acnror_
	 *            String
	 * @param acnran_
	 *            String
	 * @param acfereDesde_
	 *            String
	 * @param acfereHasta_
	 *            String
	 * @param codOrg_
	 *            String
	 * @param mocodigoExpediente_
	 *            String
	 * @param accoororigen_
	 *            String
	 * @param atcocm_
	 *            String
	 * @param atcopg_
	 *            String
	 * @param atcoal_
	 *            String
	 * @param alnran_
	 *            String
	 * @param alnror_
	 *            String
	 * @param atcocr_
	 *            String
	 * @param v6codigo_
	 *            String
	 * @param atfinalizada_
	 *            String
	 * @param decoor_
	 *            String
	 * @param denror_
	 *            String
	 * @param denran_
	 *            String
	 * @param attipo_
	 *            String
	 * @param indUltimoTramite_
	 *            String
	 * @param indPendienteAcuse_
	 *            String
	 * @param indIncluirCerrados_
	 *            String
	 * @param indPendienteDecision_
	 *            String
	 * @param indPendienteFirma_
	 *            String
	 * @param ehfechafinDecisionDesde_
	 *            String
	 * @param ehfechafinDecisionHasta_
	 *            String
	 * @param fcodigo_
	 *            String
	 * @param trcodigo_
	 *            String
	 * @param decodigo_
	 *            String
	 * @param mocodigoTramitador_
	 *            String
	 * @param rpcif_
	 *            String
	 * @param rprazonsocial_
	 *            String
	 * @param rpprovincia_
	 *            String
	 * @param rpmunicipio_
	 *            String
	 * @param rplocalidad_
	 *            String
	 * @param rppais_
	 *            String
	 * @param rpdireccion_
	 *            String
	 * @param escif_
	 *            String
	 * @param esnombre_
	 *            String
	 * @param esprovincia_
	 *            String
	 * @param esmunicipio_
	 *            String
	 * @param eslocalidad_
	 *            String
	 * @param espais_
	 *            String
	 * @param esdireccion_
	 *            String
	 * @param atcops_
	 *            String
	 * @param atnoprse_
	 *            String
	 * @param estRespResidencia_
	 *            String
	 * @param estResidencia_
	 *            String
	 * @param ancodac_
	 *            String
	 * @param accoorganismoorigen_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 * 
	 * @return Object
	 */
	@RequestMapping(value = "/busquedaInspecciones", method = RequestMethod.GET)
	public @ResponseBody() Object getAllInspeccion(
			// general
			@RequestParam(value = "accoor", required = false) String accoor_,
			@RequestParam(value = "acnror", required = false) String acnror_,
			@RequestParam(value = "acnran", required = false) BigDecimal acnran_,
			@RequestParam(value = "acfereDesde", required = false) String acfereDesde_,
			@RequestParam(value = "acfereHasta", required = false) String acfereHasta_,
			@RequestParam(value = "codOrg", required = false) String codOrg_,
			@RequestParam(value = "mocodigoExpediente", required = false) String mocodigoExpediente_,
			@RequestParam(value = "accoororigen", required = false) String accoororigen_,

			// origen
			@RequestParam(value = "atcocm", required = false) String atcocm_,
			@RequestParam(value = "atcopg", required = false) String atcopg_,
			@RequestParam(value = "atcoal", required = false) String atcoal_,
			@RequestParam(value = "alnror", required = false) String alnror_,
			@RequestParam(value = "alnran", required = false) String alnran_,
			@RequestParam(value = "atcocr", required = false) String atcocr_,
			@RequestParam(value = "v6codigo", required = false) String v6codigo_,
			@RequestParam(value = "atfinalizada", required = false) String atfinalizada_,

			@RequestParam(value = "decoor", required = false) String decoor_,
			@RequestParam(value = "denror", required = false) String denror_,
			@RequestParam(value = "denran", required = false) String denran_,

			@RequestParam(value = "attipo", required = false) String attipo_,

			// tramite
			@RequestParam(value = "fcodigo", required = false) String fcodigo_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_,
			@RequestParam(value = "decodigo", required = false) String decodigo_,
			@RequestParam(value = "mocodigoTramitador", required = false) String mocodigoTramitador_,
			@RequestParam(value = "ehfechafinDecisionDesde", required = false) String ehfechafinDecisionDesde_,
			@RequestParam(value = "ehfechafinDecisionHasta", required = false) String ehfechafinDecisionHasta_,

			@RequestParam(value = "indUltimoTramite", required = false) String indUltimoTramite_,
			@RequestParam(value = "indPendienteAcuse", required = false) String indPendienteAcuse_,
			@RequestParam(value = "indIncluirCerrados", required = false) String indIncluirCerrados_,
			@RequestParam(value = "indPendienteDecision", required = false) String indPendienteDecision_,
			@RequestParam(value = "indPendienteFirma", required = false) String indPendienteFirma_,

			// Responsable de establecimiento
			@RequestParam(value = "rpcif", required = false) String rpcif_,
			@RequestParam(value = "rprazonsocial", required = false) String rprazonsocial_,
			@RequestParam(value = "rpprovincia", required = false) String rpprovincia_,
			@RequestParam(value = "rpmunicipio", required = false) String rpmunicipio_,
			@RequestParam(value = "rplocalidad", required = false) String rplocalidad_,
			@RequestParam(value = "rpdireccion", required = false) String rpdireccion_,
			@RequestParam(value = "rppais", required = false) String rppais_,

			// Establecimiento
			@RequestParam(value = "escif", required = false) String escif_,
			@RequestParam(value = "esnombre", required = false) String esnombre_,
			@RequestParam(value = "esprovincia", required = false) String esprovincia_,
			@RequestParam(value = "esmunicipio", required = false) String esmunicipio_,
			@RequestParam(value = "eslocalidad", required = false) String eslocalidad_,
			@RequestParam(value = "esdireccion", required = false) String esdireccion_,
			@RequestParam(value = "espais", required = false) String espais_,

			// Producto / servicio
			@RequestParam(value = "ps", required = false) String atcops_,
			@RequestParam(value = "psproducto", required = false) String atnoprse_,

			@RequestParam(value = "estRespResidencia", required = false) String estRespResidencia_,
			@RequestParam(value = "estResidencia", required = false) String estResidencia_,

			// Codigo acta
			@RequestParam(value = "ancodac", required = false) String ancodac_,
			// Codigo organismo origen
			@RequestParam(value = "accoorganismoorigen", required = false) String accoorganismoorigen_,

			HttpServletRequest request, Model model) {
		try {
			String acfereDesde = ("".equals(acfereDesde_)) ? null : acfereDesde_;
			String acfereHasta = ("".equals(acfereHasta_)) ? null : acfereHasta_;

			// control de los campos susceptibles de llegar a "" desde el filtro
			String accoor = ("".equals(accoor_)) ? null : accoor_;
			String acnror = ("".equals(acnror_)) ? null : acnror_;
			BigDecimal acnran = ("".equals(acnran_)) ? null : acnran_;

			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String mocodigoExpediente = ("".equals(mocodigoExpediente_)) ? null : mocodigoExpediente_;
			String accoororigen = ("".equals(accoororigen_)) ? null : accoororigen_;

			// tramitacion
			String fcodigo = ("".equals(fcodigo_)) ? null : fcodigo_;
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;
			String decodigo = ("".equals(decodigo_)) ? null : decodigo_;
			String mocodigoTramitador = ("".equals(mocodigoTramitador_)) ? null : mocodigoTramitador_;
			String ehfechafinDecisionDesde = ("".equals(ehfechafinDecisionDesde_)) ? null : ehfechafinDecisionDesde_;
			String ehfechafinDecisionHasta = ("".equals(ehfechafinDecisionHasta_)) ? null : ehfechafinDecisionHasta_;

			// control checks
			String indUltimoTramite = ("on".equals(indUltimoTramite_)) ? Y41bConstantes.VALOR_SI : null;
			String indPendienteAcuse = ("on".equals(indPendienteAcuse_)) ? Y41bConstantes.VALOR_SI : null;
			String indIncluirCerrados = ("on".equals(indIncluirCerrados_)) ? Y41bConstantes.VALOR_SI : null;
			String indPendienteDecision = ("on".equals(indPendienteDecision_)) ? Y41bConstantes.VALOR_SI : null;
			String indPendienteFirma = ("on".equals(indPendienteFirma_)) ? Y41bConstantes.VALOR_SI : null;

			// establecimiento responsable
			String rpcif = ("".equals(rpcif_)) ? null : rpcif_;
			String rprazonsocial = ("".equals(rprazonsocial_)) ? null : rprazonsocial_;
			String rpprovincia = ("".equals(rpprovincia_)) ? null : rpprovincia_;
			String rpmunicipio = ("".equals(rpmunicipio_)) ? null : rpmunicipio_;
			String rplocalidad = ("".equals(rplocalidad_)) ? null : rplocalidad_;
			String rpdireccion = ("".equals(rpdireccion_)) ? null : rpdireccion_;
			String rppais = ("".equals(rppais_)) ? null : rppais_;

			// establecimiento
			String escif = ("".equals(escif_)) ? null : escif_;
			String esnombre = ("".equals(esnombre_)) ? null : esnombre_;
			String esprovincia = ("".equals(esprovincia_)) ? null : esprovincia_;
			String esmunicipio = ("".equals(esmunicipio_)) ? null : esmunicipio_;
			String eslocalidad = ("".equals(eslocalidad_)) ? null : eslocalidad_;
			String esdireccion = ("".equals(esdireccion_)) ? null : esdireccion_;
			String espais = ("".equals(espais_)) ? null : espais_;

			// producto
			String atcops = ("".equals(atcops_)) ? null : atcops_;
			String atnoprse = ("".equals(atnoprse_)) ? null : atnoprse_;

			// Codigo acta
			String ancodac = ("".equals(ancodac_)) ? null : ancodac_;

			// origen
			String atcocm = ("".equals(atcocm_)) ? null : atcocm_;
			String atcopg = ("".equals(atcopg_)) ? null : atcopg_;
			String atcoal = ("".equals(atcoal_)) ? null : atcoal_;
			String alnran = ("".equals(alnran_)) ? null : alnran_;
			String alnror = ("".equals(alnror_)) ? null : alnror_;
			String atcocr = ("".equals(atcocr_)) ? null : atcocr_;
			String v6codigo = ("".equals(v6codigo_)) ? null : v6codigo_;
			String atfinalizada = ("".equals(atfinalizada_)) ? null : atfinalizada_;
			String decoor = ("".equals(decoor_)) ? null : decoor_;
			String denror = ("".equals(denror_)) ? null : denror_;
			String denran = ("".equals(denran_)) ? null : denran_;

			String attipo = ("".equals(attipo_)) ? null : attipo_;

			String estRespResidencia = ("".equals(estRespResidencia_)) ? null : estRespResidencia_;
			String estResidencia = ("".equals(estResidencia_)) ? null : estResidencia_;

			// codigo organismo origen
			String accoorganismoorigen = ("".equals(accoorganismoorigen_)) ? null : accoorganismoorigen_;

			Acta acta = new Acta();
			acta.setAccoor(accoor);
			acta.setAcnror(acnror);
			acta.setAcnran(acnran);
			acta.setAcfereDesde(acfereDesde);
			acta.setAcfereHasta(acfereHasta);

			acta.setAccomo(mocodigoExpediente);
			acta.setAccoororigen(accoororigen);

			// tramitacion
			acta.setFcodigo(fcodigo);
			acta.setTrcodigo(trcodigo);
			acta.setDecodigo(decodigo);
			acta.setMocodigoTramitador(mocodigoTramitador);
			acta.setEhfechafinDecisionDesde(ehfechafinDecisionDesde);
			acta.setEhfechafinDecisionHasta(ehfechafinDecisionHasta);

			// Codigo acta
			acta.setAncodac(ancodac);

			acta.setIndUltimoTramite(indUltimoTramite);
			acta.setIndPendienteAcuse(indPendienteAcuse);
			acta.setIndIncluirCerrados(indIncluirCerrados);
			acta.setIndPendienteDecision(indPendienteDecision);
			acta.setIndPendienteFirma(indPendienteFirma);

			// establecimiento responsable
			Establecimiento establecimientoResponsable = new Establecimiento();
			establecimientoResponsable.setEsnif(rpcif);
			establecimientoResponsable.setEsnombre(rprazonsocial);
			establecimientoResponsable.setEsnoraProvinciaId(rpprovincia);
			establecimientoResponsable.setEsnoraMunicipioId(rpmunicipio);
			establecimientoResponsable.setEsnoraLocalidadId(rplocalidad);
			establecimientoResponsable.setEsnodir(rpdireccion);
			establecimientoResponsable.setEsnoraPaisId(rppais);

			acta.setEstablecimientoResponsable(establecimientoResponsable);

			// establecimiento visitado
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEsnif(escif);
			establecimiento.setEsnombre(esnombre);
			establecimiento.setEsnoraProvinciaId(esprovincia);
			establecimiento.setEsnoraMunicipioId(esmunicipio);
			establecimiento.setEsnoraLocalidadId(eslocalidad);
			establecimiento.setEsnodir(esdireccion);
			establecimiento.setEsnoraPaisId(espais);

			acta.setEstablecimiento(establecimiento);

			acta.setAccoorganismoorigen(accoorganismoorigen);

			// producto
			Actuacion actuacion = new Actuacion();
			actuacion.setAtcops(atcops);
			actuacion.setAtnoprse(atnoprse);
			Actdec actdec = new Actdec();
			actdec.setAdcoor(codOrg);
			actuacion.setActdec(actdec);

			// origen
			actuacion.setAtcocm(atcocm);
			actuacion.setAlnror(alnror);
			actuacion.setAlnran(alnran);
			actuacion.setV6codigo(v6codigo);

			if (decoor != null && decoor != "") {
				actuacion.setDecoor(decoor);
			}

			if (denror != null && denror != "") {
				actuacion.setDenror(denror);
			}

			if (denran != null && denran != "") {
				actuacion.setDenran(denran);
			}

			if (attipo != null && attipo != "") {
				actuacion.setAttipo(attipo);
			}

			acta.setActuacion(actuacion);

			acta.setEstRespResidencia(estRespResidencia);
			acta.setEstResidencia(estResidencia);

			// Ponemos los valores para la visualizacion de las fechas
			// correctamente Ini
			acta.setAcfereDesdeStr(acfereDesde);
			acta.setAcfereHastaStr(acfereHasta);
			acta.setEhfechafinDecisionDesdeStr(ehfechafinDecisionDesde);
			acta.setEhfechafinDecisionHastaStr(ehfechafinDecisionHasta);
			// Ponemos los valores para la visualizacion de las fechas
			// correctamente Fin

			model.addAttribute("actaBusqueda", acta);

			// INICIO - Para la busqueda de inspecciones en campaa y alertas
			actuacion.setAtcopg(atcopg);
			actuacion.setAtcoal(atcoal);
			actuacion.setAtcocr(atcocr);
			actuacion.setAtfinalizadas(atfinalizada);

			if (atcoal != null) {
				HttpServletRequest httpRequest = (HttpServletRequest) request;
				HttpSession httpSession = httpRequest.getSession(false);
				CensoMonitor censoMonitor = (CensoMonitor) httpSession
						.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

				if (censoMonitor.getPerfilOrganizacion() != null && !censoMonitor.getPerfilOrganizacion().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO)) {
					if (censoMonitor.getPerfilInspecciones() != null && censoMonitor.getPerfilInspecciones()
							.getIdPerfil().equals(Y41bConstantes.PERFIL_INSTRUCTOR)) {
						acta.setAccomo(censoMonitor.getMocodigo());
					}
				}
			}
			// FIN - Para la busqueda de inspecciones en campaa y alertas

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<BusquedaInspeccion> inspeccionesBusqueda = this.actaService.findAllActaLike(acta, pagination);

				if (inspeccionesBusqueda == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.actaService.findAllLikeCount(acta, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(inspeccionesBusqueda);
				return data;
			} else {
				List<Acta> inspeccionesBusqueda = this.actaService.findAllLike(acta, pagination, false);
				if (inspeccionesBusqueda == null) {
					throw new Exception("No data Found.");
				}
				return inspeccionesBusqueda;
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	// Detalle inspecciones antiguas

	/**
	 * Method 'getCreateFormY49BTabsInspeccionesDetalleAntiguas'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @param atcodigo
	 *            String
	 * @return ModelAndView
	 */
	@RequestMapping(value = "y41bTabsBusquedaResultadoInspecciones/y41bTabsInspeccionesDetalleAntiguas/{atcodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormY49BTabsInspeccionesDetalleAntiguas(Model model, HttpServletRequest request,
			@PathVariable() String atcodigo) {

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		model.addAttribute("atcodigo", atcodigo);
		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(atcodigo);
		model.addAttribute("numExpediente", this.actaService.findNumExpediente(actuacion));

		httpSession.setAttribute("desde", Y41bConstantes.DESDE_BUSQUEDA);

		if (censoMonitor.getPerfilInspecciones() == null || censoMonitor.getPerfilInspecciones().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bTabsInspeccionesDetalleAntiguas", "model", model);
		}
	}

	// Vista
	/**
	 * Method 'getCreateFormY49BTabsInspeccionesDetalleAntiguasVista'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @param atcodigo
	 *            String
	 * @return ModelAndView
	 */
	@RequestMapping(value = "y41bTabsInspeccionesDetalleAntiguas/y41bTabsInspeccionesDetalleAntiguasVisita/{atcodigo}", method = RequestMethod.GET)
	public @ResponseBody() ModelAndView getCreateFormY49BTabsInspeccionesDetalleAntiguasVista(
			@PathVariable() String atcodigo, Model model, HttpServletRequest request) {

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(atcodigo);
		Acta acta = this.actaService.findVisita(actuacion);
		model.addAttribute("acta", acta);

		return new ModelAndView("y41bTabsInspeccionesDetalleAntiguasVisita", "model", model);

	}

	// Actuacion

	/**
	 * Method 'getCreateFormY49BTabsInspeccionesDetalleAntiguasActuacion'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @param atcodigo
	 *            String
	 * @return ModelAndView
	 */
	@RequestMapping(value = "y41bTabsInspeccionesDetalleAntiguas/y41bTabsInspeccionesDetalleAntiguasActuacion/{atcodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormY49BTabsInspeccionesDetalleAntiguasActuacion(@PathVariable() String atcodigo,
			Model model, HttpServletRequest request) {

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(atcodigo);
		Acta acta = this.actaService.findActuacion(actuacion);

		if (acta.getActuacion() == null) {
			acta.setActuacion(new Actuacion());
		}

		model.addAttribute("acta", acta);

		if (censoMonitor.getPerfilInspecciones() == null || censoMonitor.getPerfilInspecciones().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bTabsInspeccionesDetalleAntiguasActuacion", "model", model);
		}
	}

	// Constatacion
	/**
	 * Method 'getCreateFormY49BTabsInspeccionesDetalleAntiguasConstatacion'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "y41bTabsInspeccionesDetalleAntiguas/y41bTabsInspeccionesDetalleAntiguasConstatacion", method = RequestMethod.GET)
	public @ResponseBody() ModelAndView getCreateFormY49BTabsInspeccionesDetalleAntiguasConstatacion(Model model,
			HttpServletRequest request) {

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilInspecciones() == null || censoMonitor.getPerfilInspecciones().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bTabsInspeccionesDetalleAntiguasConstatacion", "model", model);
		}
	}

	/**
	 * Method 'getConstatacion'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "/busquedaConstatacion/{atcodigo}", method = RequestMethod.GET)
	public @ResponseBody() Object getConstatacion(@PathVariable() String atcodigo, HttpServletRequest request) {
		try {

			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(atcodigo);

			Pagination pagination = null;
			pagination = new Pagination();
			pagination.setPage(Long.valueOf(request.getParameter("page")));
			pagination.setRows(Long.valueOf(request.getParameter("rows")));
			pagination.setSort(request.getParameter("sidx"));
			pagination.setAscDsc(request.getParameter("sord"));
			List<DetalleConstatacion> constatacionBusqueda = this.actaService.findConstatacion(actuacion, pagination);
			if (constatacionBusqueda == null) {
				throw new Exception("No data Found.");
			}

			Long total = this.actaService.findConstatacionCount(actuacion);

			JQGridJSONModel data = new JQGridJSONModel();
			data.setPage(request.getParameter("page"));
			data.setRecords(total.intValue());
			data.setTotal(total, pagination.getRows());
			data.setRows(constatacionBusqueda);
			return data;

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	// Protocolo
	/**
	 * Method 'getCreateFormY49BTabsInspeccionesDetalleAntiguasProtocolo'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "y41bTabsInspeccionesDetalleAntiguas/y41bTabsInspeccionesDetalleAntiguasProtocolo/{atcodigo}", method = RequestMethod.GET)
	public @ResponseBody() ModelAndView getCreateFormY49BTabsInspeccionesDetalleAntiguasProtocolo(

			@PathVariable() String atcodigo, Model model, HttpServletRequest request) {

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(atcodigo);

		if (censoMonitor.getPerfilInspecciones() == null || censoMonitor.getPerfilInspecciones().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
			// return this.actaService.findProtocolo(acta);
		} else {
			return new ModelAndView("y41bTabsInspeccionesDetalleAntiguasProtocolo", "model", model);
		}
	}

	/**
	 * Method 'getProtocolo'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "/busquedaProtocolo/{atcodigo}", method = RequestMethod.GET)
	public @ResponseBody() Object getProtocolo(@PathVariable() String atcodigo, HttpServletRequest request) {
		try {

			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(atcodigo);

			Pagination pagination = null;
			pagination = new Pagination();
			pagination.setPage(Long.valueOf(request.getParameter("page")));
			pagination.setRows(Long.valueOf(request.getParameter("rows")));
			pagination.setSort(request.getParameter("sidx"));
			pagination.setAscDsc(request.getParameter("sord"));
			List<DetalleProtocolo> protocoloBusqueda = this.actaService.findProtocolo(actuacion, null, pagination);
			if (protocoloBusqueda == null) {
				throw new Exception("No data Found.");
			}

			Long total = this.actaService.findProtocoloCount(actuacion);

			JQGridJSONModel data = new JQGridJSONModel();
			data.setPage(request.getParameter("page"));
			data.setRecords(total.intValue());
			data.setTotal(total, pagination.getRows());
			data.setRows(protocoloBusqueda);
			return data;

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	// Muestra
	/**
	 * Method 'getCreateFormY49BTabsInspeccionesDetalleAntiguasMuestra'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 * @return Object
	 */
	@RequestMapping(value = "y41bTabsInspeccionesDetalleAntiguas/y41bTabsInspeccionesDetalleAntiguasMuestra/{atcodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormY49BTabsInspeccionesDetalleAntiguasMuestra(@PathVariable() String atcodigo,
			Model model, HttpServletRequest request) {

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(atcodigo);
		DetalleMuestra detalleMuestra = this.actaService.findMuestra(actuacion);
		model.addAttribute("detalleMuestra", detalleMuestra);

		if (censoMonitor.getPerfilInspecciones() == null || censoMonitor.getPerfilInspecciones().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bTabsInspeccionesDetalleAntiguasMuestra", "model", model);
		}
	}

	// Documento
	/**
	 * Method 'getCreateFormY49BTabsInspeccionesDetalleAntiguasDocumentos'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 * @return Object
	 */
	@RequestMapping(value = "y41bTabsInspeccionesDetalleAntiguas/y41bTabsInspeccionesDetalleAntiguasDocumentos/{atcodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormY49BTabsInspeccionesDetalleAntiguasDocumentos(@PathVariable() String atcodigo,
			Model model, HttpServletRequest request) {

		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(atcodigo);
		// Analisis analisis = this.actaService.findDocumentos(acta);
		model.addAttribute("actuacion", actuacion);

		if (censoMonitor.getPerfilInspecciones() == null || censoMonitor.getPerfilInspecciones().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("y41bTabsInspeccionesDetalleAntiguasDocumentos", "model", model);
		}
	}

	/**
	 * Method 'getProtocolo'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "/busquedaDocumentos/{atcodigo}", method = RequestMethod.GET)
	public @ResponseBody() Object getDocumentos(@PathVariable() String atcodigo, HttpServletRequest request) {
		try {

			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(atcodigo);

			Pagination pagination = null;
			pagination = new Pagination();
			pagination.setPage(Long.valueOf(request.getParameter("page")));
			pagination.setRows(Long.valueOf(request.getParameter("rows")));
			pagination.setSort(request.getParameter("sidx"));
			pagination.setAscDsc(request.getParameter("sord"));
			List<DetalleDocumentos> documentosBusqueda = this.actaService.findDocumentos(actuacion, pagination);
			if (documentosBusqueda == null) {
				throw new Exception("No data Found.");
			}

			Long total = this.actaService.findDocumentosCount(actuacion);

			JQGridJSONModel data = new JQGridJSONModel();
			data.setPage(request.getParameter("page"));
			data.setRecords(total.intValue());
			data.setTotal(total, pagination.getRows());
			data.setRows(documentosBusqueda);
			return data;

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Metodo para generar un archivo excel con los filtrados correspondientes *
	 * 
	 * @param accoor_
	 *            String
	 * @param acnror_
	 *            String
	 * @param acnran_
	 *            String
	 * @param acfereDesde_
	 *            String
	 * @param acfereHasta_
	 *            String
	 * @param codOrg_
	 *            String
	 * @param mocodigoExpediente_
	 *            String
	 * @param accoororigen_
	 *            String
	 * @param atcocm_
	 *            String
	 * @param alnran_
	 *            String
	 * @param alnror_
	 *            String
	 * @param v6codigo_
	 *            String
	 * @param decoor_
	 *            String
	 * @param denran_
	 *            String
	 * @param denror_
	 *            String
	 * @param attipo_
	 *            String
	 * @param indUltimoTramite_
	 *            String
	 * @param indPendienteAcuse_
	 *            String
	 * @param indIncluirCerrados_
	 *            String
	 * @param indPendienteDecision_
	 *            String
	 * @param indPendienteFirma_
	 *            String
	 * @param ehfechafinDecisionDesde_
	 *            String
	 * @param ehfechafinDecisionHasta_
	 *            String
	 * @param fcodigo_
	 *            String
	 * @param trcodigo_
	 *            String
	 * @param decodigo_
	 *            String
	 * @param mocodigoTramitador_
	 *            String
	 * @param rpcif_
	 *            String
	 * @param rprazonsocial_
	 *            String
	 * @param rpprovincia_
	 *            String
	 * @param rpmunicipio_
	 *            String
	 * @param rplocalidad_
	 *            String
	 * @param rppais_
	 *            String
	 * @param rpdireccion_
	 *            String
	 * @param escif_
	 *            String
	 * @param esnombre_
	 *            String
	 * @param esprovincia_
	 *            String
	 * @param esmunicipio_
	 *            String
	 * @param eslocalidad_
	 *            String
	 * @param espais_
	 *            String
	 * @param esdireccion_
	 *            String
	 * @param atcops_
	 *            String
	 * @param atnoprse_
	 *            String
	 * @param estRespResidencia_
	 *            String
	 * @param estResidencia_
	 *            String
	 * @param ancodac_
	 *            String
	 * @param accoorganismoorigen_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excel", method = RequestMethod.GET)
	public void getAllSolicitudExcel(
			// general
			@RequestParam(value = "accoor", required = false) String accoor_,
			@RequestParam(value = "acnror", required = false) String acnror_,
			@RequestParam(value = "acnran", required = false) BigDecimal acnran_,
			@RequestParam(value = "acfereDesde", required = false) String acfereDesde_,
			@RequestParam(value = "acfereHasta", required = false) String acfereHasta_,
			@RequestParam(value = "codOrg", required = false) String codOrg_,
			@RequestParam(value = "mocodigoExpediente", required = false) String mocodigoExpediente_,
			@RequestParam(value = "accoororigen", required = false) String accoororigen_,

			// origen
			@RequestParam(value = "atcocm", required = false) String atcocm_,
			@RequestParam(value = "alnror", required = false) String alnror_,
			@RequestParam(value = "alnran", required = false) String alnran_,
			@RequestParam(value = "v6codigo", required = false) String v6codigo_,

			@RequestParam(value = "decoor", required = false) String decoor_,
			@RequestParam(value = "denror", required = false) String denror_,
			@RequestParam(value = "denran", required = false) String denran_,

			@RequestParam(value = "attipo", required = false) String attipo_,

			// tramite
			@RequestParam(value = "fcodigo", required = false) String fcodigo_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_,
			@RequestParam(value = "decodigo", required = false) String decodigo_,
			@RequestParam(value = "mocodigoTramitador", required = false) String mocodigoTramitador_,
			@RequestParam(value = "ehfechafinDecisionDesde", required = false) String ehfechafinDecisionDesde_,
			@RequestParam(value = "ehfechafinDecisionHasta", required = false) String ehfechafinDecisionHasta_,

			@RequestParam(value = "indUltimoTramite", required = false) String indUltimoTramite_,
			@RequestParam(value = "indPendienteAcuse", required = false) String indPendienteAcuse_,
			@RequestParam(value = "indIncluirCerrados", required = false) String indIncluirCerrados_,
			@RequestParam(value = "indPendienteDecision", required = false) String indPendienteDecision_,
			@RequestParam(value = "indPendienteFirma", required = false) String indPendienteFirma_,

			// Responsable de establecimiento
			@RequestParam(value = "rpcif", required = false) String rpcif_,
			@RequestParam(value = "rprazonsocial", required = false) String rprazonsocial_,
			@RequestParam(value = "rpprovincia", required = false) String rpprovincia_,
			@RequestParam(value = "rpmunicipio", required = false) String rpmunicipio_,
			@RequestParam(value = "rplocalidad", required = false) String rplocalidad_,
			@RequestParam(value = "rpdireccion", required = false) String rpdireccion_,
			@RequestParam(value = "rppais", required = false) String rppais_,

			// Establecimiento
			@RequestParam(value = "escif", required = false) String escif_,
			@RequestParam(value = "esnombre", required = false) String esnombre_,
			@RequestParam(value = "esprovincia", required = false) String esprovincia_,
			@RequestParam(value = "esmunicipio", required = false) String esmunicipio_,
			@RequestParam(value = "eslocalidad", required = false) String eslocalidad_,
			@RequestParam(value = "esdireccion", required = false) String esdireccion_,
			@RequestParam(value = "espais", required = false) String espais_,

			// Producto / servicio
			@RequestParam(value = "ps", required = false) String atcops_,
			@RequestParam(value = "psproducto", required = false) String atnoprse_,

			@RequestParam(value = "estRespResidencia", required = false) String estRespResidencia_,
			@RequestParam(value = "estResidencia", required = false) String estResidencia_,

			// Codigo acta
			@RequestParam(value = "ancodac", required = false) String ancodac_,
			// Codigo organismo origen
			@RequestParam(value = "accoorganismoorigen", required = false) String accoorganismoorigen_,

			HttpServletRequest request, HttpServletResponse response) {
		try {
			// parseo de fechas
			String acfereDesde = ("".equals(acfereDesde_)) ? null : acfereDesde_;
			String acfereHasta = ("".equals(acfereHasta_)) ? null : acfereHasta_;

			// control de los campos susceptibles de llegar a "" desde el filtro
			String accoor = ("".equals(accoor_)) ? null : accoor_;
			String acnror = ("".equals(acnror_)) ? null : acnror_;
			BigDecimal acnran = ("".equals(acnran_)) ? null : acnran_;

			String codOrg = ("".equals(codOrg_)) ? null : codOrg_;
			String mocodigoExpediente = ("".equals(mocodigoExpediente_)) ? null : mocodigoExpediente_;
			String accoororigen = ("".equals(accoororigen_)) ? null : accoororigen_;

			// tramitacion
			String fcodigo = ("".equals(fcodigo_)) ? null : fcodigo_;
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;
			String decodigo = ("".equals(decodigo_)) ? null : decodigo_;
			String mocodigoTramitador = ("".equals(mocodigoTramitador_)) ? null : mocodigoTramitador_;

			String ehfechafinDecisionDesde = ("".equals(ehfechafinDecisionDesde_)) ? null : ehfechafinDecisionDesde_;
			String ehfechafinDecisionHasta = ("".equals(ehfechafinDecisionHasta_)) ? null : ehfechafinDecisionHasta_;

			// control checks
			String indUltimoTramite = ("on".equals(indUltimoTramite_)) ? Y41bConstantes.VALOR_SI : null;
			String indPendienteAcuse = ("on".equals(indPendienteAcuse_)) ? Y41bConstantes.VALOR_SI : null;
			String indIncluirCerrados = ("on".equals(indIncluirCerrados_)) ? Y41bConstantes.VALOR_SI : null;
			String indPendienteDecision = ("on".equals(indPendienteDecision_)) ? Y41bConstantes.VALOR_SI : null;
			String indPendienteFirma = ("on".equals(indPendienteFirma_)) ? Y41bConstantes.VALOR_SI : null;

			// establecimiento responsable
			String rpcif = ("".equals(rpcif_)) ? null : rpcif_;
			String rprazonsocial = ("".equals(rprazonsocial_)) ? null : rprazonsocial_;
			String rpprovincia = ("".equals(rpprovincia_)) ? null : rpprovincia_;
			String rpmunicipio = ("".equals(rpmunicipio_)) ? null : rpmunicipio_;
			String rplocalidad = ("".equals(rplocalidad_)) ? null : rplocalidad_;
			String rpdireccion = ("".equals(rpdireccion_)) ? null : rpdireccion_;
			String rppais = ("".equals(rppais_)) ? null : rppais_;

			// establecimiento
			String escif = ("".equals(escif_)) ? null : escif_;
			String esnombre = ("".equals(esnombre_)) ? null : esnombre_;
			String esprovincia = ("".equals(esprovincia_)) ? null : esprovincia_;
			String esmunicipio = ("".equals(esmunicipio_)) ? null : esmunicipio_;
			String eslocalidad = ("".equals(eslocalidad_)) ? null : eslocalidad_;
			String esdireccion = ("".equals(esdireccion_)) ? null : esdireccion_;
			String espais = ("".equals(espais_)) ? null : espais_;

			// producto
			String atcops = ("".equals(atcops_)) ? null : atcops_;
			String atnoprse = ("".equals(atnoprse_)) ? null : atnoprse_;

			// Codigo acta
			String ancodac = ("".equals(ancodac_)) ? null : ancodac_;

			// origen
			String atcocm = ("".equals(atcocm_)) ? null : atcocm_;
			String alnran = ("".equals(alnran_)) ? null : alnran_;
			String alnror = ("".equals(alnror_)) ? null : alnror_;
			String v6codigo = ("".equals(v6codigo_)) ? null : v6codigo_;
			String decoor = ("".equals(decoor_)) ? null : decoor_;
			String denror = ("".equals(denror_)) ? null : denror_;
			String denran = ("".equals(denran_)) ? null : denran_;

			String attipo = ("".equals(attipo_)) ? null : attipo_;

			String estRespResidencia = ("".equals(estRespResidencia_)) ? null : estRespResidencia_;
			String estResidencia = ("".equals(estResidencia_)) ? null : estResidencia_;

			// codigo organismo origen
			String accoorganismoorigen = ("".equals(accoorganismoorigen_)) ? null : accoorganismoorigen_;

			Acta acta = new Acta();
			acta.setAccoor(accoor);
			acta.setAcnror(acnror);
			acta.setAcnran(acnran);
			acta.setAcfereDesde(acfereDesde);
			acta.setAcfereHasta(acfereHasta);

			acta.setAccomo(mocodigoExpediente);
			acta.setAccoororigen(accoororigen);

			// tramitacion
			acta.setFcodigo(fcodigo);
			acta.setTrcodigo(trcodigo);
			acta.setDecodigo(decodigo);
			acta.setMocodigoTramitador(mocodigoTramitador);
			acta.setEhfechafinDecisionDesde(ehfechafinDecisionDesde);
			acta.setEhfechafinDecisionHasta(ehfechafinDecisionHasta);

			// Codigo acta
			acta.setAncodac(ancodac);

			acta.setIndUltimoTramite(indUltimoTramite);
			acta.setIndPendienteAcuse(indPendienteAcuse);
			acta.setIndIncluirCerrados(indIncluirCerrados);
			acta.setIndPendienteDecision(indPendienteDecision);
			acta.setIndPendienteFirma(indPendienteFirma);

			// establecimiento responsable
			Establecimiento establecimientoResponsable = new Establecimiento();
			establecimientoResponsable.setEsnif(rpcif);
			establecimientoResponsable.setEsnombre(rprazonsocial);
			establecimientoResponsable.setEsnoraProvinciaId(rpprovincia);
			establecimientoResponsable.setEsnoraMunicipioId(rpmunicipio);
			establecimientoResponsable.setEsnoraLocalidadId(rplocalidad);
			establecimientoResponsable.setEsnodir(rpdireccion);
			establecimientoResponsable.setEsnoraPaisId(rppais);

			acta.setEstablecimientoResponsable(establecimientoResponsable);

			// establecimiento visitado
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEsnif(escif);
			establecimiento.setEsnombre(esnombre);
			establecimiento.setEsnoraProvinciaId(esprovincia);
			establecimiento.setEsnoraMunicipioId(esmunicipio);
			establecimiento.setEsnoraLocalidadId(eslocalidad);
			establecimiento.setEsnodir(esdireccion);
			establecimiento.setEsnoraPaisId(espais);

			acta.setEstablecimiento(establecimiento);

			acta.setAccoorganismoorigen(accoorganismoorigen);

			// producto
			Actuacion actuacion = new Actuacion();
			actuacion.setAtcops(atcops);
			actuacion.setAtnoprse(atnoprse);
			Actdec actdec = new Actdec();
			actdec.setAdcoor(codOrg);
			actuacion.setActdec(actdec);

			// origen
			actuacion.setAtcocm(atcocm);
			actuacion.setAlnran(alnran);
			actuacion.setAlnror(alnror);
			actuacion.setV6codigo(v6codigo);

			actuacion.setDecoor(decoor);
			actuacion.setDenran(denran);
			actuacion.setDenror(denror);

			actuacion.setAttipo(attipo);

			acta.setActuacion(actuacion);

			acta.setEstRespResidencia(estRespResidencia);
			acta.setEstResidencia(estResidencia);

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy, "yyyyMMddHHmmss");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache"); //
			response.setContentType("text/html"); //
			response.setHeader("Content-type", "application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_BUSQUEDA_INSPECCIONES + fechaActual + ".xls";
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(nombre) + "\"");

			String xslString = this.y41bExcelGeneratorService.getInspeccionesExcel(acta);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllBandejaInspecciones'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/findAllBandejaInspecciones", method = RequestMethod.GET)
	public @ResponseBody() Object getAllBandejaInspecciones(HttpServletRequest request, Model model) {
		try {

			Acta filterActa = new Acta();

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			Actdec filterActdec = new Actdec();
			filterActdec.setAdcoor(censoMonitor.getOrganismo().getCodOrg());

			Actuacion filterActuacion = new Actuacion();
			filterActuacion.setIskontsumobide(Y41bConstantes.SI);
			filterActa.setActuacion(filterActuacion);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setAscDsc(request.getParameter("sord"));

				String sort = request.getParameter("sidx");
				if ("v6establecimientovisitaesnombre".equals(sort)) {
					sort = "t3establecimiento.nombre";
				}
				pagination.setSort(sort);

				List<BusquedaInspeccion> listInspecciones = this.inspeccionService
						.findAllBandejaInspecciones(filterActa, pagination);

				if (listInspecciones == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.inspeccionService.findAllBandejaInspeccionesCount(filterActa);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listInspecciones);
				return data;
			} else {
				List<BusquedaInspeccion> listInspecciones = this.inspeccionService
						.findAllBandejaInspecciones(filterActa, pagination);
				if (listInspecciones == null) {
					throw new Exception("No data Found.");
				}
				return listInspecciones;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllBandejaInspeccionesCount'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllBandejaInspeccionescount", method = RequestMethod.GET)
	public @ResponseBody() Long getAllBandejaInspeccionesCount(HttpServletRequest request) {
		try {

			Acta filterActa = new Acta();

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			Actdec filterActdec = new Actdec();
			filterActdec.setAdcoor(censoMonitor.getOrganismo().getCodOrg());

			Actuacion filterActuacion = new Actuacion();
			filterActuacion.setIskontsumobide(Y41bConstantes.SI);
			filterActa.setActuacion(filterActuacion);

			Long total = this.inspeccionService.findAllBandejaInspeccionesCount(filterActa);

			return total;
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllBandejaPropuestasInspecciones'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/findAllBandejaPropuestasInspecciones", method = RequestMethod.GET)
	public @ResponseBody() Object getAllBandejaPropuestasInspecciones(HttpServletRequest request, Model model) {
		try {
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			InspeccionesPropBandeja inspeccionesPropBandeja = new InspeccionesPropBandeja();
			inspeccionesPropBandeja.setBaprinscoor(censoMonitor.getOrganismo().getCodOrg());

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setAscDsc(request.getParameter("sord"));
				pagination.setSidx(request.getParameter("sidx"));

				List<InspeccionesPropBandeja> listInspeccionesPropBandeja = this.inspeccionesPropBandejaService
						.findAll(inspeccionesPropBandeja, pagination);

				if (listInspeccionesPropBandeja == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.inspeccionesPropBandejaService.findAllCount(inspeccionesPropBandeja);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listInspeccionesPropBandeja);
				return data;
			} else {
				List<InspeccionesPropBandeja> listInspeccionesPropBandeja = this.inspeccionesPropBandejaService
						.findAll(inspeccionesPropBandeja, null);
				if (listInspeccionesPropBandeja == null) {
					throw new Exception("No data Found.");
				}
				return listInspeccionesPropBandeja;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllBandejaPropuestasInspeccionesCount'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllBandejaPropuestasInspeccionescount", method = RequestMethod.GET)
	public @ResponseBody() Long getAllBandejaPropuestasInspeccionesCount(HttpServletRequest request) {
		try {
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			InspeccionesPropBandeja inspeccionesPropBandeja = new InspeccionesPropBandeja();
			inspeccionesPropBandeja.setBaprinscoor(censoMonitor.getOrganismo().getCodOrg());

			Long total = this.inspeccionesPropBandejaService.findAllCount(inspeccionesPropBandeja);

			return total;
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Metodo para generar un archivo excel con los filtrados correspondientes *
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excelBandejaPropuestasInspecciones", method = RequestMethod.GET)
	public void getAllConsultaPropuestasInspeccionesExcel(HttpServletRequest request, HttpServletResponse response) {
		try {
			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy, "yyyyMMddHHmmss");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_BUSQUEDA_BANDPROPUESTASINSPECCIONES + fechaActual + ".xls";
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(nombre) + "\"");

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			InspeccionesPropBandeja inspeccionesPropBandeja = new InspeccionesPropBandeja();

			CensoMonitor censoMonitorAux = new CensoMonitor();
			Organismo organismoAux = new Organismo();
			organismoAux.setCodOrg(censoMonitor.getOrganismo().getCodOrg());
			censoMonitorAux.setOrganismo(organismoAux);
			inspeccionesPropBandeja.setBaprinsresponsable(censoMonitorAux);

			String xslString = this.y41bExcelGeneratorService
					.getBandejaPropuestasInspeccionesExcel(inspeccionesPropBandeja);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'editInstructor'.
	 * 
	 * @param solicitudCambioInstructor
	 *            SolicitudCambioInstructor
	 * @param request
	 *            HttpServletRequest
	 * 
	 */
	@RequestMapping(value = "/modificarInstructor", method = RequestMethod.PUT)
	public @ResponseBody() void editInstructor(@RequestBody() SolicitudCambioInstructor solicitudCambioInstructor,
			HttpServletRequest request) {
		try {
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			this.actaService.updateCambioInstructor(solicitudCambioInstructor, censoMonitor);
			InspeccionController.logger.info("Entity correctly inserted!");

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException("Method failed /inspeccion/modificarInstructor");
		}
	}

	/**
	 * Method 'trasvaseTotal'.
	 * 
	 * @param solicitudCambioInstructor
	 *            SolicitudCambioInstructor
	 * 
	 */
	@RequestMapping(value = "/trasvaseTotal", method = RequestMethod.PUT)
	public @ResponseBody void trasvaseTotal(@RequestBody SolicitudCambioInstructor solicitudCambioInstructor) {
		try {

			this.actaService.updateTrasvaseTotalCambioInstructor(solicitudCambioInstructor);
			logger.info("Entity correctly inserted!");

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException("Method failed /inspeccion/modificarInstructor");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param listActas
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return Inspector
	 */
	@RequestMapping(value = "/asignarInspector", method = RequestMethod.PUT)
	public @ResponseBody() Acta updateInspectorEnInspeccion(@RequestBody() List<HashMap<String, String>> listActas,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			List<Acta> listActasAux = new ArrayList<Acta>();

			for (HashMap<String, String> acta : listActas) {
				Acta actaAux = new Acta();
				actaAux.setAccomo(acta.get("accomo"));
				actaAux.setAccodigo(acta.get("accodigo"));

				listActasAux.add(actaAux);
			}

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			this.actaService.updateInspector(listActasAux, censoMonitor);

			return null;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'getCreateFormModInspeccionesConsulta'.
	 * 
	 * @param codCampanha_
	 *            String
	 * @param codProgramacionCampanha_
	 *            String
	 * @param codAlerta_
	 *            String
	 * @param codProgramacionAlerta_
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "inspeccionesConsulta", method = RequestMethod.GET)
	public ModelAndView getCreateFormModInspeccionesConsulta(
			@RequestParam(value = "codCampanha", required = false) String codCampanha_,
			@RequestParam(value = "codProgramacionCampanha", required = false) String codProgramacionCampanha_,
			@RequestParam(value = "codAlerta", required = false) String codAlerta_,
			@RequestParam(value = "codProgramacionAlerta", required = false) String codProgramacionAlerta_, Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));

		String codCampanha = ("".equals(codCampanha_)) ? null : codCampanha_;
		String codProgramacionCampanha = ("".equals(codProgramacionCampanha_)) ? null : codProgramacionCampanha_;

		String codAlerta = ("".equals(codAlerta_)) ? null : codAlerta_;
		String codProgramacionAlerta = ("".equals(codProgramacionAlerta_)) ? null : codProgramacionAlerta_;

		Acta acta = new Acta();
		Actuacion actuacion = new Actuacion();

		actuacion.setAtcocm(codCampanha);
		actuacion.setAtcopg(codProgramacionCampanha);

		actuacion.setAtcoal(codAlerta);
		actuacion.setAtcocr(codProgramacionAlerta);

		acta.setActuacion(actuacion);

		model.addAttribute("inspeccionesConsulta", acta);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilOrganizacion() == null || censoMonitor.getPerfilOrganizacion().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("inspeccionesConsulta", "model", model);
		}
	}

	/**
	 * Method 'getAllActas'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllActas/{atcodigo}", method = RequestMethod.GET)
	public @ResponseBody() Object getAllActas(@PathVariable(value = "atcodigo") String atcodigo,
			HttpServletRequest request) {
		try {
			ActaNueva actaNuevaFilter = new ActaNueva();
			actaNuevaFilter.setAncodins(atcodigo);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<ActaNueva> listActaNueva = null;

				listActaNueva = this.actaNuevaService.findAll(actaNuevaFilter, pagination);

				if (listActaNueva == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.actaNuevaService.findAllCount(actaNuevaFilter);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listActaNueva);
				return data;
			} else {
				List<ActaNueva> listActaNueva = null;

				listActaNueva = this.actaNuevaService.findAll(actaNuevaFilter, pagination);

				if (listActaNueva == null) {
					throw new Exception("No data Found.");
				}
				return listActaNueva;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllActasTramitada'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllActaTramitada/{atcodigo}", method = RequestMethod.GET)
	public @ResponseBody() Object getAllActasTramitada(@PathVariable(value = "atcodigo") String atcodigo,
			HttpServletRequest request) {
		try {
			ActaNueva actaNuevaFilter = new ActaNueva();
			actaNuevaFilter.setAncodins(atcodigo);

			Pagination pagination = null;

			List<ActaNueva> listActaNueva = null;

			listActaNueva = this.actaNuevaService.findAllActaTramitada(actaNuevaFilter, pagination);

			if (listActaNueva == null) {
				throw new Exception("No data Found.");
			}
			return listActaNueva;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllActaDocs'.
	 * 
	 * @param codActa
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findAllActaDocs/{codActa}", method = RequestMethod.GET)
	public @ResponseBody() Object getAllActaDocs(@PathVariable() String codActa, HttpServletRequest request) {
		try {
			Adjuntardocs adjuntardocsFilter = new Adjuntardocs();
			adjuntardocsFilter.setThidTramite(codActa);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAllTipoDocInspecciones(adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.adjuntardocsService.findAllCount(adjuntardocsFilter);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjuntardocs);
				return data;
			} else {
				List<Adjuntardocs> listAdjuntardocs = null;

				listAdjuntardocs = this.adjuntardocsService.findAllTipoDocInspecciones(adjuntardocsFilter, pagination);

				if (listAdjuntardocs == null) {
					throw new Exception("No data Found.");
				}
				return listAdjuntardocs;
			}
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getByIdDocumentoInspeccion'.
	 * 
	 * @param codActa
	 *            String
	 * @param iddocumento
	 *            String
	 * 
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findInspeccionDocumento/{codActa}/{iddocumento}", method = RequestMethod.GET)
	public @ResponseBody() void getByIdDocumentoInspeccion(@PathVariable() String codActa,
			@PathVariable() String iddocumento, HttpServletResponse response) {
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThcodocumento(iddocumento);
			adjuntardocsAux.setThidTramite(codActa);

			adjuntardocsAux = this.adjuntardocsService.findAdjuntardocs(adjuntardocsAux);

			Blob contenido = adjuntardocsAux.getThdatafile();
			byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(adjuntardocsAux.getThnofile()) + "\"");
			response.setContentType(adjuntardocsAux.getThcontenttypefile());
			response.setContentLength(adjuntardocsAux.getThsizefile());
			response.getOutputStream().write(bContenido);

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getCreateFormY41bActasDocumentosSubida'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bTabsActasDocumentosSubida", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bActasDocumentosSubida(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path", this.appConfiguration.get("statics.path"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilInspecciones() == null || censoMonitor.getPerfilInspecciones().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("y41bTabsActas_Documentos", "model", model);
		}
	}

	/**
	 * Method 'addActaDocs'.
	 * 
	 * @param file
	 *            MultipartFile
	 * @param codActa
	 *            String
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @param esActa
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return ConsultaFile
	 */
	@RequestMapping(value = "/y41bTabsInspeccion/y41bTabsActaDocs", method = RequestMethod.POST)
	public @ResponseBody() List<Map<String, Object>> addActaDocs(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			@ModelAttribute(value = "codActa") String codActa,
			@ModelAttribute(value = "inspeccionDetalle") InspeccionDetalle inspeccionDetalle,
			@ModelAttribute(value = "esActa") String esActa, HttpServletResponse response, HttpServletRequest request) {
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();

			String tedesfile = request.getParameter("tedesfile");

			adjuntardocsAux.setThcodocumento(this.denunciaService.getNewPKDocumentoHecho().toString());

			Blob blob = new SerialBlob(file.getBytes());
			adjuntardocsAux.setThdatafile(blob);
			adjuntardocsAux.setThcontenttypefile(file.getContentType());
			adjuntardocsAux.setThnofile(file.getOriginalFilename());
			adjuntardocsAux.setThsizefile((int) file.getSize());

			adjuntardocsAux.setThidExpediente(inspeccionDetalle.getAtcodigo());
			adjuntardocsAux.setThidTramite(codActa);

			adjuntardocsAux.setThtedesfile(tedesfile);
			adjuntardocsAux.setThorigen(Y41bConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION);

			TipoDocumento tipoDocumento = new TipoDocumento();
			if (esActa != null && Y41bConstantes.VALOR_SI.equals(esActa)) {
				tipoDocumento.setIdTipodoc(Y41bConstantes.TIPO_DOC_ACTA_INSP);
			} else {
				String tipodocumento = request.getParameter("idTipodoc");
				tipoDocumento.setIdTipodoc(tipodocumento);
			}
			adjuntardocsAux.setTipoDocumento(tipoDocumento);

			TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
			tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);
			adjuntardocsAux.setTipoProcedimiento(tipoProcedimiento);

			adjuntardocsAux.setThfecha(new Date());

			if (esActa != null && Y41bConstantes.VALOR_SI.equals(esActa)) {
				Actuacion actuacionaux = new Actuacion();
				actuacionaux.setAtcodigo(inspeccionDetalle.getAtcodigo());

				InspeccionDetalle inspeccionDetalleAux = this.actaService.findInspeccion(actuacionaux, null);

				if (Y41bConstantes.SI.equals(inspeccionDetalleAux.getCmonline())
						|| Y41bConstantes.SI.equals(inspeccionDetalleAux.getAtonline())) {
					Perfil perfilFirma = new Perfil();
					perfilFirma.setIdPerfil(Y41bConstantes.PERFIL_INSTRUCTOR);
					adjuntardocsAux.setPerfil(perfilFirma);
					adjuntardocsAux.setThfechasolfirma(Calendar.getInstance().getTime());
					adjuntardocsAux.setThestadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
				}
			}

			if (adjuntardocsAux.getTipoDocumento() != null && adjuntardocsAux.getTipoDocumento().getIdTipodoc()
					.equalsIgnoreCase(Y41bConstantes.TIPO_DOC_PROTOCOLO)) {
				Actuacion actuacionaux = new Actuacion();
				actuacionaux.setAtcodigo(inspeccionDetalle.getAtcodigo());

				InspeccionDetalle inspeccionDetalleAux = this.actaService.findInspeccion(actuacionaux, null);

				if (Y41bConstantes.SI.equals(inspeccionDetalleAux.getCmonline())
						|| Y41bConstantes.SI.equals(inspeccionDetalleAux.getAtonline())) {
					Perfil perfilFirma = new Perfil();
					perfilFirma.setIdPerfil(Y41bConstantes.PERFIL_INSTRUCTOR);
					adjuntardocsAux.setPerfil(perfilFirma);
					adjuntardocsAux.setThfechasolfirma(Calendar.getInstance().getTime());
					adjuntardocsAux.setThestadodocumento(Y41bConstantes.ESTADO_DOCUMENTO_PENDIENTEFIRMA);
				}
			}

			adjuntardocsAux = this.adjuntardocsService.add(adjuntardocsAux);

			InspeccionController.logger.info("Entity correctly inserted!" + adjuntardocsAux);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			filesMetaInfo.add(this.getFileReturnMap(file));
			return filesMetaInfo;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * 
	 * @param file
	 *            MultipartFile
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMap(MultipartFile file) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();
		mapaRetorno.put("url",
				"/y41bVistaWar/inspeccion/y41bTabsInspeccion/y41bTabsActaDocs/" + file.getOriginalFilename());
		mapaRetorno.put("name", file.getOriginalFilename());
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno.put("delete_url",
				"/y41bVistaWar/inspeccion/y41bTabsInspeccion/y41bTabsActaDocs/" + file.getOriginalFilename());
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/**
	 * Method 'removeActaDocs'.
	 * 
	 * @param codActa
	 *            String
	 * @param idDocumento
	 *            String
	 * @param ancodac
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/y41bTabsInspeccion/y41bTabsActaDocs/{codActa}/{idDocumento}", method = RequestMethod.DELETE)
	public void removeActaDocs(@PathVariable() String codActa, @PathVariable() String idDocumento,
			@RequestParam(value = "ancodac", required = false) String ancodac, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Adjuntardocs adjuntardocsAux = new Adjuntardocs();
			adjuntardocsAux.setThcodocumento(idDocumento);

			// realizar un control para comprobar si el documento tiene oid de
			// dokusi, si es asi no dejar eliminarlo
			Adjuntardocs adjuntardocs = new Adjuntardocs();
			adjuntardocs.setThcodocumento(idDocumento);
			adjuntardocs.setThidTramite(codActa);

			try {
				adjuntardocs = this.adjuntardocsService.findAdjuntardocs(adjuntardocs);
			} catch (Exception e) {
				adjuntardocs = null;
			}

			if (adjuntardocs != null && adjuntardocs.getThiddocumentum() != null
					&& !adjuntardocs.getThiddocumentum().equals("")) {

				Actuacion actuacionaux = new Actuacion();
				actuacionaux.setAtcodigo(adjuntardocs.getThidExpediente());

				InspeccionDetalle inspeccionDetalleAux = this.actaService.findInspeccion(actuacionaux, null);

				if (Y41bConstantes.SI.equals(inspeccionDetalleAux.getCmonline())
						|| Y41bConstantes.SI.equals(inspeccionDetalleAux.getAtonline())) {
					ActaNueva actaNueva = new ActaNueva();
					actaNueva.setAncodigo(codActa);

					actaNueva = this.actaNuevaService.find(actaNueva);

					if (actaNueva != null && actaNueva.getAnproceedingsidplatea() != null) {
						throw new Y41bUDAException("error.acta.removeDocumentoActaException", true, new Exception());
					}
				} else {
					ActaNueva actaNuevaBusqueda = new ActaNueva();
					actaNuevaBusqueda.setAncodac(ancodac);
					List<ActaNueva> actasNuevasAux = this.actaNuevaService.findAllActaTramitada(actaNuevaBusqueda,
							null);

					ActaNueva actaNuevaAux = null;

					if (actasNuevasAux != null && actasNuevasAux.size() > 0) {
						actaNuevaAux = actasNuevasAux.get(0);
					}

					if (actaNuevaAux != null) {
						actaNuevaAux = this.actaNuevaService.recuperaActaDocsActaNueva(actaNuevaAux);

						if (actaNuevaAux != null && actaNuevaAux.getDocumentoHecho() != null
								&& actaNuevaAux.getDocumentoHecho().getQ5iddocumentum() != null
								&& actaNuevaAux.getDocumentoHecho().getQ5iddocumentum()
										.equals(adjuntardocs.getThiddocumentum())) {
							throw new Y41bUDAException("error.acta.removeDocumentoActaException", true,
									new Exception());
						}
					}
				}

			}

			this.adjuntardocsService.remove(adjuntardocsAux);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getByIdDocumentoInspeccion'.
	 * 
	 * @param iddocumento
	 *            String
	 * 
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findInspeccionDocumentoActa/{iddocumento}", method = RequestMethod.GET)
	public @ResponseBody() void getByIdDocumentoInspeccionActa(@PathVariable() String iddocumento,
			HttpServletResponse response) {
		try {
			DocumentoHechoDetalle documentoHechoDetalle = new DocumentoHechoDetalle();
			documentoHechoDetalle.setQ5codocumento(iddocumento);

			documentoHechoDetalle = this.denunciaService.findDocumentoHecho(documentoHechoDetalle);

			Blob contenido = documentoHechoDetalle.getQ5datafile();
			byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ StringEscapeUtils.unescapeHtml(documentoHechoDetalle.getQ5nofile()) + "\"");
			response.setContentType(documentoHechoDetalle.getQ5contenttypefile());
			response.setContentLength(documentoHechoDetalle.getQ5sizefile());
			response.getOutputStream().write(bContenido);

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getActa'.
	 * 
	 * @param ancodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/findActaNueva/{ancodigo}", method = RequestMethod.GET)
	public @ResponseBody() Object getActa(@PathVariable(value = "ancodigo") String ancodigo,
			HttpServletRequest request) {
		try {
			ActaNueva actaNueva = new ActaNueva();
			actaNueva.setAncodigo(ancodigo);

			actaNueva = this.actaNuevaService.find(actaNueva);

			if (actaNueva == null || actaNueva.getAncodins() == null) {
				throw new Exception("No data Found.");
			} else {

				TramiteComun tramiteComun = new TramiteComun();
				tramiteComun.setIdExpediente(actaNueva.getAncodins());
				tramiteComun.setIdTramite(ancodigo);

				TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
				tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);

				tramiteComun.setTipoProcedimiento(tipoProcedimiento);

				this.instramexpService.addTramiteAdjuntarDocsTableTemporal(tramiteComun);

				TramiteComun tramiteComunAux = new TramiteComun();
				tramiteComunAux.setIdExpediente(ancodigo);
				this.instramexpService.addTramiteAdjuntarActaInfraccTableTemporal(tramiteComunAux);
			}

			return actaNueva;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addActaNueva'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 * @return ActaNueva
	 */
	@RequestMapping(value = "/altaActaNueva", method = RequestMethod.POST)
	public @ResponseBody() ActaNueva addActaNueva(HttpServletRequest request, Model model) {
		try {
			ActaNueva actaNueva = this.parseRequestFormularioActaNueva(request);

			if (actaNueva.getAncodigo() == null) {
				actaNueva.setAncodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));
			}
			model.addAttribute("codActa", actaNueva.getAncodigo());

			actaNueva = this.actaNuevaService.addActaNueva(actaNueva);

			InspeccionController.logger.info("Entity correctly inserted!" + actaNueva);

			return actaNueva;

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			InspeccionController.logger.error("###########################ERROR ALTA SOLICITUD", e);
			throw new MethodFailureException("Method failed altaActaNueva");
		}
	}

	/**
	 * Method 'updateActaNueva'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @param model
	 *            Model
	 * @return ActaNueva
	 */
	@RequestMapping(value = "/modificacionActaNueva", method = RequestMethod.POST)
	public @ResponseBody() ActaNueva updateActaNueva(HttpServletRequest request, HttpServletResponse response,
			Model model) {
		try {
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			ActaNueva actaNueva = this.parseRequestFormularioActaNueva(request);
			actaNueva = this.actaNuevaService.updateActaNueva(actaNueva, censoMonitor, false);

			InspeccionController.logger.info("Entity correctly updated!" + actaNueva);

			return actaNueva;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			InspeccionController.logger.error("###########################ERROR UPDATE SOLICITUD", e);
			throw new MethodFailureException("Method failed updateActaNueva");
		}
	}

	/**
	 * Method 'tramitarActaNueva'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @param model
	 *            Model
	 */
	@RequestMapping(value = "/tramitacionActaNueva", method = RequestMethod.POST)
	public @ResponseBody() void tramitarActaNueva(HttpServletRequest request, HttpServletResponse response,
			Model model) {
		try {
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			ActaNueva actaNueva = this.parseRequestFormularioActaNueva(request);
			actaNueva = this.actaNuevaService.updateActaNueva(actaNueva, censoMonitor, true);

			InspeccionController.logger.info("Entity correctly tramitated!" + actaNueva);

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			InspeccionController.logger.error("###########################ERROR TRAMITAR ACTA NUEVA", e);
			throw new MethodFailureException("Method failed tramitarActaNueva");
		}
	}

	/**
	 * Method 'removeActaNueva'.
	 * 
	 * @param ancodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @param model
	 *            Model
	 */
	@RequestMapping(value = "/eliminacionActaNueva/{ancodigo}", method = RequestMethod.DELETE)
	public @ResponseBody() void removeActaNueva(@PathVariable(value = "ancodigo") String ancodigo,
			HttpServletRequest request, HttpServletResponse response, Model model) {
		try {
			ActaNueva actaNueva = new ActaNueva();
			actaNueva.setAncodigo(ancodigo);
			this.actaNuevaService.remove(actaNueva);

			InspeccionController.logger.info("Entity correctly removed!");

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			InspeccionController.logger.error("###########################ERROR REMOVE INSPECCION", e);
			throw new MethodFailureException("Method failed removeActaNueva");
		}
	}

	/**
	 * Method 'removeMiCarpetaActaNueva'.
	 * 
	 * @param ancodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @param model
	 *            Model
	 */
	@RequestMapping(value = "/eliminacionMiCarpetaActaNueva/{ancodigo}", method = RequestMethod.DELETE)
	public @ResponseBody() void removeMiCarpetaActaNueva(@PathVariable(value = "ancodigo") String ancodigo,
			HttpServletRequest request, HttpServletResponse response, Model model) {
		try {
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			ActaNueva actaNueva = new ActaNueva();
			actaNueva.setAncodigo(ancodigo);
			this.actaNuevaService.removeMiCarpeta(actaNueva, censoMonitor);

			InspeccionController.logger.info("Entity correctly removed!");

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			InspeccionController.logger.error("###########################ERROR REMOVE INSPECCION", e);
			throw new MethodFailureException("Method failed removeActaNueva");
		}
	}

	/**
	 * Recoge los datos del formulario del Acta Nueva y los transforma en un
	 * objeto.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return ActaNueva
	 */
	private ActaNueva parseRequestFormularioActaNueva(HttpServletRequest request) {

		try {
			ActaNueva actaNueva = new ActaNueva();
			Locale locale = LocaleContextHolder.getLocale();

			// campos formulario
			String ancodigo = request.getParameter("ancodigo");
			if (ancodigo != null && !"".equals(ancodigo)) {
				actaNueva.setAncodigo(ancodigo);
			}
			String ancodins = request.getParameter("ancodins");
			if (ancodins != null && !"".equals(ancodins)) {
				actaNueva.setAncodins(ancodins);
			}

			actaNueva.setAnyadirPlantilla(request.getParameter("anyadirPlantilla"));
			actaNueva.setAncodac(request.getParameter("ancodac"));
			actaNueva.setAnfecha(Y41bUtils.parseDate(request.getParameter("anfecha"), locale));
			actaNueva.setAnhoraini(request.getParameter("anhoraini"));
			actaNueva.setAnhorafin(request.getParameter("anhorafin"));
			actaNueva.setAntipo(request.getParameter("antipo"));

			actaNueva.setAndnico(request.getParameter("andnico"));
			actaNueva.setAnnombreco(request.getParameter("annombreco"));
			actaNueva.setAnnoraCpId(request.getParameter("annoraCpId"));
			actaNueva.setAnnombreCp(request.getParameter("annombre_cp"));
			actaNueva.setAnnoraProvinciaId(request.getParameter("noraProvinciaId"));
			// actaNueva.setAnnombreProvincia(request
			// .getParameter("annombreProvincia"));
			actaNueva.setAnnoraMunicipioId(request.getParameter("noraMunicipioId"));
			// actaNueva.setAnnombreMunicipio(request
			// .getParameter("annombreMunicipio"));
			actaNueva.setAnnoraLocalidadId(request.getParameter("noraLocalidadId"));
			// actaNueva.setAnnombreLocalidad(request
			// .getParameter("annombreLocalidad"));
			actaNueva.setAnnoraCalleId(request.getParameter("annoraCalleId"));
			actaNueva.setAnnombreCalle(request.getParameter("annombreCalle"));
			actaNueva.setAnnoraPortalId(request.getParameter("noraPortalId"));
			// actaNueva.setAnnombrePortal(request.getParameter("annombrePortal"));
			actaNueva.setAnnombrePiso(request.getParameter("annombrePiso"));
			actaNueva.setAntelefonoco(request.getParameter("antelefonoco"));
			actaNueva.setAncondicionco(request.getParameter("ancondicionco"));
			actaNueva.setAnreqresumen(request.getParameter("anreqresumen"));
			actaNueva.setAninfresumen(request.getParameter("aninfresumen"));
			if (request.getParameter("anligadoprotocolo") != null
					&& Y41bConstantes.VALOR_SI.equals(request.getParameter("anligadoprotocolo"))) {
				actaNueva.setAnligadoprotocolo(Y41bConstantes.VALOR_SI);
			}
			if (request.getParameter("aninfpropuesta") != null
					&& Y41bConstantes.VALOR_SI.equals(request.getParameter("aninfpropuesta"))) {
				actaNueva.setAninfpropuesta(Y41bConstantes.VALOR_SI);
			}

			String ananiomu = request.getParameter("ananiomu");
			if (ananiomu == null || "".equals(ananiomu)) {
				actaNueva.setAnaniomu(null);
			} else {
				try {
					actaNueva.setAnaniomu(Long.parseLong(ananiomu));
				} catch (NumberFormatException ex) {
					throw new Y41bUDAException("error.inspeccion.numeroMuestraNoValidoException", true, ex);
				}
			}
			String annumeromu = request.getParameter("annumeromu");
			if (annumeromu == null || "".equals(annumeromu)) {
				actaNueva.setAnnumeromu(null);
			} else {
				try {
					actaNueva.setAnnumeromu(Long.parseLong(annumeromu));
				} catch (NumberFormatException ex) {
					throw new Y41bUDAException("error.inspeccion.numeroMuestraNoValidoException", true, ex);
				}
			}
			actaNueva.setAnespefificmu(request.getParameter("anespefificmu"));
			actaNueva.setAncodcaractermu(request.getParameter("ancodcaractermu"));
			actaNueva.setAncodunidadesmu(request.getParameter("ancodunidadesmu"));
			String anunidadesotrosmu = request.getParameter("anunidadesotrosmu");
			if (anunidadesotrosmu == null || "".equals(anunidadesotrosmu)) {
				actaNueva.setAnunidadesotrosmu(null);
			} else {
				actaNueva.setAnunidadesotrosmu(new BigDecimal(anunidadesotrosmu));
			}
			String anejemplaresunidadmu = request.getParameter("anejemplaresunidadmu");
			if (anejemplaresunidadmu == null || "".equals(anejemplaresunidadmu)) {
				actaNueva.setAnejemplaresunidadmu(null);
			} else {
				actaNueva.setAnejemplaresunidadmu(new BigDecimal(anejemplaresunidadmu));
			}
			String animportemu = request.getParameter("animportemu");
			if (animportemu == null || "".equals(animportemu)) {
				actaNueva.setAnimportemu(null);
			} else {
				actaNueva.setAnimportemu(new BigDecimal(animportemu.replaceAll(",", ".")));
			}
			actaNueva.setAndepositomu(request.getParameter("andepositomu"));
			String annumerolabsmu = request.getParameter("annumerolabsmu");
			if (annumerolabsmu == null || "".equals(annumerolabsmu)) {
				actaNueva.setAnnumerolabsmu(null);
			} else {
				actaNueva.setAnnumerolabsmu(new BigDecimal(annumerolabsmu));
			}
			String anunidadesinmov = request.getParameter("anunidadesinmov");
			if (anunidadesinmov == null || "".equals(anunidadesinmov)) {
				actaNueva.setAnunidadesinmov(null);
			} else {
				actaNueva.setAnunidadesinmov(new BigDecimal(anunidadesinmov));
			}
			String anunidadesdesinmov = request.getParameter("anunidadesdesinmov");
			if (anunidadesdesinmov == null || "".equals(anunidadesdesinmov)) {
				actaNueva.setAnunidadesdesinmov(null);
			} else {
				actaNueva.setAnunidadesdesinmov(new BigDecimal(anunidadesdesinmov));
			}
			String anunidadesdestruidas = request.getParameter("anunidadesdestruidas");
			if (anunidadesdestruidas == null || "".equals(anunidadesdestruidas)) {
				actaNueva.setAnunidadesdestruidas(null);
			} else {
				actaNueva.setAnunidadesdestruidas(new BigDecimal(anunidadesdestruidas));
			}
			String anunidadesdevueltas = request.getParameter("anunidadesdevueltas");
			if (anunidadesdevueltas == null || "".equals(anunidadesdevueltas)) {
				actaNueva.setAnunidadesdevueltas(null);
			} else {
				actaNueva.setAnunidadesdevueltas(new BigDecimal(anunidadesdevueltas));
			}

			String anunidadesrecuperadas = request.getParameter("anunidadesrecuperadas");
			if (anunidadesrecuperadas == null || "".equals(anunidadesrecuperadas)) {
				actaNueva.setAnunidadesrecuperadas(null);
			} else {
				actaNueva.setAnunidadesrecuperadas(new BigDecimal(anunidadesrecuperadas));
			}

			actaNueva.setAndestinoinmov(request.getParameter("andestinoinmov"));
			actaNueva.setAnlugarinmov(request.getParameter("anlugarinmov"));

			String anunidadesrevisadas = request.getParameter("anunidadesrevisadas");
			if (anunidadesrevisadas == null || "".equals(anunidadesrevisadas)) {
				actaNueva.setAnunidadesrevisadas(null);
			} else {
				actaNueva.setAnunidadesrevisadas(new BigDecimal(anunidadesrevisadas));
			}

			return actaNueva;
		} catch (Exception e) {
			InspeccionController.logger.error("###########################ERROR ALTA SOLICITUD", e);
			throw new MethodFailureException("Method failed addDocumentoSolicitudDetalle");
		}
	}

	/**
	 * Recuperar las infracciones para un Acta Nueva
	 * 
	 * @param codActa
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return jqGrid
	 */
	@RequestMapping(value = "/findAllInfraccionesActaNueva/{codActa}", method = RequestMethod.GET, headers = {
			"JQGridModel=true" })
	public @ResponseBody() JQGridJSONModel findAllArticulos(@PathVariable() String codActa,
			HttpServletRequest request) {
		try {
			JQGridJSONModel jqGrid = null;
			Pagination pagination = null;

			pagination = new Pagination();
			pagination.setPage(Long.valueOf(request.getParameter("page")));
			pagination.setRows(Long.valueOf(request.getParameter("rows")));
			pagination.setSort(request.getParameter("sidx"));
			pagination.setAscDsc(request.getParameter("sord"));

			AdjunInfraccHechoDenun adjunInfraccHechoDenunFilter = new AdjunInfraccHechoDenun();
			adjunInfraccHechoDenunFilter.setHicohd(codActa);

			List<AdjunInfraccHechoDenun> listAdjunInfraccHechoDenun = this.adjunInfraccHechoDenunService
					.findAll(adjunInfraccHechoDenunFilter, pagination);

			if (listAdjunInfraccHechoDenun == null) {
				throw new Exception("No data Found.");
			}

			Long total = this.adjunInfraccHechoDenunService.findAllCount(adjunInfraccHechoDenunFilter);

			JQGridJSONModel data = new JQGridJSONModel();
			data.setPage(request.getParameter("page"));
			data.setRecords(total.intValue());
			data.setTotal(total, pagination.getRows());
			data.setRows(listAdjunInfraccHechoDenun);

			jqGrid = new JQGridJSONModel(pagination, total, listAdjunInfraccHechoDenun);

			return jqGrid;
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'addInfraccionActaNueva'.
	 * 
	 * @param codActa
	 *            String
	 * @param adjunInfraccHechoDenun
	 *            AdjunInfraccHechoDenun
	 * @param request
	 *            HttpServletRequest
	 * @return AdjunInfraccHechoDenun
	 */
	@RequestMapping(value = "/addInfraccionActaNueva/{codActa}", method = RequestMethod.POST)
	public @ResponseBody() AdjunInfraccHechoDenun addInfraccionActaNueva(@PathVariable() String codActa,
			@RequestBody() AdjunInfraccHechoDenun adjunInfraccHechoDenun, HttpServletRequest request) {
		try {
			adjunInfraccHechoDenun.setHicohd(codActa);

			String hiinexii = null;
			if (adjunInfraccHechoDenun.getHicotti() != null && adjunInfraccHechoDenun.getHicotti().indexOf("N0") > -1) {
				// es un articulo
				hiinexii = "S";
			} else {
				hiinexii = "N";
			}
			adjunInfraccHechoDenun.setHiinexii(hiinexii);

			this.adjunInfraccHechoDenunService.add(adjunInfraccHechoDenun);

			InspeccionController.logger.info("Entity correctly inserted!");

			return adjunInfraccHechoDenun;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'addInfraccionProtocolo'.
	 * 
	 * @param codInspeccion
	 *            String
	 * @param codActa
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return
	 */
	@RequestMapping(value = "/addInfraccionProtocolo/{codInspeccion}/{codActa}", method = RequestMethod.POST)
	public void addInfraccionProtocolo(@PathVariable() String codInspeccion, @PathVariable() String codActa,
			HttpServletRequest request) {
		try {
			ActaNueva actaNueva = new ActaNueva();
			actaNueva.setAncodins(codInspeccion);
			actaNueva.setAncodigo(codActa);

			this.actaNuevaService.addInfraccionProtocolo(actaNueva);

			InspeccionController.logger.info("Entity correctly inserted!");

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'eliminarInfraccionProtocolo'.
	 * 
	 * @param codInspeccion
	 *            String
	 * @param codActa
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarInfraccionProtocolo/{codInspeccion}/{codActa}", method = RequestMethod.DELETE)
	public void eliminarInfraccionProtocolo(@PathVariable() String codInspeccion, @PathVariable() String codActa,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			ActaNueva actaNueva = new ActaNueva();
			actaNueva.setAncodins(codInspeccion);
			actaNueva.setAncodigo(codActa);

			this.actaNuevaService.removeInfraccionProtocolo(actaNueva);

			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'removeInfracciones'.
	 * 
	 * @param codInspeccion
	 *            String
	 * @param hicodigo
	 *            Long
	 * @param codComunicacionSoivre
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarInfraccionActaNueva/{codInspeccion}/{hicodigo}", method = RequestMethod.DELETE)
	public void removeInfracciones(@PathVariable() String codInspeccion, @PathVariable() String hicodigo,
			@ModelAttribute(value = "codComunicacionSoivre") String codComunicacionSoivre,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			AdjunInfraccHechoDenun adjunInfraccHechoDenunAux = new AdjunInfraccHechoDenun();
			adjunInfraccHechoDenunAux.setHicodigo(hicodigo);
			adjunInfraccHechoDenunAux.setHicohd(codInspeccion);

			this.adjunInfraccHechoDenunService.remove(adjunInfraccHechoDenunAux);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllPosibleTramite'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param trPosibleCodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * 
	 * 
	 * @return String
	 */
	@RequestMapping(value = "/getAllPosibleTramite/{atcodigo}/{trPosibleCodigo}", method = RequestMethod.GET)
	public @ResponseBody() Object getAllPosibleTramite(@PathVariable() String atcodigo,
			@PathVariable() String trPosibleCodigo, HttpServletRequest request) {
		try {
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			PosibleTramite posibleTramite = new PosibleTramite();
			TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
			tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);

			posibleTramite.setTipoProcedimiento(tipoProcedimiento);
			posibleTramite.setTrposiblecodigoorigen(trPosibleCodigo);

			List<Tramite> tramites = new ArrayList<Tramite>();

			TramiteInspeccionDetalle tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
			tramiteInspeccionDetalle.setAtcodigo(atcodigo);

			Long tramiteRegistroInspeccionTramitado = this.tramiteInspeccionService
					.findAllTramiteRegistroInspeccionTramitadoCount(tramiteInspeccionDetalle);

			if (tramiteRegistroInspeccionTramitado > 0) {
				tramites = this.posibleTramiteService.findAllPosibleTramiteInspecciones(posibleTramite, censoMonitor,
						null);
			} else {
				tramites = new ArrayList<Tramite>();
			}

			if (tramites == null) {
				throw new Exception("No data Found.");
			}
			return tramites;
		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException(trPosibleCodigo.toString());
		}
	}

	/**
	 * Method 'getAllPosibleTramiteCount'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param trPosibleCodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * 
	 * 
	 * @return String
	 */
	@RequestMapping(value = "/getAllPosibleTramiteCount/{atcodigo}/{trPosibleCodigo}", method = RequestMethod.GET)
	public @ResponseBody Long getAllPosibleTramiteCount(@PathVariable String atcodigo,
			@PathVariable String trPosibleCodigo, HttpServletRequest request) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			PosibleTramite posibleTramite = new PosibleTramite();
			TipoProcedimiento tipoProcedimiento = new TipoProcedimiento();
			tipoProcedimiento.setPcodigo(Y41bConstantes.TIPO_PROC_INSPECCIONES);

			posibleTramite.setTipoProcedimiento(tipoProcedimiento);
			posibleTramite.setTrposiblecodigoorigen(trPosibleCodigo);

			Long numTramites;

			TramiteInspeccionDetalle tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
			tramiteInspeccionDetalle.setAtcodigo(atcodigo);

			Long tramiteRegistroInspeccionTramitado = this.tramiteInspeccionService
					.findAllTramiteRegistroInspeccionTramitadoCount(tramiteInspeccionDetalle);

			if (tramiteRegistroInspeccionTramitado > 0) {
				numTramites = this.posibleTramiteService.findAllPosibleTramiteCount(posibleTramite, censoMonitor);
			} else {
				numTramites = new Long(0);
			}

			if (numTramites == null) {
				throw new Exception("No data Found.");
			}
			return numTramites;
		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException(trPosibleCodigo.toString());
		}
	}

	/**
	 * Method 'countByIdTramitacionTrcodigo'. Comprueba la existencia de un tipo
	 * de tramite concreto dentro de la actuacion
	 * 
	 * @param atcodigo
	 *            String
	 * @param trcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "/tramitacion/{atcodigo}/{trcodigo}", method = RequestMethod.GET)
	public @ResponseBody() Long countByIdTramitacionTrcodigo(@PathVariable() String atcodigo,
			@PathVariable() String trcodigo, HttpServletRequest request) {
		try {

			TramiteInspeccionDetalle tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
			tramiteInspeccionDetalle.setAtcodigo(atcodigo);
			tramiteInspeccionDetalle.setTrcodigo(trcodigo);

			Long total = this.inspeccionService.findAllTramiteInspeccionCount(tramiteInspeccionDetalle);

			return total;

		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}

	/**
	 * Method 'eliminarTramite'.
	 * 
	 * @param ticodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/tramitacion/eliminarTramite/{ticodigo}", method = RequestMethod.POST)
	public @ResponseBody() void eliminarTramite(@PathVariable() String ticodigo, HttpServletRequest request) {
		try {
			this.instramexpService.eliminarTramite(ticodigo);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'aceptarPropuestaInspeccion'.
	 * 
	 * @param filtros
	 *            HashMap<String, String>
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return InspeccionDetalle
	 */
	@RequestMapping(value = "/aceptarPropuestaInspeccion", method = RequestMethod.POST)
	public @ResponseBody() InspeccionDetalle aceptarPropuestaInspeccion(@RequestBody() HashMap<String, String> filtros,
			HttpServletRequest request) {
		try {
			String idPropuestaInspeccion = filtros.get("idPropuestaInspeccion");

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			Locale locale = LocaleContextHolder.getLocale();

			InspeccionDetalle inspeccionDetalle = this.inspeccionesPropBandejaService
					.aceptarPropuestaInspeccion(censoMonitor, idPropuestaInspeccion, locale.getLanguage());

			InspeccionController.logger.info("Propuesta de inspeccion aceptada!");

			return inspeccionDetalle;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException("Method failed /inspeccion/aceptarPropuestaInspeccion");
		}
	}

	/**
	 * Method 'rechazarPropuestaInspeccion'.
	 * 
	 * @param filtros
	 *            HashMap<String, String>
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/rechazarPropuestaInspeccion", method = RequestMethod.POST)
	public @ResponseBody() void rechazarPropuestaInspeccion(@RequestBody() HashMap<String, String> filtros,
			HttpServletRequest request) {
		try {
			String idPropuestaInspeccion = filtros.get("idPropuestaInspeccion");
			String observaciones = filtros.get("observaciones");

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			Locale locale = LocaleContextHolder.getLocale();

			this.inspeccionesPropBandejaService.rechazarPropuestaInspeccion(censoMonitor, idPropuestaInspeccion,
					observaciones, locale.getLanguage());

			InspeccionController.logger.info("Propuesta de inspeccion rechazada!");

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException("Method failed /inspeccion/rechazarPropuestaInspeccion");
		}
	}

	/**
	 * Method 'getInspeccionByNumExpediente'.
	 * 
	 * @param accoor
	 *            String
	 * @param acnror
	 *            String
	 * @param acnran
	 *            BigDecimal
	 * @param atnror
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * 
	 * 
	 * @return String
	 */
	@RequestMapping(value = "/getInspeccionByNumExpediente/{accoor}/{acnror}/{acnran}/{atnror}", method = RequestMethod.GET)
	public @ResponseBody InspeccionDetalle getInspeccionByNumExpediente(@PathVariable String accoor,
			@PathVariable String acnror, @PathVariable BigDecimal acnran, @PathVariable String atnror,
			HttpServletRequest request) {
		try {

			InspeccionDetalle inspeccionDetalle = new InspeccionDetalle();
			inspeccionDetalle.setAccoor(accoor);
			inspeccionDetalle.setAcnror(acnror);
			inspeccionDetalle.setAcnran(acnran);
			inspeccionDetalle.setAtnror(atnror);

			inspeccionDetalle = this.inspeccionService.findNumExpedienteInspeccion(inspeccionDetalle);

			if (inspeccionDetalle == null) {
				throw new Exception(accoor.toString());
			}
			return inspeccionDetalle;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException(accoor.toString());
		}
	}

	/**
	 * Method 'comprobarProtocolo'.
	 * 
	 * @param atcodigo
	 *            String
	 * 
	 * @return boolean
	 */
	@RequestMapping(value = "/comprobarProtocolo/{atcodigo}", method = RequestMethod.GET)
	public @ResponseBody boolean comprobarProtocolo(@PathVariable String atcodigo) {
		return this.tipPregProtocService.checkAnswersFilled(atcodigo);
	}

	/**
	 * Method 'guardarFechaProtocolo'.
	 * 
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @param model
	 *            Model
	 */
	@RequestMapping(value = "/guardarFechaProtocolo", method = RequestMethod.POST)
	public void guardarFechaProtocolo(@RequestBody InspeccionDetalle inspeccionDetalle, Model model) {
		try {
			this.inspeccionService.updateFechaProtocolo(inspeccionDetalle);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getdatosActaNueva'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param ancodac
	 *            String
	 * @param ancodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return actaNueva ActaNueva
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "/getdatosActaNueva", method = RequestMethod.GET)
	public @ResponseBody() ActaNueva getdatosActaNueva(
			@RequestParam(value = "atcodigo", required = false) String atcodigo,
			@RequestParam(value = "ancodac", required = false) String ancodac,
			@RequestParam(value = "ancodigo", required = false) String ancodigo, HttpServletRequest request)
			throws Exception {
		try {
			ActaNueva actaNueva = new ActaNueva();
			actaNueva.setAncodac(ancodac);
			actaNueva.setAncodins(atcodigo);
			actaNueva.setAncodigo(ancodigo);

			actaNueva = this.actaNuevaService.findByAncodac(actaNueva);

			return actaNueva;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getDocumentoActaNueva'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param ancodac
	 *            String
	 * @param ancodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return actaNueva ActaNueva
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "/getDocumentoActaNueva", method = RequestMethod.POST)
	public @ResponseBody() ActaNueva getDocumentoActaNueva(
			@RequestParam(value = "atcodigo", required = false) String atcodigo,
			@RequestParam(value = "ancodac", required = false) String ancodac,
			@RequestParam(value = "ancodigo", required = false) String ancodigo, HttpServletRequest request)
			throws Exception {
		try {
			ActaNueva actaNueva = new ActaNueva();
			actaNueva.setAncodac(ancodac);
			actaNueva.setAncodins(atcodigo);
			actaNueva.setAncodigo(ancodigo);

			actaNueva = this.actaNuevaService.getDocumentoActaNueva(actaNueva);

			return actaNueva;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllTipoDocumentos'.
	 * 
	 * @return List
	 */
	@RequestMapping(value = "/findAllTipoDocumento", method = RequestMethod.GET)
	public @ResponseBody List<TipoDocumento> getAllTipoDocumento() {
		return this.inspeccionesTipoDocumentoService.findAllTipoDocumento(new InspeccionesTipoDocumento(), null);
	}

	/**
	 * Method 'reabrirExpediente'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/tramitacion/reabrirExpediente/{atcodigo}", method = RequestMethod.POST)
	public @ResponseBody void reabrirExpediente(@PathVariable String atcodigo, HttpServletRequest request) {
		try {
			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			this.instramexpService.reabrirExpediente(atcodigo, censoMonitor);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getEtiqueta'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * 
	 */
	@RequestMapping(value = "/etiqueta/{atcodigo}", method = RequestMethod.GET)
	public @ResponseBody void getEtiqueta(@PathVariable String atcodigo, HttpServletResponse response) {
		try {
			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(atcodigo);

			PlantillaInspeccionDetalle plantillaInspeccionDetalle = this.actaService
					.findPlantillaSolicitudDetalle(actuacion);

			if (plantillaInspeccionDetalle == null) {
				throw new Exception(atcodigo.toString());
			}

			String rutaRTF = (String) appConfiguration.get("y41bVistaWar.ruta.plantillas.word");
			String rutaXML = (String) appConfiguration.get("y41bVistaWar.rutaxml.plantillas.word");
			String nombreRTF = Y41bConstantes.NOMBRE_PLANTILLA_INSPECCIONES_ETIQUETA_RTF;
			String nombreXML = Y41bConstantes.NOMBRE_PLANTILLA_INSPECCIONES_ETIQUETA_XML;
			String rutaCompletaRTF = rutaRTF + nombreRTF;
			String rutaCompletaXML = rutaXML + nombreXML;

			String plantilla = new String(Y41bDocumento.leerArchivoOrigen(rutaCompletaRTF));

			String strFileDataDecode = Y41bGenerarDocumento.generarDocumentoWord(rutaCompletaXML,
					plantillaInspeccionDetalle, plantilla);

			byte[] bytesFichero = strFileDataDecode.getBytes();

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			String nombreFichero = plantillaInspeccionDetalle.getNumExpediente() + ".rtf";

			response.setHeader("Content-Disposition", "attachment; filename=\"" + nombreFichero + "\"");
			response.setContentType("application/msword");
			response.setContentLength(bytesFichero.length);
			response.getOutputStream().write(bytesFichero);

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException(atcodigo.toString());
		} catch (Throwable t) {
			t.printStackTrace();
			throw new ResourceNotFoundException(atcodigo.toString());
		}
	}

	/**
	 * Method 'adjuntarDocsTramiteGenerico'.
	 * 
	 * @param tramiteGenerico
	 *            TramiteGenerico
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/adjuntarDocsTramite", method = RequestMethod.POST)
	public void adjuntarDocsTramiteGenerico(@RequestBody TramiteGenerico tramiteGenerico, HttpServletResponse response,
			HttpServletRequest request) {
		try {

			TramiteComun tramiteComun = new TramiteComun();
			tramiteComun.setIdTramite(tramiteGenerico.getIdTramite());
			// insertar los documento en la tabla intermedia de hechos.
			List<DocumentoExpediente> listDocumentoExpediente = tramiteGenerico.getDocumentosExpediente();
			this.soltramexpService.addDocumentosTableTemporalActa(listDocumentoExpediente, tramiteComun);

			logger.info("Entity correctly inserted!");
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'saveActaFirmaDocHash'.
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/saveActaFirmaDocHash", method = RequestMethod.PUT)
	public @ResponseBody void saveActaFirmaDocHash(@RequestBody Adjuntardocs adjuntardocs, HttpServletRequest request) {
		try {
			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			// Anyadimos a la bandejaFirma informacion de BBDD de esa bandeja
			// que vamos a necesitar
			BufferedInputStream bIS = this.y41bPifAdapterService.getFile(adjuntardocs.getRutaPifFileFirma());

			// Verificar firmante
			BASE64Decoder b64Decoder = new BASE64Decoder();
			String firmaCodificada = this.extraerFirma(Y41bUtils.convertInputStreamToString(bIS));

			adjuntardocs.setFirma(firmaCodificada);
			String strFirmaDecodificada = new String(b64Decoder.decodeBuffer(firmaCodificada));
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			factory.setValidating(false);
			factory.setIgnoringElementContentWhitespace(true);
			DocumentBuilder builder = factory.newDocumentBuilder();
			StringReader stringIn = null;

			Parametros parametros = new Parametros();
			parametros.setParametro(Y41bConstantes.VALIDAR_FIRMANTE_BANDEJA_FIRMA);

			parametros = this.parametrosService.find(parametros);

			if (parametros.getValor() != null && parametros.getValor().toUpperCase().equals(Y41bConstantes.VALOR_SI)) {

				stringIn = new StringReader(strFirmaDecodificada);

				Document document = builder.parse(new InputSource(stringIn));
				String strCertificado = this.buscarDomString(document, "//X509Certificate/text()");

				SignCertificateType signCertificateType = this.y41bPlateaAdapterService
						.verifyCertificate(b64Decoder.decodeBuffer(strCertificado));

				if (signCertificateType.getSuscriptor() != null
						&& signCertificateType.getSuscriptor().getDni().equals(censoMonitor.getModni())) {
					// Coincide el firmante con el conectado
				} else if (signCertificateType.getEntidad() != null
						&& signCertificateType.getEntidad().getCif().equals(censoMonitor.getModni())) {
					// Coincide el firmante con el conectado
				} else {
					// No coincide el firmante con el conectado
					throw new Y41bUDAException("error.bandejafirma.nocoincide", true, new Exception());
				}
			}

			// Anyadimos a la bandejaFirma informacion de BBDD de esa
			// bandeja
			// que vamos a necesitar
			Adjuntardocs adjuntardocsBBDD = null;
			adjuntardocsBBDD = this.adjuntardocsService.findDocByPK(adjuntardocs);

			adjuntardocs.setThiddocumentum(adjuntardocsBBDD.getThiddocumentum());
			adjuntardocs.setThnofile(adjuntardocsBBDD.getThnofile());

			this.actaNuevaService.saveActaFirmaDocHash(adjuntardocs);

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'subirDocumentoPIF'.
	 * 
	 * @param iddokusi
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/subirDocumentoPIF/{iddokusi}", method = RequestMethod.POST)
	public @ResponseBody String subirDocumentoPIF(@PathVariable String iddokusi) {

		Documento documento = new Documento();
		User user = new User();
		user.setNombre(Y41bConstantes.COD_APLICACION);
		user.setDni(Y41bConstantes.COD_APLICACION);
		documento.setUser(user);
		Procedure procedure = new Procedure();
		procedure.setIdProcedimiento(Y41bConstantes.ID_PROCEDIMIENTO_INSPECCIONES);
		documento.setProcedure(procedure);
		documento.setOidDokusi(iddokusi);

		String pathTo = "/" + Y41bConstantes.COD_APLICACION_HSHF.toLowerCase() + "/"
				+ Y41bConstantes.COD_APLICACION.toLowerCase();

		Documento documentoRdo = y41bDokusiAdapterService.descargarPifDocumentoDokusiRuta(documento, pathTo);

		return documentoRdo.getPifId();
	}

	/**
	 * Method 'extraerFirma'. Extrae la firma codificada del xml recibido por el
	 * componente de firma
	 * 
	 * @param ejgvDocument
	 *            String en formato XML con una cabecera ejgvDocument que
	 *            contiene la firma codificada en Base 64
	 * @return texto con la firma codificada en Base 64 o null si no existe
	 */
	private String extraerFirma(String ejgvDocument) {
		try {
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			factory.setValidating(false);
			factory.setIgnoringElementContentWhitespace(true);
			DocumentBuilder builder = factory.newDocumentBuilder();
			StringReader stringIn = new StringReader(ejgvDocument);

			Document document = builder.parse(new InputSource(stringIn));

			return this.buscarDomString(document, "//sign/text()");

		} catch (Y41bUDAException e) {
			return null;
		} catch (SAXException e) {
			return null;
		} catch (IOException e) {
			return null;
		} catch (ParserConfigurationException e) {
			return null;
		}
	}

	private String buscarDomString(Document docDom, String strPath) {
		NodeList NodeLiResultado = null;
		String strValor = "";

		try {
			NodeLiResultado = XPathAPI.selectNodeList(docDom, strPath);

			if (NodeLiResultado.getLength() != 0) {
				strValor = (String) NodeLiResultado.item(0).getNodeValue();
			} else {
				strValor = "";
			}

		} catch (Exception ex) {
			ex.printStackTrace(System.out);
		}

		return strValor;
	}

	/**
	 * Method 'generarActa'.
	 * 
	 * @param codActa
	 *            String
	 * @param inspeccionDetalle
	 *            InspeccionDetalle
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * 
	 */

	@RequestMapping(value = "/generarActa/{codActa}", method = RequestMethod.GET)
	public @ResponseBody() void generarActa(@PathVariable() String codActa,
			@ModelAttribute(value = "inspeccionDetalle") InspeccionDetalle inspeccionDetalle,
			HttpServletRequest request, HttpServletResponse response) {
		try {
			ActaNueva actaNueva = new ActaNueva();
			actaNueva.setAncodigo(codActa);
			actaNueva.setAncodins(inspeccionDetalle.getAtcodigo());

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			String strFileData = this.actaNuevaService.generarActaInspeccionWeb(actaNueva, censoMonitor);

			byte[] bytesFichero = strFileData.getBytes();

			Actuacion actuacionaux = new Actuacion();
			actuacionaux.setAtcodigo(actaNueva.getAncodins());

			InspeccionDetalle inspeccionDetalleAux = this.actaService.findInspeccion(actuacionaux, null);

			StringBuffer nombreFichero = new StringBuffer();

			if (inspeccionDetalleAux != null) {
				nombreFichero.append(inspeccionDetalleAux.getAccoor()).append("-")
						.append(inspeccionDetalleAux.getAcnror()).append("-").append(inspeccionDetalleAux.getAcnran())
						.append("-").append(inspeccionDetalleAux.getAtnror());
			}

			nombreFichero.append("-").append("Acta");

			actaNueva = new ActaNueva();
			actaNueva.setAncodigo(codActa);

			actaNueva = this.actaNuevaService.find(actaNueva);
			nombreFichero.append("-").append(actaNueva.getAncodac());

			response.setHeader("Content-Disposition", "attachment; filename=\"" + nombreFichero.append(".rtf") + "\"");
			response.setContentType("application/msword");
			response.setContentLength(bytesFichero.length);
			response.getOutputStream().write(bytesFichero);

			// Vaciamos el stream
			response.getOutputStream().flush();
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException("Method failed");
		}
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////
	/////////////////////////// TABLA PROTOCOLO INSPECCIONES
	//////////////////////////////////////////////////////////////////////////////////////////////////////// OFICIO//////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * Method 'getAllProtocolosInspeccionesOficio'.
	 * 
	 * @param atcodigo_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/protocolosInspeccionesOficio", method = RequestMethod.GET)
	public @ResponseBody Object getAllProtocolosInspeccionesOficio(
			@RequestParam(value = "atcodigo", required = false) String atcodigo_, HttpServletRequest request) {
		try {

			// control de los campos susceptibles de llegar a "" desde el filtro
			String atcodigo = ("".equals(atcodigo_)) ? null : atcodigo_;

			ProtocoloInspeccion filterProtocoloInspeccion = new ProtocoloInspeccion(null, atcodigo);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<TipProtocolo> tipProtocolos = this.inspeccionService
						.findAllProtocoloInspeccion(filterProtocoloInspeccion, pagination);

				if (tipProtocolos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.inspeccionService.findAllProtocoloInspeccionCount(filterProtocoloInspeccion);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(tipProtocolos);
				return data;
			} else {
				List<TipProtocolo> tipProtocolos = this.inspeccionService
						.findAllProtocoloInspeccion(filterProtocoloInspeccion, pagination);
				if (tipProtocolos == null) {
					throw new Exception("No data Found.");
				}
				return tipProtocolos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllProtocolosInspeccionesOficioCount'.
	 * 
	 * @param atcodigo_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/protocolosInspeccionesOficiocount", method = RequestMethod.GET)
	public @ResponseBody Object getAllProtocolosInspeccionesOficioCount(
			@RequestParam(value = "atcodigo", required = false) String atcodigo_, HttpServletRequest request) {
		try {

			// control de los campos susceptibles de llegar a "" desde el filtro
			String atcodigo = ("".equals(atcodigo_)) ? null : atcodigo_;

			ProtocoloInspeccion filterProtocoloInspeccion = new ProtocoloInspeccion(null, atcodigo);

			Long total = this.inspeccionService.findAllProtocoloInspeccionCount(filterProtocoloInspeccion);

			return total;
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'addProtocolosInspeccionesOficio'.
	 * 
	 * @param protocoloInspeccion
	 *            ProtocoloInspeccion
	 * @return ProtocoloInspeccion
	 */
	@RequestMapping(value = "/addProtocolosInspeccionesOficio", method = RequestMethod.POST)
	public @ResponseBody ProtocoloInspeccion addProtocolosInspeccionesOficio(
			@RequestBody ProtocoloInspeccion protocoloInspeccion) {
		try {
			ProtocoloInspeccion protocoloInspeccionAux = this.inspeccionService
					.addProtocolosInspeccionesOficio(protocoloInspeccion);
			logger.info("Entity correctly inserted!");
			return protocoloInspeccionAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeProtocolosInspeccionesOficio'.
	 * 
	 * @param tpcodigo_
	 *            String
	 * @param atcodigo_
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarProtocolosInspeccionesOficio", method = RequestMethod.DELETE)
	public void removeProtocolosInspeccionesOficio(@RequestParam(value = "tpcodigo", required = false) String tpcodigo_,
			@RequestParam(value = "atcodigo") String atcodigo_, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {

			String tpcodigo = ("".equals(tpcodigo_)) ? null : tpcodigo_;

			String atcodigo = ("".equals(atcodigo_)) ? null : atcodigo_;

			ProtocoloInspeccion protocoloInspeccion = new ProtocoloInspeccion(tpcodigo, atcodigo);

			this.inspeccionService.removeProtocolosInspeccionesOficio(protocoloInspeccion);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/////
	/**
	 * Method 'getAllBandejaInspecciones'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/findAllDocsMovilidad/{atcodigo}", method = RequestMethod.GET)
	public @ResponseBody() Object getAllDocsMovilidad(@PathVariable() String atcodigo, HttpServletRequest request,
			Model model) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(atcodigo);

			InspeccionDetalle inspeccionDetalle = this.actaService.findInspeccion(actuacion, censoMonitor);

			List<DocumentoExpediente> listDocumentoExpediente = null;
			Pagination pagination = null;
			Long total = new Long(0);

			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				listDocumentoExpediente = this.instramexpService.findAllDocsMovilidad(inspeccionDetalle, pagination);

				if (listDocumentoExpediente == null) {
					throw new Exception("No data Found.");
				}
				total = this.instramexpService.findAllDocsMovilidadCount(inspeccionDetalle);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listDocumentoExpediente);
				return data;
			} else {

				listDocumentoExpediente = this.instramexpService.findAllDocsMovilidad(inspeccionDetalle, null);

				if (listDocumentoExpediente == null) {
					throw new Exception("No data Found.");
				}
				return listDocumentoExpediente;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getByIdDocumentoMovilidad'.
	 * 
	 * @param codocumento
	 *            String
	 * 
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/findDocMovilidad/{codocumento}", method = RequestMethod.GET)
	public @ResponseBody void getByIdDocumentoMovilidad(@PathVariable String codocumento,
			HttpServletResponse response) {
		try {

			DocumentoHechoDetalle documentoHechoDetalle = new DocumentoHechoDetalle();
			documentoHechoDetalle.setQ5codocumento(codocumento);

			documentoHechoDetalle = this.denunciaService.findDocumentoHecho(documentoHechoDetalle);

			Blob contenido = documentoHechoDetalle.getQ5datafile();
			byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ StringEscapeUtils.unescapeHtml(documentoHechoDetalle.getQ5nofile()) + "\"");
			response.setContentType(documentoHechoDetalle.getQ5contenttypefile());
			response.setContentLength(documentoHechoDetalle.getQ5sizefile());
			response.getOutputStream().write(bContenido);

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getDocsByHdcodigo'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param numExpediente
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/grabarMarcajeParaTablet/{atcodigo}", method = RequestMethod.POST)
	public @ResponseBody void grabarMarcajeParaTablet(@PathVariable String atcodigo, HttpServletRequest request,
			HttpServletResponse response) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(atcodigo);

			InspeccionDetalle inspeccionDetalle = this.actaService.findInspeccion(actuacion, censoMonitor);

			String idsdocumentosParam = request.getParameter("idsdocumentos");

			this.inspeccionService.grabarMarcajeParaTablet(inspeccionDetalle, idsdocumentosParam, censoMonitor);

		} catch (Exception e) {
			logger.error(
					"###########################ERROR AL GRABAR MARCAJE PARA MOVILIDAD grabarMarcajeParaTablet/{atcodigo}",
					e);
			throw new Y41bUDAException("grabarMarcajeParaTablet/{atcodigo}", false, e);
		}
	}

	/**
	 * Method 'getByIdInspeccionMovilidad'.
	 * 
	 * @param atcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return inspeccionDetalle InspeccionDetalle
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "/findInspeccionMovilidad/{atcodigo}", method = RequestMethod.GET)
	public @ResponseBody() InspeccionMovilidad getByIdInspeccionMovilidad(@PathVariable() String atcodigo,
			HttpServletRequest request) throws Exception {
		try {

			Actuacion actuacion = new Actuacion();
			actuacion.setAtcodigo(atcodigo);

			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			InspeccionMovilidad inspeccionMovilidad = this.actaService.findInspeccionMovilidad(actuacion, censoMonitor);

			return inspeccionMovilidad;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}
}
