package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.InfraccHechoDenExpSancService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.InfraccHechoDenExpSanc;

/**
 * InfraccHechoDenExpSancController  
 *  
 */
 
@Controller
@RequestMapping (value = "/infracchechodenexpsanc")

public class InfraccHechoDenExpSancController  {

	private static final Logger logger = LoggerFactory.getLogger(InfraccHechoDenExpSancController.class);

	@Autowired
	private InfraccHechoDenExpSancService infraccHechoDenExpSancService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		InfraccHechoDenExpSancController.logger.info("[GET - View] : infracchechodenexpsanc");
		return "infracchechodenexpsanc";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param dxcodigo String
	 * @return infraccHechoDenExpSanc InfraccHechoDenExpSanc
	 */
	@RequestMapping(value = "/{dxcodigo}", method = RequestMethod.GET)
	public @ResponseBody InfraccHechoDenExpSanc getById(@PathVariable String dxcodigo) {
        InfraccHechoDenExpSanc infraccHechoDenExpSanc = new InfraccHechoDenExpSanc();
		infraccHechoDenExpSanc.setDxcodigo(dxcodigo);
        infraccHechoDenExpSanc = this.infraccHechoDenExpSancService.find(infraccHechoDenExpSanc);
        InfraccHechoDenExpSancController.logger.info("[GET - findBy_PK] : Obtener InfraccHechoDenExpSanc por PK");
        return infraccHechoDenExpSanc;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterInfraccHechoDenExpSanc InfraccHechoDenExpSanc
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<InfraccHechoDenExpSanc> getAll(@ModelAttribute InfraccHechoDenExpSanc filterInfraccHechoDenExpSanc) {
		InfraccHechoDenExpSancController.logger.info("[GET - find_ALL] : Obtener InfraccHechoDenExpSanc por filtro");
	    return this.infraccHechoDenExpSancService.findAll(filterInfraccHechoDenExpSanc, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param infraccHechoDenExpSanc InfraccHechoDenExpSanc 
	 * @return InfraccHechoDenExpSanc
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody InfraccHechoDenExpSanc edit(@RequestBody InfraccHechoDenExpSanc infraccHechoDenExpSanc) {		
        InfraccHechoDenExpSanc infraccHechoDenExpSancAux = this.infraccHechoDenExpSancService.update(infraccHechoDenExpSanc);
		InfraccHechoDenExpSancController.logger.info("[PUT] : InfraccHechoDenExpSanc actualizado correctamente");
        return infraccHechoDenExpSancAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param infraccHechoDenExpSanc InfraccHechoDenExpSanc 
	 * @return InfraccHechoDenExpSanc
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody InfraccHechoDenExpSanc add(@RequestBody InfraccHechoDenExpSanc infraccHechoDenExpSanc) {		
        InfraccHechoDenExpSanc infraccHechoDenExpSancAux = this.infraccHechoDenExpSancService.add(infraccHechoDenExpSanc);
        InfraccHechoDenExpSancController.logger.info("[POST] : InfraccHechoDenExpSanc insertado correctamente");
    	return infraccHechoDenExpSancAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param dxcodigo String
	 * @return infraccHechoDenExpSanc
	 */
	@RequestMapping(value = "/{dxcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody InfraccHechoDenExpSanc remove(@PathVariable String dxcodigo) {
        InfraccHechoDenExpSanc infraccHechoDenExpSanc = new InfraccHechoDenExpSanc();
        infraccHechoDenExpSanc.setDxcodigo(dxcodigo);
        this.infraccHechoDenExpSancService.remove(infraccHechoDenExpSanc);
       	InfraccHechoDenExpSancController.logger.info("[DELETE] : InfraccHechoDenExpSanc borrado correctamente");
       	return infraccHechoDenExpSanc;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param infraccHechoDenExpSancIds List
	 * @return infraccHechoDenExpSancList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> infraccHechoDenExpSancIds) {
        List<InfraccHechoDenExpSanc> infraccHechoDenExpSancList = new ArrayList<InfraccHechoDenExpSanc>();
        for (List<String> infraccHechoDenExpSancId:infraccHechoDenExpSancIds) {
		    Iterator<String> iterator = infraccHechoDenExpSancId.iterator();
		    InfraccHechoDenExpSanc infraccHechoDenExpSanc = new InfraccHechoDenExpSanc(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        infraccHechoDenExpSanc.setDxcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
		    infraccHechoDenExpSancList.add(infraccHechoDenExpSanc);
	    }
        this.infraccHechoDenExpSancService.removeMultiple(infraccHechoDenExpSancList);
		InfraccHechoDenExpSancController.logger.info("[POST - DELETE_ALL] : InfraccHechoDenExpSanc borrados correctamente");
		return infraccHechoDenExpSancIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterInfraccHechoDenExpSanc InfraccHechoDenExpSanc
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute InfraccHechoDenExpSanc filterInfraccHechoDenExpSanc, @ModelAttribute Pagination pagination) {
        List<InfraccHechoDenExpSanc> infraccHechoDenExpSancs = this.infraccHechoDenExpSancService.findAll(filterInfraccHechoDenExpSanc, pagination);
        Long recordNum = this.infraccHechoDenExpSancService.findAllCount(filterInfraccHechoDenExpSanc);
        InfraccHechoDenExpSancController.logger.info("[GET - jqGrid] : Obtener InfraccHechoDenExpSanc");
		return new JQGridJSONModel(pagination, recordNum, infraccHechoDenExpSancs);
	}
	
}	
