package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.model.InfraccHechoDen;
import com.ejie.y41b.model.TipReqNormativo;
import com.ejie.y41b.service.InfraccHechoDenService;
import com.ejie.y41b.service.TipReqNormativoService;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * InfraccHechoDenController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/infracchechoden")
public class InfraccHechoDenController {

	private static final Logger logger = LoggerFactory
			.getLogger(InfraccHechoDenController.class);

	@Autowired
	private InfraccHechoDenService infraccHechoDenService;
	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * 
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		InfraccHechoDenController.logger.info("[GET - View] : infracchechoden");
		return "infracchechoden";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param hicodigo
	 *            String
	 * @return infraccHechoDen InfraccHechoDen
	 */
	@RequestMapping(value = "/{hicodigo}", method = RequestMethod.GET)
	public @ResponseBody
	InfraccHechoDen getById(@PathVariable String hicodigo) {
		InfraccHechoDen infraccHechoDen = new InfraccHechoDen();
		infraccHechoDen.setHicodigo(hicodigo);
		infraccHechoDen = this.infraccHechoDenService.find(infraccHechoDen);
		InfraccHechoDenController.logger
				.info("[GET - findBy_PK] : Obtener InfraccHechoDen por PK");
		return infraccHechoDen;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterInfraccHechoDen
	 *            InfraccHechoDen
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<InfraccHechoDen> getAll(
			@ModelAttribute InfraccHechoDen filterInfraccHechoDen) {
		InfraccHechoDenController.logger
				.info("[GET - find_ALL] : Obtener InfraccHechoDen por filtro");
		return this.infraccHechoDenService.findAll(filterInfraccHechoDen, null);
	}

	/**
	 * Method 'getInfraccionesByHicohd'.
	 * 
	 * @param hicohd
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "/solicitud/{hicohd}", method = RequestMethod.GET)
	public @ResponseBody
	Object getInfraccionesByHicohd(@PathVariable String hicohd,
			HttpServletRequest request) {
		try {

			InfraccHechoDen infraccHechoDen = new InfraccHechoDen();
			infraccHechoDen.setHicohd(hicohd);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<InfraccHechoDen> listaInfraccHechoDen = this.infraccHechoDenService
						.findAll(infraccHechoDen, pagination);

				if (listaInfraccHechoDen == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.infraccHechoDenService
						.findAllCount(infraccHechoDen);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listaInfraccHechoDen);
				return data;
			} else {
				List<InfraccHechoDen> listaInfraccHechoDen = this.infraccHechoDenService
						.findAll(infraccHechoDen, pagination);
				if (listaInfraccHechoDen == null) {
					throw new Exception("No data Found.");
				}
				return listaInfraccHechoDen;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException(
					"No data Found. /denuncia/solicitud/{hdcodigo}");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param infraccHechoDen
	 *            InfraccHechoDen
	 * @return InfraccHechoDen
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	InfraccHechoDen edit(@RequestBody InfraccHechoDen infraccHechoDen) {
		InfraccHechoDen infraccHechoDenAux = this.infraccHechoDenService
				.update(infraccHechoDen);
		InfraccHechoDenController.logger
				.info("[PUT] : InfraccHechoDen actualizado correctamente");
		return infraccHechoDenAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param infraccHechoDen
	 *            InfraccHechoDen
	 * @return InfraccHechoDen
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	InfraccHechoDen add(@RequestBody InfraccHechoDen infraccHechoDen) {
		try {
			InfraccHechoDen infraccHechoDenAux = this.infraccHechoDenService
					.add(infraccHechoDen);
			InfraccHechoDenController.logger
					.info("[POST] : InfraccHechoDen insertado correctamente");
			return infraccHechoDenAux;
		} catch (Y41bUDAException e) {
			throw e;
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param hicodigo
	 *            String
	 * @return infraccHechoDen
	 */
	@RequestMapping(value = "/{hicodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	InfraccHechoDen remove(@PathVariable String hicodigo) {
		InfraccHechoDen infraccHechoDen = new InfraccHechoDen();
		infraccHechoDen.setHicodigo(hicodigo);
		this.infraccHechoDenService.remove(infraccHechoDen);
		InfraccHechoDenController.logger
				.info("[DELETE] : InfraccHechoDen borrado correctamente");
		return infraccHechoDen;
	}

	@Autowired
	private TipReqNormativoService tipreqnormativoService;

	/**
	 * Method 'removeAll'.
	 * 
	 * @param infraccHechoDenIds
	 *            List
	 * @return infraccHechoDenList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> infraccHechoDenIds) {
		List<InfraccHechoDen> infraccHechoDenList = new ArrayList<InfraccHechoDen>();
		for (List<String> infraccHechoDenId : infraccHechoDenIds) {
			Iterator<String> iterator = infraccHechoDenId.iterator();
			InfraccHechoDen infraccHechoDen = new InfraccHechoDen(); // NOPMD -
																		// Objeto
																		// nuevo
																		// en la
																		// lista
																		// (parametro
																		// del
																		// servicio)
			infraccHechoDen.setHicodigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			infraccHechoDenList.add(infraccHechoDen);
		}
		this.infraccHechoDenService.removeMultiple(infraccHechoDenList);
		InfraccHechoDenController.logger
				.info("[POST - DELETE_ALL] : InfraccHechoDen borrados correctamente");
		return infraccHechoDenIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterInfraccHechoDen
	 *            InfraccHechoDen
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute InfraccHechoDen filterInfraccHechoDen,
			@ModelAttribute Pagination pagination) {
		List<InfraccHechoDen> infraccHechoDens = this.infraccHechoDenService
				.findAll(filterInfraccHechoDen, pagination);
		Long recordNum = this.infraccHechoDenService
				.findAllCount(filterInfraccHechoDen);
		InfraccHechoDenController.logger
				.info("[GET - jqGrid] : Obtener InfraccHechoDen");
		return new JQGridJSONModel(pagination, recordNum, infraccHechoDens);
	}

	/**
	 * Dame num articulos.
	 * 
	 * @param excodigo
	 *            the excodigo
	 * @return the integer
	 * @throws Exception
	 */
	@RequestMapping(value = "/dameNumArticulosyMaterias/{excodigo}", method = RequestMethod.GET)
	public @ResponseBody
	String dameNumArticulosyMaterias(@PathVariable String excodigo)
			throws Exception {
		this.logger.info("[GET - getById] : Inicio dameNumMaterias");
		try {

			List<InfraccHechoDen> articulos = this.infraccHechoDenService
					.findArticulos(excodigo, null);
			List<InfraccHechoDen> materias = this.infraccHechoDenService
					.findMaterias(excodigo, null);
			if (articulos != null && materias != null) {

				String resultado = articulos.size() + "-" + materias.size();
				this.logger
						.info("[GET - getById] : FIN dameNumMaterias.RESULTADO:"
								+ resultado + ".");
				return resultado;
			} else {
				return "0-0";
			}
		} catch (Exception e) {
			throw e;
		}
	}

	/**
	 * Dame num articulos.
	 * 
	 * @param excodigo
	 *            the excodigo
	 * @return the integer
	 */
	@RequestMapping(value = "/dameArticulos/{excodigo}", method = RequestMethod.GET)
	public @ResponseBody
	String dameArticulos(@PathVariable String excodigo) {
		this.logger.info("[GET - getById] : Inicio dameNumMaterias");
		StringBuffer articulosSeleccionados = new StringBuffer();
		StringBuffer articulosSeleccionadosNombre = new StringBuffer();
		List<String> articulosAniadidos = new ArrayList<String>();

		List<InfraccHechoDen> articulos = this.infraccHechoDenService
				.findArticulos(excodigo, null);
		for (InfraccHechoDen infraccHechoDen : articulos) {
			if (infraccHechoDen.getTipReqNormativo() != null
					&& infraccHechoDen.getTipReqNormativo().getTticodigo() != null) {

				if (articulosSeleccionados.length() != 0)
					articulosSeleccionados.append("__");
				articulosSeleccionados.append(infraccHechoDen
						.getTipReqNormativo().getTticodigo());
				articulosAniadidos.add(infraccHechoDen.getTipReqNormativo()
						.getTticodigo());

				if (articulosSeleccionadosNombre.length() != 0)
					articulosSeleccionadosNombre.append("__");

				TipReqNormativo tipreqnormativo = new TipReqNormativo();
				tipreqnormativo.setTticodigo(infraccHechoDen
						.getTipReqNormativo().getTticodigo());
				tipreqnormativo = tipreqnormativoService.find(tipreqnormativo);
				// Nombre
				articulosSeleccionadosNombre.append(tipreqnormativo
						.getTtinombre());
			}
		}

		return articulosSeleccionados.toString() + "##"
				+ articulosSeleccionadosNombre.toString();

	}

}
