package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.InfraccArbService;
import com.ejie.y41b.service.TipReqNormativoService;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.InfraccArb;

/**
 * InfraccArbController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/infraccarb")
public class InfraccArbController {

	private static final Logger logger = LoggerFactory
			.getLogger(InfraccArbController.class);

	@Autowired
	private InfraccArbService infraccArbService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		InfraccArbController.logger.info("[GET - View] : infraccarb");
		return "infraccarb";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param hicodigo
	 *            String
	 * @return infraccArb InfraccArb
	 */
	@RequestMapping(value = "/{hicodigo}", method = RequestMethod.GET)
	public @ResponseBody
	InfraccArb getById(@PathVariable String hicodigo) {
		InfraccArb infraccArb = new InfraccArb();
		infraccArb.setHicodigo(hicodigo);
		infraccArb = this.infraccArbService.find(infraccArb);
		InfraccArbController.logger
				.info("[GET - findBy_PK] : Obtener InfraccArb por PK");
		return infraccArb;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterInfraccArb
	 *            InfraccArb
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<InfraccArb> getAll(@ModelAttribute InfraccArb filterInfraccArb) {
		InfraccArbController.logger
				.info("[GET - find_ALL] : Obtener InfraccArb por filtro");
		return this.infraccArbService.findAll(filterInfraccArb, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param infraccArb
	 *            InfraccArb
	 * @return InfraccArb
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	InfraccArb edit(@RequestBody InfraccArb infraccArb) {
		InfraccArb infraccArbAux = this.infraccArbService.update(infraccArb);
		InfraccArbController.logger
				.info("[PUT] : InfraccArb actualizado correctamente");
		return infraccArbAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param infraccArb
	 *            InfraccArb
	 * @return InfraccArb
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	InfraccArb add(@RequestBody InfraccArb infraccArb) {
		InfraccArb infraccArbAux = this.infraccArbService.add(infraccArb);
		InfraccArbController.logger
				.info("[POST] : InfraccArb insertado correctamente");
		return infraccArbAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param hicodigo
	 *            String
	 * @return infraccArb
	 */
	@RequestMapping(value = "/{hicodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	InfraccArb remove(@PathVariable String hicodigo) {
		InfraccArb infraccArb = new InfraccArb();
		infraccArb.setHicodigo(hicodigo);
		this.infraccArbService.remove(infraccArb);
		InfraccArbController.logger
				.info("[DELETE] : InfraccArb borrado correctamente");
		return infraccArb;
	}

	@Autowired
	private TipReqNormativoService tipreqnormativoService;

	/**
	 * Method 'removeAll'.
	 * 
	 * @param infraccArbIds
	 *            List
	 * @return infraccArbList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> infraccArbIds) {
		List<InfraccArb> infraccArbList = new ArrayList<InfraccArb>();
		for (List<String> infraccArbId : infraccArbIds) {
			Iterator<String> iterator = infraccArbId.iterator();
			InfraccArb infraccArb = new InfraccArb(); // NOPMD -
														// Objeto
														// nuevo
														// en la
														// lista
														// (parametro
														// del
														// servicio)
			infraccArb.setHicodigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			infraccArbList.add(infraccArb);
		}
		this.infraccArbService.removeMultiple(infraccArbList);
		InfraccArbController.logger
				.info("[POST - DELETE_ALL] : InfraccArb borrados correctamente");
		return infraccArbIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterInfraccArb
	 *            InfraccArb
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute InfraccArb filterInfraccArb,
			@ModelAttribute Pagination pagination) {
		List<InfraccArb> infraccArbs = this.infraccArbService.findAll(
				filterInfraccArb, pagination);
		Long recordNum = this.infraccArbService.findAllCount(filterInfraccArb);
		InfraccArbController.logger.info("[GET - jqGrid] : Obtener InfraccArb");
		return new JQGridJSONModel(pagination, recordNum, infraccArbs);
	}

}
