package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.IncService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.Inc;

/**
 * IncController  
 *  
 */
 
@Controller
@RequestMapping (value = "/inc")

public class IncController  {

	private static final Logger logger = LoggerFactory.getLogger(IncController.class);

	@Autowired
	private IncService incService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		IncController.logger.info("[GET - View] : inc");
		return "inc";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param inccodigo String
	 * @return inc Inc
	 */
	@RequestMapping(value = "/{inccodigo}", method = RequestMethod.GET)
	public @ResponseBody Inc getById(@PathVariable String inccodigo) {
        Inc inc = new Inc();
		inc.setInccodigo(inccodigo);
        inc = this.incService.find(inc);
        IncController.logger.info("[GET - findBy_PK] : Obtener Inc por PK");
        return inc;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterInc Inc
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Inc> getAll(@ModelAttribute Inc filterInc) {
		IncController.logger.info("[GET - find_ALL] : Obtener Inc por filtro");
	    return this.incService.findAll(filterInc, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param inc Inc 
	 * @return Inc
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Inc edit(@RequestBody Inc inc) {		
        Inc incAux = this.incService.update(inc);
		IncController.logger.info("[PUT] : Inc actualizado correctamente");
        return incAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param inc Inc 
	 * @return Inc
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Inc add(@RequestBody Inc inc) {		
        Inc incAux = this.incService.add(inc);
        IncController.logger.info("[POST] : Inc insertado correctamente");
    	return incAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param inccodigo String
	 * @return inc
	 */
	@RequestMapping(value = "/{inccodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody Inc remove(@PathVariable String inccodigo) {
        Inc inc = new Inc();
        inc.setInccodigo(inccodigo);
        this.incService.remove(inc);
       	IncController.logger.info("[DELETE] : Inc borrado correctamente");
       	return inc;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param incIds List
	 * @return incList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> incIds) {
        List<Inc> incList = new ArrayList<Inc>();
        for (List<String> incId:incIds) {
		    Iterator<String> iterator = incId.iterator();
		    Inc inc = new Inc(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        inc.setInccodigo(ObjectConversionManager.convert(iterator.next(), String.class));
		    incList.add(inc);
	    }
        this.incService.removeMultiple(incList);
		IncController.logger.info("[POST - DELETE_ALL] : Inc borrados correctamente");
		return incIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterInc Inc
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute Inc filterInc, @ModelAttribute Pagination pagination) {
        List<Inc> incs = this.incService.findAll(filterInc, pagination);
        Long recordNum = this.incService.findAllCount(filterInc);
        IncController.logger.info("[GET - jqGrid] : Obtener Inc");
		return new JQGridJSONModel(pagination, recordNum, incs);
	}
	
}	
