package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.HistoricofasesService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.Historicofases;

/**
 * HistoricofasesController  
 *  
 */
 
@Controller
@RequestMapping (value = "/historicofases")

public class HistoricofasesController  {

	private static final Logger logger = LoggerFactory.getLogger(HistoricofasesController.class);

	@Autowired
	private HistoricofasesService historicofasesService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		HistoricofasesController.logger.info("[GET - View] : historicofases");
		return "historicofases";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param hfcodigo String
	 * @return historicofases Historicofases
	 */
	@RequestMapping(value = "/{hfcodigo}", method = RequestMethod.GET)
	public @ResponseBody Historicofases getById(@PathVariable String hfcodigo) {
        Historicofases historicofases = new Historicofases();
		historicofases.setHfcodigo(hfcodigo);
        historicofases = this.historicofasesService.find(historicofases);
        HistoricofasesController.logger.info("[GET - findBy_PK] : Obtener Historicofases por PK");
        return historicofases;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterHistoricofases Historicofases
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Historicofases> getAll(@ModelAttribute Historicofases filterHistoricofases) {
		HistoricofasesController.logger.info("[GET - find_ALL] : Obtener Historicofases por filtro");
	    return this.historicofasesService.findAll(filterHistoricofases, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param historicofases Historicofases 
	 * @return Historicofases
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Historicofases edit(@RequestBody Historicofases historicofases) {		
        Historicofases historicofasesAux = this.historicofasesService.update(historicofases);
		HistoricofasesController.logger.info("[PUT] : Historicofases actualizado correctamente");
        return historicofasesAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param historicofases Historicofases 
	 * @return Historicofases
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Historicofases add(@RequestBody Historicofases historicofases) {		
        Historicofases historicofasesAux = this.historicofasesService.add(historicofases);
        HistoricofasesController.logger.info("[POST] : Historicofases insertado correctamente");
    	return historicofasesAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param hfcodigo String
	 * @return historicofases
	 */
	@RequestMapping(value = "/{hfcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody Historicofases remove(@PathVariable String hfcodigo) {
        Historicofases historicofases = new Historicofases();
        historicofases.setHfcodigo(hfcodigo);
        this.historicofasesService.remove(historicofases);
       	HistoricofasesController.logger.info("[DELETE] : Historicofases borrado correctamente");
       	return historicofases;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param historicofasesIds List
	 * @return historicofasesList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> historicofasesIds) {
        List<Historicofases> historicofasesList = new ArrayList<Historicofases>();
        for (List<String> historicofasesId:historicofasesIds) {
		    Iterator<String> iterator = historicofasesId.iterator();
		    Historicofases historicofases = new Historicofases(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        historicofases.setHfcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
		    historicofasesList.add(historicofases);
	    }
        this.historicofasesService.removeMultiple(historicofasesList);
		HistoricofasesController.logger.info("[POST - DELETE_ALL] : Historicofases borrados correctamente");
		return historicofasesIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterHistoricofases Historicofases
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute Historicofases filterHistoricofases, @ModelAttribute Pagination pagination) {
        List<Historicofases> historicofasess = this.historicofasesService.findAll(filterHistoricofases, pagination);
        Long recordNum = this.historicofasesService.findAllCount(filterHistoricofases);
        HistoricofasesController.logger.info("[GET - jqGrid] : Obtener Historicofases");
		return new JQGridJSONModel(pagination, recordNum, historicofasess);
	}
	
}	
