package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.HistoricoService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.Historico;

/**
 * HistoricoController  
 *  
 */
 
@Controller
@RequestMapping (value = "/historico")

public class HistoricoController  {

	private static final Logger logger = LoggerFactory.getLogger(HistoricoController.class);

	@Autowired
	private HistoricoService historicoService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		HistoricoController.logger.info("[GET - View] : historico");
		return "historico";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param shcodigo String
	 * @return historico Historico
	 */
	@RequestMapping(value = "/{shcodigo}", method = RequestMethod.GET)
	public @ResponseBody Historico getById(@PathVariable String shcodigo) {
        Historico historico = new Historico();
		historico.setShcodigo(shcodigo);
        historico = this.historicoService.find(historico);
        HistoricoController.logger.info("[GET - findBy_PK] : Obtener Historico por PK");
        return historico;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterHistorico Historico
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Historico> getAll(@ModelAttribute Historico filterHistorico) {
		HistoricoController.logger.info("[GET - find_ALL] : Obtener Historico por filtro");
	    return this.historicoService.findAll(filterHistorico, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param historico Historico 
	 * @return Historico
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Historico edit(@RequestBody Historico historico) {		
        Historico historicoAux = this.historicoService.update(historico);
		HistoricoController.logger.info("[PUT] : Historico actualizado correctamente");
        return historicoAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param historico Historico 
	 * @return Historico
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Historico add(@RequestBody Historico historico) {		
        Historico historicoAux = this.historicoService.add(historico);
        HistoricoController.logger.info("[POST] : Historico insertado correctamente");
    	return historicoAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param shcodigo String
	 * @return historico
	 */
	@RequestMapping(value = "/{shcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody Historico remove(@PathVariable String shcodigo) {
        Historico historico = new Historico();
        historico.setShcodigo(shcodigo);
        this.historicoService.remove(historico);
       	HistoricoController.logger.info("[DELETE] : Historico borrado correctamente");
       	return historico;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param historicoIds List
	 * @return historicoList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> historicoIds) {
        List<Historico> historicoList = new ArrayList<Historico>();
        for (List<String> historicoId:historicoIds) {
		    Iterator<String> iterator = historicoId.iterator();
		    Historico historico = new Historico(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        historico.setShcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
		    historicoList.add(historico);
	    }
        this.historicoService.removeMultiple(historicoList);
		HistoricoController.logger.info("[POST - DELETE_ALL] : Historico borrados correctamente");
		return historicoIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterHistorico Historico
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute Historico filterHistorico, @ModelAttribute Pagination pagination) {
        List<Historico> historicos = this.historicoService.findAll(filterHistorico, pagination);
        Long recordNum = this.historicoService.findAllCount(filterHistorico);
        HistoricoController.logger.info("[GET - jqGrid] : Obtener Historico");
		return new JQGridJSONModel(pagination, recordNum, historicos);
	}
	
}	
