package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.HistorialAlerta;
import com.ejie.y41b.service.HistorialAlertaService;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * HistorialAlertaController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/historialalerta")
@SessionAttributes({ "codigo", "modoHistorial" })
public class HistorialAlertaController {

	private static final Logger logger = LoggerFactory
			.getLogger(HistorialAlertaController.class);

	@Autowired
	private HistorialAlertaService historialAlertaService;

	@Autowired
	private Properties appConfiguration;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		HistorialAlertaController.logger.info("[GET - View] : historialalerta");
		return "historialalerta";
	}

	/**
	 * Method 'getCreateFormBusqueda'.
	 * 
	 * @param codigo
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "historialAlertaBusqueda/{codigo}", method = RequestMethod.GET)
	public String getCreateFormBusqueda(@PathVariable String codigo, Model model) {
		HistorialAlertaController.logger.info("[GET - View] : historialalerta");

		model.addAttribute("codigo", codigo);

		return "historialAlerta";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idhistorial
	 *            String
	 * @return historialAlerta HistorialAlerta
	 */
	@RequestMapping(value = "/{idhistorial}", method = RequestMethod.GET)
	public @ResponseBody
	HistorialAlerta getById(@PathVariable String idhistorial) {
		HistorialAlerta historialAlerta = new HistorialAlerta();
		historialAlerta.setIdhistorial(idhistorial);
		historialAlerta = this.historialAlertaService.find(historialAlerta);
		HistorialAlertaController.logger
				.info("[GET - findBy_PK] : Obtener HistorialAlerta por PK");
		return historialAlerta;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterHistorialAlerta
	 *            HistorialAlerta
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<HistorialAlerta> getAll(
			@ModelAttribute HistorialAlerta filterHistorialAlerta) {
		HistorialAlertaController.logger
				.info("[GET - find_ALL] : Obtener HistorialAlerta por filtro");
		return this.historialAlertaService.findAll(filterHistorialAlerta, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param historialAlerta
	 *            HistorialAlerta
	 * @return HistorialAlerta
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	HistorialAlerta edit(@RequestBody HistorialAlerta historialAlerta) {
		HistorialAlerta historialAlertaAux = this.historialAlertaService
				.update(historialAlerta);
		HistorialAlertaController.logger
				.info("[PUT] : HistorialAlerta actualizado correctamente");
		return historialAlertaAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param historialAlerta
	 *            HistorialAlerta
	 * @return HistorialAlerta
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	HistorialAlerta add(@RequestBody HistorialAlerta historialAlerta) {
		HistorialAlerta historialAlertaAux = this.historialAlertaService
				.add(historialAlerta);
		HistorialAlertaController.logger
				.info("[POST] : HistorialAlerta insertado correctamente");
		return historialAlertaAux;
	}

	/**
	 * Method 'addHistorico'.
	 * 
	 * @param historialAlerta
	 *            HistorialAlerta
	 * @param request
	 *            HttpServletRequest
	 * @return HistorialAlerta
	 */
	@RequestMapping(value = "/addHistorico", method = RequestMethod.POST)
	public @ResponseBody
	HistorialAlerta addHistorico(@RequestBody HistorialAlerta historialAlerta,
			HttpServletRequest request) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			historialAlerta.setComohistorial(censoMonitor.getMocodigo());

			HistorialAlerta historialAlertaAux = this.historialAlertaService
					.add(historialAlerta);
			logger.info("Entity correctly inserted!");
			return historialAlertaAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'updateHistorico'.
	 * 
	 * @param historialAlerta
	 *            HistorialAlerta
	 * @param request
	 *            HttpServletRequest
	 * @return HistorialAlerta
	 */
	@RequestMapping(value = "/updateHistorico", method = RequestMethod.PUT)
	public @ResponseBody
	HistorialAlerta updateHistorico(
			@RequestBody HistorialAlerta historialAlerta,
			HttpServletRequest request) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			historialAlerta.setComohistorial(censoMonitor.getMocodigo());

			HistorialAlerta historialAlertaAux = this.historialAlertaService
					.update(historialAlerta);
			logger.info("Entity correctly inserted!");
			return historialAlertaAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idhistorial
	 *            String
	 * @return historialAlerta
	 */
	@RequestMapping(value = "/{idhistorial}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	HistorialAlerta remove(@PathVariable String idhistorial) {
		HistorialAlerta historialAlerta = new HistorialAlerta();
		historialAlerta.setIdhistorial(idhistorial);
		this.historialAlertaService.remove(historialAlerta);
		HistorialAlertaController.logger
				.info("[DELETE] : HistorialAlerta borrado correctamente");
		return historialAlerta;
	}

	/**
	 * Method 'removeHistorico'.
	 * 
	 * @param idhistorial
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "removeHistorico/{idhistorial}", method = RequestMethod.DELETE)
	public void removeHistorico(@PathVariable String idhistorial,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			HistorialAlerta historialAlerta = new HistorialAlerta();
			historialAlerta.setIdhistorial(idhistorial);
			this.historialAlertaService.removeHistorico(historialAlerta);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			logger.error("Unable to delete " + idhistorial);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param historialAlertaIds
	 *            List
	 * @return historialAlertaList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> historialAlertaIds) {
		List<HistorialAlerta> historialAlertaList = new ArrayList<HistorialAlerta>();
		for (List<String> historialAlertaId : historialAlertaIds) {
			Iterator<String> iterator = historialAlertaId.iterator();
			HistorialAlerta historialAlerta = new HistorialAlerta(); // NOPMD -
																		// Objeto
																		// nuevo
																		// en la
																		// lista
																		// (parametro
																		// del
																		// servicio)
			historialAlerta.setIdhistorial(ObjectConversionManager.convert(
					iterator.next(), String.class));
			historialAlertaList.add(historialAlerta);
		}
		this.historialAlertaService.removeMultiple(historialAlertaList);
		HistorialAlertaController.logger
				.info("[POST - DELETE_ALL] : HistorialAlerta borrados correctamente");
		return historialAlertaIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterHistorialAlerta
	 *            HistorialAlerta
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute HistorialAlerta filterHistorialAlerta,
			@ModelAttribute Pagination pagination) {
		List<HistorialAlerta> historialAlertas = this.historialAlertaService
				.findAll(filterHistorialAlerta, pagination);
		Long recordNum = this.historialAlertaService
				.findAllCount(filterHistorialAlerta);
		HistorialAlertaController.logger
				.info("[GET - jqGrid] : Obtener HistorialAlerta");
		return new JQGridJSONModel(pagination, recordNum, historialAlertas);
	}

	/**
	 * Method 'getAllHistorico'.
	 * 
	 * @param codigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/findAllHistorico", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllHistorico(
			@RequestParam(value = "codigo", required = false) String codigo,
			HttpServletRequest request, Model model) {
		try {
			HistorialAlerta filterHistorialAlerta = new HistorialAlerta();
			filterHistorialAlerta.setCodigo(codigo);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<HistorialAlerta> listHistorialAlerta = this.historialAlertaService
						.findAll(filterHistorialAlerta, pagination);

				if (listHistorialAlerta == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.historialAlertaService
						.findAllCount(filterHistorialAlerta);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listHistorialAlerta);
				return data;
			} else {
				List<HistorialAlerta> listHistorialAlerta = this.historialAlertaService
						.findAll(filterHistorialAlerta, pagination);
				if (listHistorialAlerta == null) {
					throw new Exception("No data Found.");
				}
				return listHistorialAlerta;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getCreateFormMaintY41bAlertaDetalleProgramacion'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintY41bHistorialAlerta_Detalle", method = RequestMethod.GET)
	public ModelAndView getCreateFormMaintY41bHistorialAlertaDetalle(
			Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));

		model.addAttribute("idhistorial", "");

		model.addAttribute("modoHistorial", Y41bConstantes.MODO_POPUP_ALTA);

		return new ModelAndView("historialAlertaDetalle", "model", model);
	}

	/**
	 * Method 'getCreateFormMaintY41bHistorialAlertaMod'.
	 * 
	 * @param idhistorial
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintY41bHistorialAlerta_Mod/{idhistorial}", method = RequestMethod.GET)
	public ModelAndView getCreateFormMaintY41bHistorialAlertaMod(
			@PathVariable String idhistorial, Model model,
			HttpServletRequest request) {

		model.addAttribute("idhistorial", idhistorial);

		model.addAttribute("modoHistorial",
				Y41bConstantes.MODO_POPUP_MODIFICACION);

		return new ModelAndView("historialAlertaDetalle", "model", model);
	}
}
