package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.FormasVentaService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.FormasVenta;

/**
 * FormasVentaController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/formasventa")
public class FormasVentaController {

	private static final Logger logger = LoggerFactory
			.getLogger(FormasVentaController.class);

	@Autowired
	private FormasVentaService formasVentaService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		FormasVentaController.logger.info("[GET - View] : formasventa");
		return "formasventa";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param fvcodigo
	 *            String
	 * @return formasVenta FormasVenta
	 */
	@RequestMapping(value = "/{fvcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	FormasVenta getById(@PathVariable String fvcodigo) {
		FormasVenta formasVenta = new FormasVenta();
		formasVenta.setFvcodigo(fvcodigo);
		formasVenta = this.formasVentaService.find(formasVenta);
		FormasVentaController.logger
				.info("[GET - findBy_PK] : Obtener FormasVenta por PK");
		return formasVenta;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterFormasVenta
	 *            FormasVenta
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<FormasVenta> getAll(@ModelAttribute FormasVenta filterFormasVenta) {
		FormasVentaController.logger
				.info("[GET - find_ALL] : Obtener FormasVenta por filtro");
		return this.formasVentaService.findAll(filterFormasVenta, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param formasVenta
	 *            FormasVenta
	 * @return FormasVenta
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	FormasVenta edit(@RequestBody FormasVenta formasVenta) {
		FormasVenta formasVentaAux = this.formasVentaService
				.update(formasVenta);
		FormasVentaController.logger
				.info("[PUT] : FormasVenta actualizado correctamente");
		return formasVentaAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param formasVenta
	 *            FormasVenta
	 * @return FormasVenta
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	FormasVenta add(@RequestBody FormasVenta formasVenta) {
		FormasVenta formasVentaAux = this.formasVentaService.add(formasVenta);
		FormasVentaController.logger
				.info("[POST] : FormasVenta insertado correctamente");
		return formasVentaAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param fvcodigo
	 *            String
	 * @return formasVenta
	 */
	@RequestMapping(value = "/{fvcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	FormasVenta remove(@PathVariable String fvcodigo) {
		FormasVenta formasVenta = new FormasVenta();
		formasVenta.setFvcodigo(fvcodigo);
		this.formasVentaService.remove(formasVenta);
		FormasVentaController.logger
				.info("[DELETE] : FormasVenta borrado correctamente");
		return formasVenta;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param formasVentaIds
	 *            List
	 * @return formasVentaList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> formasVentaIds) {
		List<FormasVenta> formasVentaList = new ArrayList<FormasVenta>();
		for (List<String> formasVentaId : formasVentaIds) {
			Iterator<String> iterator = formasVentaId.iterator();
			FormasVenta formasVenta = new FormasVenta(); // NOPMD - Objeto nuevo
															// en la lista
															// (parametro del
															// servicio)
			formasVenta.setFvcodigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			formasVentaList.add(formasVenta);
		}
		this.formasVentaService.removeMultiple(formasVentaList);
		FormasVentaController.logger
				.info("[POST - DELETE_ALL] : FormasVenta borrados correctamente");
		return formasVentaIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterFormasVenta
	 *            FormasVenta
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute FormasVenta filterFormasVenta,
			@ModelAttribute Pagination pagination) {
		List<FormasVenta> formasVentas = this.formasVentaService.findAll(
				filterFormasVenta, pagination);
		Long recordNum = this.formasVentaService
				.findAllCount(filterFormasVenta);
		FormasVentaController.logger
				.info("[GET - jqGrid] : Obtener FormasVenta");
		return new JQGridJSONModel(pagination, recordNum, formasVentas);
	}

	/**
	 * Method 'comboFormasVenta'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "/combo", method = RequestMethod.GET)
	public @ResponseBody()
	List<FormasVenta> comboFormasVenta(HttpServletRequest request) {

		Locale locale = LocaleContextHolder.getLocale();
		String idioma = locale.getLanguage();
		Pagination pagination = new Pagination();
		if (Y41bConstantes.CASTELLANO.equals(idioma)) {
			pagination.setSort("fvnombre");
		} else {
			pagination.setSort("fvnombree");
		}
		pagination.setAscDsc("DESC");
		return this.formasVentaService.findAll(new FormasVenta(), pagination);
	}
}
