package com.ejie.y41b.control;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Denuncia;
import com.ejie.y41b.model.FormaPresentacion;
import com.ejie.y41b.service.DenunciaService;
import com.ejie.y41b.service.FormaPresentacionService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * * FormaPresentacionController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/formapresentacion")
public class FormaPresentacionController {

	private static final Logger logger = LoggerFactory.getLogger(FormaPresentacionController.class);

	@Autowired
	private FormaPresentacionService formaPresentacionService;
	@Autowired
	private DenunciaService denunciaService;

	@Autowired
	private Properties appConfiguration;

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/*********************************************************************************************************************************************************/
	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilConsultas() == null || censoMonitor.getPerfilConsultas().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedEscritorio", "model", model);
		} else {
			return new ModelAndView("formapresentacion", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormAltaFormaPresentacion'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "altaFormaPresentacion", method = RequestMethod.GET)
	public ModelAndView getCreateFormAltaFormaPresentacion(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("codFormaPresentacion", Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

		model.addAttribute("modoFormaPresentacion", Y41bConstantes.MODO_POPUP_ALTA);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilMaestros() == null || censoMonitor.getPerfilMaestros().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleformapresentacion", "model", model);
		}
	}

	/**
	 * Method 'getCreateFormModTribunal'.
	 * 
	 * @param codTribunal
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "modFormaPresentacion/{codFormaPresentacion}", method = RequestMethod.GET)
	public ModelAndView getCreateFormModFormaPresentacion(@PathVariable String codFormaPresentacion, Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("codFormaPresentacion", codFormaPresentacion);

		model.addAttribute("modoFormaPresentacion", Y41bConstantes.MODO_POPUP_MODIFICACION);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		FormaPresentacion formaPresentacion = new FormaPresentacion();
		formaPresentacion.setTfpcodigo(codFormaPresentacion);

		if (censoMonitor.getPerfilMaestros() == null || censoMonitor.getPerfilMaestros().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("detalleformapresentacion", "model", model);
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param tfpcodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "findFormaPresentacion/{tfpcodigo}", method = RequestMethod.GET)
	public @ResponseBody FormaPresentacion getById(@PathVariable String tfpcodigo) {
		try {
			FormaPresentacion formaPresentacion = new FormaPresentacion();
			formaPresentacion.setTfpcodigo(tfpcodigo);
			formaPresentacion = this.formaPresentacionService.find(formaPresentacion);
			if (formaPresentacion == null) {
				throw new Exception(tfpcodigo.toString());
			}
			return formaPresentacion;
		} catch (Exception e) {
			throw new ResourceNotFoundException(tfpcodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param tfpcodigo
	 *            String
	 * @param tfpnombre
	 *            String
	 * @param tfpnombree
	 *            String
	 * @param tfpnombrei
	 *            String
	 * @param tfpnombref
	 *            String
	 * @param tfpnombrea
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody Object getAll(@RequestParam(value = "tfpcodigo", required = false) String tfpcodigo,
			@RequestParam(value = "tfpnombre", required = false) String tfpnombre,
			@RequestParam(value = "tfpnombree", required = false) String tfpnombree,
			@RequestParam(value = "tfpnombrei", required = false) String tfpnombrei,
			@RequestParam(value = "tfpnombref", required = false) String tfpnombref,
			@RequestParam(value = "tfpnombrea", required = false) String tfpnombrea,
			@RequestParam(value = "tfpconsultas", required = false) String tfpconsultas,
			@RequestParam(value = "tfpsolicitudes", required = false) String tfpsolicitudes,
			@RequestParam(value = "tfparbitrajes", required = false) String tfparbitrajes, HttpServletRequest request) {
		try {
			FormaPresentacion filterFormaPresentacion = new FormaPresentacion(tfpcodigo, tfpnombre, tfpnombree,
					tfpnombrei, tfpnombref, tfpnombrea, tfpconsultas, tfpsolicitudes, tfparbitrajes);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<FormaPresentacion> formaPresentacions = this.formaPresentacionService
						.findAll(filterFormaPresentacion, pagination);

				if (formaPresentacions == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterFormaPresentacion, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(formaPresentacions);
				return data;
			} else {
				List<FormaPresentacion> formaPresentacions = this.formaPresentacionService
						.findAll(filterFormaPresentacion, pagination);
				if (formaPresentacions == null) {
					throw new Exception("No data Found.");
				}
				return formaPresentacions;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllPorTipo'.
	 * 
	 * @param tfpcodigo
	 *            String
	 * @param tfpconsultas
	 *            String
	 * @param tfpsolicitudes
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/getAllPorTipo", method = RequestMethod.GET)
	public @ResponseBody Object getAllPorTipo(@RequestParam(value = "tfpcodigo", required = false) String tfpcodigo,
			@RequestParam(value = "tfpconsultas", required = false) String tfpconsultas,
			@RequestParam(value = "tfpsolicitudes", required = false) String tfpsolicitudes,
			@RequestParam(value = "tfparbitrajes", required = false) String tfparbitrajes, HttpServletRequest request) {
		try {
			FormaPresentacion filterFormaPresentacion = new FormaPresentacion();
			filterFormaPresentacion.setTfpcodigo(tfpcodigo);
			filterFormaPresentacion.setTfpconsultas(tfpconsultas);
			filterFormaPresentacion.setTfpsolicitudes(tfpsolicitudes);
			filterFormaPresentacion.setTfparbitrajes(tfparbitrajes);
			return this.formaPresentacionService.findAll(filterFormaPresentacion, null);
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllFillCombosPorTipo'.
	 * 
	 * @param tfpcodigo
	 *            String
	 * @param filter
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/getAllFillCombosPorTipo", method = RequestMethod.GET)
	public @ResponseBody Object getAllFillCombosPorTipo(
			@RequestParam(value = "tfpcodigo", required = false) String tfpcodigo,
			@RequestParam(value = "filter", required = false) String filter, HttpServletRequest request) {
		try {
			FormaPresentacion filterFormaPresentacion = new FormaPresentacion();
			filterFormaPresentacion.setTfpcodigo(tfpcodigo);
			return this.formaPresentacionService.findAllConsultasOrSolicitudes(filterFormaPresentacion, null, filter);
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllFillCombosPorTipo'.
	 * 
	 * @param tfpcodigo
	 *            String
	 * @param filter
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/getAllFillCombosPorTipoSinWeb", method = RequestMethod.GET)
	public @ResponseBody Object getAllFillCombosPorTipoSinWeb(
			@RequestParam(value = "tfpcodigo", required = false) String tfpcodigo,
			@RequestParam(value = "filter", required = false) String filter,
			@RequestParam(value = "sir", required = false) String sir, HttpServletRequest request) {
		try {
			FormaPresentacion filterFormaPresentacion = new FormaPresentacion();
			filterFormaPresentacion.setTfpcodigo(tfpcodigo);
			return this.formaPresentacionService.findAllConsultasOrSolicitudesSinWeb(filterFormaPresentacion, null,
					filter, sir);
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllFillCombosPorTipoAlta'.
	 * 
	 * @param tfpcodigo
	 *            String
	 * @param filter
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/getAllFillCombosPorTipoAlta", method = RequestMethod.GET)
	public @ResponseBody Object getAllFillCombosPorTipoAlta(
			@RequestParam(value = "tfpcodigo", required = false) String tfpcodigo,
			@RequestParam(value = "filter", required = false) String filter, HttpServletRequest request) {
		try {
			FormaPresentacion filterFormaPresentacion = new FormaPresentacion();
			filterFormaPresentacion.setTfpcodigo(tfpcodigo);
			return this.formaPresentacionService.findAllConsultasOrSolicitudesAlta(filterFormaPresentacion, null,
					filter);
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllFillCombosPorTipoAltaSinWeb'.
	 * 
	 * @param tfpcodigo
	 *            String
	 * @param filter
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/getAllFillCombosPorTipoAltaSinWeb", method = RequestMethod.GET)
	public @ResponseBody Object getAllFillCombosPorTipoAltaSinWeb(
			@RequestParam(value = "tfpcodigo", required = false) String tfpcodigo,
			@RequestParam(value = "filter", required = false) String filter,
			@RequestParam(value = "sir", required = false) String sir, HttpServletRequest request) {
		try {
			FormaPresentacion filterFormaPresentacion = new FormaPresentacion();
			filterFormaPresentacion.setTfpcodigo(tfpcodigo);
			return this.formaPresentacionService.findAllConsultasOrSolicitudesAltaSinWeb(filterFormaPresentacion, null,
					filter, sir);
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterFormaPresentacion
	 *            FormaPresentacion
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody Long getAllCount(
			@RequestParam(value = "formaPresentacion", required = false) FormaPresentacion filterFormaPresentacion,
			HttpServletRequest request) {
		try {
			return formaPresentacionService
					.findAllCount(filterFormaPresentacion != null ? filterFormaPresentacion : new FormaPresentacion());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param formaPresentacion
	 *            FormaPresentacion
	 * @param response
	 *            HttpServletResponse
	 * @return FormaPresentacion
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody FormaPresentacion edit(@RequestBody FormaPresentacion formaPresentacion,
			HttpServletResponse response) {
		try {
			FormaPresentacion formaPresentacionAux = this.formaPresentacionService.update(formaPresentacion);
			logger.info("Entity correctly inserted!");
			return formaPresentacionAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param formaPresentacion
	 *            FormaPresentacion
	 * @return FormaPresentacion
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody FormaPresentacion add(@RequestBody FormaPresentacion formaPresentacion) {
		try {
			FormaPresentacion formaPresentacionAux = this.formaPresentacionService.add(formaPresentacion);
			FormaPresentacionController.logger.info("[POST] : Forma Presentación insertado correctamente");
			return formaPresentacionAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param tfpcodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "remove/{tfpcodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String tfpcodigo, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			FormaPresentacion formaPresentacion = new FormaPresentacion();
			formaPresentacion.setTfpcodigo(tfpcodigo);
			this.formaPresentacionService.updateFechaBaja(formaPresentacion);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			logger.error("Unable to delete " + tfpcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param formaPresentacionIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody ArrayList<ArrayList<String>> formaPresentacionIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<FormaPresentacion> formaPresentacionList = new ArrayList<FormaPresentacion>();
		try {
			for (ArrayList<String> formaPresentacionId : formaPresentacionIds) {
				Iterator<String> iterator = formaPresentacionId.iterator();
				FormaPresentacion formaPresentacion = new FormaPresentacion();
				formaPresentacion.setTfpcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
				formaPresentacionList.add(formaPresentacion);
			}
			this.formaPresentacionService.removeMultiple(formaPresentacionList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getFormaPresentacionService'.
	 * 
	 * @return FormaPresentacionService
	 */
	protected FormaPresentacionService getFormaPresentacionService() {
		return this.formaPresentacionService;
	}

	/**
	 * Method 'setFormaPresentacionService'.
	 * 
	 * @param formaPresentacionService
	 *            FormaPresentacionService
	 * @return
	 */
	public void setFormaPresentacionService(FormaPresentacionService formaPresentacionService) {
		this.formaPresentacionService = formaPresentacionService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param tfpcodigo_
	 *            String
	 * @param tfpnombre_
	 *            String
	 * @param tfpnombree_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "/like", method = RequestMethod.GET)
	public @ResponseBody Object getAll(@RequestParam(value = "tfpcodigo", required = false) String tfpcodigo_,
			@RequestParam(value = "tfpnombre", required = false) String tfpnombre_,
			@RequestParam(value = "tfpnombree", required = false) String tfpnombree_,
			@RequestParam(value = "tfpconsultas", required = false) String tfpconsultas_,
			@RequestParam(value = "tfpsolicitudes", required = false) String tfpsolicitudes_,
			@RequestParam(value = "tfparbitrajes", required = false) String tfparbitrajes_,

			HttpServletRequest request) {

		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String tfpcodigo = ("".equals(tfpcodigo_)) ? null : tfpcodigo_;
			String tfpnombre = null;
			String tfpnombree = null;

			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
				tfpnombre = ("".equals(tfpnombre_)) ? null : tfpnombre_;
			} else {
				tfpnombree = ("".equals(tfpnombre_)) ? null : tfpnombre_;
			}

			String tfpconsultas = null;
			String tfpsolicitudes = null;
			String tfparbitrajes = null;

			FormaPresentacion filterFormaPresentacion = new FormaPresentacion(tfpcodigo, tfpnombre, tfpnombree,
					tfpconsultas, tfpsolicitudes, tfparbitrajes);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<FormaPresentacion> formaPresentacion = this.formaPresentacionService
						.findAllLike(filterFormaPresentacion, pagination, false);

				if (formaPresentacion == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.formaPresentacionService.findAllLikeCount(filterFormaPresentacion, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(formaPresentacion);
				return data;
			} else {
				List<FormaPresentacion> formaPresentacion = this.formaPresentacionService
						.findAllLike(filterFormaPresentacion, pagination, false);
				if (formaPresentacion == null) {
					throw new Exception("No data Found.");
				}
				return formaPresentacion;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param formaPresentacion
	 *            formaPresentacion
	 * @return formaPresentacion
	 */

	@RequestMapping(value = "/updateFormaPresentacion", method = RequestMethod.PUT)
	public @ResponseBody FormaPresentacion edit(@RequestBody FormaPresentacion formaPresentacion) {
		try {
			FormaPresentacion formaPresentacionAux = null;

			formaPresentacionAux = this.formaPresentacionService.update(formaPresentacion);
			FormaPresentacionController.logger.info("[PUT] : Forma de Presentación actualizado correctamente");
			return formaPresentacionAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param tfpcodigo
	 *            String
	 * @param solicitud
	 *            String
	 * 
	 * 
	 * @return formaPresentacion
	 */

	@RequestMapping(value = "/existeSolicitudConFP/{tfpcodigo}/{solicitud}", method = RequestMethod.GET)
	public @ResponseBody Object buscarSolicitudconFP(@PathVariable String tfpcodigo, @PathVariable String solicitud) {
		try {
			Boolean existe = false;
			FormaPresentacion formaPresentacion = new FormaPresentacion();
			formaPresentacion.setTfpcodigo(tfpcodigo);
			formaPresentacion.setTfpsolicitudes(solicitud);

			long numSolicitud = 0;
			// Antes de actualizar comprobar que, si se ha eliminado el check de
			// solicitudes, no haya ninguna solicitud con esa Forma de
			// presentación
			if (formaPresentacion.getTfpsolicitudes().equalsIgnoreCase("N")) {
				Denuncia denuncia = new Denuncia();
				denuncia.setFormaPresentacion(formaPresentacion);

				numSolicitud = this.denunciaService.findAllCount(denuncia);
			}
			if (numSolicitud == 0) {
				existe = false;
			} else {
				existe = true;
			}

			return existe.toString();
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	// /**
	// * Method 'removeAll'.
	// *
	// * @param formaPresentacionIds
	// * List
	// * @return formaPresentacionList
	// */
	// @RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	// @ResponseStatus(value = HttpStatus.OK)
	// public @ResponseBody
	// List<List<String>> removeMultiple(
	// @RequestBody List<List<String>> formaPresentacionIds) {
	// List<FormaPresentacion> formaPresentacionList = new
	// ArrayList<FormaPresentacion>();
	// for (List<String> formaPresentacionId : formaPresentacionIds) {
	// Iterator<String> iterator = formaPresentacionId.iterator();
	// FormaPresentacion formaPresentacion = new FormaPresentacion(); // NOPMD
	// // -
	// // Objeto
	// // nuevo
	// // en
	// // la
	// // lista (parametro del
	// // servicio)
	// formaPresentacion.setTfpcodigo(ObjectConversionManager.convert(
	// iterator.next(), String.class));
	// formaPresentacionList.add(formaPresentacion);
	// }
	// this.formaPresentacionService.removeMultiple(formaPresentacionList);
	// FormaPresentacionController.logger
	// .info("[POST - DELETE_ALL] : Forma de Presentación borrados
	// correctamente");
	// return formaPresentacionIds;
	// }

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterFormaPresentacion
	 *            Tribunal
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute FormaPresentacion filterFormaPresentacion,
			@ModelAttribute Pagination pagination) {
		List<FormaPresentacion> formaPresentacion = this.formaPresentacionService.findAll(filterFormaPresentacion,
				pagination);
		Long recordNum = this.formaPresentacionService.findAllCount(filterFormaPresentacion);
		FormaPresentacionController.logger.info("[GET - jqGrid] : Obtener Forma de Presentación");
		return new JQGridJSONModel(pagination, recordNum, formaPresentacion);
	}

	/**
	 * Method 'getComboFormaPresentacion'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "/combo", method = RequestMethod.GET)
	public @ResponseBody List<FormaPresentacion> getComboFormaPresentacion(HttpServletRequest request) {

		List<FormaPresentacion> lFormaPresentacion = null;

		this.logger.info("[GET - find_ALL] : Obtener combo Forma de Presentacion");
		FormaPresentacion filterFormaPresentacion = new FormaPresentacion();
		/*
		 * desde la ficha de expedientes
		 */
		Locale locale = LocaleContextHolder.getLocale();
		String idioma = locale.getLanguage();
		Pagination pagination = new Pagination();
		if (Y41bConstantes.CASTELLANO.equals(idioma)) {
			pagination.setSort("tbnombre");
		} else {
			pagination.setSort("tbnombree");
		}
		pagination.setAscDsc("ASC");

		lFormaPresentacion = formaPresentacionService.findAll(filterFormaPresentacion, null);

		return lFormaPresentacion;
	}

}
