package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.FaseService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Fase;
import com.ejie.y41b.model.TipoProcedimiento;

/**
 * FaseController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/fase")
public class FaseController {

	private static final Logger logger = LoggerFactory
			.getLogger(FaseController.class);

	@Autowired
	private FaseService faseService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		FaseController.logger.info("[GET - View] : fase");
		return "fase";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param fcodigo
	 *            String
	 * @return fase Fase
	 */
	@RequestMapping(value = "/{fcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Fase getById(@PathVariable String fcodigo) {
		Fase fase = new Fase();
		fase.setFcodigo(fcodigo);
		fase = this.faseService.find(fase);
		FaseController.logger.info("[GET - findBy_PK] : Obtener Fase por PK");
		return fase;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterFase
	 *            Fase
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Fase> getAll(@ModelAttribute Fase filterFase) {
		FaseController.logger
				.info("[GET - find_ALL] : Obtener Fase por filtro");
		return this.faseService.findAll(filterFase, null);
	}

	/**
	 * Method 'pCodigo'.
	 * 
	 * @param pCodigo
	 *            pCodigo
	 * @return List
	 */
	@RequestMapping(value = "/comboFases", method = RequestMethod.GET)
	public @ResponseBody
	List<Fase> getComboFases(
			@RequestParam(value = "pCodigo", required = false) String pCodigo) {
		FaseController.logger
				.info("[GET - find_ALL] : Obtener Fase por filtro");
		Fase filterFase = new Fase();
		Locale locale = LocaleContextHolder.getLocale();
		String idioma = locale.getLanguage();

		Pagination pagination = new Pagination();
		if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
			pagination.setSort("fnombre");
			pagination.setAscDsc("ASC");
		} else if (Y41bConstantes.EUSKERA.equalsIgnoreCase(idioma)) {
			pagination.setSort("fnombree");
			pagination.setAscDsc("ASC");
		}

		filterFase.setTipoProcedimiento(new TipoProcedimiento(pCodigo, null,
				null, null));

		return this.faseService.findAll(filterFase, pagination);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param fase
	 *            Fase
	 * @return Fase
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Fase edit(@RequestBody Fase fase) {
		Fase faseAux = this.faseService.update(fase);
		FaseController.logger.info("[PUT] : Fase actualizado correctamente");
		return faseAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param fase
	 *            Fase
	 * @return Fase
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Fase add(@RequestBody Fase fase) {
		Fase faseAux = this.faseService.add(fase);
		FaseController.logger.info("[POST] : Fase insertado correctamente");
		return faseAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param fcodigo
	 *            String
	 * @return fase
	 */
	@RequestMapping(value = "/{fcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Fase remove(@PathVariable String fcodigo) {
		Fase fase = new Fase();
		fase.setFcodigo(fcodigo);
		this.faseService.remove(fase);
		FaseController.logger.info("[DELETE] : Fase borrado correctamente");
		return fase;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param faseIds
	 *            List
	 * @return faseList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(@RequestBody List<List<String>> faseIds) {
		List<Fase> faseList = new ArrayList<Fase>();
		for (List<String> faseId : faseIds) {
			Iterator<String> iterator = faseId.iterator();
			Fase fase = new Fase(); // NOPMD - Objeto nuevo en la lista
									// (parametro del servicio)
			fase.setFcodigo(ObjectConversionManager.convert(iterator.next(),
					String.class));
			faseList.add(fase);
		}
		this.faseService.removeMultiple(faseList);
		FaseController.logger
				.info("[POST - DELETE_ALL] : Fase borrados correctamente");
		return faseIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterFase
	 *            Fase
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Fase filterFase,
			@ModelAttribute Pagination pagination) {
		List<Fase> fases = this.faseService.findAll(filterFase, pagination);
		Long recordNum = this.faseService.findAllCount(filterFase);
		FaseController.logger.info("[GET - jqGrid] : Obtener Fase");
		return new JQGridJSONModel(pagination, recordNum, fases);
	}

}
