package com.ejie.y41b.control;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Expedien;
import com.ejie.y41b.model.ExpedienKgest;
import com.ejie.y41b.model.FiltroSanciones;
import com.ejie.y41b.model.InfraccHechoDen;
import com.ejie.y41b.model.InspeccionDetalle;
import com.ejie.y41b.model.Sanbandeja;
import com.ejie.y41b.model.Sanexp;
import com.ejie.y41b.model.Sanexprel;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.model.Sanpropbandeja;
import com.ejie.y41b.model.SolicitudCambioInstructor;
import com.ejie.y41b.model.T17Municipio;
import com.ejie.y41b.model.T17Provincia;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.model.TramiteComun;
import com.ejie.y41b.model.TramiteGenerico;
import com.ejie.y41b.service.ActaService;
import com.ejie.y41b.service.Arbtramexp4Service;
import com.ejie.y41b.service.ArbtramexpService;
import com.ejie.y41b.service.CensoMonitorService;
import com.ejie.y41b.service.ExpedienService;
import com.ejie.y41b.service.InfraccHechoDenService;
import com.ejie.y41b.service.InstramexpService;
import com.ejie.y41b.service.SanexprelService;
import com.ejie.y41b.service.SanintervService;
import com.ejie.y41b.service.SanpropbandejaService;
import com.ejie.y41b.service.SantramexpService;
import com.ejie.y41b.service.SoltramexpService;
import com.ejie.y41b.service.T17MunicipioService;
import com.ejie.y41b.service.T17ProvinciaService;
import com.ejie.y41b.service.Y41bExcelGeneratorService;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.documentos.Y41bDocumento;
import com.ejie.y41b.utils.documentos.Y41bGenerarDocumento;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * ExpedienController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/expedien")
public class ExpedienController {

	private static final Logger logger = LoggerFactory
			.getLogger(ExpedienController.class);

	@Autowired()
	private ExpedienService expedienService;

	@Autowired()
	private SanintervService sanintervService;

	@Autowired()
	private SoltramexpService soltramexpService;

	@Autowired()
	private SanpropbandejaService sanpropbandejaService;

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private Y41bUDAErrorManager errorManager;

	@Autowired()
	private InfraccHechoDenService infracchechodenService;
	@Autowired()
	private Y41bExcelGeneratorService y41bExcelGeneratorService;

	@Autowired()
	private T17MunicipioService municipioService;

	@Autowired()
	private T17ProvinciaService provinciaService;

	@Autowired()
	private CensoMonitorService censoMonitorService;

	@Autowired()
	private SanexprelService sanexprelService;
	@Autowired()
	private SantramexpService santramexpService;

	@Resource()
	private ReloadableResourceBundleMessageSource appMessageSource;
	@Autowired()
	private ArbtramexpService arbtramexpService;
	@Autowired()
	private Arbtramexp4Service arbtramexp4Service;

	@Autowired()
	private InstramexpService instramexpService;

	@Autowired()
	private ActaService actaService;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody()
	void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(this.errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintBusquedaSancionesInicial", method = RequestMethod.GET)
	public String getCreateFormInicial(Model model, HttpServletRequest request) {
		ExpedienController.logger.info("[GET - View] : expedien");
		request.getSession().setAttribute("sancionBusqueda", null);
		return "busquedasancion";
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintBusquedaSanciones", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ExpedienController.logger.info("[GET - View] : expedien");
		return "busquedasancion";
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintBusquedaSancionesModal", method = RequestMethod.GET)
	public String getCreateFormModal(Model model) {
		ExpedienController.logger.info("[GET - View] : expedien");
		return "busquedasancionmodal";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param excodigo
	 *            String
	 * @return Expedien
	 * @throws Y41bUDAException
	 *             Exception
	 */
	@RequestMapping(value = "/{excodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	Expedien getById(@PathVariable() String excodigo) throws Y41bUDAException {
		try {
			ExpedienController.logger
					.info("[GET - findBy_PK] : Obtener Expedien por PK . AAAAAAAAAAA");
			Expedien expedien = new Expedien();

			Sanexprel sanexprel = new Sanexprel();
			expedien.setExcodigo(excodigo);
			sanexprel.setExpedienByRlexcodigo(expedien);
			List<Sanexprel> listaRelacionados = this.sanexprelService.findAll(
					sanexprel, null);

			expedien = this.expedienService.find(expedien);
			expedien.setcodCompleto(expedien.damecodCompleto());
			expedien = this.expedienService.obtenerEstadoLiquidacion(expedien);

			StringBuffer exp_relacionados = new StringBuffer();
			if (listaRelacionados != null) {
				for (int i = 0; i < listaRelacionados.size(); i++) {
					if (!listaRelacionados.get(i).getRlesorig()
							.equals(Y41bConstantes.VALOR_NO)) {
						if (exp_relacionados.length() > 0) {
							exp_relacionados.append("\n");
						}
						exp_relacionados.append(listaRelacionados.get(i)
								.getCodCompleto());
						if (listaRelacionados.get(i).getRlesorig()
								.equals(Y41bConstantes.VALOR_SI)) {
							expedien.getSanexp().setTipoprocOrigen(
									listaRelacionados.get(i)
											.getTipoProcedimiento()
											.getPnombre());
						}
					}
				}
			}

			expedien.getSanexp().setExpedienteOrigen(
					exp_relacionados.toString());

			ExpedienController.logger
					.info("[GET - findBy_PK] : Obtener Expedien por PK");
			return expedien;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico" + e.getMessage(), true,
					e);
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param excodigo
	 *            String
	 * @return expedien Expedien
	 * @throws Y41bUDAException
	 *             Exception
	 */
	@RequestMapping(value = "/fichaSancionador/{excodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	Map<String, Object> getByIdFichaSancionador(@PathVariable() String excodigo)
			throws Y41bUDAException {
		Map<String, Object> mapa = new HashMap<String, Object>();
		try {
			ExpedienController.logger
					.info("[GET - findBy_PK] : Obtener Expedien por PK . AAAAAAAAAAA");
			Expedien expedien = new Expedien();

			Sanexprel sanexprel = new Sanexprel();
			expedien.setExcodigo(excodigo);
			sanexprel.setExpedienByRlexcodigo(expedien);
			List<Sanexprel> listaRelacionados = this.sanexprelService.findAll(
					sanexprel, null);

			expedien = this.expedienService.find(expedien);
			expedien.setcodCompleto(expedien.damecodCompleto());
			expedien = this.expedienService.obtenerEstadoLiquidacion(expedien);

			StringBuffer exp_relacionados = new StringBuffer();
			if (listaRelacionados != null) {
				for (int i = 0; i < listaRelacionados.size(); i++) {
					if (!listaRelacionados.get(i).getRlesorig()
							.equals(Y41bConstantes.VALOR_NO)) {
						if (exp_relacionados.length() > 0) {
							exp_relacionados.append("\n");
						}
						exp_relacionados.append(listaRelacionados.get(i)
								.getCodCompleto());
						if (listaRelacionados.get(i).getRlesorig()
								.equals(Y41bConstantes.VALOR_SI)) {
							expedien.getSanexp().setTipoprocOrigen(
									listaRelacionados.get(i)
											.getTipoProcedimiento()
											.getPnombre());
						}
					}
				}
			}

			expedien.getSanexp().setExpedienteOrigen(
					exp_relacionados.toString());
			mapa.put("expedien", expedien);

			mapa = this.santramexpService.obtenerDatosTramitesFichaSancionador(
					excodigo, mapa);

			ExpedienController.logger
					.info("[GET - findBy_PK] : Obtener Expedien por PK");
			return mapa;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico" + e.getMessage(), true,
					e);
		}
	}

	/**
	 * Method 'getSancionByNumExpediente'.
	 * 
	 * @param excoor
	 *            String
	 * @param exnror
	 *            BigDecimal
	 * @param exnran
	 *            BigDecimal
	 * @return Expedien
	 * @throws Y41bUDAException
	 *             Exception
	 */
	@RequestMapping(value = "/getSancionByNumExpediente/{excoor}/{exnror}/{exnran}", method = RequestMethod.GET)
	public @ResponseBody()
	Expedien getSancionByNumExpediente(@PathVariable() String excoor,
			@PathVariable() BigDecimal exnror, @PathVariable() BigDecimal exnran)
			throws Y41bUDAException {
		try {
			Expedien expedien = new Expedien();

			expedien.setExcoor(excoor);
			expedien.setExnror(exnror);
			expedien.setExnran(exnran);

			expedien = this.expedienService
					.findSancionByNumeroExpediente(expedien);

			if (expedien == null) {
				throw new Exception(excoor.toString());
			} else {
				expedien.setcodCompleto(expedien.damecodCompleto());
				expedien = this.expedienService
						.obtenerEstadoLiquidacion(expedien);
			}
			ExpedienController.logger
					.info("[GET - getSancionByNumExpediente] : Obtener Expedien por numero de expediente");
			return expedien;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			ExpedienController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Gets the expedien kgest.
	 * 
	 * @param excodigo
	 *            the excodigo
	 * @return the expedien kgest
	 */
	@RequestMapping(value = "/obtenerExpedienteKgest/{excodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	ExpedienKgest getExpedienKgest(@PathVariable() String excodigo) {

		ExpedienKgest expedienKges = new ExpedienKgest();
		expedienKges.setExcodigo(excodigo);
		expedienKges = this.expedienService.findKgest(expedienKges);

		expedienKges.setcodCompleto(expedienKges.damecodCompleto());
		return expedienKges;
	}

	/**
	 * Gets the pronunciamiento act expedien kgest.
	 * 
	 * @param excodigo
	 *            the excodigo
	 * @param pagination
	 *            the pagination
	 * @return the pronunciamiento act expedien kgest
	 */
	@RequestMapping(value = "/obtenerPronunciamientoActKgest/{excodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	JQGridJSONModel getPronunciamientoActExpedienKgest(
			@PathVariable() String excodigo,
			@ModelAttribute() Pagination pagination) {

		ExpedienKgest expedienKges = new ExpedienKgest();
		expedienKges.setExcodigo(excodigo);
		// return expedienService.findPronunciamientoKgest(expedienKges);

		List<ExpedienKgest> listaSancionesKgest = this.expedienService
				.findPronunciamientoActKgest(expedienKges);
		Long recordNum = this.expedienService
				.findPronunciamientoActKgestCount(expedienKges);
		ExpedienController.logger
				.info("[GET - jqGrid] : Obtener pronunciamiento actuaciones sanciones");
		return new JQGridJSONModel(pagination, recordNum, listaSancionesKgest);
	}

	/**
	 * Gets the pronunciamiento recl expedien kgest.
	 * 
	 * @param excodigo
	 *            the excodigo
	 * @param pagination
	 *            the pagination
	 * @return the pronunciamiento recl expedien kgest
	 */
	@RequestMapping(value = "/obtenerPronunciamientoReclKgest/{excodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	JQGridJSONModel getPronunciamientoReclExpedienKgest(
			@PathVariable() String excodigo,
			@ModelAttribute() Pagination pagination) {

		ExpedienKgest expedienKges = new ExpedienKgest();
		expedienKges.setExcodigo(excodigo);

		List<ExpedienKgest> listaSancionesKgest = this.expedienService
				.findPronunciamientoReclKgest(expedienKges);
		Long recordNum = this.expedienService
				.findPronunciamientoReclKgestCount(expedienKges);
		ExpedienController.logger
				.info("[GET - jqGrid] : Obtener pronunciamiento reclamaciones sanciones");
		return new JQGridJSONModel(pagination, recordNum, listaSancionesKgest);
	}

	/**
	 * Gets the pronunciamiento otras expedien kgest.
	 * 
	 * @param excodigo
	 *            the excodigo
	 * @param pagination
	 *            the pagination
	 * @return the pronunciamiento otras expedien kgest
	 */
	@RequestMapping(value = "/obtenerPronunciamientoOtrasKgest/{excodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	JQGridJSONModel getPronunciamientoOtrasExpedienKgest(
			@PathVariable() String excodigo,
			@ModelAttribute() Pagination pagination) {

		ExpedienKgest expedienKges = new ExpedienKgest();
		expedienKges.setExcodigo(excodigo);

		List<ExpedienKgest> listaSancionesKgest = this.expedienService
				.findPronunciamientoOtrasKgest(expedienKges);
		Long recordNum = this.expedienService
				.findPronunciamientoOtrasKgestCount(expedienKges);
		ExpedienController.logger
				.info("[GET - jqGrid] : Obtener pronunciamiento reclamaciones sanciones");
		return new JQGridJSONModel(pagination, recordNum, listaSancionesKgest);
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterExpedien
	 *            Expedien
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Expedien> getAll(@ModelAttribute() Expedien filterExpedien) {
		ExpedienController.logger
				.info("[GET - find_ALL] : Obtener Expedien por filtro");
		return this.expedienService.findAll(filterExpedien, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param expedien
	 *            Expedien
	 * @param request
	 *            HttpServletRequest
	 * @return Expedien
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Expedien edit(@RequestBody() Expedien expedien, HttpServletRequest request) {
		try {
			HttpSession httpSession = request.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
			censoMonitor = this.censoMonitorService.find(censoMonitor);
			Expedien expedienAux = this.expedienService.update(expedien,
					censoMonitor);
			ExpedienController.logger
					.info("[PUT] : Expedien actualizado correctamente");
			return expedienAux;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			ExpedienController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param expedien
	 *            Expedien
	 * @param baprsanid
	 *            Long
	 * @return Expedien
	 */
	@RequestMapping(value = "/{baprsanid}", method = RequestMethod.POST)
	public @ResponseBody()
	Expedien add(@RequestBody() Expedien expedien,
			@PathVariable() Long baprsanid) {
		try {
			Expedien expedienAux = this.expedienService
					.add(expedien, baprsanid);
			ExpedienController.logger
					.info("[POST] : Expedien insertado correctamente");
			return expedienAux;
		} catch (Exception e) {
			throw new Y41bUDAException("error.platea.invocation", true, e);
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param expedien
	 *            Expedien
	 * @return Expedien
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Expedien add(@RequestBody() Expedien expedien) {
		try {
			Expedien expedienAux = this.expedienService.add(expedien);
			ExpedienController.logger
					.info("[POST] : Expedien insertado correctamente");
			return expedienAux;
		} catch (Exception e) {
			throw new Y41bUDAException("error.platea.invocation", true, e);
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param excodigo
	 *            String
	 * @return expedien
	 */
	@RequestMapping(value = "/{excodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Expedien remove(@PathVariable() String excodigo) {
		Expedien expedien = new Expedien();
		expedien.setExcodigo(excodigo);
		this.expedienService.remove(expedien);
		ExpedienController.logger
				.info("[DELETE] : Expedien borrado correctamente");
		return expedien;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param expedienIds
	 *            List
	 * @return expedienList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(
			@RequestBody() List<List<String>> expedienIds) {
		List<Expedien> expedienList = new ArrayList<Expedien>();
		for (List<String> expedienId : expedienIds) {
			Iterator<String> iterator = expedienId.iterator();
			Expedien expedien = new Expedien(); // NOPMD - Objeto nuevo en la
												// lista (parametro del
												// servicio)
			expedien.setExcodigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			expedienList.add(expedien);
		}
		this.expedienService.removeMultiple(expedienList);
		ExpedienController.logger
				.info("[POST - DELETE_ALL] : Expedien borrados correctamente");
		return expedienIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterExpedien
	 *            Expedien
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(@ModelAttribute() Expedien filterExpedien,
			@ModelAttribute() Pagination pagination) {
		List<Expedien> expediens = this.expedienService.findAll(filterExpedien,
				pagination);
		Long recordNum = this.expedienService.findAllCount(filterExpedien);
		ExpedienController.logger.info("[GET - jqGrid] : Obtener Expedien");
		return new JQGridJSONModel(pagination, recordNum, expediens);
	}

	/**
	 * Method 'getCreateFormFiltroSanciones'.
	 * 
	 * @param httpRequest
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "muestraFiltro", method = RequestMethod.GET)
	public ModelAndView getCreateFormFiltroSanciones(
			HttpServletRequest httpRequest, Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		HttpSession httpSession = httpRequest.getSession();
		FiltroSanciones sancionBusqueda = (FiltroSanciones) httpSession
				.getAttribute("sancionBusqueda");
		if (sancionBusqueda == null) {
			model.addAttribute("cargarFiltroInicial", true);
			model.addAttribute("sancionBusqueda", new FiltroSanciones());
		} else {
			model.addAttribute("cargarFiltroInicial", false);

			// EVOLUTIVO 0135083 2.7 para poder volver a pintar la lista con las
			// infraccioens
			if (sancionBusqueda.getInfracRelacionadas() != null
					&& sancionBusqueda.getInfracRelacionadasDescripciones() != null) {
				StringBuilder infraccRelacionadaCod = new StringBuilder();
				for (int i = 0; i < sancionBusqueda.getInfracRelacionadas().length; i++) {
					if (i > 0) {
						infraccRelacionadaCod.append("/");
					}
					infraccRelacionadaCod.append(sancionBusqueda
							.getInfracRelacionadas()[i]);
				}
				StringBuilder infraccRelacionadaDescripciones = new StringBuilder();
				for (int i = 0; i < sancionBusqueda
						.getInfracRelacionadasDescripciones().length; i++) {
					if (i > 0) {
						infraccRelacionadaDescripciones.append("/");
					}
					infraccRelacionadaDescripciones.append(sancionBusqueda
							.getInfracRelacionadasDescripciones()[i]);
				}
				sancionBusqueda.setInfracRelacionadasStr(infraccRelacionadaCod
						.toString());
				sancionBusqueda
						.setInfracRelacionadasDescripcionesStr(infraccRelacionadaDescripciones
								.toString());
			}
			// EVOLUTIVO 0135083 2.7
			model.addAttribute("sancionBusqueda", sancionBusqueda);
		}
		return new ModelAndView("busquedaSancionFiltro", "model", model);
	}

	/**
	 * Method 'getCreateFormListadoSanciones'.
	 * 
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "muestraResultadoSanciones", method = RequestMethod.GET)
	public ModelAndView getCreateFormListadoSanciones(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView("busquedaSancionListado", "model", model);
	}

	/**
	 * 
	 * @param excoor
	 *            String
	 * @param exnror
	 *            String
	 * @param exnran
	 *            String
	 * @param cofechaInicioDesde
	 *            String
	 * @param cofechaInicioHasta
	 *            String
	 * @param y41bBusquedaSancionFiltroEstadoExp
	 *            String
	 * @param cifnif
	 *            String
	 * @param conoco
	 *            String
	 * @param provinciaId
	 *            String
	 * @param municipioId
	 *            String
	 * @param localidadId
	 *            String
	 * @param y41bBusquedaSancionFiltroFase
	 *            String
	 * @param y41bBusquedaSancionFiltroTramite
	 *            String
	 * @param indUltimoTramite
	 *            String
	 * @param y41bBusquedaSancionFiltroResolucion
	 *            String
	 * @param y41bBusquedaSancionFiltroInstructor
	 *            String
	 * @param y41bBusquedaSancionFiltroResponsable
	 *            String
	 * @param indAcuseRecibo
	 *            String
	 * @param indPendienteFirma
	 *            String
	 * @param cofechaTramitacionDesde
	 *            String
	 * @param cofechaTramitacionHasta
	 *            String
	 * @param pagination
	 *            Pagination
	 * @param model
	 *            Model
	 * @param httpRequest
	 *            HttpServletRequest
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "searchSancionesFiltro", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGridPrueba(
			@RequestParam(value = "excoor", required = false) String excoor,
			@RequestParam(value = "exnror", required = false) BigDecimal exnror,
			@RequestParam(value = "exnran", required = false) BigDecimal exnran,
			@RequestParam(value = "cofechaInicioDesde", required = false) String cofechaInicioDesde,
			@RequestParam(value = "cofechaInicioHasta", required = false) String cofechaInicioHasta,
			@RequestParam(value = "y41bBusquedaSancionFiltroEstadoExp", required = false) String y41bBusquedaSancionFiltroEstadoExp,
			@RequestParam(value = "cifnif", required = false) String cifnif,
			@RequestParam(value = "conoco", required = false) String conoco,
			@RequestParam(value = "provinciaId", required = false) String provinciaId,
			@RequestParam(value = "municipioId", required = false) String municipioId,
			@RequestParam(value = "localidadId", required = false) String localidadId,
			@RequestParam(value = "y41bBusquedaSancionFiltroFase", required = false) String y41bBusquedaSancionFiltroFase,
			@RequestParam(value = "y41bBusquedaSancionFiltroTramite", required = false) String y41bBusquedaSancionFiltroTramite,
			@RequestParam(value = "indUltimoTramite", required = false) String indUltimoTramite,
			@RequestParam(value = "y41bBusquedaSancionFiltroResolucion", required = false) String y41bBusquedaSancionFiltroResolucion,
			@RequestParam(value = "y41bBusquedaSancionFiltroInstructor", required = false) String y41bBusquedaSancionFiltroInstructor,
			@RequestParam(value = "y41bBusquedaSancionFiltroResponsable", required = false) String y41bBusquedaSancionFiltroResponsable,
			@RequestParam(value = "indAcuseRecibo", required = false) String indAcuseRecibo,
			@RequestParam(value = "indPendienteFirma", required = false) String indPendienteFirma,
			@RequestParam(value = "cofechaTramitacionDesde", required = false) String cofechaTramitacionDesde,
			@RequestParam(value = "cofechaTramitacionHasta", required = false) String cofechaTramitacionHasta,
			@RequestParam(value = "infracRelacionadas", required = false) String[] infracRelacionadas,
			@RequestParam(value = "infracRelacionadasDescripciones", required = false) String[] infracRelacionadasDescripciones,
			@RequestParam(value = "pcodigo", required = false) String pcodigo,
			@RequestParam(value = "accoororigen", required = false) String accoororigen,
			@RequestParam(value = "atcocm", required = false) String atcocm,
			@ModelAttribute() Pagination pagination, Model model,
			HttpServletRequest httpRequest) {

		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		censoMonitor = this.censoMonitorService.find(censoMonitor);
		String perfil = censoMonitor.getPerfilSanciones().getIdPerfil();
		if (perfil != null
				&& Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO.equals(perfil)) {
			// Si perfil sin acceso devolvemos listado vacio
			return new JQGridJSONModel(pagination, 0L,
					new ArrayList<Sanbandeja>());
		}

		FiltroSanciones filtroSanciones = new FiltroSanciones();
		// EVOLUTIVO 0135083 2.7
		if (null != infracRelacionadas && infracRelacionadas.length > 0) {
			filtroSanciones.setInfracRelacionadas(infracRelacionadas);
			filtroSanciones
					.setInfracRelacionadasDescripciones(infracRelacionadasDescripciones);
		}
		// EVOLUTIVO 0135083 2.7
		if (!Y41bUtils.esNullOCadenaVacia(excoor)) {
			filtroSanciones.setExcoor(excoor);
		}
		if (null != exnror) {
			filtroSanciones.setExnror(exnror);
		}
		if (null != exnran) {
			filtroSanciones.setExnran(exnran);
		}

		if (!Y41bUtils.esNullOCadenaVacia(y41bBusquedaSancionFiltroEstadoExp)) {
			filtroSanciones
					.setEstadoExpediente(y41bBusquedaSancionFiltroEstadoExp);
		}
		if (!Y41bUtils.esNullOCadenaVacia(cifnif)) {
			filtroSanciones.setCifnif(cifnif);
		}
		if (!Y41bUtils.esNullOCadenaVacia(conoco)) {
			filtroSanciones.setConoco(conoco);
		}
		if (!Y41bUtils.esNullOCadenaVacia(provinciaId)) {
			filtroSanciones.setProvinciaId(provinciaId);
		}
		if (!Y41bUtils.esNullOCadenaVacia(municipioId)) {
			filtroSanciones.setMunicipioId(municipioId);
		}
		if (!Y41bUtils.esNullOCadenaVacia(localidadId)) {
			filtroSanciones.setLocalidadId(localidadId);
		}
		if (!Y41bUtils.esNullOCadenaVacia(y41bBusquedaSancionFiltroFase)) {
			filtroSanciones.setIdFase(y41bBusquedaSancionFiltroFase);
		}
		if (!Y41bUtils.esNullOCadenaVacia(y41bBusquedaSancionFiltroTramite)) {
			filtroSanciones.setTramite(y41bBusquedaSancionFiltroTramite);
		}
		if (!Y41bUtils.esNullOCadenaVacia(indUltimoTramite)
				&& "on".equals(indUltimoTramite)) {
			filtroSanciones.setUltimoTramite(true);
		}
		if (!Y41bUtils.esNullOCadenaVacia(y41bBusquedaSancionFiltroResolucion)) {
			filtroSanciones
					.setTipoResolucion(y41bBusquedaSancionFiltroResolucion);
		}
		if (!Y41bUtils.esNullOCadenaVacia(y41bBusquedaSancionFiltroInstructor)) {
			filtroSanciones.setInstructor(y41bBusquedaSancionFiltroInstructor);
		}
		if (!Y41bUtils.esNullOCadenaVacia(y41bBusquedaSancionFiltroResponsable)) {
			filtroSanciones
					.setResponsable(y41bBusquedaSancionFiltroResponsable);
		}

		if (!Y41bUtils.esNullOCadenaVacia(indAcuseRecibo)
				&& "on".equals(indAcuseRecibo)) {
			filtroSanciones.setAcuseRecibo(true);
		}
		if (!Y41bUtils.esNullOCadenaVacia(indPendienteFirma)
				&& "on".equals(indPendienteFirma)) {
			filtroSanciones.setIndPendienteFirma(true);
		}
		// EVOLUTIVO 0150942
		if (!Y41bUtils.esNullOCadenaVacia(pcodigo)) {
			filtroSanciones.setPcodigo(pcodigo);
		}
		if (!Y41bUtils.esNullOCadenaVacia(accoororigen)) {
			filtroSanciones.setAccoororigen(accoororigen);
		}
		if (!Y41bUtils.esNullOCadenaVacia(atcocm)) {
			filtroSanciones.setAtcocm(atcocm);
		}
		// EVOLUTIVO 0150942
		filtroSanciones = this.prepararFiltro(filtroSanciones,
				cofechaInicioDesde, cofechaInicioHasta,
				cofechaTramitacionDesde, cofechaTramitacionHasta);
		httpSession.setAttribute("sancionBusqueda", filtroSanciones);

		List<FiltroSanciones> listaSanciones = this.expedienService
				.findAllLikeSanciones(filtroSanciones, pagination, false);
		Long recordNum = this.expedienService.findAllLikeCountSanciones(
				filtroSanciones, false);
		ExpedienController.logger.info("[GET - jqGrid] : Obtener sanciones");
		return new JQGridJSONModel(pagination, recordNum, listaSanciones);
	}

	/**
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @param cofechaInicioDesde
	 *            String
	 * @param cofechaInicioHasta
	 *            String
	 * @param cofechaTramitacionDesde
	 *            String
	 * @param cofechaTramitacionHasta
	 *            String
	 * @return FiltroSanciones
	 */
	private FiltroSanciones prepararFiltro(FiltroSanciones filtroSanciones,
			String cofechaInicioDesde, String cofechaInicioHasta,
			String cofechaTramitacionDesde, String cofechaTramitacionHasta) {
		Locale locale = LocaleContextHolder.getLocale();

		try {
			if (null != cofechaInicioDesde) {
				filtroSanciones.setFechaIniDesde(Y41bUtils.parseDate(
						cofechaInicioDesde, locale));
				filtroSanciones.setFechaIniDesdeStr(cofechaInicioDesde);
			}
			if (null != cofechaInicioHasta) {
				filtroSanciones.setFechaIniHasta(Y41bUtils.parseDate(
						cofechaInicioHasta, locale));
				filtroSanciones.setFechaIniHastaStr(cofechaInicioHasta);
			}
		} catch (Exception e) {
			ExpedienController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
		try {
			if (null != cofechaTramitacionDesde
					&& !cofechaTramitacionDesde.equals("")) {
				filtroSanciones.setFechaTramitacionDesde(Y41bUtils
						.parseDateTime(
								cofechaTramitacionDesde.concat(" 00:00:00"),
								locale));
				filtroSanciones
						.setFechaTramitacionDesdeStr(cofechaTramitacionDesde);
			}
			if (null != cofechaTramitacionHasta
					&& !cofechaTramitacionHasta.equals("")) {
				filtroSanciones.setFechaTramitacionHasta(Y41bUtils
						.parseDateTime(
								cofechaTramitacionHasta.concat(" 23:59:59"),
								locale));
				filtroSanciones
						.setFechaTramitacionHastaStr(cofechaTramitacionHasta);
			}
		} catch (Exception e) {
			ExpedienController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
		return filtroSanciones;
	}

	/**
	 * Method 'getFichaExpediente'.
	 * 
	 * @param model
	 *            Model
	 * @param desde
	 *            String
	 * @param accesoPest2
	 *            String
	 * @param excodigo
	 *            String
	 * @param httpRequest
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "fichaExpedienteSancion/{excodigo}", method = RequestMethod.GET)
	public ModelAndView getFichaExpediente(
			Model model,
			@RequestParam(value = "desde", required = false) String desde,
			@RequestParam(value = "accesoPest2", required = false) String accesoPest2,
			@PathVariable() String excodigo, HttpServletRequest httpRequest) {

		try {
			return this.expedienService.getFichaExpedienteSanciones(model,
					desde, accesoPest2, excodigo, httpRequest);
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico" + e.getMessage(), true,
					e);
		}
	}

	/**
	 * Method 'getFichaExpediente'.
	 * 
	 * @param model
	 *            Model
	 * @param desde
	 *            String
	 * @param accesoPest2
	 *            String
	 * @param excodigo
	 *            String
	 * @param httpRequest
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "fichaExpedienteSancionSinCabecera/{excodigo}", method = RequestMethod.GET)
	public ModelAndView getFichaExpedienteSinCabecera(
			Model model,
			@RequestParam(value = "desde", required = false) String desde,
			@RequestParam(value = "accesoPest2", required = false) String accesoPest2,
			@PathVariable() String excodigo, HttpServletRequest httpRequest) {

		try {
			return this.expedienService.getFichaExpedienteSanciones(model,
					desde, accesoPest2, true, excodigo, httpRequest);
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico" + e.getMessage(), true,
					e);
		}
	}

	/**
	 * Method 'getFichaExpedienteBusquedaEscritorio'.
	 * 
	 * @param model
	 *            Model
	 * @param desde
	 *            String
	 * @param accesoPest2
	 *            String
	 * @param excodigo
	 *            String
	 * @param httpRequest
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "/maintBusquedaSanciones/fichaExpedienteSancion/{excodigo}", method = RequestMethod.GET)
	public ModelAndView getFichaExpedienteBusquedaEscritorio(
			Model model,
			@RequestParam(value = "desde", required = false) String desde,
			@RequestParam(value = "accesoPest2", required = false) String accesoPest2,
			@PathVariable() String excodigo, HttpServletRequest httpRequest) {

		try {
			return this.expedienService.getFichaExpedienteSanciones(model,
					desde, accesoPest2, excodigo, httpRequest);
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico" + e.getMessage(), true,
					e);
		}
	}

	/**
	 * Method 'getExpedientePestania1'.
	 * 
	 * @param model
	 *            Model
	 * @param httpRequest
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "muestraFichaExpedientePestania1", method = RequestMethod.GET)
	public ModelAndView getExpedientePestania1(Model model,
			HttpServletRequest httpRequest) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		censoMonitor = this.censoMonitorService.find(censoMonitor);
		String perfil = censoMonitor.getPerfilSanciones().getIdPerfil();
		if (perfil != null
				&& Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO.equals(perfil)) {
			// Si perfil sin acceso devolvemos listado vacio
			return new ModelAndView("accessDenied", "model", model);
		} else {
			return new ModelAndView("fichaExpedienteSancionPestania1", "model",
					model);
		}
	}

	/**
	 * Method 'getExpedientePestania2'.
	 * 
	 * @param model
	 *            Model
	 * @param httpRequest
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "muestraFichaExpedientePestania2", method = RequestMethod.GET)
	public ModelAndView getExpedientePestania2(Model model,
			HttpServletRequest httpRequest) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		censoMonitor = this.censoMonitorService.find(censoMonitor);
		String perfil = censoMonitor.getPerfilSanciones().getIdPerfil();
		if (perfil != null
				&& Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO.equals(perfil)) {
			// Si perfil sin acceso devolvemos listado vacio
			return new ModelAndView("accessDenied", "model", model);
		} else {
			return new ModelAndView("fichaExpedienteSancionPestania2", "model",
					model);
		}

	}

	/**
	 * Method 'getExpedientePestania3'.
	 * 
	 * @param model
	 *            Model
	 * @param httpRequest
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "muestraFichaExpedientePestania3", method = RequestMethod.GET)
	public ModelAndView getExpedientePestania3(Model model,
			HttpServletRequest httpRequest) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);
		censoMonitor = this.censoMonitorService.find(censoMonitor);
		String perfil = censoMonitor.getPerfilSanciones().getIdPerfil();
		if (perfil != null
				&& Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO.equals(perfil)) {
			// Si perfil sin acceso devolvemos listado vacio
			return new ModelAndView("accessDenied", "model", model);
		} else {
			return new ModelAndView("fichaExpedienteSancionPestania3", "model",
					model);
		}
	}

	/**
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "muestraFichaExpedienteHistoricoPestaniaRegistro", method = RequestMethod.GET)
	public ModelAndView getExpedienteHistoricoPestaniaRegistro(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView(
				"fichaExpedienteHistoricoSancionPestaniaRegistro", "model",
				model);
	}

	/**
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "muestraFichaExpedienteHistoricoPestaniaAlegaciones", method = RequestMethod.GET)
	public ModelAndView getExpedienteHistoricoAlegaciones(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView(
				"fichaExpedienteHistoricoSancionPestaniaAlegaciones", "model",
				model);
	}

	/**
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "muestraFichaExpedienteHistoricoPestaniaAnalisis", method = RequestMethod.GET)
	public ModelAndView getExpedienteHistoricoAnalisis(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView(
				"fichaExpedienteHistoricoSancionPestaniaAnalisis", "model",
				model);
	}

	/**
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "muestraFichaExpedienteHistoricoPestaniaResolucion", method = RequestMethod.GET)
	public ModelAndView getExpedienteHistoricoResolucion(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView(
				"fichaExpedienteHistoricoSancionPestaniaResolucion", "model",
				model);
	}

	/**
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "muestraFichaExpedienteHistoricoPestaniaPronunciamiento", method = RequestMethod.GET)
	public ModelAndView getExpedienteHistoricoPronunciamiento(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView(
				"fichaExpedienteHistoricoSancionPestaniaPronunciamiento",
				"model", model);
	}

	/**
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "muestraFichaExpedienteHistoricoPestaniaLiquidacion", method = RequestMethod.GET)
	public ModelAndView getExpedienteHistoricoLiquidacion(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView(
				"fichaExpedienteHistoricoSancionPestaniaLiquidacion", "model",
				model);
	}

	/**
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "muestraFichaExpedienteHistoricoPestaniaRecurso", method = RequestMethod.GET)
	public ModelAndView getExpedienteHistoricoRecurso(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView(
				"fichaExpedienteHistoricoSancionPestaniaRecurso", "model",
				model);
	}

	/**
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "muestraFichaExpedienteHistoricoPestaniaContencioso", method = RequestMethod.GET)
	public ModelAndView getExpedienteHistoricoContencioso(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView(
				"fichaExpedienteHistoricoSancionPestaniaContencioso", "model",
				model);
	}

	/**
	 * Method 'maintNuevaMod'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "maintNuevaMod", method = RequestMethod.GET)
	public ModelAndView getCreateFormMod(Model model, HttpServletRequest request) {

		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));

		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilSanciones() == null) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else if (censoMonitor.getPerfilSanciones().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_INSTRUCTOR)) {
			return new ModelAndView("modalSancionNueva", "model", model);
		} else if (censoMonitor.getPerfilSanciones().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_SUPERVISOR)) {
			return new ModelAndView("modalSancionNueva", "model", model);
		} else if (censoMonitor.getPerfilSanciones().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_COORDINADOR)) {
			return new ModelAndView("modalSancionNueva", "model", model);
		} else if (censoMonitor.getPerfilSanciones().getIdPerfil()
				.equals(Y41bConstantes.PERFIL_DIRECTOR)) {
			return new ModelAndView("modalSancionNueva", "model", model);
		} else {
			return new ModelAndView("accessDeniedModal", "model", model);
		}
	}

	/**
	 * @param sancionnueva
	 *            Expedien
	 * @param baprsanid
	 *            Long
	 * @param request
	 *            HttpServletRequest
	 * @return Expedien
	 */
	@RequestMapping(value = "/guardarSancion/{baprsanid}", method = RequestMethod.POST)
	public @ResponseBody()
	Expedien updateSancion(@RequestBody() Expedien sancionnueva,
			@PathVariable() Long baprsanid, HttpServletRequest request) {
		Expedien nuevoExpedien;
		try {
			ExpedienController.logger.info("Entity correctly inserted!"
					+ sancionnueva.toString() + request.toString());

			if (sancionnueva.getExcodigo() == null) {
				Locale locale = LocaleContextHolder.getLocale();
				// Siempre viene relleno el campo Exdesces
				if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
					sancionnueva.getSanexp().setExdesceu(
							sancionnueva.getSanexp().getExdesces());
					sancionnueva.getSanexp().setExdesces("");
				}
				if (sancionnueva.getSanexp() == null) {
					sancionnueva.setSanexp(new Sanexp());
				}
				nuevoExpedien = this.add(sancionnueva, baprsanid);
			} else {
				sancionnueva.setArticulosAniadidos((List<String>) request
						.getSession().getAttribute("articulosAniadidos"));
				sancionnueva.setMateriasAniadidas((List<String>) request
						.getSession().getAttribute("materiasAniadidas"));
				nuevoExpedien = this.edit(sancionnueva, request);
			}

			return nuevoExpedien;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			ExpedienController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}

	}

	/**
	 * @param sancionnueva
	 *            Expedien
	 * @param request
	 *            HttpServletRequest
	 * @return Expedien
	 */
	@RequestMapping(value = "/guardarSancion", method = RequestMethod.POST)
	public @ResponseBody()
	Expedien updateSancion(@RequestBody() Expedien sancionnueva,
			HttpServletRequest request) {
		return this.updateSancion(sancionnueva, null, request);
	}

	/**
	 * Method 'getCreateFormRechazoMod'. Rechazo de una propuesta de sancion.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param baprsanid
	 *            String
	 * @param idExpediente
	 *            String
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "/maintRechazoMod/{codProcedimiento}/{baprsanid}/{idExpediente}", method = RequestMethod.GET)
	public ModelAndView getCreateFormRechazoMod(
			@PathVariable() String codProcedimiento,
			@PathVariable() String baprsanid,
			@PathVariable() String idExpediente, Model model) {

		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		model.addAttribute("idExpediente", idExpediente);
		model.addAttribute("codProcedimiento", codProcedimiento);
		model.addAttribute("idPropBandeja", baprsanid);

		return new ModelAndView("modalSancionRechazo", "model", model);
	}

	// 0160753: Bandeja de Sancionador - Cambio de orgnico
	/**
	 * Method 'getCreateFormRechazoMod'. Rechazo de una propuesta de sancion.
	 * 
	 * @param codProcedimiento
	 *            String
	 * @param baprsanid
	 *            String
	 * @param idExpediente
	 *            String
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "/maintCambioMod/{codProcedimiento}/{baprsanid}/{idExpediente}", method = RequestMethod.GET)
	public ModelAndView getCreateFormCambioMod(
			@PathVariable() String codProcedimiento,
			@PathVariable() String baprsanid,
			@PathVariable() String idExpediente, Model model) {

		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		model.addAttribute("idExpediente", idExpediente);
		model.addAttribute("codProcedimiento", codProcedimiento);
		model.addAttribute("idPropBandeja", baprsanid);

		return new ModelAndView("modalSancionCambio", "model", model);
	}

	/**
	 * 
	 * @param rechazosanobserv
	 *            String
	 * @param codInstructor
	 *            String
	 * @param baprsanid
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return boolean
	 */
	@RequestMapping(value = "/guardarCambioSancion/{baprsanid}", method = RequestMethod.POST)
	public @ResponseBody()
	boolean updateCambioSancion(
			@RequestParam(value = "nuevoOrganismo", required = false) String nuevoOrganismo,
			@PathVariable() String baprsanid, HttpServletRequest request) {
		try {
			ExpedienController.logger.info("INICIO updateCambioSancion: "
					+ nuevoOrganismo.toString() + request.toString());

			Sanpropbandeja sanpropbandeja = new Sanpropbandeja();
			sanpropbandeja.setBaprsanid(Long.valueOf(baprsanid));
			sanpropbandeja = this.sanpropbandejaService.find(sanpropbandeja);
			sanpropbandeja.setBaprNuevoOrganismo(nuevoOrganismo);

			// tramiteGenerico.setComentario(rechazosanobserv);

			ExpedienController.logger.info("Entity correctly inserted!");

			this.sanpropbandejaService.updateBaprNuevoOrganismo(sanpropbandeja);
			return true;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed" + e.getMessage());
		}
	}

	// 0160753: Bandeja de Sancionador - Cambio de orgnico
	/**
	 * 
	 * @param rechazosanobserv
	 *            String
	 * @param codInstructor
	 *            String
	 * @param baprsanid
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return boolean
	 */
	@RequestMapping(value = "/guardarRechazoSancion/{baprsanid}", method = RequestMethod.POST)
	public @ResponseBody()
	boolean updateRechazoSancion(
			@RequestParam(value = "rechazosanobserv", required = false) String rechazosanobserv,
			@RequestParam(value = "instructor", required = false) String codInstructor,
			@PathVariable() String baprsanid, HttpServletRequest request) {
		try {
			ExpedienController.logger.info("INICIO updateRechazoSancion: "
					+ rechazosanobserv.toString() + request.toString());

			Sanpropbandeja sanpropbandeja = new Sanpropbandeja();
			sanpropbandeja.setBaprsanid(Long.valueOf(baprsanid));
			sanpropbandeja = this.sanpropbandejaService.find(sanpropbandeja);
			TramiteGenerico tramiteGenerico = new TramiteGenerico();
			tramiteGenerico
					.setIdExpediente(sanpropbandeja.getBaprsanexcodigo());
			tramiteGenerico.setFechaInicio(new Date());
			CensoMonitor censoMonitor = new CensoMonitor();
			censoMonitor.setMocodigo(codInstructor);
			tramiteGenerico.setInstructorAsignado(censoMonitor);
			tramiteGenerico.setComentario(rechazosanobserv);
			String literalNombreTramite = "propuesta.rechazo";
			if (Y41bConstantes.TIPO_PROC_SOLICITUDES.equals(sanpropbandeja
					.getBaprsanpcodigo())) {
				this.soltramexpService.addTramiteGenericoAutomatico(
						tramiteGenerico, literalNombreTramite);
			} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(sanpropbandeja
					.getBaprsanpcodigo())) {
				tramiteGenerico.setNombreTramite(this.appMessageSource
						.getMessage(literalNombreTramite, null,
								LocaleContextHolder.getLocale()));
				TramiteComun tramiteComun = new TramiteComun();
				tramiteComun.setIdExpediente(new String(sanpropbandeja
						.getBaprsanexcodigo()));
				tramiteComun
						.setIdTipoTramite(Y41bConstantes.TRAMITE_ARBITRAJE_GENERICO);
				tramiteComun.setTipoProcedimiento(new TipoProcedimiento(
						Y41bConstantes.TIPO_PROC_ARBITRAJE));
				tramiteComun.setIdTramite(this.arbtramexpService.getNewPK()
						.toString());
				this.arbtramexp4Service
						.addTramiteGenerico(tramiteGenerico, tramiteComun, "",
								false, Y41bConstantes.MODO_POPUP_ALTA);
			} else if (Y41bConstantes.TIPO_PROC_INSPECCIONES
					.equals(sanpropbandeja.getBaprsanpcodigo())) {

				String nombreEstablecimiento = null;

				Actuacion actuacion = new Actuacion();
				actuacion.setAtcodigo(sanpropbandeja.getBaprsanexcodigo());

				InspeccionDetalle inspeccionDetalle = this.actaService
						.findInspeccion(actuacion, null);
				if (inspeccionDetalle != null) {
					String baprsansancionado = sanpropbandeja
							.getBaprsansancionado();
					if (inspeccionDetalle.getEstablecimientoR() != null
							&& baprsansancionado != null
							&& baprsansancionado
									.equalsIgnoreCase(inspeccionDetalle
											.getEstablecimientoR()
											.getEscodigo())) {
						nombreEstablecimiento = inspeccionDetalle
								.getEstablecimientoR().getNombre();
					} else if (inspeccionDetalle.getEstablecimientoV() != null
							&& baprsansancionado != null
							&& baprsansancionado
									.equalsIgnoreCase(inspeccionDetalle
											.getEstablecimientoV()
											.getEscodigo())) {
						nombreEstablecimiento = inspeccionDetalle
								.getEstablecimientoV().getNombre();
					}
				}

				this.instramexpService.addTramiteGenericoAutomatico(
						tramiteGenerico, literalNombreTramite,
						nombreEstablecimiento);
			}
			ExpedienController.logger.info("Entity correctly inserted!");

			this.sanpropbandejaService.remove(sanpropbandeja);
			return true;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed" + e.getMessage());
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "y41bSancionModificacionInstructor", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bSancionModificacionInstructor(
			Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilSolicitudes() == null
				|| censoMonitor.getPerfilSolicitudes().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_PROCEDIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("y41bSancionModificacionInstructor",
					"model", model);
		}
	}

	/**
	 * 
	 * @param model
	 *            Model
	 * @param excodigo
	 *            String
	 * @param uaescodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "/maintExpedientesHistoricosSancionado/{excodigo}/{uaescodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41bSancionExpedientesHistoricos(
			Model model, @PathVariable() String excodigo,
			@PathVariable() String uaescodigo, HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("uaescodigo_denunciado", uaescodigo);
		model.addAttribute("excodigo", excodigo);

		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView("y41bSancionExpedientesHistoricos", "model",
				model);
	}

	/**
	 * Method 'editInstructor'.
	 * 
	 * @param solicitudCambioInstructor
	 *            SolicitudCambioInstructor
	 */
	@RequestMapping(value = "/modificarInstructor", method = RequestMethod.PUT)
	public @ResponseBody()
	void editInstructor(
			@RequestBody() SolicitudCambioInstructor solicitudCambioInstructor) {
		try {

			this.expedienService
					.updateCambioInstructor(solicitudCambioInstructor);
			ExpedienController.logger.info("Entity correctly inserted!");

		} catch (Exception e) {
			ExpedienController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'trasvaseTotal'.
	 * 
	 * @param solicitudCambioInstructor
	 *            SolicitudCambioInstructor
	 */
	@RequestMapping(value = "/trasvaseTotal", method = RequestMethod.PUT)
	public @ResponseBody()
	void trasvaseTotal(
			@RequestBody() SolicitudCambioInstructor solicitudCambioInstructor) {
		try {

			this.expedienService
					.updateTrasvaseTotalCambioInstructor(solicitudCambioInstructor);

			ExpedienController.logger.info("Entity correctly inserted!");

		} catch (Exception e) {
			ExpedienController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterExpedien
	 *            Expedien
	 * @param excodigo
	 *            the excodigo
	 * @param uaescodigo
	 *            the uaescodigo
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/listaSentenciasFirmes/{excodigo}/{uaescodigo}", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGridHistoricoSancionado(
			@ModelAttribute() Expedien filterExpedien,
			@PathVariable() String excodigo, @PathVariable() String uaescodigo,
			@ModelAttribute() Pagination pagination) {
		Expedien expedien = new Expedien();
		expedien.setExcodigo(excodigo);
		Saninterv saninterv = new Saninterv();
		saninterv.setUaescodigo(uaescodigo);
		List<Expedien> expediens = this.expedienService
				.listExpedientesConRecursos(expedien, saninterv, pagination);
		Long recordNum = new Long(this.expedienService.expedientesConRecursos(
				expedien, saninterv) + "");
		ExpedienController.logger.info("[GET - jqGrid] : Obtener Expedien");
		return new JQGridJSONModel(pagination, recordNum, expediens);
	}

	/**
	 * Method 'getAllJQGridArticulos'.
	 * 
	 * @param excodigo
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/findArticulos/{excodigo}", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGridArticulos(@PathVariable() String excodigo,
			@ModelAttribute() Pagination pagination) {

		List<InfraccHechoDen> articulos = this.infracchechodenService
				.findArticulosMaterias(excodigo, pagination);
		Long recordNum = this.infracchechodenService
				.findArticulosMateriasCount(excodigo);
		ExpedienController.logger.info("[GET - jqGrid] : Obtener Articulos");
		return new JQGridJSONModel(pagination, recordNum, articulos);
	}

	/**
	 * Method 'getAllJQGridMaterias'.
	 * 
	 * @param excodigo
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/findMaterias/{excodigo}", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGridMaterias(@PathVariable() String excodigo,
			@ModelAttribute() Pagination pagination) {

		List<InfraccHechoDen> articulos = this.infracchechodenService
				.findMaterias(excodigo, pagination);
		Long recordNum = this.infracchechodenService
				.findMateriasCount(excodigo);
		ExpedienController.logger.info("[GET - jqGrid] : Obtener Materias");
		return new JQGridJSONModel(pagination, recordNum, articulos);
	}

	/**
	 * Metodo para generar un archivo excel con los filtrados correspondientes
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excel", method = RequestMethod.GET)
	public void getAllConsultaExcel(HttpServletRequest request,
			HttpServletResponse response) {
		try {

			HttpSession httpSession = request.getSession();
			FiltroSanciones filtroSanciones = (FiltroSanciones) httpSession
					.getAttribute("sancionBusqueda");

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy,
					"yyyyMMddHHmmss");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_BUSQUEDA_SANCIONES
					+ fechaActual + ".xls";
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ StringEscapeUtils.unescapeHtml(nombre) + "\"");

			String xslString = this.y41bExcelGeneratorService
					.getSancionesExcel(filtroSanciones);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}

	}

	/**
	 * Method 'getEtiquetaByCodSancion'.
	 * 
	 * @param excodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * 
	 */
	@RequestMapping(value = "/etiqueta/{excodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	void getEtiquetaByCodSancion(@PathVariable() String excodigo,
			HttpServletResponse response) {
		try {

			Expedien expedien = new Expedien();
			expedien.setExcodigo(excodigo);
			expedien = this.expedienService.find(expedien);
			if (expedien == null) {
				throw new Exception(excodigo.toString());
			}

			Saninterv saninterv = new Saninterv();
			saninterv.setExpedien(new Expedien(expedien.getExcodigo()));
			saninterv
					.setUatipointerv(Y41bConstantes.TIPO_INTERVINIENTE_SANCIONADO);
			Pagination pagination = new Pagination();
			pagination.setRows(2L);
			List<Saninterv> listaSaninterv = this.sanintervService.findAllLike(
					saninterv, pagination, false);
			if (listaSaninterv != null && listaSaninterv.size() == 1) {
				saninterv = listaSaninterv.get(0);
				if (saninterv != null) {
					if (saninterv.getUamunId() != null
							&& saninterv.getUaprovId() != null) {
						T17Municipio municipio = this.municipioService
								.find(new T17Municipio(saninterv.getUamunId(),
										saninterv.getUaprovId(), "", excodigo));
						expedien.setEsNombreMunicipio(municipio.getDsO());
						expedien.setEsNombreSancionado((saninterv.getUanombre() == null ? ""
								: saninterv
										.getUanombre()
										.concat(" ")
										.concat(saninterv.getUaapellido1() == null ? ""
												: saninterv.getUaapellido1())
										.concat(" ")
										.concat(saninterv.getUaapellido2() == null ? ""
												: saninterv.getUaapellido2()))
								.trim());
					}
				}
			}

			String rutaRTF = (String) this.appConfiguration
					.get("y41bVistaWar.ruta.plantillas.word");
			String rutaXML = (String) this.appConfiguration
					.get("y41bVistaWar.rutaxml.plantillas.word");
			String nombreRTF = Y41bConstantes.NOMBRE_PLANTILLA_SANCIONES_ETIQUETA_RTF;
			String nombreXML = Y41bConstantes.NOMBRE_PLANTILLA_SANCIONES_ETIQUETA_XML;
			String rutaCompletaRTF = rutaRTF + nombreRTF;
			String rutaCompletaXML = rutaXML + nombreXML;

			String plantilla = new String(
					Y41bDocumento.leerArchivoOrigen(rutaCompletaRTF));

			String strFileDataDecode = Y41bGenerarDocumento
					.generarDocumentoWord(rutaCompletaXML, expedien, plantilla);

			byte[] bytesFichero = strFileDataDecode.getBytes();

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			String nombreFichero = expedien.getExcoor() + "-"
					+ expedien.getExnror() + "-" + expedien.getExnran()
					+ ".rtf";

			// response.addHeader("Expires", "-1");

			// Esto se ha quitado porque sino en Internet Explorer produce
			// un error al mostrarse
			// response.setCharacterEncoding("ISO-8859-1");
			// response.setHeader("Cache-Control", "no-cache");

			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ StringEscapeUtils.unescapeHtml(nombreFichero) + "\"");
			response.setContentType("application/msword");
			response.setContentLength(bytesFichero.length);
			response.getOutputStream().write(bytesFichero);

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Exception e) {
			ExpedienController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param excodigo
	 *            String
	 * @return expedien Expedien
	 * @throws Y41bUDAException
	 *             Exception
	 */
	@RequestMapping(value = "/comprobarGenerarPropuesta/{excodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	Map<String, Object> comprobarGenerarPropuesta(
			@PathVariable() String excodigo) throws Y41bUDAException {
		Map<String, Object> mapa = new HashMap<String, Object>();
		try {
			mapa = this.santramexpService.obtenerDatosTramitesFichaSancionador(
					excodigo, mapa);

			ExpedienController.logger
					.info("[GET - findBy_PK] : Obtener Expedien por PK");
			return mapa;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico" + e.getMessage(), true,
					e);
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param excodigo
	 *            String
	 * @return Expedien
	 * @throws Y41bUDAException
	 *             Exception
	 */
	@RequestMapping(value = "/comprobarDatosObligatorios/{excodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	Expedien obtenerDatosObligatorios(@PathVariable() String excodigo)
			throws Y41bUDAException {
		try {
			ExpedienController.logger
					.info("[GET - findBy_PK] : Obtener Expedien por PK . AAAAAAAAAAA");
			Expedien expedien = new Expedien();
			expedien.setExcodigo(excodigo);
			Expedien expediente = this.expedienService.find(expedien);
			expediente.setcodCompleto(expediente.damecodCompleto());

			List<InfraccHechoDen> articulos = this.infracchechodenService
					.findArticulos(excodigo, null);
			List<InfraccHechoDen> materias = this.infracchechodenService
					.findMaterias(excodigo, null);

			expediente.setArticulos(articulos);
			expediente.setMaterias(materias);

			Saninterv denunciado = this.sanintervService
					.dameSancionado(excodigo);

			Saninterv saninterv = new Saninterv();
			saninterv.setExpedien(new Expedien(expedien.getExcodigo()));
			List<Saninterv> listaSantinterv = this.sanintervService.findAll(
					saninterv, null);
			boolean tieneDireccionCompleta = true;
			if (listaSantinterv != null && listaSantinterv.size() > 0) {
				for (int i = 0; i < listaSantinterv.size(); i++) {
					saninterv = listaSantinterv.get(i);
					if (!Y41bConstantes.COD_PAIS_ESTADO.equals(saninterv
							.getUapaisId())) { // si es extranjero
						if (!Y41bUtils.esNullOCadenaVacia(saninterv
								.getUapaisId())
								&& !Y41bUtils.esNullOCadenaVacia(saninterv
										.getUadireNocapv())) {
							tieneDireccionCompleta = true;
						} else {
							tieneDireccionCompleta = false;
						}
					} else {// si es nacional
						if (!Y41bUtils.esNullOCadenaVacia(saninterv
								.getUaprovId())
								&& !Y41bUtils.esNullOCadenaVacia(saninterv
										.getUamunId())) {
							if (saninterv.getUamunId() != null
									&& saninterv.getUaprovId() != null) {
								T17Municipio municipio = this.municipioService
										.find(this.crearMunicipio(
												saninterv.getUamunId(),
												saninterv.getUaprovId(),
												excodigo));
								saninterv
										.setNombreMunicipio(municipio.getDsO());
							}

							if (saninterv.getUaprovId() != null) {
								T17Provincia provincia = this.provinciaService
										.find(this.crearProvincia(
												saninterv.getUaprovId(),
												excodigo));
								saninterv
										.setNombreProvincia(provincia.getDsO());
							}
							if (!Y41bUtils.esNullOCadenaVacia(saninterv
									.getNombreProvincia())
									&& !Y41bUtils.esNullOCadenaVacia(saninterv
											.getNombreMunicipio())) {
								// si es de capv
								if (saninterv.getUaprovId().equals(
										Y41bConstantes.CODIGO_PROVINCIA_ARABA)
										|| saninterv
												.getUaprovId()
												.equals(Y41bConstantes.CODIGO_PROVINCIA_GIPUZKOA)
										|| saninterv
												.getUaprovId()
												.equals(Y41bConstantes.CODIGO_PROVINCIA_BIZKAIA)) {
									if (!Y41bUtils.esNullOCadenaVacia(saninterv
											.getUacalleId())) {
										tieneDireccionCompleta = true;
									} else {
										tieneDireccionCompleta = false;
									}
								} else { // si no es de capv
									if (!Y41bUtils.esNullOCadenaVacia(saninterv
											.getUadireNocapv())) {// si NO es de
																	// capv
										tieneDireccionCompleta = true;
									} else {
										tieneDireccionCompleta = false;
									}
								}
							} else {// Es nacional y no tiene descripcin de
									// provincia y municipio
								tieneDireccionCompleta = false;
							}
						} else {// Es nacional y no tiene provincia
							tieneDireccionCompleta = false;
						}

					}
					if (!tieneDireccionCompleta) {
						break;
					}
				}
			}
			if (tieneDireccionCompleta) {
				denunciado.setDireccionCompleta("OK");
			} else {
				denunciado.setDireccionCompleta("ERROR");
			}

			expediente.setDenunciado(denunciado);

			ExpedienController.logger
					.info("[GET - findBy_PK] : Obtener Expedien por PK");
			return expediente;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico" + e.getMessage(), true,
					e);
		}
	}

	/**
	 * 
	 * @param munId
	 *            String
	 * @param provId
	 *            String
	 * @param excodigo
	 *            String
	 * @return T17Municipio
	 */
	private T17Municipio crearMunicipio(String munId, String provId,
			String excodigo) {
		return new T17Municipio(munId, provId, "", excodigo);
	}

	/**
	 * 
	 * @param provId
	 *            String
	 * @param excodigo
	 *            String
	 * @return T17Provincia
	 */
	private T17Provincia crearProvincia(String provId, String excodigo) {
		return new T17Provincia(provId, "", excodigo);
	}
}
