package com.ejie.y41b.control;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.EstadopagoService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.Estadopago;

/**
 * EstadopagoController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/estadopago")
public class EstadopagoController {

	private static final Logger logger = LoggerFactory
			.getLogger(EstadopagoController.class);

	@Autowired()
	private EstadopagoService estadopagoService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		EstadopagoController.logger.info("[GET - View] : estadopago");
		return "estadopago";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param sacodigo
	 *            String
	 * @return estadopago Estadopago
	 */
	@RequestMapping(value = "/{sacodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	Estadopago getById(@PathVariable() String sacodigo) {
		Estadopago estadopago = new Estadopago();
		estadopago.setSacodigo(sacodigo);
		estadopago = this.estadopagoService.find(estadopago);
		EstadopagoController.logger
				.info("[GET - findBy_PK] : Obtener Estadopago por PK");
		return estadopago;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterEstadopago
	 *            Estadopago
	 * @return List
	 */
	@RequestMapping(value = "/listar", method = RequestMethod.GET)
	public @ResponseBody()
	List<Estadopago> getAll(@ModelAttribute() Estadopago filterEstadopago) {
		EstadopagoController.logger
				.info("[GET - find_ALL] : Obtener Estadopago por filtro");
		return this.estadopagoService.findAll(filterEstadopago, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param estadopago
	 *            Estadopago
	 * @return Estadopago
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Estadopago edit(@RequestBody() Estadopago estadopago) {
		Estadopago estadopagoAux = this.estadopagoService.update(estadopago);
		EstadopagoController.logger
				.info("[PUT] : Estadopago actualizado correctamente");
		return estadopagoAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param estadopago
	 *            Estadopago
	 * @return Estadopago
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Estadopago add(@RequestBody() Estadopago estadopago) {
		Estadopago estadopagoAux = this.estadopagoService.add(estadopago);
		EstadopagoController.logger
				.info("[POST] : Estadopago insertado correctamente");
		return estadopagoAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param sacodigo
	 *            String
	 * @return estadopago
	 */
	@RequestMapping(value = "/{sacodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Estadopago remove(@PathVariable() String sacodigo) {
		Estadopago estadopago = new Estadopago();
		estadopago.setSacodigo(sacodigo);
		this.estadopagoService.remove(estadopago);
		EstadopagoController.logger
				.info("[DELETE] : Estadopago borrado correctamente");
		return estadopago;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param estadopagoIds
	 *            List
	 * @return estadopagoList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(
			@RequestBody() List<List<String>> estadopagoIds) {
		List<Estadopago> estadopagoList = new ArrayList<Estadopago>();
		for (List<String> estadopagoId : estadopagoIds) {
			Iterator<String> iterator = estadopagoId.iterator();
			Estadopago estadopago = new Estadopago(); // NOPMD - Objeto nuevo en
														// la lista (parametro
														// del servicio)
			estadopago.setSacodigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			estadopagoList.add(estadopago);
		}
		this.estadopagoService.removeMultiple(estadopagoList);
		EstadopagoController.logger
				.info("[POST - DELETE_ALL] : Estadopago borrados correctamente");
		return estadopagoIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterEstadopago
	 *            Estadopago
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(@ModelAttribute() Estadopago filterEstadopago,
			@ModelAttribute() Pagination pagination) {
		List<Estadopago> estadopagos = this.estadopagoService.findAll(
				filterEstadopago, pagination);
		Long recordNum = this.estadopagoService.findAllCount(filterEstadopago);
		EstadopagoController.logger.info("[GET - jqGrid] : Obtener Estadopago");
		return new JQGridJSONModel(pagination, recordNum, estadopagos);
	}

}
