package com.ejie.y41b.control;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Actividad;
import com.ejie.y41b.model.AdjunDatosAvisosEstablec;
import com.ejie.y41b.model.AdjunDatosMailEstablec;
import com.ejie.y41b.model.AdjunDatosMailSede;
import com.ejie.y41b.model.Arbadhsol;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Descriptor;
import com.ejie.y41b.model.EsCanalPrioritario;
import com.ejie.y41b.model.EstablecimArbitra;
import com.ejie.y41b.model.EstablecimSector;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.EstablecimientoDecisionAnyo;
import com.ejie.y41b.model.EstablecimientoDetalle;
import com.ejie.y41b.model.EstablecimientoReclamacionesAnyo;
import com.ejie.y41b.model.HechoDenunciado;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.Perfil;
import com.ejie.y41b.model.PlantillaEstablecimientoDetalle;
import com.ejie.y41b.model.PlantillaPegatinaEstablecimiento;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.model.Sector;
import com.ejie.y41b.model.Sede;
import com.ejie.y41b.model.TipoProcedimiento;
import com.ejie.y41b.service.AdjunDatosAvisosEstablecService;
import com.ejie.y41b.service.AdjunDatosMailEstablecService;
import com.ejie.y41b.service.AdjunDatosMailSedeService;
import com.ejie.y41b.service.ArbadhsolService;
import com.ejie.y41b.service.ArbintervService;
import com.ejie.y41b.service.CensoMonitorService;
import com.ejie.y41b.service.DenunciaService;
import com.ejie.y41b.service.EstablecimientoService;
import com.ejie.y41b.service.OrganismoService;
import com.ejie.y41b.service.SanintervService;
import com.ejie.y41b.service.TipoProcedimientoService;
import com.ejie.y41b.service.Y41bExcelGeneratorService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.documentos.Y41bDocumento;
import com.ejie.y41b.utils.documentos.Y41bGenerarDocumento;
import com.ejie.y41b.utils.dokusi.Y41bUtilsDokusi;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

;

/**
 * * EstablecimientoController  
 * 
 *  
 */

/**
 *  
 * 
 */
@Controller
@RequestMapping(value = "/establecimiento")
@SessionAttributes({ "establecimiento", "sede" })
public class EstablecimientoController {

	private static final Logger logger = LoggerFactory.getLogger(EstablecimientoController.class);

	@Autowired
	private EstablecimientoService establecimientoService;

	@Autowired()
	private OrganismoService organismoService;

	@Autowired
	private Y41bExcelGeneratorService y41bExcelGeneratorService;

	@Autowired
	private DenunciaService denunciaService;

	@Autowired
	private AdjunDatosMailEstablecService adjunDatosMailEstablecService;

	@Autowired
	private AdjunDatosMailSedeService adjunDatosMailSedeService;

	@Autowired()
	private CensoMonitorService censoMonitorService;

	@Resource()
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired
	private AdjunDatosAvisosEstablecService adjunDatosAvisosEstablecService;

	@Autowired
	private TipoProcedimientoService tipoProcedimientoService;
	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Properties appConfiguration;
	@Autowired
	private ArbintervService arbintervService;
	@Autowired
	private SanintervService sanintervService;
	@Autowired
	private ArbadhsolService arbadhsolService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("establecimiento", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintModal", method = RequestMethod.GET)
	public ModelAndView getCreateFormModal(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("establecimientoModal", "model", model);
	}

	/**
	 * Method 'getCreateModalSector'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "sectores", method = RequestMethod.GET)
	public ModelAndView getCreateModalSector(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("sectores", "model", model);
	}

	/**
	 * Method 'getCreateModalMantenimiento'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "mantenimiento", method = RequestMethod.GET)
	public ModelAndView getCreateModalMantenimiento(Model model, HttpServletRequest request) {

		Establecimiento establecimiento = new Establecimiento();
		establecimiento.setEscodigo(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

		model.addAttribute("establecimiento", establecimiento);

		Sede sede = new Sede();
		sede.setIdDatosede(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

		model.addAttribute("sede", sede);

		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("mantenimiento", "model", model);
	}

	/**
	 * Method 'guardarDatosMailsEstablecimiento'.
	 * 
	 * @param escodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 */
	@RequestMapping(value = "/guardarDatosMailsEstablecimiento/{escodigo}", method = RequestMethod.GET)
	public void guardarDatosMailsEstablecimiento(@PathVariable String escodigo, HttpServletRequest request,
			Model model) {

		try {
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(new String(Y41bUtilsDokusi.decode(escodigo)));

			model.addAttribute("establecimiento", establecimiento);

			Sede sedeAux = new Sede();
			sedeAux.setIdDatosede(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

			model.addAttribute("sede", sedeAux);

			this.establecimientoService.addAdjunDatosMailEstablecTableTemporal(establecimiento);
			this.establecimientoService.addAdjunDatosMailEstablecSedeTableTemporal(establecimiento, sedeAux);
		} catch (Exception e) {
			throw new ResourceNotFoundException(escodigo.toString());
		}
	}

	/**
	 * Method 'getCreateModalNuReclamaciones'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/reclamacionesEstablecimientos", method = RequestMethod.GET)
	public ModelAndView getCreateModalReclamaciones(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("reclamacionesEstablecimientos", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "mailMultiple", method = RequestMethod.GET)
	public ModelAndView getCreateFormMailMultiple(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("mailMultiple", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "avisosMultiple", method = RequestMethod.GET)
	public ModelAndView getCreateFormAvisosMultiple(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("avisosMultiple", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param escodigo
	 *            String
	 * @param sedeAux
	 *            Sede
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/{escodigo}", method = RequestMethod.GET)
	public @ResponseBody Establecimiento getById(@PathVariable String escodigo,
			@ModelAttribute(value = "sede") Sede sedeAux, Model model) {
		try {
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(new String(Y41bUtilsDokusi.decode(escodigo)));

			model.addAttribute("establecimiento", establecimiento);

			establecimiento = this.establecimientoService.find(establecimiento);

			this.establecimientoService.addAdjunDatosMailEstablecTableTemporal(establecimiento);
			this.establecimientoService.addAdjunDatosMailEstablecSedeTableTemporal(establecimiento, sedeAux);

			if (establecimiento == null) {
				throw new Exception(escodigo.toString());
			}
			return establecimiento;
		} catch (Exception e) {
			throw new ResourceNotFoundException(escodigo.toString());
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param escodigo
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/detalle", method = RequestMethod.GET)
	public @ResponseBody EstablecimientoDetalle getEstablecimientoById(
			@RequestParam(value = "escodigo", required = true) String escodigo, Model model) {
		try {
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(escodigo);

			model.addAttribute("establecimiento", establecimiento);

			EstablecimientoDetalle establecimientoDetalle = this.establecimientoService
					.findEstablecimiento(establecimiento);

			this.establecimientoService.addAdjunDatosMailEstablecTableTemporal(establecimiento);

			// AdjunDatosAvisosEstablec adjunDatosAvisosEstablec = new
			// AdjunDatosAvisosEstablec();
			// adjunDatosAvisosEstablec.setYiescif(establecimiento.getEsnif());
			// // datos de tabla final a temporal
			// this.adjunDatosAvisosEstablecService.addAvisosMultipleFinalATemporal(adjunDatosAvisosEstablec);

			if (!model.containsAttribute("sede")) {
				// precarga de los valores del conectado
				Sede sedeAux = new Sede();

				this.establecimientoService.addAdjunDatosMailEstablecSedeTableTemporal(establecimiento, sedeAux);
			} else {

				Map<String, Object> modelMap = model.asMap();
				Sede sedeAux = (Sede) modelMap.get("sede");

				this.establecimientoService.addAdjunDatosMailEstablecSedeTableTemporal(establecimiento, sedeAux);
			}

			if (establecimientoDetalle == null) {
				throw new Exception(escodigo.toString());
			}
			return establecimientoDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(escodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param escodigo
	 *            String
	 * @param censoMonitorMocodigo
	 *            String
	 * @param esnombre
	 *            String
	 * @param esnif
	 *            String
	 * @param esnoan
	 *            String
	 * @param esnoco
	 *            String
	 * @param esnodir
	 *            String
	 * @param escolo
	 *            String
	 * @param esnrcopo
	 *            String
	 * @param esnrtel
	 *            String
	 * @param esnrfax
	 *            String
	 * @param escopa
	 *            String
	 * @param esincapr
	 *            String
	 * @param esindemp
	 *            String
	 * @param esteco
	 *            String
	 * @param esinadar
	 *            String
	 * @param esfeadar
	 *            Date
	 * @param escoem
	 *            String
	 * @param esinempr
	 *            String
	 * @param esnrtel2
	 *            String
	 * @param esfeba
	 *            Date
	 * @param esnoap1
	 *            String
	 * @param esnoap2
	 *            String
	 * @param esnolo
	 *            String
	 * @param escomapv
	 *            String
	 * @param escoca
	 *            String
	 * @param esnopeco
	 *            String
	 * @param escoidco
	 *            String
	 * @param esinreco
	 *            String
	 * @param esfemod
	 *            String
	 * @param esinesco
	 *            String
	 * @param esnomu
	 *            String
	 * @param esnorep
	 *            String
	 * @param esnifrep
	 *            String
	 * @param dtteemr
	 *            String
	 * @param escarep
	 *            String
	 * @param esteurl
	 *            String
	 * @param escooe
	 *            String
	 * @param esnodeco
	 *            String
	 * @param esintiar
	 *            String
	 * @param esfeplad
	 *            Date
	 * @param esindeme
	 *            String
	 * @param esnoraPaisId
	 *            String
	 * @param esnoraPaisNombre
	 *            String
	 * @param esnoraProvinciaId
	 *            String
	 * @param esnombreProvincia
	 *            String
	 * @param esnoraMunicipioId
	 *            String
	 * @param esnombreMunicipio
	 *            String
	 * @param esnoraLocalidadId
	 *            String
	 * @param esnombreLocalidad
	 *            String
	 * @param esnoraCalleId
	 *            String
	 * @param esnombreCalle
	 *            String
	 * @param esnoraCpId
	 *            String
	 * @param esnombreCp
	 *            String
	 * @param esnoraPortalId
	 *            String
	 * @param esnombrePortal
	 *            String
	 * @param esnombrePiso
	 *            String
	 * @param esdireccion_nocapv
	 *            String
	 * @param esextranjero
	 *            String
	 * @param esestado
	 *            String
	 * @param essede
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/establecimientosAll", method = RequestMethod.GET)
	public @ResponseBody Object getAll(@RequestParam(value = "escodigo", required = false) String escodigo,
			@RequestParam(value = "censoMonitorMocodigo", required = false) String censoMonitorMocodigo,
			@RequestParam(value = "esnombre", required = false) String esnombre,
			@RequestParam(value = "esnif", required = false) String esnif,
			@RequestParam(value = "esnoan", required = false) String esnoan,
			@RequestParam(value = "esnoco", required = false) String esnoco,
			@RequestParam(value = "esnodir", required = false) String esnodir,
			@RequestParam(value = "escolo", required = false) String escolo,
			@RequestParam(value = "esnrcopo", required = false) String esnrcopo,
			@RequestParam(value = "esnrtel", required = false) String esnrtel,
			@RequestParam(value = "esnrfax", required = false) String esnrfax,
			@RequestParam(value = "escopa", required = false) String escopa,
			@RequestParam(value = "esincapr", required = false) String esincapr,
			@RequestParam(value = "esindemp", required = false) String esindemp,
			@RequestParam(value = "esteco", required = false) String esteco,
			@RequestParam(value = "esinadar", required = false) String esinadar,
			@RequestParam(value = "esfeadar", required = false) Date esfeadar,
			@RequestParam(value = "escoem", required = false) String escoem,
			@RequestParam(value = "esinempr", required = false) String esinempr,
			@RequestParam(value = "esnrtel2", required = false) String esnrtel2,
			@RequestParam(value = "esfeba", required = false) Date esfeba,
			@RequestParam(value = "esnoap1", required = false) String esnoap1,
			@RequestParam(value = "esnoap2", required = false) String esnoap2,
			@RequestParam(value = "esnolo", required = false) String esnolo,
			@RequestParam(value = "escomapv", required = false) String escomapv,
			@RequestParam(value = "escoca", required = false) String escoca,
			@RequestParam(value = "esnopeco", required = false) String esnopeco,
			@RequestParam(value = "escoidco", required = false) String escoidco,
			@RequestParam(value = "esinreco", required = false) String esinreco,
			@RequestParam(value = "esfemod", required = false) String esfemod,
			@RequestParam(value = "esinesco", required = false) String esinesco,
			@RequestParam(value = "esnomu", required = false) String esnomu,
			@RequestParam(value = "esnorep", required = false) String esnorep,
			@RequestParam(value = "esnifrep", required = false) String esnifrep,
			@RequestParam(value = "dtteemr", required = false) String dtteemr,
			@RequestParam(value = "escarep", required = false) String escarep,
			@RequestParam(value = "esteurl", required = false) String esteurl,
			@RequestParam(value = "escooe", required = false) String escooe,
			@RequestParam(value = "esnodeco", required = false) String esnodeco,
			@RequestParam(value = "esintiar", required = false) String esintiar,
			@RequestParam(value = "esfeplad", required = false) Date esfeplad,
			@RequestParam(value = "esindeme", required = false) String esindeme,
			@RequestParam(value = "esnoraPaisId", required = false) String esnoraPaisId,
			@RequestParam(value = "esnoraPaisNombre", required = false) String esnoraPaisNombre,
			@RequestParam(value = "esnoraProvinciaId", required = false) String esnoraProvinciaId,
			@RequestParam(value = "esnombreProvincia", required = false) String esnombreProvincia,
			@RequestParam(value = "esnoraMunicipioId", required = false) String esnoraMunicipioId,
			@RequestParam(value = "esnombreMunicipio", required = false) String esnombreMunicipio,
			@RequestParam(value = "esnoraLocalidadId", required = false) String esnoraLocalidadId,
			@RequestParam(value = "esnombreLocalidad", required = false) String esnombreLocalidad,
			@RequestParam(value = "esnoraCalleId", required = false) String esnoraCalleId,
			@RequestParam(value = "esnombreCalle", required = false) String esnombreCalle,
			@RequestParam(value = "esnoraCpId", required = false) String esnoraCpId,
			@RequestParam(value = "esnombreCp", required = false) String esnombreCp,
			@RequestParam(value = "esnoraPortalId", required = false) String esnoraPortalId,
			@RequestParam(value = "esnombrePortal", required = false) String esnombrePortal,
			@RequestParam(value = "esnombrePiso", required = false) String esnombrePiso,
			@RequestParam(value = "esdireccion_nocapv", required = false) String esdireccion_nocapv,
			@RequestParam(value = "esextranjero", required = false) String esextranjero,
			@RequestParam(value = "esestado", required = false) String esestado,
			@RequestParam(value = "essede", required = false) String essede, HttpServletRequest request) {
		try {
			Establecimiento filterEstablecimiento = new Establecimiento(escodigo, esnombre, null, esnif, esnoan, esnoco,
					esnodir, escolo, esnrcopo, esnrtel, esnrfax, escopa, esincapr, esindemp, esteco, esinadar, esfeadar,
					escoem, null, esinempr, esnrtel2, esfeba, esnoap1, esnoap2, esnolo, escomapv, escoca, esnopeco,
					escoidco, esinreco, esfemod, esinesco, esnomu, esnorep, esnifrep, dtteemr, escarep, esteurl, escooe,
					esnodeco, esintiar, esfeplad, esindeme, esnoraPaisId, esnoraPaisNombre, esnoraProvinciaId,
					esnombreProvincia, esnoraMunicipioId, esnombreMunicipio, esnoraLocalidadId, esnombreLocalidad,
					esnoraCalleId, esnombreCalle, esnoraCpId, esnombreCp, esnoraPortalId, esnombrePortal, esnombrePiso,
					esdireccion_nocapv, esextranjero, esestado, essede,
					new CensoMonitor(censoMonitorMocodigo, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Establecimiento> establecimientos = this.establecimientoService.findAll(filterEstablecimiento,
						pagination);

				if (establecimientos == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterEstablecimiento, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(establecimientos);
				return data;
			} else {
				List<Establecimiento> establecimientos = this.establecimientoService.findAll(filterEstablecimiento,
						pagination);
				if (establecimientos == null) {
					throw new Exception("No data Found.");
				}
				return establecimientos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllEstablecimiento'.
	 * 
	 * @param escodigo
	 *            String
	 * @param censoMonitorMocodigo
	 *            String
	 * @param esnombre_
	 *            String
	 * @param esnif_
	 *            String
	 * @param esnoan
	 *            String
	 * @param esnoco_
	 *            String
	 * @param esnodir
	 *            String
	 * @param escolo
	 *            String
	 * @param esnrcopo
	 *            String
	 * @param esnrtel
	 *            String
	 * @param esnrfax
	 *            String
	 * @param escopa
	 *            String
	 * @param esincapr
	 *            String
	 * @param esindemp_
	 *            String
	 * @param esteco
	 *            String
	 * @param esinadar_
	 *            String
	 * @param esfeadar
	 *            Date
	 * @param escoem
	 *            String
	 * @param esinempr
	 *            String
	 * @param esnrtel2
	 *            String
	 * @param esfeba
	 *            Date
	 * @param esnoap1
	 *            String
	 * @param esnoap2
	 *            String
	 * @param esnolo
	 *            String
	 * @param escomapv
	 *            String
	 * @param escoca
	 *            String
	 * @param esnopeco
	 *            String
	 * @param escoidco
	 *            String
	 * @param esinreco
	 *            String
	 * @param esfemod
	 *            String
	 * @param esinesco
	 *            String
	 * @param esnomu
	 *            String
	 * @param esnorep
	 *            String
	 * @param esnifrep
	 *            String
	 * @param dtteemr
	 *            String
	 * @param escarep
	 *            String
	 * @param esteurl
	 *            String
	 * @param escooe
	 *            String
	 * @param esnodeco
	 *            String
	 * @param esintiar
	 *            String
	 * @param esfeplad
	 *            Date
	 * @param esindeme
	 *            String
	 * @param esnoraPaisId_
	 *            String
	 * @param esnoraPaisNombre
	 *            String
	 * @param provinciaId_
	 *            String
	 * @param esnombreProvincia
	 *            String
	 * @param municipioId_
	 *            String
	 * @param esnombreMunicipio
	 *            String
	 * @param localidadId_
	 *            String
	 * @param esnombreLocalidad
	 *            String
	 * @param esnoraCalleId
	 *            String
	 * @param esnombreCalle
	 *            String
	 * @param esnoraCpId
	 *            String
	 * @param esnombreCp
	 *            String
	 * @param esnoraPortalId
	 *            String
	 * @param esnombrePortal
	 *            String
	 * @param esnombrePiso
	 *            String
	 * @param esdireccion_nocapv_
	 *            String
	 * @param esextranjero_
	 *            String
	 * @param esestado_
	 *            String
	 * @param esinfeba_
	 *            String
	 * @param sectorSecodigo_
	 *            String
	 * @param idsDescriptores_
	 *            String
	 * @param essede_
	 *            String
	 * @param ahnrdi_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busqueda", method = RequestMethod.GET)
	public @ResponseBody Object getAllEstablecimiento(
			@RequestParam(value = "escodigo", required = false) String escodigo,
			@RequestParam(value = "censoMonitorMocodigo", required = false) String censoMonitorMocodigo,
			@RequestParam(value = "esnombre", required = false) String esnombre_,
			@RequestParam(value = "esnif", required = false) String esnif_,
			@RequestParam(value = "esnoan", required = false) String esnoan,
			@RequestParam(value = "esnoco", required = false) String esnoco_,
			@RequestParam(value = "esnodir", required = false) String esnodir,
			@RequestParam(value = "escolo", required = false) String escolo,
			@RequestParam(value = "esnrcopo", required = false) String esnrcopo,
			@RequestParam(value = "esnrtel", required = false) String esnrtel_,
			@RequestParam(value = "esnrfax", required = false) String esnrfax,
			@RequestParam(value = "escopa", required = false) String escopa,
			@RequestParam(value = "esincapr", required = false) String esincapr,
			@RequestParam(value = "esindemp", required = false) String esindemp_,
			@RequestParam(value = "esteco", required = false) String esteco,
			@RequestParam(value = "esinadar", required = false) String esinadar_,
			@RequestParam(value = "esfeadar", required = false) Date esfeadar,
			@RequestParam(value = "escoem", required = false) String escoem_,
			@RequestParam(value = "esinempr", required = false) String esinempr,
			@RequestParam(value = "esnrtel2", required = false) String esnrtel2,
			@RequestParam(value = "esfeba", required = false) Date esfeba,
			@RequestParam(value = "esnoap1", required = false) String esnoap1,
			@RequestParam(value = "esnoap2", required = false) String esnoap2,
			@RequestParam(value = "esnolo", required = false) String esnolo,
			@RequestParam(value = "escomapv", required = false) String escomapv,
			@RequestParam(value = "escoca", required = false) String escoca,
			@RequestParam(value = "esnopeco", required = false) String esnopeco,
			@RequestParam(value = "escoidco", required = false) String escoidco,
			@RequestParam(value = "esinreco", required = false) String esinreco,
			@RequestParam(value = "esfemod", required = false) String esfemod,
			@RequestParam(value = "esinesco", required = false) String esinesco,
			@RequestParam(value = "esnomu", required = false) String esnomu,
			@RequestParam(value = "esnorep", required = false) String esnorep,
			@RequestParam(value = "esnifrep", required = false) String esnifrep,
			@RequestParam(value = "dtteemr", required = false) String dtteemr,
			@RequestParam(value = "escarep", required = false) String escarep,
			@RequestParam(value = "esteurl", required = false) String esteurl,
			@RequestParam(value = "escooe", required = false) String escooe,
			@RequestParam(value = "esnodeco", required = false) String esnodeco,
			@RequestParam(value = "esintiar", required = false) String esintiar,
			@RequestParam(value = "esfeplad", required = false) Date esfeplad,
			@RequestParam(value = "esindeme", required = false) String esindeme,
			@RequestParam(value = "esnoraPaisId", required = false) String esnoraPaisId_,
			@RequestParam(value = "esnoraPaisNombre", required = false) String esnoraPaisNombre,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "esnombreProvincia", required = false) String esnombreProvincia,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "esnombreMunicipio", required = false) String esnombreMunicipio,
			@RequestParam(value = "localidadId", required = false) String localidadId_,
			@RequestParam(value = "esnombreLocalidad", required = false) String esnombreLocalidad,
			@RequestParam(value = "esnoraCalleId", required = false) String esnoraCalleId_,
			@RequestParam(value = "esnombreCalle", required = false) String esnombreCalle,
			@RequestParam(value = "esnoraCpId", required = false) String esnoraCpId,
			@RequestParam(value = "esnombreCp", required = false) String esnombreCp,
			@RequestParam(value = "esnoraPortalId", required = false) String esnoraPortalId,
			@RequestParam(value = "esnombrePortal", required = false) String esnombrePortal,
			@RequestParam(value = "esnombrePiso", required = false) String esnombrePiso_,
			@RequestParam(value = "esdireccion_nocapv", required = false) String esdireccion_nocapv_,
			@RequestParam(value = "esextranjero", required = false) String esextranjero_,
			@RequestParam(value = "esestado", required = false) String esestado_,
			@RequestParam(value = "esinfeba", required = false) String esinfeba_,
			@RequestParam(value = "sectorSecodigo", required = false) String sectorSecodigo_,
			@RequestParam(value = "idsDescriptores", required = false) String idsDescriptores_,
			@RequestParam(value = "essede", required = false) String essede_,
			@RequestParam(value = "bajaAd", required = false) String bajaAd_,
			@RequestParam(value = "ahnrdi", required = false) String ahnrdi_,
			@RequestParam(value = "sinRenuncia", required = false) String sinRenuncia_, HttpServletRequest request) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro

			String esnombre = devuelveValorFiltro(esnombre_);

			String esnoco = devuelveValorFiltro(esnoco_);
			String esnif = devuelveValorFiltro(esnif_);
			String escoem = devuelveValorFiltro(escoem_);
			String esindemp = devuelveValorFiltro(esindemp_);

			String esinadar = devuelveValorFiltro(esinadar_);
			String esinfeba = devuelveValorFiltro(esinfeba_);
			String sectorSecodigo = devuelveValorFiltro(sectorSecodigo_);

			String idsDescriptores = devuelveValorFiltro(idsDescriptores_);
			String essede = devuelveValorFiltro(essede_);

			String esnrtel = devuelveValorFiltro(esnrtel_);
			String bajaAd = devuelveValorFiltro(bajaAd_);
			String esnoraCalleId = devuelveValorFiltro(esnoraCalleId_);

			String ahnrdi = devuelveValorFiltro(ahnrdi_);

			// 0150111
			String sinRenuncia = devuelveValorFiltro(sinRenuncia_);

			String esextranjero = "";
			String esestado = "";
			String provinciaId = "";
			String municipioId = "";
			String localidadId = "";
			String esnoraPaisId = "";
			String esdireccion_nocapv = "";

			String esnombrePiso = devuelveValorFiltro(esnombrePiso_);

			if (Y41bConstantes.NORA_LOCALIZACION_TODOS.equals(esextranjero_)) {
				esextranjero = null;
				esnoraPaisId = null;
				esestado = null;
				provinciaId = null;
				municipioId = null;
				localidadId = null;
				esdireccion_nocapv = null;
				esnombrePiso = null;
			} else if (Y41bConstantes.NORA_LOCALIZACION_EXTRANJERO.equals(esextranjero_)) {
				esextranjero = Y41bConstantes.VALOR_SI;
				esnoraPaisId = ("".equals(esnoraPaisId_)) ? null : esnoraPaisId_;
				esestado = null;
				provinciaId = null;
				municipioId = null;
				localidadId = null;
				esdireccion_nocapv = devuelveValorFiltro(esdireccion_nocapv_);
				esnombrePiso = null;
			} else {
				esextranjero = null;
				esnoraPaisId = null;
				esestado = Y41bConstantes.NORA_LOCALIZACION_ESTADO;
				provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
				municipioId = ("".equals(municipioId_)) ? null : municipioId_;
				localidadId = ("".equals(localidadId_)) ? null : localidadId_;
				esnombrePiso = devuelveValorFiltro(esnombrePiso_);
				esdireccion_nocapv = null;
			}

			Establecimiento filterEstablecimiento = new Establecimiento(escodigo, esnombre, null, esnif, esnoan, esnoco,
					esnodir, escolo, esnrcopo, esnrtel, esnrfax, escopa, esincapr, esindemp, esteco, esinadar, esfeadar,
					escoem, null, esinempr, esnrtel2, esfeba, esnoap1, esnoap2, esnolo, escomapv, escoca, esnopeco,
					escoidco, esinreco, esfemod, esinesco, esnomu, esnorep, esnifrep, dtteemr, escarep, esteurl, escooe,
					esnodeco, esintiar, esfeplad, esindeme, esnoraPaisId, esnoraPaisNombre, provinciaId,
					esnombreProvincia, municipioId, esnombreMunicipio, localidadId, esnombreLocalidad, esnoraCalleId,
					esnombreCalle, esnoraCpId, esnombreCp, esnoraPortalId, esnombrePortal, esnombrePiso,
					esdireccion_nocapv, esextranjero, esestado, essede,
					new CensoMonitor(censoMonitorMocodigo, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null));
			filterEstablecimiento.setEsinfeba(esinfeba);
			filterEstablecimiento.setBajaAd(bajaAd);
			filterEstablecimiento.setAhnrdi(ahnrdi);
			filterEstablecimiento.setSinRenuncia(sinRenuncia);

			List<Descriptor> descriptores = new ArrayList<Descriptor>();

			if (null != idsDescriptores && !"".equals(idsDescriptores)) {
				Descriptor descriptor = null;
				for (String id : idsDescriptores.split(",")) {
					descriptor = new Descriptor();
					descriptor.setIdDescriptor(id);
					descriptores.add(descriptor);
				}
			}
			filterEstablecimiento.setDescriptores(descriptores);

			EstablecimSector filterEstablecimSector = new EstablecimSector(null, null,
					new Establecimiento(null, null, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null),
					new Actividad(null, null, null, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null),
					new Sector(sectorSecodigo, null, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null));

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Establecimiento> establecimientos = this.establecimientoService
						.findAllLikeEstablecimiento(filterEstablecimiento, filterEstablecimSector, pagination, false);

				if (establecimientos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.establecimientoService.findAllLikeEstablecimientoCount(filterEstablecimiento,
						filterEstablecimSector, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(establecimientos);
				return data;
			} else {
				List<Establecimiento> establecimientos = this.establecimientoService
						.findAllLikeEstablecimiento(filterEstablecimiento, filterEstablecimSector, pagination, false);
				if (establecimientos == null) {
					throw new Exception("No data Found.");
				}
				return establecimientos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllEstablecimientoExcel'.
	 * 
	 * @param escodigo
	 *            String
	 * @param censoMonitorMocodigo
	 *            String
	 * @param esnombre_
	 *            String
	 * @param esnif_
	 *            String
	 * @param esnoan
	 *            String
	 * @param esnoco_
	 *            String
	 * @param esnodir
	 *            String
	 * @param escolo
	 *            String
	 * @param esnrcopo
	 *            String
	 * @param esnrtel
	 *            String
	 * @param esnrfax
	 *            String
	 * @param escopa
	 *            String
	 * @param esincapr
	 *            String
	 * @param esindemp_
	 *            String
	 * @param esteco
	 *            String
	 * @param esinadar_
	 *            String
	 * @param esfeadar
	 *            Date
	 * @param escoem
	 *            String
	 * @param esinempr
	 *            String
	 * @param esnrtel2
	 *            String
	 * @param esfeba
	 *            Date
	 * @param esnoap1
	 *            String
	 * @param esnoap2
	 *            String
	 * @param esnolo
	 *            String
	 * @param escomapv
	 *            String
	 * @param escoca
	 *            String
	 * @param esnopeco
	 *            String
	 * @param escoidco
	 *            String
	 * @param esinreco
	 *            String
	 * @param esfemod
	 *            String
	 * @param esinesco
	 *            String
	 * @param esnomu
	 *            String
	 * @param esnorep
	 *            String
	 * @param esnifrep
	 *            String
	 * @param dtteemr
	 *            String
	 * @param escarep
	 *            String
	 * @param esteurl
	 *            String
	 * @param escooe
	 *            String
	 * @param esnodeco
	 *            String
	 * @param esintiar
	 *            String
	 * @param esfeplad
	 *            Date
	 * @param esindeme
	 *            String
	 * @param esnoraPaisId_
	 *            String
	 * @param esnoraPaisNombre
	 *            String
	 * @param provinciaId_
	 *            String
	 * @param esnombreProvincia
	 *            String
	 * @param municipioId_
	 *            String
	 * @param esnombreMunicipio
	 *            String
	 * @param localidadId_
	 *            String
	 * @param esnombreLocalidad
	 *            String
	 * @param esnoraCalleId
	 *            String
	 * @param esnombreCalle
	 *            String
	 * @param esnoraCpId
	 *            String
	 * @param esnombreCp
	 *            String
	 * @param esnoraPortalId
	 *            String
	 * @param esnombrePortal
	 *            String
	 * @param esnombrePiso
	 *            String
	 * @param esdireccion_nocapv_
	 *            String
	 * @param esextranjero_
	 *            String
	 * @param esestado_
	 *            String
	 * @param esinfeba_
	 *            String
	 * @param sectorSecodigo_
	 *            String
	 * @param idsDescriptores_
	 *            String
	 * @param essede_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/excel", method = RequestMethod.GET)
	public void getAllEstablecimientoExcel(@RequestParam(value = "escodigo", required = false) String escodigo,
			@RequestParam(value = "censoMonitorMocodigo", required = false) String censoMonitorMocodigo,
			@RequestParam(value = "esnombre", required = false) String esnombre_,
			@RequestParam(value = "esnif", required = false) String esnif_,
			@RequestParam(value = "esnoan", required = false) String esnoan,
			@RequestParam(value = "esnoco", required = false) String esnoco_,
			@RequestParam(value = "esnodir", required = false) String esnodir,
			@RequestParam(value = "escolo", required = false) String escolo,
			@RequestParam(value = "esnrcopo", required = false) String esnrcopo,
			@RequestParam(value = "esnrtel", required = false) String esnrtel_,
			@RequestParam(value = "esnrfax", required = false) String esnrfax,
			@RequestParam(value = "escopa", required = false) String escopa,
			@RequestParam(value = "esincapr", required = false) String esincapr,
			@RequestParam(value = "esindemp", required = false) String esindemp_,
			@RequestParam(value = "esteco", required = false) String esteco,
			@RequestParam(value = "esinadar", required = false) String esinadar_,
			@RequestParam(value = "esfeadar", required = false) Date esfeadar,
			@RequestParam(value = "escoem", required = false) String escoem,
			@RequestParam(value = "esinempr", required = false) String esinempr,
			@RequestParam(value = "esnrtel2", required = false) String esnrtel2,
			@RequestParam(value = "esfeba", required = false) Date esfeba,
			@RequestParam(value = "esnoap1", required = false) String esnoap1,
			@RequestParam(value = "esnoap2", required = false) String esnoap2,
			@RequestParam(value = "esnolo", required = false) String esnolo,
			@RequestParam(value = "escomapv", required = false) String escomapv,
			@RequestParam(value = "escoca", required = false) String escoca,
			@RequestParam(value = "esnopeco", required = false) String esnopeco,
			@RequestParam(value = "escoidco", required = false) String escoidco,
			@RequestParam(value = "esinreco", required = false) String esinreco,
			@RequestParam(value = "esfemod", required = false) String esfemod,
			@RequestParam(value = "esinesco", required = false) String esinesco,
			@RequestParam(value = "esnomu", required = false) String esnomu,
			@RequestParam(value = "esnorep", required = false) String esnorep,
			@RequestParam(value = "esnifrep", required = false) String esnifrep,
			@RequestParam(value = "dtteemr", required = false) String dtteemr,
			@RequestParam(value = "escarep", required = false) String escarep,
			@RequestParam(value = "esteurl", required = false) String esteurl,
			@RequestParam(value = "escooe", required = false) String escooe,
			@RequestParam(value = "esnodeco", required = false) String esnodeco,
			@RequestParam(value = "esintiar", required = false) String esintiar,
			@RequestParam(value = "esfeplad", required = false) Date esfeplad,
			@RequestParam(value = "esindeme", required = false) String esindeme,
			@RequestParam(value = "esnoraPaisId", required = false) String esnoraPaisId_,
			@RequestParam(value = "esnoraPaisNombre", required = false) String esnoraPaisNombre,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "esnombreProvincia", required = false) String esnombreProvincia,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "esnombreMunicipio", required = false) String esnombreMunicipio,
			@RequestParam(value = "localidadId", required = false) String localidadId_,
			@RequestParam(value = "esnombreLocalidad", required = false) String esnombreLocalidad,
			@RequestParam(value = "esnoraCalleId", required = false) String esnoraCalleId,
			@RequestParam(value = "esnombreCalle", required = false) String esnombreCalle,
			@RequestParam(value = "esnoraCpId", required = false) String esnoraCpId,
			@RequestParam(value = "esnombreCp", required = false) String esnombreCp,
			@RequestParam(value = "esnoraPortalId", required = false) String esnoraPortalId,
			@RequestParam(value = "esnombrePortal", required = false) String esnombrePortal,
			@RequestParam(value = "esnombrePiso", required = false) String esnombrePiso_,
			@RequestParam(value = "esdireccion_nocapv", required = false) String esdireccion_nocapv_,
			@RequestParam(value = "esextranjero", required = false) String esextranjero_,
			@RequestParam(value = "esestado", required = false) String esestado_,
			@RequestParam(value = "esinfeba", required = false) String esinfeba_,
			@RequestParam(value = "sectorSecodigo", required = false) String sectorSecodigo_,
			@RequestParam(value = "idsDescriptores", required = false) String idsDescriptores_,
			@RequestParam(value = "essede", required = false) String essede_,
			@RequestParam(value = "bajaAd", required = false) String bajaAd_,
			@RequestParam(value = "sinRenuncia", required = false) String sinRenuncia_, HttpServletRequest request,
			HttpServletResponse response) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro

			String esnombre = devuelveValorFiltro(esnombre_);

			String esnoco = devuelveValorFiltro(esnoco_);
			String esnif = devuelveValorFiltro(esnif_);
			String esindemp = devuelveValorFiltro(esindemp_);

			String esinadar = devuelveValorFiltro(esinadar_);
			String esinfeba = devuelveValorFiltro(esinfeba_);
			String sectorSecodigo = devuelveValorFiltro(sectorSecodigo_);

			String idsDescriptores = devuelveValorFiltro(idsDescriptores_);
			String essede = devuelveValorFiltro(essede_);

			String esnrtel = devuelveValorFiltro(esnrtel_);
			String bajaAd = devuelveValorFiltro(bajaAd_);

			// 0150111
			String sinRenuncia = devuelveValorFiltro(sinRenuncia_);

			String esextranjero = "";
			String esestado = "";
			String provinciaId = "";
			String municipioId = "";
			String localidadId = "";
			String esnoraPaisId = "";
			String esdireccion_nocapv = "";

			String esnombrePiso = devuelveValorFiltro(esnombrePiso_);

			if (Y41bConstantes.NORA_LOCALIZACION_TODOS.equals(esextranjero_)) {
				esextranjero = null;
				esnoraPaisId = null;
				esestado = null;
				provinciaId = null;
				municipioId = null;
				localidadId = null;
				esdireccion_nocapv = null;
			} else if (Y41bConstantes.NORA_LOCALIZACION_EXTRANJERO.equals(esextranjero_)) {
				esextranjero = Y41bConstantes.VALOR_SI;
				esnoraPaisId = ("".equals(esnoraPaisId_)) ? null : esnoraPaisId_;
				esestado = null;
				provinciaId = null;
				municipioId = null;
				localidadId = null;
				esdireccion_nocapv = devuelveValorFiltro(esdireccion_nocapv_);
			} else {
				esextranjero = null;
				esnoraPaisId = null;
				esestado = Y41bConstantes.NORA_LOCALIZACION_ESTADO;
				provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
				municipioId = ("".equals(municipioId_)) ? null : municipioId_;
				localidadId = ("".equals(localidadId_)) ? null : localidadId_;
				esdireccion_nocapv = null;
			}

			Establecimiento filterEstablecimiento = new Establecimiento(escodigo, esnombre, null, esnif, esnoan, esnoco,
					esnodir, escolo, esnrcopo, esnrtel, esnrfax, escopa, esincapr, esindemp, esteco, esinadar, esfeadar,
					escoem, null, esinempr, esnrtel2, esfeba, esnoap1, esnoap2, esnolo, escomapv, escoca, esnopeco,
					escoidco, esinreco, esfemod, esinesco, esnomu, esnorep, esnifrep, dtteemr, escarep, esteurl, escooe,
					esnodeco, esintiar, esfeplad, esindeme, esnoraPaisId, esnoraPaisNombre, provinciaId,
					esnombreProvincia, municipioId, esnombreMunicipio, localidadId, esnombreLocalidad, esnoraCalleId,
					esnombreCalle, esnoraCpId, esnombreCp, esnoraPortalId, esnombrePortal, esnombrePiso,
					esdireccion_nocapv, esextranjero, esestado, essede,
					new CensoMonitor(censoMonitorMocodigo, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null));
			filterEstablecimiento.setEsinfeba(esinfeba);
			filterEstablecimiento.setBajaAd(bajaAd);

			filterEstablecimiento.setSinRenuncia(sinRenuncia);

			List<Descriptor> descriptores = new ArrayList<Descriptor>();

			if (null != idsDescriptores && !"".equals(idsDescriptores)) {
				Descriptor descriptor = null;
				for (String id : idsDescriptores.split(",")) {
					descriptor = new Descriptor();
					descriptor.setIdDescriptor(id);
					descriptores.add(descriptor);
				}
			}
			filterEstablecimiento.setDescriptores(descriptores);

			EstablecimSector filterEstablecimSector = new EstablecimSector(null, null,
					new Establecimiento(null, null, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null),
					new Actividad(null, null, null, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null),
					new Sector(sectorSecodigo, null, null, null, null, null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null));

			Date fechaHoy = new Date();
			String fechaActual = Y41bUtils.formatearDateToString(fechaHoy, "yyyyMMddHHmmss");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			// response.setContentType("text/html");
			// response.setHeader("Content-type: application/octet-stream");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41bConstantes.EXCEL_BUSQUEDA_ESTABLECIMIENTOS + fechaActual + ".xls";
			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(nombre) + "\"");

			String xslString = this.y41bExcelGeneratorService.getEstablecimientosExcelExtendido(filterEstablecimiento,
					filterEstablecimSector);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterEstablecimiento
	 *            Establecimiento
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody Long getAllCount(
			@RequestParam(value = "establecimiento", required = false) Establecimiento filterEstablecimiento,
			HttpServletRequest request) {
		try {
			return establecimientoService
					.findAllCount(filterEstablecimiento != null ? filterEstablecimiento : new Establecimiento());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param response
	 *            HttpServletResponse
	 * @return Establecimiento
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody Establecimiento edit(@RequestBody Establecimiento establecimiento,
			HttpServletResponse response) {
		try {
			Establecimiento establecimientoAux = this.establecimientoService.update(establecimiento);
			logger.info("Entity correctly inserted!");
			return establecimientoAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'updateEstablecimiento'.
	 * 
	 * @param establecimientoDetalle
	 *            EstablecimientoDetalle
	 * @param establecimientoAux
	 *            Establecimiento
	 * @param sedeAux
	 *            Sede
	 * @param request
	 *            HttpServletRequest
	 * @return Establecimiento
	 */
	@RequestMapping(value = "/modificacionDetalle", method = RequestMethod.PUT)
	public @ResponseBody Establecimiento updateEstablecimiento(
			@RequestBody EstablecimientoDetalle establecimientoDetalle,
			@ModelAttribute(value = "establecimiento") Establecimiento establecimientoAux,
			@ModelAttribute(value = "sede") Sede sedeAux, HttpServletRequest request) {
		try {

			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			if (establecimientoDetalle.getEscodigo() == null || establecimientoDetalle.getEscodigo().equals("")) {
				establecimientoDetalle.setEscodigo(establecimientoAux.getEscodigo());
			}

			Establecimiento estableci;

			// control checks
			if ("on".equals(establecimientoDetalle.getEssede())) {
				establecimientoDetalle.setEssede(Y41bConstantes.VALOR_SI);
			} else {
				establecimientoDetalle.setEssede(Y41bConstantes.VALOR_NO);
			}

			// estado
			if ((establecimientoDetalle.getEsextranjero()).equalsIgnoreCase(Y41bConstantes.NO)) {

				estableci = new Establecimiento(establecimientoDetalle.getEscodigo(),
						establecimientoDetalle.getEsnombre(), establecimientoDetalle.getEstipid(),
						establecimientoDetalle.getEsnif(), establecimientoDetalle.getEsnoan(),
						establecimientoDetalle.getEsnoco(), establecimientoDetalle.getEsnodir(), "0",
						establecimientoDetalle.getEsnrcopo(), establecimientoDetalle.getEsnrtel(),
						establecimientoDetalle.getEsnrfax(), establecimientoDetalle.getEscopa(),
						establecimientoDetalle.getEsincapr(), establecimientoDetalle.getEsindemp(),
						establecimientoDetalle.getEsteco(), establecimientoDetalle.getEsinadar(),
						establecimientoDetalle.getEsfeadar(), establecimientoDetalle.getEscoem(),
						establecimientoDetalle.getEsmailnotificacion(), establecimientoDetalle.getEsinempr(),
						establecimientoDetalle.getEsnrtel2(), establecimientoDetalle.getEsfeba(),
						establecimientoDetalle.getEsnoap1(), establecimientoDetalle.getEsnoap2(),
						establecimientoDetalle.getEsnolo(), establecimientoDetalle.getEscomapv(),
						establecimientoDetalle.getEscoca(), establecimientoDetalle.getEsnopeco(),
						establecimientoDetalle.getEscoidco(), establecimientoDetalle.getEsinreco(),
						Y41bUtils.parseDateToString(new Date(), Y41bConstantes.CASTELLANO),
						establecimientoDetalle.getEsinesco(), establecimientoDetalle.getEsnomu(),
						establecimientoDetalle.getEsnorep(), establecimientoDetalle.getEsnifrep(),
						establecimientoDetalle.getDtteemr(), establecimientoDetalle.getEscarep(),
						establecimientoDetalle.getEsteurl(), establecimientoDetalle.getEscooe(),
						establecimientoDetalle.getEsnodeco(), establecimientoDetalle.getEsintiar(),
						establecimientoDetalle.getEsfeplad(), establecimientoDetalle.getEsindeme(), null, null,
						establecimientoDetalle.getProvinciaId(), establecimientoDetalle.getEsnombreProvincia(),
						establecimientoDetalle.getMunicipioId(), establecimientoDetalle.getEsnombreMunicipio(),
						establecimientoDetalle.getLocalidadId(), establecimientoDetalle.getEsnombreLocalidad(),
						establecimientoDetalle.getCalleId(), establecimientoDetalle.getCalleId_label(),
						establecimientoDetalle.getCpId(), establecimientoDetalle.getEsnombreCp(),
						establecimientoDetalle.getPortalId(), establecimientoDetalle.getEsnombrePortal(),
						establecimientoDetalle.getEsnombrePiso(), establecimientoDetalle.getEsdireccion_nocapv(),
						establecimientoDetalle.getEsextranjero(), null, establecimientoDetalle.getEssede(),
						censoMonitor);
				estableci.setEsfeerd(establecimientoDetalle.getEsfeerd());
				if (establecimientoDetalle.getProvinciaId().equals(Y41bConstantes.CODIGO_PROVINCIA_ARABA)
						|| establecimientoDetalle.getProvinciaId().equals(Y41bConstantes.CODIGO_PROVINCIA_GIPUZKOA)
						|| establecimientoDetalle.getProvinciaId().equals(Y41bConstantes.CODIGO_PROVINCIA_BIZKAIA)) {
					estableci.setEsdireccion_nocapv(null);
				} else {
					estableci.setEsnombreCalle(null);
					estableci.setEsnoraCalleId(null);
				}
			} else {
				// extranjero
				estableci = new Establecimiento(establecimientoDetalle.getEscodigo(),
						establecimientoDetalle.getEsnombre(), establecimientoDetalle.getEstipid(),
						establecimientoDetalle.getEsnif(), establecimientoDetalle.getEsnoan(),
						establecimientoDetalle.getEsnoco(), establecimientoDetalle.getEsnodir(), "0",
						establecimientoDetalle.getEsnrcopo(), establecimientoDetalle.getEsnrtel(),
						establecimientoDetalle.getEsnrfax(), establecimientoDetalle.getEscopa(),
						establecimientoDetalle.getEsincapr(), establecimientoDetalle.getEsindemp(),
						establecimientoDetalle.getEsteco(), establecimientoDetalle.getEsinadar(),
						establecimientoDetalle.getEsfeadar(), establecimientoDetalle.getEscoem(),
						establecimientoDetalle.getEsmailnotificacion(), establecimientoDetalle.getEsinempr(),
						establecimientoDetalle.getEsnrtel2(), establecimientoDetalle.getEsfeba(),
						establecimientoDetalle.getEsnoap1(), establecimientoDetalle.getEsnoap2(),
						establecimientoDetalle.getEsnolo(), establecimientoDetalle.getEscomapv(),
						establecimientoDetalle.getEscoca(), establecimientoDetalle.getEsnopeco(),
						establecimientoDetalle.getEscoidco(), establecimientoDetalle.getEsinreco(),
						Y41bUtils.parseDateToString(new Date(), Y41bConstantes.CASTELLANO),
						establecimientoDetalle.getEsinesco(), establecimientoDetalle.getEsnomu(),
						establecimientoDetalle.getEsnorep(), establecimientoDetalle.getEsnifrep(),
						establecimientoDetalle.getDtteemr(), establecimientoDetalle.getEscarep(),
						establecimientoDetalle.getEsteurl(), establecimientoDetalle.getEscooe(),
						establecimientoDetalle.getEsnodeco(), establecimientoDetalle.getEsintiar(),
						establecimientoDetalle.getEsfeplad(), establecimientoDetalle.getEsindeme(),
						establecimientoDetalle.getEsnoraPaisId(), establecimientoDetalle.getEsnoraPaisNombre(), null,
						null, null, null, null, null, null, null, establecimientoDetalle.getCpId(),
						establecimientoDetalle.getEsnombreCp(), null, null, null,
						establecimientoDetalle.getEsdireccion_nocapv(), establecimientoDetalle.getEsextranjero(), null,
						establecimientoDetalle.getEssede(), censoMonitor);
				estableci.setEsfeerd(establecimientoDetalle.getEsfeerd());
			}

			estableci.setEsilocalizable(establecimientoDetalle.getEsilocalizable());
			estableci.setEsnocolabora(establecimientoDetalle.getEsnocolabora());

			EstablecimArbitra establecimArbitra = new EstablecimArbitra();
			establecimArbitra.setAhcodigo(establecimientoDetalle.getAhcodigo());
			establecimArbitra.setEstablecimiento(estableci);
			if (establecimientoDetalle.getAhfere() != null) {
				establecimArbitra
						.setAhfeba(Y41bUtils.addDays(establecimientoDetalle.getAhfere(), Y41bConstantes.NUM_30));
			}
			establecimArbitra.setAhfere(establecimientoDetalle.getAhfere());
			establecimArbitra.setAhcoja(establecimientoDetalle.getAhcoja());
			establecimArbitra.setAhtelimi(establecimientoDetalle.getAhtelimi());
			establecimArbitra.setAhmedia(establecimientoDetalle.getAhmedia());

			estableci.setSedes(establecimientoDetalle.getSedes());
			estableci.setIdsDescriptores(establecimientoDetalle.getIdsDescriptores());

			String idsDescriptores = establecimientoDetalle.getIdsDescriptores();

			List<Descriptor> descriptores = new ArrayList<Descriptor>();

			if (null != idsDescriptores && !"".equals(idsDescriptores)) {
				Descriptor descriptor = null;
				for (String id : idsDescriptores.split(",")) {
					descriptor = new Descriptor();
					descriptor.setIdDescriptor(id);
					descriptores.add(descriptor);
				}
			}
			estableci.setDescriptores(descriptores);

			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(establecimientoDetalle.getEscodigo());

			Sector sector = new Sector();
			sector.setSecodigo(establecimientoDetalle.getSecodigo());

			Actividad actividad = new Actividad();
			String avCodigo = "";

			if (sector.getSecodigo().length() >= 3) {
				avCodigo = sector.getSecodigo().substring(0, 3);
			}
			actividad.setAvcodigo(avCodigo);

			EstablecimSector establecimSector = new EstablecimSector(establecimientoDetalle.getEacodigo(),
					// establecimientoDetalle.getEainprse(),
					Y41bConstantes.ACTIVIDAD_SECTOR_INDICADOR, establecimiento, actividad, sector);

			estableci.setEsCanalPrioritario(establecimientoDetalle.getEsCanalPrioritario());

			this.establecimientoService.updateEstablecimiento(estableci, establecimArbitra, establecimSector, sedeAux,
					censoMonitor);

			logger.info("Entity correctly inserted!");
			return estableci;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Establecimiento
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Establecimiento add(@RequestBody Establecimiento establecimiento) {
		try {

			Establecimiento establecimientoAux = this.establecimientoService.add(establecimiento);
			logger.info("Entity correctly inserted!");
			return establecimientoAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'addEstablecimiento'.
	 * 
	 * @param establecimientoDetalle
	 *            Establecimiento
	 * @param establecimientoAux
	 *            Establecimiento
	 * @param sedeAux
	 *            Sede
	 * @param request
	 *            HttpServletRequest
	 * @return Establecimiento
	 */
	@RequestMapping(value = "/altaDetalle", method = RequestMethod.POST)
	public @ResponseBody Establecimiento addEstablecimiento(@RequestBody EstablecimientoDetalle establecimientoDetalle,
			@ModelAttribute(value = "establecimiento") Establecimiento establecimientoAux,
			@ModelAttribute(value = "sede") Sede sedeAux, HttpServletRequest request) {
		try {

			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

			if (establecimientoDetalle.getEscodigo() == null || establecimientoDetalle.getEscodigo().equals("")) {
				establecimientoDetalle.setEscodigo(establecimientoAux.getEscodigo());
			}

			Establecimiento estableci;

			// control checks
			if ("on".equals(establecimientoDetalle.getEssede())) {
				establecimientoDetalle.setEssede(Y41bConstantes.VALOR_SI);
			} else {
				establecimientoDetalle.setEssede(Y41bConstantes.VALOR_NO);
			}

			// estado
			if ((establecimientoDetalle.getEsextranjero()).equalsIgnoreCase(Y41bConstantes.NO)) {

				estableci = new Establecimiento(establecimientoDetalle.getEscodigo(),
						establecimientoDetalle.getEsnombre(), establecimientoDetalle.getEstipid(),
						establecimientoDetalle.getEsnif(), establecimientoDetalle.getEsnoan(),
						establecimientoDetalle.getEsnoco(), establecimientoDetalle.getEsnodir(), "0",
						establecimientoDetalle.getEsnrcopo(), establecimientoDetalle.getEsnrtel(),
						establecimientoDetalle.getEsnrfax(), establecimientoDetalle.getEscopa(),
						establecimientoDetalle.getEsincapr(), establecimientoDetalle.getEsindemp(),
						establecimientoDetalle.getEsteco(), establecimientoDetalle.getEsinadar(),
						establecimientoDetalle.getEsfeadar(), establecimientoDetalle.getEscoem(),
						establecimientoDetalle.getEsmailnotificacion(), establecimientoDetalle.getEsinempr(),
						establecimientoDetalle.getEsnrtel2(), establecimientoDetalle.getEsfeba(),
						establecimientoDetalle.getEsnoap1(), establecimientoDetalle.getEsnoap2(),
						establecimientoDetalle.getEsnolo(), establecimientoDetalle.getEscomapv(),
						establecimientoDetalle.getEscoca(), establecimientoDetalle.getEsnopeco(),
						establecimientoDetalle.getEscoidco(), establecimientoDetalle.getEsinreco(),
						Y41bUtils.parseDateToString(new Date(), Y41bConstantes.CASTELLANO),
						establecimientoDetalle.getEsinesco(), establecimientoDetalle.getEsnomu(),
						establecimientoDetalle.getEsnorep(), establecimientoDetalle.getEsnifrep(),
						establecimientoDetalle.getDtteemr(), establecimientoDetalle.getEscarep(),
						establecimientoDetalle.getEsteurl(), establecimientoDetalle.getEscooe(),
						establecimientoDetalle.getEsnodeco(), establecimientoDetalle.getEsintiar(),
						establecimientoDetalle.getEsfeplad(), establecimientoDetalle.getEsindeme(), null, null,
						establecimientoDetalle.getProvinciaId(), establecimientoDetalle.getEsnombreProvincia(),
						establecimientoDetalle.getMunicipioId(), establecimientoDetalle.getEsnombreMunicipio(),
						establecimientoDetalle.getLocalidadId(), establecimientoDetalle.getEsnombreLocalidad(),
						establecimientoDetalle.getCalleId(), establecimientoDetalle.getCalleId_label(),
						establecimientoDetalle.getCpId(), establecimientoDetalle.getEsnombreCp(),
						establecimientoDetalle.getPortalId(), establecimientoDetalle.getEsnombrePortal(),
						establecimientoDetalle.getEsnombrePiso(), establecimientoDetalle.getEsdireccion_nocapv(),
						establecimientoDetalle.getEsextranjero(), null, establecimientoDetalle.getEssede(),
						censoMonitor);
				estableci.setEsfeerd(establecimientoDetalle.getEsfeerd());
			} else {
				// extranjero
				estableci = new Establecimiento(establecimientoDetalle.getEscodigo(),
						establecimientoDetalle.getEsnombre(), establecimientoDetalle.getEstipid(),
						establecimientoDetalle.getEsnif(), establecimientoDetalle.getEsnoan(),
						establecimientoDetalle.getEsnoco(), establecimientoDetalle.getEsnodir(), "0",
						establecimientoDetalle.getEsnrcopo(), establecimientoDetalle.getEsnrtel(),
						establecimientoDetalle.getEsnrfax(), establecimientoDetalle.getEscopa(),
						establecimientoDetalle.getEsincapr(), establecimientoDetalle.getEsindemp(),
						establecimientoDetalle.getEsteco(), establecimientoDetalle.getEsinadar(),
						establecimientoDetalle.getEsfeadar(), establecimientoDetalle.getEscoem(),
						establecimientoDetalle.getEsmailnotificacion(), establecimientoDetalle.getEsinempr(),
						establecimientoDetalle.getEsnrtel2(), establecimientoDetalle.getEsfeba(),
						establecimientoDetalle.getEsnoap1(), establecimientoDetalle.getEsnoap2(),
						establecimientoDetalle.getEsnolo(), establecimientoDetalle.getEscomapv(),
						establecimientoDetalle.getEscoca(), establecimientoDetalle.getEsnopeco(),
						establecimientoDetalle.getEscoidco(), establecimientoDetalle.getEsinreco(),
						Y41bUtils.parseDateToString(new Date(), Y41bConstantes.CASTELLANO),
						establecimientoDetalle.getEsinesco(), establecimientoDetalle.getEsnomu(),
						establecimientoDetalle.getEsnorep(), establecimientoDetalle.getEsnifrep(),
						establecimientoDetalle.getDtteemr(), establecimientoDetalle.getEscarep(),
						establecimientoDetalle.getEsteurl(), establecimientoDetalle.getEscooe(),
						establecimientoDetalle.getEsnodeco(), establecimientoDetalle.getEsintiar(),
						establecimientoDetalle.getEsfeplad(), establecimientoDetalle.getEsindeme(),
						establecimientoDetalle.getEsnoraPaisId(), establecimientoDetalle.getEsnoraPaisNombre(), null,
						null, null, null, null, null, null, null, establecimientoDetalle.getCpId(),
						establecimientoDetalle.getEsnombreCp(), null, null, null,
						establecimientoDetalle.getEsdireccion_nocapv(), establecimientoDetalle.getEsextranjero(), null,
						establecimientoDetalle.getEssede(), censoMonitor);
				estableci.setEsfeerd(establecimientoDetalle.getEsfeerd());
			}

			EstablecimArbitra establecimArbitra = new EstablecimArbitra();
			if (establecimientoDetalle.getAhfere() != null) {
				establecimArbitra
						.setAhfeba(Y41bUtils.addDays(establecimientoDetalle.getAhfere(), Y41bConstantes.NUM_30));
			}
			establecimArbitra.setAhfere(establecimientoDetalle.getAhfere());
			establecimArbitra.setAhcoja(establecimientoDetalle.getAhcoja());
			establecimArbitra.setAhtelimi(establecimientoDetalle.getAhtelimi());
			establecimArbitra.setAhmedia(establecimientoDetalle.getAhmedia());

			estableci.setSedes(establecimientoDetalle.getSedes());
			estableci.setIdsDescriptores(establecimientoDetalle.getIdsDescriptores());

			String idsDescriptores = establecimientoDetalle.getIdsDescriptores();

			List<Descriptor> descriptores = new ArrayList<Descriptor>();

			if (null != idsDescriptores && !"".equals(idsDescriptores)) {
				Descriptor descriptor = null;
				for (String id : idsDescriptores.split(",")) {
					descriptor = new Descriptor();
					descriptor.setIdDescriptor(id);
					descriptores.add(descriptor);
				}
			}
			estableci.setDescriptores(descriptores);

			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(establecimientoDetalle.getEscodigo());

			Sector sector = new Sector();
			sector.setSecodigo(establecimientoDetalle.getSecodigo());

			Actividad actividad = new Actividad();
			String avCodigo = "";

			if (sector.getSecodigo().length() >= 3) {
				avCodigo = sector.getSecodigo().substring(0, 3);
			}
			actividad.setAvcodigo(avCodigo);

			EstablecimSector establecimSector = new EstablecimSector(establecimientoDetalle.getEacodigo(),
					// establecimientoDetalle.getEainprse(),
					Y41bConstantes.ACTIVIDAD_SECTOR_INDICADOR, establecimiento, actividad, sector);

			estableci.setEsCanalPrioritario(establecimientoDetalle.getEsCanalPrioritario());

			estableci = this.establecimientoService.addEstablecimiento(estableci, establecimArbitra, establecimSector,
					sedeAux, censoMonitor);

			logger.info("Entity correctly inserted!");
			return estableci;
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param escodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{escodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String escodigo, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(new String(Y41bUtilsDokusi.decode(escodigo)));
			this.establecimientoService.remove(establecimiento);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + escodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param escodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "removeEstablecimiento/{escodigo}", method = RequestMethod.DELETE)
	public void removeEstablecimiento(@PathVariable String escodigo, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {

			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(new String(Y41bUtilsDokusi.decode(escodigo)));

			EstablecimSector establecimSector = new EstablecimSector();

			establecimSector.setEstablecimiento(establecimiento);

			this.establecimientoService.removeEstablecimiento(establecimiento, establecimSector);

			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			logger.error("Unable to delete " + escodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param establecimientoIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody ArrayList<ArrayList<String>> establecimientoIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Establecimiento> establecimientoList = new ArrayList<Establecimiento>();
		try {
			for (ArrayList<String> establecimientoId : establecimientoIds) {
				Iterator<String> iterator = establecimientoId.iterator();
				Establecimiento establecimiento = new Establecimiento();
				establecimiento.setEscodigo(ObjectConversionManager.convert(iterator.next(), String.class));
				establecimientoList.add(establecimiento);
			}
			this.establecimientoService.removeMultiple(establecimientoList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'fusionarEstablecimiento'.
	 * 
	 * @param establecimientoIdBueno
	 * 
	 * @param establecimientoIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/fusionarEstablecimiento", method = RequestMethod.POST)
	public void fusionarEstablecimiento(@RequestParam(value = "escodigo", required = true) String escodigo,
			@RequestBody ArrayList<String> establecimientoIds, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");

		ArrayList<Establecimiento> establecimientoList = new ArrayList<Establecimiento>();
		try {

			for (String establecimientoId : establecimientoIds) {
				Establecimiento establecimiento = new Establecimiento();
				establecimiento.setEscodigo(establecimientoId);
				establecimientoList.add(establecimiento);
			}

			Establecimiento establecimientoCodigo = new Establecimiento();
			establecimientoCodigo.setEscodigo(escodigo);

			this.establecimientoService.fusionEstablecimientos(establecimientoCodigo, establecimientoList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			e.printStackTrace();
			logger.error(e.getMessage());
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException(e.getMessage());
		}
	}

	/**
	 * Method 'getReclamacionesAnyo'.
	 * 
	 * @param escodigo
	 *            String
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */

	@RequestMapping(value = "/reclamacionesAnyo", method = RequestMethod.GET)
	public @ResponseBody Object getReclamacionesAnyo(@RequestParam(value = "escodigo", required = true) String escodigo,
			HttpServletRequest request) {
		try {
			Establecimiento filterEstablecimiento = new Establecimiento();

			// filterEstablecimiento.setEscodigo(new
			// String(Y41bUtilsDokusi.decode(escodigo)));
			filterEstablecimiento.setEscodigo(escodigo);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<EstablecimientoReclamacionesAnyo> establecimientoReclamacionesAnyo = this.establecimientoService
						.findAllEstablecimientoReclamacionesAnyo(filterEstablecimiento, pagination);

				if (establecimientoReclamacionesAnyo == null) {
					throw new Exception("No data Found.");
				}

				// Long total = getAllCountReclamaciones(filterEstablecimiento,
				// request);
				Long total = this.establecimientoService
						.findAllEstablecimientoReclamacionesAnyoCount(filterEstablecimiento);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(establecimientoReclamacionesAnyo);
				return data;
			} else {
				List<EstablecimientoReclamacionesAnyo> establecimientoReclamacionesAnyo = this.establecimientoService
						.findAllEstablecimientoReclamacionesAnyo(filterEstablecimiento, pagination);
				if (establecimientoReclamacionesAnyo == null) {
					throw new Exception("No data Found.");
				}
				return establecimientoReclamacionesAnyo;
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCountReclamaciones'.
	 * 
	 * @param filterEstablecimiento
	 *            Establecimiento
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/countReclamaciones", method = RequestMethod.GET)
	public @ResponseBody Long getAllCountReclamaciones(
			@RequestParam(value = "establecimiento", required = false) Establecimiento filterEstablecimiento,
			HttpServletRequest request) {
		try {
			return establecimientoService.findAllEstablecimientoReclamacionesAnyoCount(
					filterEstablecimiento != null ? filterEstablecimiento : new Establecimiento());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}

	/**
	 * Method 'getDecisionesAnyo'.
	 * 
	 * @param escodigo
	 *            String
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */

	@RequestMapping(value = "/decisionesAnyo", method = RequestMethod.GET)
	public @ResponseBody Object getDecisionesAnyo(@RequestParam(value = "escodigo", required = true) String escodigo,
			HttpServletRequest request) {
		try {
			Establecimiento filterEstablecimiento = new Establecimiento();

			// filterEstablecimiento.setEscodigo(new
			// String(Y41bUtilsDokusi.decode(escodigo)));
			filterEstablecimiento.setEscodigo(escodigo);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<EstablecimientoDecisionAnyo> establecimientoDecisionAnyo = this.establecimientoService
						.findAllEstablecimientoDecisionAnyo(filterEstablecimiento, pagination);

				if (establecimientoDecisionAnyo == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCountDecision(filterEstablecimiento, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(establecimientoDecisionAnyo);
				return data;
			} else {
				List<EstablecimientoDecisionAnyo> establecimientoDecisionAnyo = this.establecimientoService
						.findAllEstablecimientoDecisionAnyo(filterEstablecimiento, pagination);
				if (establecimientoDecisionAnyo == null) {
					throw new Exception("No data Found.");
				}
				return establecimientoDecisionAnyo;
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCountDecision'.
	 * 
	 * @param filterEstablecimiento
	 *            Establecimiento
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/countDecision", method = RequestMethod.GET)
	public @ResponseBody Long getAllCountDecision(
			@RequestParam(value = "establecimiento", required = false) Establecimiento filterEstablecimiento,
			HttpServletRequest request) {
		try {
			return establecimientoService.findAllEstablecimientoDecisionAnyoCount(
					filterEstablecimiento != null ? filterEstablecimiento : new Establecimiento());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getEstablecimientoService'.
	 * 
	 * @return EstablecimientoService
	 */
	protected EstablecimientoService getEstablecimientoService() {
		return this.establecimientoService;
	}

	/**
	 * Method 'setEstablecimientoService'.
	 * 
	 * @param establecimientoService
	 *            EstablecimientoService
	 * @return
	 */
	public void setEstablecimientoService(EstablecimientoService establecimientoService) {
		this.establecimientoService = establecimientoService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * 
	 * @param cadena
	 *            cadena
	 * @return valor o ""
	 */
	private static String devuelveValorFiltro(String cadena) {
		if (null != cadena && !"".equalsIgnoreCase(cadena)) {
			return cadena;
		} else {
			return null;
		}
	}

	/**
	 * Method 'comprobarMismoCifYSede'.
	 * 
	 * @param esnif
	 *            String
	 * @param escodigo
	 *            String
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */

	@RequestMapping(value = "/comprobarMismoCifYSede/{esnif}/{escodigo}", method = RequestMethod.GET)
	public @ResponseBody Object comprobarMismoCifYSede(@PathVariable String esnif, @PathVariable String escodigo,
			HttpServletRequest request) {
		try {

			Boolean existeSede = false;

			Establecimiento establecimientoAux = new Establecimiento();
			establecimientoAux.setEsnif(esnif);

			List<Establecimiento> listEstablecimiento = this.establecimientoService
					.findAllLikeEstablecimiento(establecimientoAux, null, null, false);

			if (listEstablecimiento.size() > 0) {
				for (Establecimiento estaAux : listEstablecimiento) {
					if (estaAux.getEssede() != null && estaAux.getEssede().equals(Y41bConstantes.SI)) {
						if (estaAux.getEscodigo().equals(new String(Y41bUtilsDokusi.decode(escodigo)))) {
							existeSede = false;
						} else {
							existeSede = true;
						}
						break;
					}
				}
			}

			return existeSede.toString();

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'obtenerSede'.
	 * 
	 * Obtiene el establecimiento sede a partir de un cif de establecimiento
	 * 
	 * @param esnif
	 *            String
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */

	@RequestMapping(value = "/obtenerSede/{esnif}", method = RequestMethod.GET)
	public @ResponseBody Establecimiento obtenerSede(@PathVariable String esnif, HttpServletRequest request) {
		try {

			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEsnif(esnif);

			establecimiento = this.establecimientoService.obtenerEstablecimientoSede(establecimiento);

			if (establecimiento == null) {
				throw new Exception("No data Found. /obtenerSede/{esnif}");
			} else {
				return establecimiento;
			}

		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'obtenerDatosSede'.
	 * 
	 * Obtiene los datos de la sede a partir de un cif de establecimiento
	 * 
	 * @param esnif
	 *            String
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */

	@RequestMapping(value = "/obtenerDatosSede/{esnif}", method = RequestMethod.GET)
	public @ResponseBody Object obtenerDatosSede(@PathVariable String esnif, HttpServletRequest request) {
		try {
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEsnif(esnif);

			List<Sede> listSede = this.establecimientoService.findAllEstablecimientoAnteriorSedes(establecimiento);

			return listSede;

		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'obtenerDireccionSede'.
	 * 
	 * Obtiene el establecimiento sede a partir de su codigo de establecimiento
	 * , con direccion completa
	 * 
	 * @param escodigo
	 *            String
	 * @param pcodigo
	 *            String
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */

	@RequestMapping(value = "/obtenerDireccionSede/{escodigo}/{pcodigo}", method = RequestMethod.GET)
	public @ResponseBody Sede obtenerDireccionSede(@PathVariable String escodigo, @PathVariable String pcodigo,
			HttpServletRequest request) {
		try {

			Sede sede = new Sede();
			sede.setEscodigo(new String(Y41bUtilsDokusi.decode(escodigo)));
			sede.setPcodigo(pcodigo);

			sede = this.establecimientoService.findEstablecimientoSede(sede);

			if (sede == null) {
				throw new Exception("No data Found. /obtenerDireccionSede/{escodigo}/{pcodigo}");
			} else {
				return sede;
			}

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllExpedientesAbiertosCount'.
	 * 
	 * @param escodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busquedaExpedientesAbiertoscount/{escodigo}", method = RequestMethod.GET)
	public @ResponseBody Long getAllExpedientesAbiertosCount(@PathVariable String escodigo,
			HttpServletRequest request) {
		try {

			HechoDenunciado hechodenunciado = new HechoDenunciado();
			Establecimiento establecimientoAux = new Establecimiento();
			establecimientoAux.setEscodigo(new String(Y41bUtilsDokusi.decode(escodigo)));
			hechodenunciado.setEstablecimiento(establecimientoAux);

			Long total = this.denunciaService.findAllExpedientesAbiertosCount(hechodenunciado);

			return total;
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getMailsEstablecimiento'.
	 * 
	 * @param establecimientoAux
	 *            Establecimiento
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */

	@RequestMapping(value = "/mailestablecimiento", method = RequestMethod.GET)
	public @ResponseBody Object getAllMailsEstablecimiento(
			@ModelAttribute(value = "establecimiento") Establecimiento establecimientoAux, HttpServletRequest request) {
		try {
			AdjunDatosMailEstablec filterAdjunDatosMailEstablec = new AdjunDatosMailEstablec();

			filterAdjunDatosMailEstablec.setEscodigo(establecimientoAux.getEscodigo());

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<AdjunDatosMailEstablec> listAdjunDatosMailEstablec = this.adjunDatosMailEstablecService
						.findAll(filterAdjunDatosMailEstablec, pagination);

				if (listAdjunDatosMailEstablec == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.adjunDatosMailEstablecService.findAllCount(filterAdjunDatosMailEstablec);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjunDatosMailEstablec);
				return data;
			} else {
				List<AdjunDatosMailEstablec> listAdjunDatosMailEstablec = this.adjunDatosMailEstablecService
						.findAll(filterAdjunDatosMailEstablec, pagination);
				if (listAdjunDatosMailEstablec == null) {
					throw new Exception("No data Found.");
				}
				return listAdjunDatosMailEstablec;
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'addMailEstablecimiento'.
	 * 
	 * @param adjunDatosMailEstablec
	 *            AdjunDatosMailEstablec
	 * @param establecimientoAux
	 *            Establecimiento
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/altaMailEstablecimiento", method = RequestMethod.POST)
	public void addMailEstablecimiento(@RequestBody AdjunDatosMailEstablec adjunDatosMailEstablec,
			@ModelAttribute(value = "establecimiento") Establecimiento establecimientoAux, HttpServletRequest request) {
		try {
			if (adjunDatosMailEstablec.getEscodigo() == null || adjunDatosMailEstablec.getEscodigo().equals("")) {
				adjunDatosMailEstablec.setEscodigo(establecimientoAux.getEscodigo());
			}

			this.adjunDatosMailEstablecService.add(adjunDatosMailEstablec);

			logger.info("Entity correctly inserted!");
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'getAllMailsSedeEstablecimiento'.
	 * 
	 * @param pcodigo
	 *            String
	 * @param sedeAux
	 *            Sede
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */

	@RequestMapping(value = "/mailestablecimientosede/{pcodigo}", method = RequestMethod.GET)
	public @ResponseBody Object getAllMailsSedeEstablecimiento(@PathVariable String pcodigo,
			@ModelAttribute(value = "sede") Sede sedeAux, HttpServletRequest request) {
		try {
			AdjunDatosMailSede filterAdjunDatosMailSede = new AdjunDatosMailSede();

			filterAdjunDatosMailSede.setIdDatosede(sedeAux.getIdDatosede());
			filterAdjunDatosMailSede.setPcodigo(pcodigo);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<AdjunDatosMailSede> listAdjunDatosMailSede = this.adjunDatosMailSedeService
						.findAll(filterAdjunDatosMailSede, pagination);

				if (listAdjunDatosMailSede == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.adjunDatosMailSedeService.findAllCount(filterAdjunDatosMailSede);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjunDatosMailSede);
				return data;
			} else {
				List<AdjunDatosMailSede> listAdjunDatosMailSede = this.adjunDatosMailSedeService
						.findAll(filterAdjunDatosMailSede, pagination);
				if (listAdjunDatosMailSede == null) {
					throw new Exception("No data Found.");
				}
				return listAdjunDatosMailSede;
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'addMailSedeEstablecimiento'.
	 * 
	 * @param adjunDatosMailSede
	 *            AdjunDatosMailSede
	 * @param sedeAux
	 *            Sede
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/altaMailSedeEstablecimiento", method = RequestMethod.POST)
	public void addMailSedeEstablecimiento(@RequestBody AdjunDatosMailSede adjunDatosMailSede,
			@ModelAttribute(value = "sede") Sede sedeAux, HttpServletRequest request) {
		try {
			if (adjunDatosMailSede.getIdDatosede() == null || adjunDatosMailSede.getIdDatosede().equals("")) {
				adjunDatosMailSede.setIdDatosede(sedeAux.getIdDatosede());
			}

			this.adjunDatosMailSedeService.add(adjunDatosMailSede);

			logger.info("Entity correctly inserted!");
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'resetMailEstablecimiento'.
	 * 
	 * @param escodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/resetMailEstablecimiento/{escodigo}", method = RequestMethod.POST)
	public void resetMailEstablecimiento(@PathVariable String escodigo, HttpServletRequest request) {
		try {
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(new String(Y41bUtilsDokusi.decode(escodigo)));
			this.establecimientoService.addAdjunDatosMailEstablecTableTemporal(establecimiento);

			logger.info("Entity correctly inserted!");
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	// /**
	// * Method 'resetMailSedeEstablecimiento'.
	// *
	// * @param establecimientoAux
	// * Establecimiento
	// * @param sedeAux
	// * Sede
	// * @param request
	// * HttpServletRequest
	// */
	// @RequestMapping(value = "/resetMailSedeEstablecimiento", method =
	// RequestMethod.POST)
	// public void resetMailSedeEstablecimiento(
	// @ModelAttribute(value = "establecimiento") Establecimiento
	// establecimientoAux,
	// @ModelAttribute(value = "sede") Sede sedeAux,
	// HttpServletRequest request) {
	// try {
	// this.establecimientoService
	// .addAdjunDatosMailEstablecSedeTableTemporal(
	// establecimientoAux, sedeAux);
	//
	// logger.info("Entity correctly inserted!");
	// } catch (Y41bUDAException e) {
	// throw e;
	// } catch (Exception e) {
	// throw new MethodFailureException("Method failed");
	// }
	// }

	/**
	 * Method 'resetMailSedeEstablecimiento'.
	 * 
	 * @param establecimientoAux
	 *            Establecimiento
	 * @param sedeAux
	 *            Sede
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/resetMailSedeEstablecimiento", method = RequestMethod.POST)
	public void resetMailSedeEstablecimiento(
			@ModelAttribute(value = "establecimiento") Establecimiento establecimientoAux,
			@ModelAttribute(value = "sede") Sede sedeAux, HttpServletRequest request) {
		try {
			this.establecimientoService.resetMailEstablecimientoSede(establecimientoAux, sedeAux);

			logger.info("Entity correctly inserted!");
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param establecimientoAux
	 *            Establecimiento
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/countMailsEstablecimiento", method = RequestMethod.GET)
	public @ResponseBody Long getAllMailsEstablecimientoCount(
			@ModelAttribute(value = "establecimiento") Establecimiento establecimientoAux, HttpServletRequest request) {
		try {

			AdjunDatosMailEstablec filterAdjunDatosMailEstablec = new AdjunDatosMailEstablec();
			filterAdjunDatosMailEstablec.setEscodigo(establecimientoAux.getEscodigo());

			return adjunDatosMailEstablecService.findAllCount(
					filterAdjunDatosMailEstablec != null ? filterAdjunDatosMailEstablec : new AdjunDatosMailEstablec());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param pcodigo
	 *            String
	 * @param sedeAux
	 *            Sede
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/countMailsSedeEstablecimiento/{pcodigo}", method = RequestMethod.GET)
	public @ResponseBody Long getAllMailsSedeEstablecimientoCount(@PathVariable String pcodigo,
			@ModelAttribute(value = "sede") Sede sedeAux, HttpServletRequest request) {
		try {

			AdjunDatosMailSede filterAdjunDatosMailSedeEstablec = new AdjunDatosMailSede();
			filterAdjunDatosMailSedeEstablec.setIdDatosede(sedeAux.getIdDatosede());
			filterAdjunDatosMailSedeEstablec.setPcodigo(pcodigo);

			return adjunDatosMailSedeService.findAllCount(filterAdjunDatosMailSedeEstablec != null
					? filterAdjunDatosMailSedeEstablec : new AdjunDatosMailSede());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param adjunDatosMailEstablec
	 *            AdjunDatosMailEstablec
	 * 
	 * @param establecimientoAux
	 *            Establecimiento
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/countDescripcionesEstablec", method = RequestMethod.POST)
	public @ResponseBody Long getDescripcionesEstablecimientoCount(
			@RequestBody AdjunDatosMailEstablec adjunDatosMailEstablec,
			@ModelAttribute(value = "establecimiento") Establecimiento establecimientoAux, HttpServletRequest request) {
		try {

			adjunDatosMailEstablec.setEscodigo(establecimientoAux.getEscodigo());

			return adjunDatosMailEstablecService.countDescripciones(adjunDatosMailEstablec);
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param adjunDatosMailSede
	 *            AdjunDatosMailSede
	 * @param sedeAux
	 *            Sede
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/countDescripcionesSedeEstablec", method = RequestMethod.POST)
	public @ResponseBody Long getDescripcionesSedeEstablecimientoCount(
			@RequestBody AdjunDatosMailSede adjunDatosMailSede, @ModelAttribute(value = "sede") Sede sedeAux,
			HttpServletRequest request) {
		try {
			adjunDatosMailSede.setIdDatosede(sedeAux.getIdDatosede());
			adjunDatosMailSede.setPcodigo(sedeAux.getPcodigo());

			return this.adjunDatosMailSedeService.countDescripciones(adjunDatosMailSede);
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}

	/**
	 * Method 'getPegatinaByEscodigo'.
	 * 
	 * @param escodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * 
	 */
	@RequestMapping(value = "/pegatina", method = RequestMethod.GET)
	public @ResponseBody() void getPegatinaByEscodigo(
			@RequestParam(value = "escodigo", required = true) String escodigo, HttpServletResponse response) {
		try {
			PlantillaPegatinaEstablecimiento pegatina = new PlantillaPegatinaEstablecimiento();

			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(new String(Y41bUtilsDokusi.decode(escodigo)));
			establecimiento = this.establecimientoService.find(establecimiento);

			if (establecimiento != null) {
				// Obtenemos los campos del establecimiento requeridos
				pegatina.setEsnombre(establecimiento.getEsnombre());
				StringBuffer direccion = new StringBuffer();
				if (establecimiento.getEsnombreCalle() != null) {
					direccion.append(establecimiento.getEsnombreCalle().trim());
					if (establecimiento.getEsnombrePortal() != null) {
						direccion.append(" ");
						direccion.append(establecimiento.getEsnombrePortal().trim());
						if (establecimiento.getEsnombrePiso() != null) {
							direccion.append(" ");
							direccion.append(establecimiento.getEsnombrePiso());
						}
					}
				}
				pegatina.setEsnodir(direccion.toString());
				pegatina.setEsnombreCp(establecimiento.getEsnombreCp());
				pegatina.setEsnombreMunicipio(establecimiento.getEsnombreMunicipio());
				pegatina.setEsnombreProvincia(establecimiento.getEsnombreProvincia());
			}

			// Fecha
			pegatina.setFechaTextoCas(Y41bUtils.formatearDateToString(new Date(),
					Y41bConstantes.FORMATO_FULL_FECHA_ESSINDIA, Y41bConstantes.CASTELLANO));
			pegatina.setFechaTextoEus(Y41bUtils.formatearDateToStringEuskera(new Date(),
					Y41bConstantes.FORMATO_FULL_FECHA_EUSINDIA, Y41bConstantes.EUSKERA));

			// Responsable\Coordinador junta arbitral
			CensoMonitor censoMonitorResp = new CensoMonitor();
			Organismo organismoResponsable = new Organismo();
			organismoResponsable.setCodOrg(Y41bConstantes.JUNTA_ARBITRAL_CONSUMO_EUSKADI);
			censoMonitorResp.setOrganismo(organismoResponsable);
			censoMonitorResp.setPerfilArbitraje(new Perfil(Y41bConstantes.PERFIL_COORDINADOR, null, null));

			StringBuffer nombreResponsable = new StringBuffer("");
			List<CensoMonitor> listaResponsables = this.censoMonitorService.findAll(censoMonitorResp, null);
			if (listaResponsables != null) {
				for (int i = 0; i < listaResponsables.size(); i++) {
					censoMonitorResp = listaResponsables.get(i);
					if (nombreResponsable.length() == 0) {
						nombreResponsable.append(censoMonitorResp.getMonombre());
					} else {
						nombreResponsable.append(" ,").append(censoMonitorResp.getMonombre());
					}
				}
				pegatina.setCoordinador(nombreResponsable.toString());
				pegatina.setTextoPuestoCoordinadorCas(this.appMessageSource.getMessage("plantilla.puestosecretarioJJAA",
						null, new Locale(Y41bConstantes.CASTELLANO)));
				pegatina.setTextoPuestoCoordinadorEus(this.appMessageSource.getMessage("plantilla.puestosecretarioJJAA",
						null, new Locale(Y41bConstantes.EUSKERA)));
			}

			Organismo organismo = new Organismo();
			organismo.setCodOrg(Y41bConstantes.JUNTA_ARBITRAL_CONSUMO_EUSKADI);
			List<Organismo> listaoficinaProvincia = this.organismoService.findAll(organismo, null);
			if (listaoficinaProvincia != null) {
				organismo = listaoficinaProvincia.get(0);
				if (organismo != null && organismo.getEntidadId() != null) {

					// Lugar
					pegatina.setLugarOficina(organismo.getNombreLocalidad());
					// Creamos el campo pie pagina linea1
					StringBuffer piepagina_linea1 = new StringBuffer();

					piepagina_linea1.append(organismo.getAdressCallePortal()).append(" - ")
							.append(organismo.getAdressCP()).append(" / ").append(" Tl. ")
							.append(organismo.getTelefono());

					pegatina.setPiePaginaLinea1(piepagina_linea1.toString());

					// Creamos el campo pie pagina linea2
					StringBuffer piepagina_linea2 = new StringBuffer();

					piepagina_linea2.append("e-mail: ").append(organismo.getEmail()).append(" / ")
							.append(organismo.getUrl());

					pegatina.setPiePaginaLinea2(piepagina_linea2.toString());
				}
			}

			String rutaRTF = (String) this.appConfiguration.get("y41bVistaWar.ruta.plantillas.word");
			String rutaXML = (String) this.appConfiguration.get("y41bVistaWar.rutaxml.plantillas.word");
			String nombreRTF = Y41bConstantes.NOMBRE_PLANTILLA_ARBITRAJE_ESTABLECIMIENTO_PEGATINA_RTF;
			String nombreXML = Y41bConstantes.NOMBRE_PLANTILLA_ARBITRAJE_ESTABLECIMIENTO_PEGATINA_XML;
			String rutaCompletaRTF = rutaRTF + nombreRTF;
			String rutaCompletaXML = rutaXML + nombreXML;

			String plantilla = new String(Y41bDocumento.leerArchivoOrigen(rutaCompletaRTF));
			String strFileDataDecode = Y41bGenerarDocumento.generarDocumentoWord(rutaCompletaXML, pegatina, plantilla);
			byte[] bytesFichero = strFileDataDecode.getBytes();

			String nombreFichero = "prueba.rtf";

			response.setHeader("Content-Disposition",
					"attachment; filename=\"" + StringEscapeUtils.unescapeHtml(nombreFichero) + "\"");
			response.setContentType("application/msword");
			response.setContentLength(bytesFichero.length);
			response.getOutputStream().write(bytesFichero);
			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Exception e) {
			EstablecimientoController.logger.error(e.getMessage());
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'guardarDatosMailsEstablecimiento'.
	 * 
	 * @param escodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 */
	@RequestMapping(value = "/guardarDatosMailsEstablecimientoARB/{idinterviniente}", method = RequestMethod.GET)
	public void guardarDatosMailsEstablecimientoARB(@PathVariable String idinterviniente, HttpServletRequest request,
			Model model) {

		try {

			Arbinterv arbinterv = new Arbinterv();
			arbinterv.setUaidinterv(new BigDecimal(new String(Y41bUtilsDokusi.decode(idinterviniente))));
			EstablecimientoDetalle establecimientoDetalle = this.arbintervService.findEstablecimiento(arbinterv);
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(establecimientoDetalle.getEscodigo());

			model.addAttribute("establecimiento", establecimiento);

			Sede sedeAux = new Sede();
			sedeAux.setIdDatosede(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

			model.addAttribute("sede", sedeAux);

			this.establecimientoService.addAdjunDatosMailEstablecTableTemporal(establecimiento);
			this.establecimientoService.addAdjunDatosMailEstablecSedeTableTemporal(establecimiento, sedeAux);

		} catch (Exception e) {
			throw new ResourceNotFoundException(idinterviniente.toString());
		}
	}

	/**
	 * Method 'guardarDatosMailsEstablecimiento'.
	 * 
	 * @param escodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 */
	@RequestMapping(value = "/guardarDatosMailsEstablecimientoSAN/{idinterviniente}", method = RequestMethod.GET)
	public void guardarDatosMailsEstablecimientoSAN(@PathVariable String idinterviniente, HttpServletRequest request,
			Model model) {

		try {

			Saninterv saninterv = new Saninterv();
			saninterv.setUaidinterv(new BigDecimal(new String(Y41bUtilsDokusi.decode(idinterviniente))));
			EstablecimientoDetalle establecimientoDetalle = this.sanintervService.findEstablecimiento(saninterv);
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(establecimientoDetalle.getEscodigo());

			model.addAttribute("establecimiento", establecimiento);
			Sede sedeAux = new Sede();
			sedeAux.setIdDatosede(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

			model.addAttribute("sede", sedeAux);

			this.establecimientoService.addAdjunDatosMailEstablecTableTemporal(establecimiento);
			this.establecimientoService.addAdjunDatosMailEstablecSedeTableTemporal(establecimiento, sedeAux);

		} catch (Exception e) {
			throw new ResourceNotFoundException(idinterviniente.toString());
		}
	}

	/**
	 * Method 'guardarDatosMailsEstablecimiento'.
	 * 
	 * @param escodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 */
	@RequestMapping(value = "/guardarDatosMailsEstablecimientoADH/{adhid}", method = RequestMethod.GET)
	public void guardarDatosMailsEstablecimientoADH(@PathVariable String adhid, HttpServletRequest request,
			Model model) {

		try {

			Arbadhsol arbadhsol = new Arbadhsol();
			arbadhsol.setAdhid(new String(Y41bUtilsDokusi.decode(adhid)));
			EstablecimientoDetalle establecimientoDetalle = this.arbadhsolService.findDetalleEstablecimiento(arbadhsol);
			if (establecimientoDetalle != null && establecimientoDetalle.getEscodigo() != null) {
				Establecimiento establecimiento = new Establecimiento();
				establecimiento.setEscodigo(establecimientoDetalle.getEscodigo());

				model.addAttribute("establecimiento", establecimiento);

				Sede sedeAux = new Sede();
				sedeAux.setIdDatosede(Y41bUIDGenerator.getInstance().generateId(Y41bConstantes.PK_SIZE));

				model.addAttribute("sede", sedeAux);

				this.establecimientoService.addAdjunDatosMailEstablecTableTemporal(establecimiento);
				this.establecimientoService.addAdjunDatosMailEstablecSedeTableTemporal(establecimiento, sedeAux);

			}
		} catch (Exception e) {
		}
	}

	/**
	 * Method 'getFicha'.
	 * 
	 * @param escodigo_
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * 
	 */
	@RequestMapping(value = "/ficha", method = RequestMethod.GET)
	public @ResponseBody void getFicha(@RequestParam(value = "escodigo", required = true) String escodigo_,
			HttpServletResponse response) {
		try {
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(escodigo_);

			PlantillaEstablecimientoDetalle plantillaEstablecimientoDetalle = this.establecimientoService
					.findPlantillaEstablecimientoDetalle(establecimiento);

			if (plantillaEstablecimientoDetalle == null) {
				throw new Exception(escodigo_);
			}

			String rutaRTF = (String) appConfiguration.get("y41bVistaWar.ruta.plantillas.word");
			String rutaXML = (String) appConfiguration.get("y41bVistaWar.rutaxml.plantillas.word");
			String nombreRTF = Y41bConstantes.NOMBRE_PLANTILLA_ESTABLECIMIENTO_FICHA_RTF;
			String nombreXML = Y41bConstantes.NOMBRE_PLANTILLA_ESTABLECIMIENTO_FICHA_XML;
			String rutaCompletaRTF = rutaRTF + nombreRTF;
			String rutaCompletaXML = rutaXML + nombreXML;

			String plantilla = new String(Y41bDocumento.leerArchivoOrigen(rutaCompletaRTF));

			String strFileDataDecode = Y41bGenerarDocumento.generarDocumentoWord(rutaCompletaXML,
					plantillaEstablecimientoDetalle, plantilla);

			byte[] bytesFichero = strFileDataDecode.getBytes();

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			StringBuffer nombreFichero = new StringBuffer().append(plantillaEstablecimientoDetalle.getEsnombre())
					.append(".rtf");

			response.setHeader("Content-Disposition", "attachment; filename=\"" + nombreFichero + "\"");
			response.setContentType("application/msword");
			response.setContentLength(bytesFichero.length);
			response.getOutputStream().write(bytesFichero);

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException(escodigo_);
		} catch (Throwable t) {
			t.printStackTrace();
			throw new ResourceNotFoundException(escodigo_);
		}
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "busquedaCIF", method = RequestMethod.GET)
	public ModelAndView getCreateFormBusquedaCIF(Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage", appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout", appConfiguration.get("y41bVistaWar.default.layout"));

		return new ModelAndView("establecimientosDetalle_CIF", "model", model);
	}

	/**
	 * Method 'getMailsEstablecimiento'.
	 * 
	 * @param establecimientoAux
	 *            Establecimiento
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */

	@RequestMapping(value = "/avisosestablecimiento/{esNif}", method = RequestMethod.GET)
	public @ResponseBody Object getAllAvisosEstablecimiento(@PathVariable String esNif, HttpServletRequest request) {
		try {
			AdjunDatosAvisosEstablec filterAdjunDatosAvisosEstablec = new AdjunDatosAvisosEstablec();

			filterAdjunDatosAvisosEstablec.setYiescif(esNif);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null && request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<AdjunDatosAvisosEstablec> listAdjunDatosAvisosEstablec = this.adjunDatosAvisosEstablecService
						.findAll(filterAdjunDatosAvisosEstablec, pagination);

				if (listAdjunDatosAvisosEstablec == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.adjunDatosAvisosEstablecService.findAllCount(filterAdjunDatosAvisosEstablec);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(listAdjunDatosAvisosEstablec);
				return data;
			} else {
				List<AdjunDatosAvisosEstablec> listAdjunDatosAvisosEstablec = this.adjunDatosAvisosEstablecService
						.findAll(filterAdjunDatosAvisosEstablec, pagination);
				if (listAdjunDatosAvisosEstablec == null) {
					throw new Exception("No data Found.");
				}
				return listAdjunDatosAvisosEstablec;
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'addAvisoEstablecimiento'.
	 * 
	 * @param adjunDatosAvisosEstablec
	 *            AdjunDatosAvisosEstablec
	 * @param establecimientoAux
	 *            Establecimiento
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/altaAvisosEstablecimiento", method = RequestMethod.POST)
	public void addAvisosEstablecimiento(@RequestBody AdjunDatosAvisosEstablec adjunDatosAvisosEstablec,
			HttpServletRequest request) {
		try {

			if (adjunDatosAvisosEstablec.getYipcodigo() != null
					&& adjunDatosAvisosEstablec.getYipcodigo().equalsIgnoreCase(String.valueOf(Y41bConstantes.NUM_0))) {

				// obtener lista procedimientos
				TipoProcedimiento filterTipoProcedimiento = new TipoProcedimiento();
				// List<TipoProcedimiento> tipoProcedimientoList =
				// this.tipoProcedimientoService
				// .findAll(filterTipoProcedimiento, null);
				List<TipoProcedimiento> tipoProcedimientoList = this.tipoProcedimientoService.findAllProcAvisos();
				// insertar para cada uno
				if (tipoProcedimientoList.size() > 0) {
					for (TipoProcedimiento tipoProcedimientoAux : tipoProcedimientoList) {

						AdjunDatosAvisosEstablec adjunDatosAvisosEstablecAux = new AdjunDatosAvisosEstablec();
						adjunDatosAvisosEstablecAux.setYiescif(adjunDatosAvisosEstablec.getYiescif());
						adjunDatosAvisosEstablecAux.setYipcodigo(tipoProcedimientoAux.getPcodigo());

						List<AdjunDatosAvisosEstablec> adjunDatosAvisosEstablecList = this.adjunDatosAvisosEstablecService
								.findAllLike(adjunDatosAvisosEstablecAux, null, false);

						if (adjunDatosAvisosEstablecList.size() > 0) {
							adjunDatosAvisosEstablecAux = adjunDatosAvisosEstablecList.get(0);
							adjunDatosAvisosEstablecAux.setYiemail(adjunDatosAvisosEstablec.getYiemail());
							this.adjunDatosAvisosEstablecService.update(adjunDatosAvisosEstablecAux);
						} else {
							adjunDatosAvisosEstablec.setYipcodigo(tipoProcedimientoAux.getPcodigo());
							this.adjunDatosAvisosEstablecService.add(adjunDatosAvisosEstablec);
						}

					}
				}

			} else {
				AdjunDatosAvisosEstablec adjunDatosAvisosEstablecAux = new AdjunDatosAvisosEstablec();
				adjunDatosAvisosEstablecAux.setYiescif(adjunDatosAvisosEstablec.getYiescif());
				adjunDatosAvisosEstablecAux.setYipcodigo(adjunDatosAvisosEstablec.getYipcodigo());

				List<AdjunDatosAvisosEstablec> adjunDatosAvisosEstablecList = this.adjunDatosAvisosEstablecService
						.findAllLike(adjunDatosAvisosEstablecAux, null, false);

				if (adjunDatosAvisosEstablecList.size() > 0) {
					adjunDatosAvisosEstablecAux = adjunDatosAvisosEstablecList.get(0);
					adjunDatosAvisosEstablecAux.setYiemail(adjunDatosAvisosEstablec.getYiemail());
					this.adjunDatosAvisosEstablecService.update(adjunDatosAvisosEstablecAux);
				} else {
					this.adjunDatosAvisosEstablecService.add(adjunDatosAvisosEstablec);
				}

			}

			logger.info("Entity correctly inserted!");
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 *
	 * 
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/eliminarAvisosMultipleTemp/{esNif}", method = RequestMethod.POST)
	public void eliminarDocsEsCanalPrioritarioTemp(@PathVariable String esNif, HttpServletResponse response) {

		try {

			AdjunDatosAvisosEstablec adjunDatosAvisosEstablec = new AdjunDatosAvisosEstablec();
			adjunDatosAvisosEstablec.setYiescif(esNif);

			// borramos todos los de ese codigo de la temporal
			this.adjunDatosAvisosEstablecService.removeAllAvisosFromTemp(adjunDatosAvisosEstablec);

			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41bUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new Y41bUDAException("error.generico", true, e);
		}
	}

	/**
	 * Method 'getByEsNif'.
	 * 
	 * @param esNif
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/avisosMultipleFromFinalToTemp/{esNif}", method = RequestMethod.GET)
	public void avisosMultipleFromFinalToTemp(@PathVariable String esNif, HttpServletRequest request) {

		try {
			AdjunDatosAvisosEstablec adjunDatosAvisosEstablec = new AdjunDatosAvisosEstablec();
			adjunDatosAvisosEstablec.setYiescif(esNif);
			// datos de tabla final a temporal
			this.adjunDatosAvisosEstablecService.addAvisosMultipleFinalATemporal(adjunDatosAvisosEstablec);

		} catch (Exception e) {
			throw new ResourceNotFoundException(esNif.toString());
		}
	}

	/**
	 * Method 'getByEsNif'.
	 * 
	 * @param esNif
	 *            String
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/avisosMultipleCountTemp/{esNif}", method = RequestMethod.GET)
	public @ResponseBody Long avisosMultipleCountTemp(@PathVariable String esNif, HttpServletRequest request) {

		try {
			AdjunDatosAvisosEstablec adjunDatosAvisosEstablec = new AdjunDatosAvisosEstablec();
			adjunDatosAvisosEstablec.setYiescif(esNif);

			return this.adjunDatosAvisosEstablecService.findAllCount(adjunDatosAvisosEstablec);

		} catch (Exception e) {
			throw new ResourceNotFoundException(esNif.toString());
		}
	}
}