package com.ejie.y41b.control;

import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.service.EstablecimSectorService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.y41b.model.EstablecimSector;

/**
 * EstablecimSectorController  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/EstablecimSector")
public class EstablecimSectorController {

	private static final Logger logger = LoggerFactory
			.getLogger(EstablecimSectorController.class);

	@Autowired
	private EstablecimSectorService EstablecimSectorService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		EstablecimSectorController.logger
				.info("[GET - View] : EstablecimSector");
		return "EstablecimSector";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param eacodigo
	 *            String
	 * @return EstablecimSector EstablecimSector
	 */
	@RequestMapping(value = "/{eacodigo}", method = RequestMethod.GET)
	public @ResponseBody
	EstablecimSector getById(@PathVariable String eacodigo) {
		EstablecimSector EstablecimSector = new EstablecimSector();
		EstablecimSector.setEacodigo(eacodigo);
		EstablecimSector = this.EstablecimSectorService.find(EstablecimSector);
		EstablecimSectorController.logger
				.info("[GET - findBy_PK] : Obtener EstablecimSector por PK");
		return EstablecimSector;
	}

	// /**
	// * Method 'getAll'.
	// *
	// * @param filterEstablecimSector
	// * EstablecimSector
	// * @return List
	// */
	// @RequestMapping(method = RequestMethod.GET)
	// public @ResponseBody
	// List<EstablecimSector> getAll(
	// @ModelAttribute EstablecimSector filterEstablecimSector) {
	// EstablecimSectorController.logger
	// .info("[GET - find_ALL] : Obtener EstablecimSector por filtro");
	// return this.EstablecimSectorService.findAll(filterEstablecimSector,
	// null);
	// }

	/**
	 * Method 'edit'.
	 * 
	 * @param EstablecimSector
	 *            EstablecimSector
	 * @return EstablecimSector
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	EstablecimSector edit(@RequestBody EstablecimSector EstablecimSector) {
		EstablecimSector EstablecimSectorAux = this.EstablecimSectorService
				.update(EstablecimSector);
		EstablecimSectorController.logger
				.info("[PUT] : EstablecimSector actualizado correctamente");
		return EstablecimSectorAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param EstablecimSector
	 *            EstablecimSector
	 * @return EstablecimSector
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	EstablecimSector add(@RequestBody EstablecimSector EstablecimSector) {
		EstablecimSector EstablecimSectorAux = this.EstablecimSectorService
				.add(EstablecimSector);
		EstablecimSectorController.logger
				.info("[POST] : EstablecimSector insertado correctamente");
		return EstablecimSectorAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param eacodigo
	 *            String
	 * @return EstablecimSector
	 */
	@RequestMapping(value = "/{eacodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	EstablecimSector remove(@PathVariable String eacodigo) {
		EstablecimSector EstablecimSector = new EstablecimSector();
		EstablecimSector.setEacodigo(eacodigo);
		this.EstablecimSectorService.remove(EstablecimSector);
		EstablecimSectorController.logger
				.info("[DELETE] : EstablecimSector borrado correctamente");
		return EstablecimSector;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param EstablecimSectorIds
	 *            List
	 * @return EstablecimSectorList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> EstablecimSectorIds) {
		List<EstablecimSector> EstablecimSectorList = new ArrayList<EstablecimSector>();
		for (List<String> EstablecimSectorId : EstablecimSectorIds) {
			Iterator<String> iterator = EstablecimSectorId.iterator();
			EstablecimSector EstablecimSector = new EstablecimSector(); // NOPMD
																		// -
																		// Objeto
																		// nuevo
																		// en la
																		// lista
																		// (parametro
																		// del
																		// servicio)
			EstablecimSector.setEacodigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			EstablecimSectorList.add(EstablecimSector);
		}
		this.EstablecimSectorService.removeMultiple(EstablecimSectorList);
		EstablecimSectorController.logger
				.info("[POST - DELETE_ALL] : EstablecimSector borrados correctamente");
		return EstablecimSectorIds;
	}

	// /**
	// * Method 'getAllJQGrid'.
	// *
	// * @param filterEstablecimSector
	// * EstablecimSector
	// * @param pagination
	// * Pagination
	// * @return JQGridJSONModel
	// */
	// @RequestMapping(method = RequestMethod.GET, headers = {
	// "JQGridModel=true" })
	// public @ResponseBody
	// JQGridJSONModel getAllJQGrid(
	// @ModelAttribute EstablecimSector filterEstablecimSector,
	// @ModelAttribute Pagination pagination) {
	// List<EstablecimSector> EstablecimSectors = this.EstablecimSectorService
	// .findAll(filterEstablecimSector, pagination);
	// Long recordNum = this.EstablecimSectorService
	// .findAllCount(filterEstablecimSector);
	// EstablecimSectorController.logger
	// .info("[GET - jqGrid] : Obtener EstablecimSector");
	// return new JQGridJSONModel(pagination, recordNum, EstablecimSectors);
	// }

}
