package com.ejie.y41b.control;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Actividad;
import com.ejie.y41b.model.AdjunDatosMailEstablec;
import com.ejie.y41b.model.AdjunDatosMailSede;
import com.ejie.y41b.model.Arbadhsol;
import com.ejie.y41b.model.Arbinterv;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Descriptor;
import com.ejie.y41b.model.EsCanalPrioritario;
import com.ejie.y41b.model.EstablecimArbitra;
import com.ejie.y41b.model.EstablecimSector;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.EstablecimientoDecisionAnyo;
import com.ejie.y41b.model.EstablecimientoDetalle;
import com.ejie.y41b.model.EstablecimientoReclamacionesAnyo;
import com.ejie.y41b.model.HechoDenunciado;
import com.ejie.y41b.model.Organismo;
import com.ejie.y41b.model.Perfil;
import com.ejie.y41b.model.PlantillaEstablecimientoDetalle;
import com.ejie.y41b.model.PlantillaPegatinaEstablecimiento;
import com.ejie.y41b.model.Saninterv;
import com.ejie.y41b.model.Sector;
import com.ejie.y41b.model.Sede;
import com.ejie.y41b.service.AdjunDatosMailEstablecService;
import com.ejie.y41b.service.AdjunDatosMailSedeService;
import com.ejie.y41b.service.ArbadhsolService;
import com.ejie.y41b.service.ArbintervService;
import com.ejie.y41b.service.CensoMonitorService;
import com.ejie.y41b.service.DenunciaService;
import com.ejie.y41b.service.EsCanalPrioritarioService;
import com.ejie.y41b.service.EstablecimientoService;
import com.ejie.y41b.service.OrganismoService;
import com.ejie.y41b.service.SanintervService;
import com.ejie.y41b.service.Y41bExcelGeneratorService;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.documentos.Y41bDocumento;
import com.ejie.y41b.utils.documentos.Y41bGenerarDocumento;
import com.ejie.y41b.utils.dokusi.Y41bUtilsDokusi;
import com.ejie.y41b.utils.exception.Y41bUDAErrorManager;
import com.ejie.y41b.utils.exception.Y41bUDAException;

;

/**
 * * EsCanalPrioritarioController  
 * 
 *  
 */

/**
 *  
 * 
 */
@Controller
@RequestMapping(value = "/escanalprioritario")
@SessionAttributes({ "escanalprioritario" })
public class EsCanalPrioritarioController {

	private static final Logger logger = LoggerFactory.getLogger(EsCanalPrioritarioController.class);

	@Autowired
	private EsCanalPrioritarioService esCanalPrioritarioService;

	@Autowired()
	private CensoMonitorService censoMonitorService;

	@Resource()
	private ReloadableResourceBundleMessageSource appMessageSource;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41bUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41bUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41bUDAException.class)
	public @ResponseBody void udaExceptionHandle(Y41bUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getByCif'.
	 * 
	 * @param escodigo
	 *            String
	 * @param sedeAux
	 *            Sede
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/{escif}", method = RequestMethod.GET)
	public @ResponseBody EsCanalPrioritario getById(@PathVariable String escif, Model model) {
		try {
			EsCanalPrioritario esCanalPrioritario = new EsCanalPrioritario();
			esCanalPrioritario.setYgcif(escif);

			model.addAttribute("esCanalPrioritario", esCanalPrioritario);

			esCanalPrioritario = this.esCanalPrioritarioService.findEsCanalPrioritario(esCanalPrioritario);

			if (esCanalPrioritario == null) {
				throw new Exception(escif.toString());
			}
			return esCanalPrioritario;
		} catch (Exception e) {
			throw new ResourceNotFoundException(escif.toString());
		}
	}

}