package com.ejie.y41b.control;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.Errores;
import com.ejie.y41b.model.Tiposerrores;
import com.ejie.y41b.service.ErroresService;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * ErroresController  
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/errores")
public class ErroresController {

	private static final Logger logger = LoggerFactory
			.getLogger(ErroresController.class);

	@Autowired()
	private ErroresService erroresService;

	@Autowired()
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ErroresController.logger.info("[GET - View] : errores");
		return "errores";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param sicodigo
	 *            String
	 * @return errores Errores
	 */
	@RequestMapping(value = "/{sicodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	Errores getById(@PathVariable() String sicodigo) {
		Errores errores = new Errores();
		errores.setSicodigo(sicodigo);
		errores = this.erroresService.find(errores);
		ErroresController.logger
				.info("[GET - findBy_PK] : Obtener Errores por PK");
		return errores;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterErrores
	 *            Errores
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	List<Errores> getAll(@ModelAttribute() Errores filterErrores) {
		ErroresController.logger
				.info("[GET - find_ALL] : Obtener Errores por filtro");
		return this.erroresService.findAll(filterErrores, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param errores
	 *            Errores
	 * @return Errores
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Errores edit(@RequestBody() Errores errores) {
		Errores erroresAux = this.erroresService.update(errores);
		ErroresController.logger
				.info("[PUT] : Errores actualizado correctamente");
		return erroresAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param errores
	 *            Errores
	 * @return Errores
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Errores add(@RequestBody() Errores errores) {
		Errores erroresAux = this.erroresService.add(errores);
		ErroresController.logger
				.info("[POST] : Errores insertado correctamente");
		return erroresAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param sicodigo
	 *            String
	 * @return errores
	 */
	@RequestMapping(value = "/{sicodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	Errores remove(@PathVariable() String sicodigo) {
		Errores errores = new Errores();
		errores.setSicodigo(sicodigo);
		this.erroresService.remove(errores);
		ErroresController.logger
				.info("[DELETE] : Errores borrado correctamente");
		return errores;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param erroresIds
	 *            List
	 * @return erroresList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody()
	List<List<String>> removeMultiple(
			@RequestBody() List<List<String>> erroresIds) {
		List<Errores> erroresList = new ArrayList<Errores>();
		for (List<String> erroresId : erroresIds) {
			Iterator<String> iterator = erroresId.iterator();
			Errores errores = new Errores(); // NOPMD - Objeto nuevo en la lista
												// (parametro del servicio)
			errores.setSicodigo(ObjectConversionManager.convert(
					iterator.next(), String.class));
			erroresList.add(errores);
		}
		this.erroresService.removeMultiple(erroresList);
		ErroresController.logger
				.info("[POST - DELETE_ALL] : Errores borrados correctamente");
		return erroresIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterErrores
	 *            Errores
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(@ModelAttribute() Errores filterErrores,
			@ModelAttribute() Pagination pagination) {
		List<Errores> erroress = this.erroresService.findAll(filterErrores,
				pagination);
		Long recordNum = this.erroresService.findAllCount(filterErrores);
		ErroresController.logger.info("[GET - jqGrid] : Obtener Errores");
		return new JQGridJSONModel(pagination, recordNum, erroress);
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterErrores
	 *            Errores
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "/tablaErroresE", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGridErroresEjecucion(
			@ModelAttribute() Errores filterErrores,
			@ModelAttribute() Pagination pagination) throws Exception {

		if (filterErrores.getSireferencia() != null
				&& "".equals(filterErrores.getSireferencia())) {
			filterErrores.setSireferencia(null);
		}
		if (filterErrores.getSiidtipomov() != null
				&& "".equals(filterErrores.getSiidtipomov())) {
			filterErrores.setSiidtipomov(null);
		}
		if (filterErrores.getSifechaerrorDesde() != null
				&& "".equals(filterErrores.getSifechaerrorDesde())) {
			filterErrores.setSifechaerrorDesde(null);
		}
		if (filterErrores.getSifechaerrorHasta() != null
				&& "".equals(filterErrores.getSifechaerrorHasta())) {
			filterErrores.setSifechaerrorHasta(null);
		}
		if (filterErrores.getSiidtipomov() != null
				&& "".equals(filterErrores.getSiidtipomov())) {
			filterErrores.setSiidtipomov(null);
		}
		if (filterErrores.getSificherosipca() != null
				&& "".equals(filterErrores.getSificherosipca())) {
			filterErrores.setSificherosipca(null);
		}
		filterErrores.setTiposerrores(new Tiposerrores(null, null, null, null,
				null, null));

		List<Errores> erroress = this.erroresService.findAllLike(filterErrores,
				pagination, false);
		Long recordNum = this.erroresService.findAllLikeCount(filterErrores,
				false);
		ErroresController.logger.info("[GET - jqGrid] : Obtener Errores");
		return new JQGridJSONModel(pagination, recordNum, erroress);
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterErrores
	 *            Errores
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "/tablaErroresD", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGridErroresDisenio(
			@ModelAttribute() Errores filterErrores,
			@ModelAttribute() Pagination pagination) throws Exception {

		if (filterErrores.getSifechaerrorDesde() != null
				&& "".equals(filterErrores.getSifechaerrorDesde())) {
			filterErrores.setSifechaerrorDesde(null);
		}
		if (filterErrores.getSifechaerrorHasta() != null
				&& "".equals(filterErrores.getSifechaerrorHasta())) {
			filterErrores.setSifechaerrorHasta(null);
		}
		if (filterErrores.getSificherosipca() != null
				&& "".equals(filterErrores.getSificherosipca())) {
			filterErrores.setSificherosipca(null);
		}
		filterErrores.setTiposerrores(new Tiposerrores(
				Y41bConstantes.ESTADO_PAGO_ERRORFICHERO, null, null, null,
				null, null));
		List<Errores> erroress = this.erroresService.findAllLike(filterErrores,
				pagination, false);
		Long recordNum = this.erroresService.findAllLikeCount(filterErrores,
				false);
		ErroresController.logger.info("[GET - jqGrid] : Obtener Errores");
		return new JQGridJSONModel(pagination, recordNum, erroress);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintErrores", method = RequestMethod.GET)
	public String getCreateFormErrores(Model model) {
		return "errores";
	}

	/**
	 * Method 'getCreateFormErroresPestania1'.
	 * 
	 * @param httpRequest
	 *            HttpServletRequest
	 * 
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "erroresPestania1", method = RequestMethod.GET)
	public ModelAndView getCreateFormErroresPestania1(
			HttpServletRequest httpRequest, Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));

		Date fecha = Y41bUtils.addDays(Y41bUtils.obtenerFechaHoy(),
				-Y41bConstantes.NUM_15);
		Locale locale = LocaleContextHolder.getLocale();
		String idioma = locale.getLanguage();
		model.addAttribute("fechaError",
				Y41bUtils.parseDateToString(fecha, idioma));

		return new ModelAndView("erroresPestania1", "model", model);
	}

	/**
	 * Method 'getCreateFormErroresPestania2'.
	 * 
	 * @param httpRequest
	 *            HttpServletRequest
	 * 
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "erroresPestania2", method = RequestMethod.GET)
	public ModelAndView getCreateFormErroresPestania2(
			HttpServletRequest httpRequest, Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));

		Date fecha = Y41bUtils.addDays(Y41bUtils.obtenerFechaHoy(),
				-Y41bConstantes.NUM_15);
		Locale locale = LocaleContextHolder.getLocale();
		String idioma = locale.getLanguage();
		model.addAttribute("fechaError",
				Y41bUtils.parseDateToString(fecha, idioma));

		return new ModelAndView("erroresPestania2", "model", model);
	}

	/**
	 * Method 'getCreateFormErroresPestania3'.
	 * 
	 * @param httpRequest
	 *            HttpServletRequest
	 * 
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	@RequestMapping(value = "erroresPestania3", method = RequestMethod.GET)
	public ModelAndView getCreateFormErroresPestania3(
			HttpServletRequest httpRequest, Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));

		return new ModelAndView("erroresPestania3", "model", model);
	}

	/**
	 * Method 'getCreateFormMod'.
	 * 
	 * @param sicodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return ModelAndView
	 */
	@RequestMapping(value = "/detalle/{sicodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormMod(@PathVariable() String sicodigo,
			Model model, HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("sicodigo", sicodigo);

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41bConstantes.SESSIONCENSOMONITORCONNECTED);

		if (censoMonitor.getPerfilEconomico() == null
				|| censoMonitor.getPerfilEconomico().getIdPerfil()
						.equals(Y41bConstantes.PERFIL_SINACCESO_MANTENIMIENTO)) {
			return new ModelAndView("accessDeniedModal", "model", model);
		} else {
			return new ModelAndView("erroresDetalle", "model", model);
		}
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return Properties
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

}
